<?php
// ======================================================================
// Plugin dojoFormBind by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** ===================================================================== 
 * Función de Smarty para generar en la página html el código javascript 
 * de preparación de un formulario que se va a enviar por Ajax.
 * Ejemplo: 
 * <!--[dojoFormBind formname="form1" handler="func1" mimetype="text/json" encoding="utf-8"]-->
 *
 * @author  kmarcos
 * @param   array $params  Arreglo que contiente todos los parametros de la función:   
 *                  formaname    Nombre del fomulario   
 *                  handler      Nombre de la función que va a manejar todo tipo 
 *                                      de respuestas: exitoso, error, etc  
 *                  mimetype     Formato de respuesta. Por defecto: text/json  
 *                  encoding     Estándar de codificación. Por defecto: utf-8
 *                  browserfield Nombre del input hidden donde se enviará el 
 *                               nombre del browser (corrección de error de ejecución 
 *                               en Internet Explorer)     
 * @param        object      &$smarty     Reference to the Smarty object
 * @return       string      Código JavaScript requerido para preparar el formulario
 * ======================================================================
 */ 
 
function smarty_function_dojoFormBind($params, &$smarty) 
{

    //Obtiene y valida los parametros
    
    extract($params); 
    
    if (!isset($formname) || $formname == ''){
        return;
    }
    
    if (!isset($handler) || $handler == ''){
        return;
    }
   
    if (!isset($mimetype) || $mimetype == ''){
        $mimetype = "text/json";
    }
    
    if (!isset($encoding) || $encoding == ''){
        $encoding = "UTF-8";
    }
    
    if (!isset($browserfield) || $browserfield == ''){
        $browserfield = "browsername";
    }
    
    //Prepara la forma    
    $dojo_form  = '<script type="text/javascript">';
    
    $dojo_form .= 'function prepare'.$formname.'Bind(){ var x = new dojo.io.FormBind({formNode: "'.$formname.
                  '", encoding: "'.$encoding.'" ,mimetype: "'.$mimetype.'",handler: '.$handler.'});}';
    $dojo_form .= 'dojo.addOnLoad(prepare'.$formname.'Bind);';
    
    $dojo_form .= 'function detectBrowser() {dojo.byId("'.$formname.'").'.$browserfield.'.value = navigator.appName;}';    
    $dojo_form .= 'dojo.addOnLoad(detectBrowser);';
    $dojo_form .= '</script>';
    
    return $dojo_form;
}

?>