<?php
// ======================================================================
// Plugin prepareDojo by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** ===================================================================== 
 * Función de Smarty para generar en la página html el código javascript 
 * de preparación para utilizar dojo
 * Ejemplo: 
 * <!--[prepareDojo debug="true" dojopath="./javascript/dojo/" include="event,io,widget"]-->
 *
 * @author       kmarcos
 * @param        array       $params      Arreglo que contiente todos los parametros de la función:   
                                          $debug    Iniciar modo debug (true/false)   
                                          $dojopath Path para alcanzar desde la página al toolkit Dojo
                                          $include  Lista de los recursos a utilizar
 * @param        object      &$smarty     Reference to the Smarty object
 * @return       string      Código JavaScript requerido para el uso del Dojo toolkit
 * ======================================================================
 */ 
 
function smarty_function_prepareDojo($params, &$smarty) 
{

    //Obtiene y valida los parametros
    
    extract($params); 
    
    if (!isset($debug) || strtolower($debug)!="true"){
        $debug=false;
    }
    else{
        $debug=true;
    }
    if (!isset($dojopath)){
        $dojopath="./javascript/dojo/";
    } 
    if (substr($dojopath, -1) != '/'){
        $dojopath.='/';
    }
    if(!isset($include)){
        return;
    }
    else{
        $includes = explode(",", $include);
    }
    
    //Arma la inicialización    
    $dojo_init='';
    
    //debug?
    if ($debug)
        $dojo_init .='<script type="text/javascript"> var djConfig = { isDebug: true } ;</script>';
    
    $dojo_init .= '<script type="text/javascript" src="'.$dojopath.'dojo.js">/*dojo*/</script>';
    $dojo_init .= '<script type="text/javascript" src="'.$dojopath.'src/lfx/html.js"></script>';
    
    $dojo_init .= '<script type="text/javascript">';
    
    if (in_array("event", $includes))
        $dojo_init .= ' dojo.require("dojo.event.*");';
    if (in_array("io", $includes))
        $dojo_init .= ' dojo.require("dojo.io.*");';
	if (in_array("json", $includes))
        $dojo_init .= ' dojo.require("dojo.json");';
    if (in_array("widget", $includes))
        $dojo_init .= 'dojo.require("dojo.widget.*");';        
    if (in_array("lfx", $includes))
        $dojo_init .= 'dojo.require("dojo.lfx.*");';      
    if (in_array("addax", $includes))    {
        $dojo_init .= ' dojo.registerModulePath ("addax","../addax/widget");  dojo.require("addax.widget.*");'; 
        $dojo_init .= 'dojo.registerNamespace("addax", "addax.widget", function(name) {return "addax." +dojo.string.capitalize(name);});';
        }
 
    $dojo_init .= '</script>';
    
    return $dojo_init;
}

?>