<?php
// ======================================================================
// AddaxQuery by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Moulo: AddaxQuery
 * Consultas y reportes basicos
 * 
 * Funcion de Smarty para desplegar la barra de navegación entre las paginas
 * de los resultados de las consulas
 *
 * Ejemplo: <!--[resultsnavbar total="130" currentpage=3]-->
 *
 * @package      PostNuke_Modules
 * @subpackage   AddaxQuery
 * @author       kmarcos
 * @param        array  $params  Arreglo que contiente todos los parametros de la funcion:
 *                               $total    Total de registros de la consulta
 *                               $currentpage Número de la pagina actual de resultados
 * @param        object      &$smarty     Referencia al objeto Smarty
 * @return       string      Codigo HTML de despliegue.
 *
 * ======================================================================
 */ 
function smarty_function_resultsnavbar($params, &$smarty) 
{
    extract($params); 
    unset($params);

    // valores por defecto
    if (!isset($total)|| !is_numeric($total)) {
        return;
    }
    if (!isset($currentpage) || !is_numeric($currentpage)) {
        $currentpage = 0;
    }
    
    //Obtiene el número de resultados por página
    $numresults = pnModGetVar('AddaxQuery','resultsnum');
    
    
    $html = '<div class="aq_resultsnavbar">';
    $html.= '<span class="aq_totalres">'._AQ_TOTALREG.'<strong>'.$total.'</strong></span>';
    $html.= '<table class="aq_resultsnavtable"><tr>';
    
    //PREV
    if ($currentpage>1){
        $html.= '<td class="aq_navword"><a href="'.
            pnModURL('AddaxQuery','user','executeQuery', array('page'=>($currentpage-1))).
            '">'._AQ_PREVIOUS.'</a></td>';
    }
    //Numeros de paginas
    $tpags = ($total / $numresults);
    $tpags += ($total % $numresults) > 0 ?1:0;    
    for ($p=1; $p<=$tpags; $p++){
        if ($p == $currentpage){
            $html.= '<td class="aq_page"><span>'.$currentpage.'</span></td>';
        }
        else{
            $html.= '<td class="aq_navpage"><a href="'.
            pnModURL('AddaxQuery','user','executeQuery', array('page'=>($p))).
            '">'.$p.'</a></td>';
        }
    }
     
    //NEXT
    if ($currentpage*$numresults < $total){
        $html.= '<td><a class="aq_navword" href="'.
            pnModURL('AddaxQuery','user','executeQuery', array('page'=>($currentpage+1))).
            '">'._AQ_NEXT.'</a></td>';
    }
    $html.= '<td width="*">&nbsp;</td></tr></table></div>';

    return $html;
}

?>