<?php
// ======================================================================
// AddaxQuery by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Moulo: AddaxQuery
 * Consultas y reportes basicos
 * 
 * Funcion de Smarty para desplegar la barra de impresión
 * de los resultados de las consulas
 *
 * Ejemplo: <!--[resultsprintbar currentpage=3]-->
 *
 * @package      PostNuke_Modules
 * @subpackage   AddaxQuery
 * @author       kmarcos
 * @param        array  $params  Arreglo que contiente todos los parametros de la funcion:
 *                               $total    Total de registros de la consulta
 *                               $currentpage Número de la pagina actual de resultados
 * @param        object      &$smarty     Referencia al objeto Smarty
 * @return       string      Codigo HTML de despliegue.
 *
 * ======================================================================
 */ 
function smarty_function_resultsprintbar($params, &$smarty) 
{
    extract($params); 
    unset($params);

    // valores por defecto   
    if (!isset($currentpage) || !is_numeric($currentpage)) {
        $currentpage = 0;
    }
    
    //Obtiene el número de resultados por página 
    $html = '<div class="aq_resultsprintbar">';
    $html.= '<a target="_blank" href="'.
            pnModURL('AddaxQuery','user','executeQuery', array('page'=>$currentpage,'print'=>true)).
            '">'._AQ_PRINTTHISPAGE.'</a>&nbsp;';
    $html.= '<a target="_blank" href="'.
            pnModURL('AddaxQuery','user','executeQuery', array('all'=>true,'print'=>true)).
            '">'._AQ_PRINTALL.'</a></div>';
    $html = str_replace ('index.php?','popup.php?',$html);
    return $html;
}

?>