<?php
// ======================================================================
// AddaxQuery by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxQuery 
 * Consultas y reportes basicos
 * 
 * Aqui se encuentran las funciones GUI (control) del usuario.
 *
 * @package      PostNuke_Modules
 * @subpackage   AddaxQuery
 * @author       kmarcos
 * ======================================================================
 */ 

/**
 * Funcion principal del usuario
 * @author  kmarcos
 * @return  output(pnRender)   Página principal del usuario.
 */
function AddaxQuery_user_main()
{
    // Autorización 
    if (!pnSecAuthAction(0, 'AddaxQuery::', '::', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

    //Crea Render
    $pnRender =& new pnRender('AddaxQuery');

    // Return the output that has been generated by this function
    return $pnRender->fetch('AddaxQuery_user_main.htm');
}




/**
 * Lista las consultas disponibles para el usuario
 * @author  kmarcos
 * @return  output(pnRender)  página con el listado de consultas o un mensaje 
 *          de error en caso de falla
 */
function AddaxQuery_user_view()
{

    // Create output object 
    $pnRender =& new pnRender('AddaxQuery');
    $pnRender->caching = false;

    // Security check
    if (!pnSecAuthAction(0, 'AddaxQuery::', '::', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

    // The user API function is called
    $items = pnModAPIFunc('AddaxQuery', 'user', 'getallqueries');
    
    // The return value of the function is checked here
    
    //Note que primero se evalúa si siendo un arreglo tiene elementos
    // ya que ! de un arreglo vacio da false.
    if (count($items)==0) {
        return pnVarPrepHTMLDisplay(_AQ_QUERYNOTFOUND);
    }

    if (!$items) {
        $errormsg = pnSessionGetVar('errormsg');
        pnSessionDelVar('errormsg');
        return _AQ_QUERYGETFAILED.": $errormsg";
    }
    
    $queries = array();
    foreach ($items as $item) {        
        $queries[$item[id]] = array('url'   => pnModURL('AddaxQuery', 'user', 'doQueryUsers',
        array('id' =>$item[id])),
        'title' => $item[descripcion]);
    }

    // Assign the items to the template
    $pnRender->assign('queries', $queries);

    // Return the output that has been generated by this function
    return $pnRender->fetch('AddaxQuery_user_view.htm');
}

/**
 * Ejecuta la consulta dada y presenta los resultados. Eventualmente
 * retorna un flujo diferente para tomar datos del usuario (consultas parametrizadas).
 * Valida permisos de Administrador de Bases de Datos
 * @author  kmarcos
 * @param   id    ID de la consulta
 * @return  output(pnRender) Página de resultados
 */
function AddaxQuery_user_doQueryDBAdmin($args)
{
    extract($args);
    
    // Create output object 
    $pnRender =& new pnRender('AddaxQuery');
    $pnRender->caching = false;
    
    // Security check
    if (!pnSecAuthAction(0, 'AddaxQuery::', 'user::doQueryDBAdmin', ACCESS_EDIT)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

    $id = ((null != $id)?$id:pnVarCleanFromInput('id'));
    if (!isset($id)|| !is_numeric($id)) {
        return pnVarPrepHTMLDisplay(_AQ_QUERYIDMISSING);
    }
    
    return doQuery($id,'admin');
}

/**
 * Ejecuta la consulta dada y presenta los resultados. Eventualmente
 * retorna un flujo diferente para tomar datos del usuario (consultas parametrizadas).
 * Valida permisos para otros Usuarios
 * @author  kmarcos
 * @param   $id    ID de la consulta
 * @return  output(pnRender) Página de resultados
 */
function AddaxQuery_user_doQueryUsers($id)
{
    // Create output object 
    $pnRender =& new pnRender('AddaxQuery');
    $pnRender->caching = false;
    
    // Security check
	error_log("p1");
    if (!pnSecAuthAction(0, 'AddaxQuery::', 'user::doQueryUsers', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    error_log("p2");    
    $id = ((null != $id)?$id:pnVarCleanFromInput('id'));
    if (!isset($id)|| !is_numeric($id)) {
        return pnVarPrepHTMLDisplay(_AQ_QUERYIDMISSING);
    }
    error_log("p3");
    //Verifica que la consulta esté disponible para el usuario
    $disp = pnModAPIFunc('AddaxQuery',
                         'user',
                         'isavailablequery',
                         array('id' => $id));
    error_log("p4 [$disp]");                     
    if (!$disp){
        return pnVarPrepHTMLDisplay(_AQ_QUERYNOTAVAILABLE);
    }
    
    return doQuery($id,'user');
}

/**
 * Procesa la consulta dada y presenta los resultados. Eventualmente
 * retorna un flujo diferente para tomar datos del usuario (consultas parametrizadas).
 * No hace validaciones. La Funcion que la llame debe efectuar la validación.
 * @author  kmarcos
 * @param   id    ID de la consulta
 * @param   rol   indica que usuario esta accediendo a la consulta  
 * @return  output(pnRender) Página de resultados
 */
function doQuery($id, $rol)
{      
    //Elimina toda la información de la última consulta
    pnSessionDelVar('queryinfo');   

    // Create output object
    $pnRender =& new pnRender('AddaxQuery');
    $pnRender->caching = false;
    
    // The API function is called
    $resp = pnModAPIFunc('AddaxQuery',
                         'user',
                         'getSQLQuery',
                         array('id' => $id));

    if (!$resp) {
        $errormsg = pnSessionGetVar('errormsg');
        pnSessionDelVar('errormsg');
        return pnVarPrepHTMLDisplay(_AQ_QUERYSQLFAILED).(" $id").(": $errormsg");
    }
    
    //Guarda la información de la consulta para el momento de ejecutarla
    // o para recoger los parámetros más adelante
    pnSessionSetVar('queryinfo', $resp);
    pnSessionSetVar('queryuserrol',$rol);

    // Si la consulta tiene parametros deben recogerse del usuario
    if ( $resp[queryreqparam] ) {	
        //Si hay errores prepara la salida
        $queryerror = pnSessionGetVar('lastqueryerror');
        pnSessionDelVar('lastqueryerror');
        if (isset($queryerror)){
            $pnRender->assign('queryerror',$queryerror);
            pnSessionDelVar('lastqueryerror');
        }
        //Si la consulta tiene una Funcion propia para recoger los parámetros no
        //se hace el procesamiento genérico.
        $func = $resp[queryfuncparam];        
        if(isset($func) && $func!='')
        {
            return $func($resp,$pnRender);
        }        
        //Si no se ha definido una Funcion para recoger parámetros se hace el procesamiento
        //básico genérico
        $pnRender->assign('params',$resp[queryparamlist]);
        $pnRender->assign('queryname',$resp[querydesc]); 
        $pnRender->assign('queryid',$resp[queryid]);       
        // Return the output that has been generated by this function
        return $pnRender->fetch('AddaxQuery_user_getqueryparams.htm');
    }
    else{        
        //obtiene si esta definido el template de resultados particular
        $resultshtml = $resp['resultshtml'];
        if (!isset($resultshtml) || $resultshtml =='')
        {
            $resultshtml = 'AddaxQuery_user_reportresults.htm';
        }
        //Guarda el template de resultados
        pnSessionSetVar('resultshtml',$resultshtml);
        return AddaxQuery_user_executeQuery();
    }
}
    
/**
 * Ejecuta la consulta. La información de la consulta y el template de resultados
 * debe estar en el cache de la sesión. Puede recibir el número de página para presentar
 * los resultados
 * @author  kmarcos
 * @param   $page    Número de página de resultados a desplegar
 * @return  output(pnRender) Página de resultados
 */
function AddaxQuery_user_executeQuery()
{ 
    //Obtiene la información de la consulta del cache
    $qinfo = pnSessionGetVar('queryinfo');
    $urol= pnSessionGetVar('queryuserrol');
    $reshtml = pnSessionGetVar('resultshtml');
    
    //Si no se tiene información en cache no se puede ejecutar 
    if (!isset($qinfo) || empty($qinfo))
        return pnVarPrepHTMLDisplay(_AQ_QUERYGETCACHEFAILED);

    //Flag que indica si la consulta es para impresion
    $print = pnVarCleanFromInput('print');
    if (!isset($print)) {
        $print = false;
    }
    
    //Indica que no va por paginas si no todo
    $all = pnVarCleanFromInput('all');
    if (!isset($all)) {
        $all = false;
    }
    
    // Obtiene si lo hay, el número de pagina a mostrar
    $page = pnVarCleanFromInput('page');
    if (!isset($page)|| !is_numeric($page)) {
        $page = 1;
    }
    //Adiciona los datos de paginacion a la informacion de la consulta a ejecutar
    $qinfo['all']=$all;
    $qinfo['rpage']=$page;

    // Create output object
    $pnRender =& new pnRender('AddaxQuery');
    $pnRender->caching = false;    
 
    //si la consulta está completa la ejecuta
    $result = pnModAPIFunc('AddaxQuery',
                           'user',
                           'executeQuery',
                           $qinfo);

    // The return value of the function is checked here 
    if (!$result) {
        $qerrormsg = pnSessionGetVar('qerrormsg');
        if (isset($qerrormsg) && $qerrormsg !='')
        {
            pnSessionSetVar('lastqueryerror',pnVarPrepHTMLDisplay(_AQ_QUERYEXECUTEFAILED).(". SQL: $resp[querysql]").(": $qerrormsg"));
            pnSessionDelVar('qerrormsg');
        }
        else{
            pnSessionSetVar('lastqueryerror',pnVarPrepHTMLDisplay(_AQ_QUERYNOTRESULT));
        }
        $qid = $qinfo[queryid];
        if ($urol=='admin' && pnSecAuthAction(0, 'AddaxQuery::', 'user::doQueryDBAdmin', ACCESS_ADMIN)){
            pnRedirect(pnModURL('AddaxQuery', 'user', 'doQueryDBAdmin', array('id'=>$qid)));
        }
        else{
            pnRedirect(pnModURL('AddaxQuery', 'user', 'doQueryUsers', array('id'=>$qid)));
        }
    }

    $pnRender->assign('queryid',$qinfo[queryid]);
    if (isset($qinfo['queryparamvalues'])) $pnRender->assign('queryparamvalues',$qinfo['queryparamvalues']);
    $pnRender->assign('result',$result);
    $pnRender->assign('pathdigital',pnModGetVar('AddaxQuery','pathdocdigital'));
    $pnRender->assign('print',$print);

    // Return the output that has been generated by this function
    return $pnRender->fetch($reshtml);
}


/**
 * Ejecuta una consulta dada con parametros y presenta los resultados. 
 * @author  kmarcos
 * @return  output(pnRender)  Página de resultados
 */
function AddaxQuery_user_doQueryParam()
{

    // Create output object
    $pnRender =& new pnRender('AddaxQuery');
    $pnRender->caching = false;
    
    // Security check
    if (!pnSecAuthAction(0, 'AddaxQuery::', '::', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

    /*// revisa la autorización
    if (!pnSecConfirmAuthKey()) {
        $pnRender->assign("message",pnVarPrepHTMLDisplay(_BADAUTHKEY));
        return $pnRender->fetch('AddaxQuery_user_main.htm');
    }*/
    
    // submit is set if the users sends his data. 
    /*$submit = pnVarCleanFromInput('submit');
    if(!$submit) {
        $pnRender->assign("message",pnVarPrepHTMLDisplay(_BADAUTHKEY));
        return $pnRender->fetch('AddaxQuery_user_main.htm');
    }*/

    //Toma la información de la consultas
    $queryinfo = pnSessionGetVar('queryinfo');
    pnSessionDelVar('queryinfo');

    //Crea un mapa de parametro-valor para procesar la consulta
    $values = array();
    foreach($queryinfo['queryparamlist'] as $param) {
        $values[$param] = pnVarCleanFromInput($param);
        //Usado por la excepcion para la consulta por subjects
        //OJO: Supone que la consulta solo tiene un parametro
        $paramname = $param;
    }    

    //procesa el sql para reemplazar el valor de los parametros
    $finalquery = pnModAPIFunc( 'AddaxQuery',
                    'user',
                    'completeSQLQuery',
                    array('queryinfo'=> $queryinfo, 'queryparamvalues' => $values));
    $queryinfo['queryparamvalues']=$values;

    if (!$finalquery) {
        $errormsg = pnSessionGetVar('errormsg');
        pnSessionDelVar('errormsg');
        return pnVarPrepHTMLDisplay(_AQ_QUERYGETFAILED).(": $errormsg");
    }
	
    //reemplaza la consulta ya completa
    $queryinfo[querysql] = $finalquery;

    //finalmente envia a ejecutar la consulta:
    
    //Guarda la información de la consulta para el momento de ejecutarla
    pnSessionSetVar('queryinfo', $queryinfo);
    
    //obtiene si esta definido el template de resultados 
    $resultshtml = $queryinfo['resultshtml'];
    if (!isset($resultshtml) || $resultshtml =='')
    {
        $resultshtml = 'AddaxQuery_user_queryresults.htm';
    }
    error_log("finalquery [$finalquery] resultshtml [$resultshtml]");
    //Guarda el template de resultados
    pnSessionSetVar('resultshtml',$resultshtml);
    return AddaxQuery_user_executeQuery();      	

}


/**
 * Codifica una salida exitosa con JSON (para llamados por ajax)
 *ej: _AddaxQuery_returnNOK($browser,pnVarPrepHTMLDisplay(_AQ_FORMVALIDATEERROR),$docdataval);
 * @param String mensaje de salida
 * @param array arreglo de datos adicionales (opcional)
 * @author kmarcos
 */
function _AddaxQuery_returnOK($browser,$message,$data=false)
{
    $resp = array('status' => _AQ_OK,
                  'message' => $message,
                  'data' => $data);    
    if ($browser=="Microsoft Internet Explorer"){
        header("Content-Type: text/html; charset=iso-8859-1" );
    }
    error_log('LOG ERROR RESP OK'.json_encode($resp));
    return json_encode($resp);
}

/**
 * Codifica una salida NO exitosa con JSON (para llamados por ajax)
 * ej: _AddaxQuery_returnNOK($browser,pnVarPrepHTMLDisplay($msg));
 * @param String mensaje de salida
 * @param array arreglo de datos adicionales (opcional)
 * @author kmarcos
 */
function _AddaxQuery_returnNOK($browser,$message,$data=false)
{
    $resp = array('status' => _AQ_NOK,
                  'message' => $message,
                  'data' => $data);
    if ($browser=="Microsoft Internet Explorer"){
        header("Content-Type: text/html; charset=iso-8859-1" );
    }                 
    error_log('LOG ERROR RESP NOK'.json_encode($resp));   
    return json_encode($resp);
}
?>