<?php
// ======================================================================
// AddaxQuery by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxQuery
 * Consultas y reportes basicos
 * 
 * Aqui se encuentran las funciones del API del usuario.
 *
 * @package      PostNuke_Modules
 * @subpackage   AddaxQuery
 * @author       kmarcos
 * ======================================================================
 */ 
 
/**
 * Obtiene todas las consultas disponibles para el usuario
 * @author  kmarcos
 * @return  array con las consultas disponibles para el usuario o false si hay error
 */
function AddaxQuery_userapi_getallqueries()
{
    // Get database setup 
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    // Selecciona las consultas disponibles para el usuario
    $AQTable = $pntable['consultas'];
    $AQColumn = &$pntable['consultas_column'];

    $sql = "SELECT $AQColumn[id],
		   $AQColumn[descripcion]
           FROM $AQTable
	       WHERE $AQColumn[disponible] = '1'
           ORDER BY $AQColumn[id]";
    $result = $dbconn->Execute($sql);

    // Check for an error with the database code, and if so set an appropriate
    // error message and return
    if ($dbconn->ErrorNo() != 0) {
        pnSessionSetVar('errormsg', _AQ_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }
    

    // Put items into result array. 
    $items = array();
    for (; !$result->EOF; $result->MoveNext()) {
        list($id,$descripcion) = $result->fields;
        $items[] = array('id'=>$id,'descripcion' => $descripcion );
    }

    // All successful database queries produce a result set, and that result
    // set should be closed when it has been finished with
    $result->Close();

    // Return the items
    return $items;
}

/**
 * Dado un id de consulta, indica si está disponible o no
 * @author  kmarcos
 * @param int  id de consulta
 * @return  array con las consultas disponibles para el usuario o false si hay error
 */
function AddaxQuery_userapi_isavailablequery($args)
{
    
    extract($args);

    // Get database setup 
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    // Selecciona las consultas disponibles para el usuario
    $AQTable = $pntable['consultas'];
    $AQColumn = &$pntable['consultas_column'];

    $sql = "SELECT $AQColumn[disponible]
            FROM $AQTable
	        WHERE $AQColumn[id] = '$id'
            ORDER BY $AQColumn[id]";
    $result = $dbconn->Execute($sql);
	error_log("sql consultas: [$sql]");
    // Check for an error with the database code, and if so set an appropriate
    // error message and return
    if ($dbconn->ErrorNo() != 0) {
        pnSessionSetVar('errormsg', _AQ_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }
       
    list($disponible) = $result->fields;
   
    // All successful database queries produce a result set, and that result
    // set should be closed when it has been finished with
    $result->Close();

    // Retun true o false si está disponible
    return $disponible==1?true:false;
}

/**
 * Retorna el sql que debe ser ejecutado. Si es necesario recibir valores de entrada para 
 * completar la consulta (query parametrizado) esta función retorna la informaciòn necesaria.
 * @author   kmarcos
 * @param    args[$id]	identificador de consulta
 * @return   array      con key 'queryreqparam' se indica (true or false) si requiere obtener 
 *			valores para los parametros. 
 * 			con key 'queryparamlist' se obtiene la lista de parametros, si los hay.
 * 			con key 'querysql' retorna el sql a ejecutar.
 *			con key 'querydesc' retorna el nombre de la consulta.
 * 			con key 'queryprefix' retorna el prefijo de despliegue
 * 			retorna false en caso de error
 */
function AddaxQuery_userapi_getSQLQuery($args)
{

    // Get arguments from argument array - all arguments to this function
    // should be obtained from the $args array, getting them from other
    // places such as the environment is not allowed, as that makes
    // assumptions that will not hold in future versions of PostNuke
    extract($args);

    $id = ((null != $id)?$id:pnVarCleanFromInput('id'));

    // Verifica el id de consulta

    if (!isset($id)|| !is_numeric($id)) {
        pnSessionSetVar('errormsg', _MODARGSERROR);
        return false;
    }

    // Get datbase setup - note that both pnDBGetConn() and pnDBGetTables()
    // return arrays but we handle them differently.  For pnDBGetConn() we
    // currently just want the first item, which is the official database
    // handle.  For pnDBGetTables() we want to keep the entire tables array
    // together for easy reference later on
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    // It's good practice to name the table and column definitions you are
    // getting - $table and $column don't cut it in more complex modules
    $AQTable = $pntable['consultas'];
    $AQColumn = &$pntable['consultas_column'];

    $sql = "SELECT $AQColumn[descripcion],
                   $AQColumn[consulta],
		   $AQColumn[prefijo],
		   $AQColumn[conparam],
		   $AQColumn[funcparam],
		   $AQColumn[listaparam],
		   $AQColumn[resultshtml],
		   $AQColumn[conopciones]
            FROM $AQTable
            WHERE $AQColumn[id] = '" .(int)$id."'";
    //error_log('SQL QUERIES'.$sql);
    $result =& $dbconn->Execute($sql);

    // Check for an error with the database code, and if so set an appropriate
    // error message and return
    if ($dbconn->ErrorNo() != 0) {
        pnSessionSetVar('errormsg', _AQ_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }

    // Check for no rows found, and if so return
    if ($result->EOF) {
        return false;
    }

    // Obtain the item information from the result set
    list($descripcion, $consulta, $prefijo, $conparam, $funcparam, $listaparam, $resultshtml, $conopciones) = $result->fields;

    // All successful database queries produce a result set, and that result
    // set should be closed when it has been finished with
    $result->Close();

    //Obtiene la lista de parametros. Por ahora se supone que es un solo parámetro,
    //En el futuro cuando se manejen más parametros se debe modificar esta parte
    //para obtenerlos y procesarlos sacandolos en un arreglo
    if ( $conparam ){
        $params = explode (",",$listaparam);
        foreach ($params as $key => $par)
        {
            $params[$key] = "AQ_".$prefijo."_$par";
        }

    }

    //Verifica si hay opciones adicionales//////////////////////////////////
    $options = array();
    if( $conopciones ){      
        //Busca las opciones de detalle de la consulta
        $detailtable = $pntable['detailopts'];
        $detailcolumn = &$pntable['detailopts_column'];

        $sql = "SELECT  $detailcolumn[idopcion],
                        $detailcolumn[idcons],
                        $detailcolumn[etiqueta],
                        $detailcolumn[modulo],
                        $detailcolumn[tipofunc],
                        $detailcolumn[funcion],
                        $detailcolumn[params]
                FROM  $detailtable
                WHERE $detailcolumn[idcons] = '" .(int)$id."'";
        //error_log("sql2 $sql");
        $result =& $dbconn->Execute($sql);

        // Check for an error with the database code, and if so set an appropriate
        // error message and return
        if ($dbconn->ErrorNo() != 0) {
            pnSessionSetVar('errormsg', _AQ_DATABASEERROR);
            error_log("DB Error: ".$dbconn->ErrorMsg());
            return false;
        }

        // Si no hubo resultados, simplemente no despliega opciones. Si hubo resultados de opciones
        //para los detalles de las consultas los procesa para generar los links correspondientes
        if (!$result->EOF) {
            //Obtiene la información de las opciones. Por ahora maneja un solo parametro en la opción.
            //Si se requiriera manejar más debe procesarse y crear el arreglo ($detparams)            
            for (; !$result->EOF; $result->MoveNext()) {
                list($idopcion, $idcons, $etiqueta, $modulo, $tipofunc, $funcion, $detparams) = $result->fields;
                $options[] = array  ('idopcion' => $idopcion, 'idcons' => $idcons, 'etiqueta' => $etiqueta, 'modulo' => $modulo,'tipofunc' => $tipofunc, 'funcion' => $funcion, 'detparams' => $detparams);
            }
        }
        
        // All successful database queries produce a result set, and that result
        // set should be closed when it has been finished with
        $result->Close();
      
    }/////////////////////////////////////////////////////////////////////

    //Prepara el arreglo de salida
    $resp = array ('queryid'=>$id, 'querydesc'=>$descripcion, 'querysql'=>$consulta, 'queryreqparam'=>$conparam,
                   'queryfuncparam' =>$funcparam, 'queryparamlist' => $params, 'resultshtml' => $resultshtml, 'queryprefix'=>$prefijo, 
                   'conopciones' => $conopciones, 'detailopcs' => $options);
    return $resp;

}

/**
 * A partir de la información de la consulta parametrizada y el valor de los parametros,
 * completa la instrucción sql.
 * @author   kmarcos
 * @param    $args[$queryinfo]	información de la consulta
 * @param    $args[$queryparamvalues]  mapa de parametros-valores
 * @return   sql   instrucción sql completa o false en caso de error
 */
function AddaxQuery_userapi_completeSQLQuery($args)
{
    // Get arguments from argument array - all arguments to this function
    // should be obtained from the $args array, getting them from other
    // places such as the environment is not allowed, as that makes
    // assumptions that will not hold in future versions of PostNuke
    extract($args);

    // Verifica los argumentos
    if (!isset($queryinfo)|| !isset($queryparamvalues)) {
        pnSessionSetVar('errormsg', _MODARGSERROR);
        return false;
    }

    //Obtiene la instrucción sql
    $sql = $queryinfo[querysql];

    //recorres los parametros para reemplazarlos, pero antes debe procesarlos para quitarles
    //el prefijo de despliegue
    foreach($queryinfo[queryparamlist] as $param) {
	$value = $queryparamvalues[$param];
        $pos =strlen("AQ_".$queryinfo[queryprefix]."_");
        $newparam =  substr($param ,$pos);
	$sql = str_replace($newparam,$value,$sql);
    }
    return $sql;
}

/**
 * Ejecuta y retorna los resultados de la consulta según el id
 * @author   kmarcos
 * @param    args       con key 'queryreqparam' se indica (true or false) si requiere obtener 
 *			valores para los parametros. 
 * 			con key 'queryparamlist' se obtiene la lista de parametros, si los hay.
 * 			con key 'querysql' retorna el sql a ejecutar.
 *			con key 'querydesc' retorna el nombre de la consulta.
 * 			con key 'queryprefix' retorna el prefijo de despliegue
 * 			retorna false en caso de error
 * @return   array      arreglo de resultados, or false on failure
 */
function AddaxQuery_userapi_executeQuery($args)
{
    // Get arguments from argument array - all arguments to this function
    // should be obtained from the $args array, getting them from other
    // places such as the environment is not allowed, as that makes
    // assumptions that will not hold in future versions of PostNuke
    extract($args);

    // Verifica la consulta
    if (!isset($querysql)) {
        pnSessionSetVar('qerrormsg', _MODARGSERROR);
        error_log('no query');
        return false;
    }

    // Get datbase setup 
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();
    
    //Calcula el total de resultados de la consulta
    $sqlcount = 'select count(*) from ('.$querysql.') as queryresults';  
    $rescount =& $dbconn->Execute($sqlcount);
    
    if ($dbconn->ErrorNo() != 0) {
        pnSessionSetVar('qerrormsg', _SS_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }
    list($count) = $rescount->fields;
    
    //Si no hay resultados retorna false;
    if ($count==0){
        return false;
    }
    
    if (!$all){
        //Obtiene el número de resultados por página
        $numresults = pnModGetVar('AddaxQuery','resultsnum');
        //Modifica el SQL para sacar los resultados según el número de páginas
        $offset = ($rpage-1)* $numresults;
        $querysql .= ' limit '.$offset.','.$numresults;
    }
    // Ejecuta la consulta
    //error_log("Execute SQL $querysql");
    $result =& $dbconn->Execute($querysql);    

    // Check for an error with the database code, and if so set an appropriate
    // error message and return
    if ($dbconn->ErrorNo() != 0) {
        pnSessionSetVar('qerrormsg', _AQ_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }

    // Check for no rows found, and if so return
    if ($result->EOF) {
        return false;
    }
    
    //Organiza los nombres de columnas para un posible despliegue
    $columnNames = array();

    for ($i=0; $i < $result->FieldCount(); $i++){
        //Obtiene la informacion de la columna
	$col = $result->FetchField($i);
        //asigna el nombre de despliegue
        $columnNames[$i] = "AQ_".$queryprefix."_$col->name";
    }
    
    //Organiza los datos
    $data = array();
    $i=0;
    while ($row = $result->FetchRow()) {	
        $data[$i]= $row;
	$i++;
    }

    // Create the output array
    $item = array ( 'querydesc'=>$querydesc, 'columnames' => $columnNames, 'data'=>$data, 
                    'conopciones' => $conopciones, 'detailopcs' => $detailopcs, 
                    'restotal' => $count, 'curpage' => $rpage, 'respage' => $numresults);

    // Return the item array
    return $item;
}
?>