<?php
/**
 * Zikula Application Framework
 *
 * @copyright (c) 2001, Zikula Development Team
 * @link http://www.zikula.org
 * @version $Id: pnadmin.php 27323 2009-11-01 08:09:23Z drak $
 * @license GNU/GPL - http://www.gnu.org/copyleft/gpl.html
 *
 * @package      Zikula_System_Modules
 * @subpackage   legal
 * @author       Mark West
 * @author       The Zikula Development Team
 */

/**
 * the main administration function
 *
 * This function is the default function, and is called whenever the
 * module is called without defining arguments.
 * As such it can be used for a number of things, but most commonly
 * it either just shows the module menu and returns or calls whatever
 * the module designer feels should be the default function (often this
 * is the view() function)
 *
 * @author       The Zikula Development Team
 * @return       output       The main module admin page.
 */
function legal_admin_main()
{
    // Security check
    if (!SecurityUtil::checkPermission('legal::', '::', ACCESS_EDIT)) {
        return LogUtil::registerPermissionError();
    }

    // Create a new output object
    $pnRender = & pnRender::getInstance('legal', false);

    // Return the output that has been generated by this function
    return $pnRender->fetch('legal_admin_main.htm');
}

/**
 * Modify configuration
 *
 * This is a standard function to modify the configuration parameters of the
 * module
 *
 * @author       Mark West
 * @return       output       The configuration page
 */
function legal_admin_modifyconfig()
{
    $dom = ZLanguage::getModuleDomain('legal');
    // Security check
    if (!SecurityUtil::checkPermission('legal::', '::', ACCESS_ADMIN)) {
        return LogUtil::registerPermissionError();
    }

    // get all groups
    $groups = pnModAPIFunc('Groups', 'user', 'getall');

    // add dummy group "all groups" on top
    array_unshift($groups, array('gid' => 0, 'name' => __('All users', $dom)));

    // add dummy group "no groups" on top
    array_unshift($groups, array('gid' => -1, 'name' => __('No groups', $dom)));

    // Create output object
    $pnRender = & pnRender::getInstance('legal', false);

    // Assign all the module vars
    $pnRender->assign(pnModGetVar('legal'));
    $pnRender->assign('groups', $groups);

    // Return the output that has been generated by this function
    return $pnRender->fetch('legal_admin_modifyconfig.htm');
}

/**
 * Update the configuration
 *
 * This is a standard function to update the configuration parameters of the
 * module given the information passed back by the modification form
 * Modify configuration
 *
 * @author       Mark West
 * @param        termsofuse          enable terms of use
 * @param        privacypolicy       enable privacy policy
 * @param        accessibilitypolicy enable accessibility policy
 */
function legal_admin_updateconfig()
{
    $dom = ZLanguage::getModuleDomain('legal');
    // Security check
    if (!SecurityUtil::checkPermission('legal::', '::', ACCESS_ADMIN)) {
        return LogUtil::registerPermissionError();
    }

    // Confirm the forms authorisation key
    if (!SecurityUtil::confirmAuthKey()) {
        return LogUtil::registerAuthidError(pnModURL('legal', 'admin', 'main'));
    }

    // set our module variables
    $termsofuse = (bool)FormUtil::getPassedValue('termsofuse', false, 'POST');
    pnModSetVar('legal', 'termsofuse', $termsofuse);
    $privacypolicy = (bool)FormUtil::getPassedValue('privacypolicy', false, 'POST');
    pnModSetVar('legal', 'privacypolicy', $privacypolicy);
    $accessibilitystatement = (bool)FormUtil::getPassedValue('accessibilitystatement', false, 'POST');
    pnModSetVar('legal', 'accessibilitystatement', $accessibilitystatement);

    $resetagreement = (int)FormUtil::getPassedValue('resetagreement', -1, 'POST');
    if ($resetagreement<>-1) {
        pnModAPIFunc('Legal', 'admin', 'resetagreement', array('gid' => $resetagreement));
    }

    // The configuration has been changed, so we clear all caches for
    // this module.
    $pnRender = & pnRender::getInstance('legal', false);

    // the module configuration has been updated successfuly
    LogUtil::registerStatus(__('Done! Saved module configuration.', $dom));

    // Let any other modules know that the modules configuration has been updated
    pnModCallHooks('module','updateconfig', 'legal', array('module' => 'legal'));

    // This function generated no output, and so now it is complete we redirect
    // the user to an appropriate page for them to carry on their work
    return pnRedirect(pnModURL('legal', 'admin', 'main'));
}
