<?php

// This input plugin lets you select a publication of a certain type.
// The HTML output is a <select> element prefilled with the publications.

// The plugin uses extra type parameters for the publication type ID.
// The interface for this parameter is generated by the function
// typeextra_publication_render() in the file typeextra.publication.php.

class GuppyInput_publication extends GuppyInput
{
  function render($guppy)
  {
    // Always remember to load libraries you need. You never
    // know under which circumstances your plugin will be used.
    if (!pnModAPILoad('pagesetter','user'))
      return _MODAPILOADFAILED;

    // Generate styling based on XML layout file information
    $style = $this->getHtmlStyle();
    if ($style != '')
      $style = " style=\"$style\"";
    
    if ($this->readonly)
      $readonly = " readonly=\"1\"";
      
    // Load extra type parameter - in this case the publication type ID.
    // This value was selected by the user when designing the publication
    // in which this plugin is used.
    $tid = $this->typeData;

    // Fecth all publications for the <select> element.
    $pubList = pnModAPIFunc('pagesetter', 'user', 'getPubList', 
                            array('tid'       => $tid, 
                                  'noOfItems' => 1000) );

    
    // Create HTML based on publication list

    $html = "<select name=\"" . $this->name . "\" id=\"$id\" $style$readonly />";

    $html .= "<option value=\"-1\">- " . _NONE . " -</option>\n";

    foreach ($pubList['publications'] as $pub)
    {
      if ($pub['pid'] == $this->value)
        $selected = ' selected="1"';
      else
        $selected = '';

      $html .= "<option value=\"$pub[pid]\"$selected>$pub[title]</option>\n";
    }

    $html .= "</select>\n";

    return $html;
  }


  function decode()
  {
    $this->value = $_POST[$this->name];

      // If magic quotes are on then all query/post variables are escaped - so strip slashes
    if (get_magic_quotes_gpc())
      $this->value = stripslashes($this->value);

    $this->value = $this->value=0 ? "0" : (string)$this->value;

   	return $this->value;
  }


  function validate()
  {
    return true;
  }


  // ===[ Pagesetter interface ]==============================================

  function active()
  {
    return true;
  }

  function useExtraTypeInfo()
  {
    // Inform the framework about the fact that this plugin
    // uses extra type parameters
    return true;
  }

  function OnPublicationSaved(&$pubData, $action)
  {
    // echo "Publication Saved. Title = $pubData[title], action = $action.";
  }

  function getTitle()
  {
    return 'Publication (ID)';
  }

  function getSqlType()
  {
    return 'INT';
  }
  
  function getSqlFormat()
  {
  	return NULL;
  }
  
  function getDefaultWidth()
  {
    return 200;
  }
  
  function getDefaultHeight()
  {
  	return NULL;
  }
  
}

?>
