﻿<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

/**
 * Class IndexController
 *
 * Modulo Calendario
 */
class IndexController extends Zend_Controller_Action
{

	private $_configparams;


    public function init()
    {
        error_reporting(E_ALL);
        ini_set('display_errors', '1');
        /* Initialize action controller here */
        try
        {
            require_once(APPLICATION_PATH . "/models/DAOInit.php");
            Zend_Loader::loadClass('DAOInit');
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLCombos.php");
            Zend_Loader::loadClass('GeneradorHTMLCombos');

            require_once(APPLICATION_PATH . "/models/ObjetivoEspecifico.php");
            Zend_Loader::loadClass('ObjetivoEspecifico');
            require_once(APPLICATION_PATH.'/models/connector_de_calendario/scheduler_connector.php'); // para conectar los datos del calendario con mysql
            require(APPLICATION_PATH.'/models/connector_de_calendario/grid_connector.php');

            /*require_once(APPLICATION_PATH . "/models/EventoDeInspeccion.php");
            Zend_Loader::loadClass('EventoDeInspeccion');*/

            require_once(APPLICATION_PATH . "/models/EventoDeInspeccionesyMuestreos.php");
            Zend_Loader::loadClass('EventoDeInspeccionesyMuestreos');

            require_once(APPLICATION_PATH . "/models/AyudantedeCalendario.php");
            Zend_Loader::loadClass('AyudantedeCalendario');

            require_once(APPLICATION_PATH . "/models/UserUtil.php");
            Zend_Loader::loadClass('UserUtil');
            require_once(APPLICATION_PATH . "/models/Colaborador.php");
            Zend_Loader::loadClass('Colaborador');
            require_once(APPLICATION_PATH . "/models/Region.php");
            Zend_Loader::loadClass('Region');


            $controller = Zend_Controller_Front::getInstance();
            $this->request = $controller->getRequest();

            Zend_Loader::loadClass('DAOBaseIaTipoanalisis');
            Zend_Loader::loadClass('DAOIaTipoanalisis');

            Zend_Loader::loadClass('DAOBaseIaAnalisislaboratorio');
            Zend_Loader::loadClass('DAOIaAnalisislaboratorio');

            Zend_Loader::loadClass('DAOBaseIaColaboradores');
            Zend_Loader::loadClass('DAOIaColaboradores');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosmuestras');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosmuestras');

            Zend_Loader::loadClass('DAOBaseIaTipoestablecimiento');
            Zend_Loader::loadClass('DAOIaTipoestablecimiento');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosauditoriainspeccion');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosauditoriainspeccion');

            Zend_Loader::loadClass('DAOBaseIaObjetivosespecificos');
            Zend_Loader::loadClass('DAOIaObjetivosespecificos');

            Zend_Loader::loadClass('DAOBaseIaCamposformularioinspeccion');
            Zend_Loader::loadClass('DAOIaCamposformularioinspeccion');

            Zend_Loader::loadClass('DAOBaseIaLaboratorios');
            Zend_Loader::loadClass('DAOIaLaboratorios');

          /*  Zend_Loader::loadClass('DAOBaseIaEventosInspecciones');
            Zend_Loader::loadClass('DAOIaEventosInspecciones');*/

            Zend_Loader::loadClass('DAOBaseIaEventosInspeccionesMuestreos');
            Zend_Loader::loadClass('DAOIaEventosInspeccionesMuestreos');



            $this->_configparams = Zend_Registry::get('options');
            $this->config = Zend_Registry::get('config');


            $this->host = $this->config->db->config->host;
            $this->username = $this->config->db->config->username;
            $this->password = $this->config->db->config->password;
            $this->dbname = $this->config->db->config->dbname;

        }
        catch(Exception $e)
        {
            error_log("Excepcion iniciando index: [$e]");
        }
    }


    /**
     * Retorna el JSON del arreglo que se recibe como parametro
     * @param arregloRespuesta Arreglo que se va a convertir en JSON
     * @return JSON del arreglo que se recibe como parametro
     */
    public  function retornarJSON($arregloRespuesta)
    {
        $retorno = json_encode($arregloRespuesta);
        $vars = array();
        $vars['valor'] = $retorno ;
        $this->view->assignOld($vars);
        $temp_file = 'Calendartio_user_popup.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

/*******************************************************************************************************/
// actions que se encargan de la parte de cargar y conectar el calendario con la base
/*******************************************************************************************************/

    public function pruebaAction(){
        echo hola;
    }

    public function prueba2(){
        echo hola;
    }

    /**Carga la el calendario de inspecciones sin nada , fue la primera version (se puede borrar al final)
     *
     * MODULO: Calendario
     */
    public function  cargarcalendarioinspeccionessinnadaAction(){
        $vars = array();
        $vars['titulo'] = "Calendario de INSPECCIONES::Region XXXXX ";
        $this->view->assignOld($vars);
        $temp_file = 'Calendario_para_inspecciones_sin_nada.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**Carga la el calendario de MUESTREOS sin nada , fue la primera version (se puede borrar al final)
     * MODULO: Calendario
     */
    public function  cargarcalendariomuestreossinnadaAction(){
        $vars = array();
        $vars['titulo'] = "Calendario de MUESTREOS::Region XXXXX";
        $this->view->assignOld($vars);
        $temp_file = 'Calendario_para_muestreos_sinnada2.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


    /**Carga la pantalla de el calendario de inspecciones
     *
     * MODULO: Calendario
     */
    public function  cargarcalendarioinspeccionesAction(){
        $id_region="3";
        $nombre_region="Central Occidental";
        $id_encargado="9";
        $nombre_colaborador="Carlos Viquez T.";
        // lo anterior debria ser enviado por parametros o de la base
        $vars = array();

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipo_inspeccion", $id = "tipo_inspeccion", $items, $opcionSeleccione = true ,$extra = "class='entrada'");

        $inspectores = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaColaboradores", "inspector=1 AND id_region=$id_region", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_inspectores_html = $generadorHTMLCombos->generarHTMLCombo($name = "encargado", $id = "encargado", $inspectores, $opcionSeleccione = true,$extra = "class='entrada'",false,$id_encargado);//,false,$tipo_establecimiento_id);

        /*estos se deberiar recaragar cada vez que se abre el ligth box, tambien deberia cargar los que esta especificamente asignados a el encargado de primero y marcados de alguna manera*/
        $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='INSPECCION' AND estado='Pendiente' AND colaborador IS NULL", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "tipoobjetivo");
        $combo_inspecciones_especificas_html = $generadorHTMLCombos->generarHTMLCombo($name = "inspeccion_especifica", $id = "inspeccion_especifica", $itmes, $opcionSeleccione = true,$extra = "class='combo2' style='width:467px; margin-bottom: 5px;'");//,false,$tipo_establecimiento_id);

        $vars['comboInspeccionesEspecificas'] =$combo_inspecciones_especificas_html;
        $vars['comboTipoObjetivo'] =$combo_tipo_objetivo_html;
        $vars['comboInspectores'] = $combo_inspectores_html;
        $vars['id_encargado']=$id_encargado;

        $vars['nombre_colaborador']= $id_encargado;
        $vars['titulo']="Calendario de INSPECCIONES<br>Región ".$nombre_region." :: Colaborador ".$nombre_colaborador;
        $this->view->assignOld($vars);
        $temp_file = 'Calendario_para_inspecciones.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * se encaraga de carga el calendario de muestreos
     *
     */
    public function  cargarcalendariomuestreosAction(){
        $id_region="3";
        $nombre_region="Central Occidental";
        $id_encargado="9";
        $nombre_colaborador="Carlos Viquez T.";
        // lo anterior debria ser enviado por parametros o de la base
        $vars = array();

        $generadorHTMLCombos = new GeneradorHTMLCombos();

        $inspectores = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaColaboradores", "Tomadormuestra=1 AND id_region=$id_region", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_inspectores_html = $generadorHTMLCombos->generarHTMLCombo($name = "encargado", $id = "encargado", $inspectores, $opcionSeleccione = true,$extra = "class='entrada'",false,$id_encargado);//,false,$tipo_establecimiento_id);

        /*estos se deberiar recaragar cada vez que se abre el ligth box, tambien deberia cargar los que esta especificamente asignados a el encargado de primero y marcados de alguna manera*/
        $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='MUESTREO' AND estado='Pendiente' ", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "periodo");
        $combo_inspecciones_especificas_html = $generadorHTMLCombos->generarHTMLCombo($name = "inspeccion_especifica", $id = "inspeccion_especifica", $itmes, $opcionSeleccione = true,$extra = "class='combo2' style='width:467px; margin-bottom: 5px;'");//,false,$tipo_establecimiento_id);

        /*llena el comobo de los analisis*/
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", "habilitado=1", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_analisis__nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoAnalisis", $id = "cbTipoAnalisisNuevo", $items, $opcionSeleccione = true, $extra="style='width: 230px; margin-bottom: 12px;' class='select2' onchange='cargarComboAnalisisNuevo()'");
        $vars['cbTipoAnalisisNuevo'] = $combo_tipo_analisis__nuevo_html;

        $vars['comboInspeccionesEspecificas'] =$combo_inspecciones_especificas_html;
        $vars['comboInspectores'] = $combo_inspectores_html;
        $vars['id_encargado']=$id_encargado;

        $vars['nombre_colaborador']= $id_encargado;
        $vars['titulo']="Calendario de  Tomas de Muestras <br> Región ".$nombre_region." :: Colaborador ".$nombre_colaborador;
        $this->view->assignOld($vars);
        $temp_file = 'Calendario_para_muestreos.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * Se encaragd de hacer el llamado para cargar
     */
    public function  cargarcalendariodeinspeccionesymuestreosAction(){
        $id_region="3";
        $nombre_region="Central Occidental";
        $id_encargado="9";
        $nombre_colaborador="Carlos Viquez T.";
        // lo anterior debria ser enviado por parametros o de la base
        $vars = array();

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipo_inspeccion", $id = "tipo_inspeccion", $items, $opcionSeleccione = true ,$extra = "class='entrada'");

        $inspectores = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaColaboradores", "inspector=1 AND id_region=$id_region", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_inspectores_html = $generadorHTMLCombos->generarHTMLCombo($name = "encargado", $id = "encargado", $inspectores, $opcionSeleccione = true,$extra = "class='entrada'style='width: 218px;'",false,$id_encargado);//,false,$tipo_establecimiento_id);

        /*estos se deberiar recaragar cada vez que se abre el ligth box, tambien deberia cargar los que esta especificamente asignados a el encargado de primero y marcados de alguna manera*/
        $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='INSPECCION' AND estado='Pendiente' AND colaborador IS NULL", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "tipoobjetivo");
        $combo_inspecciones_especificas_html = $generadorHTMLCombos->generarHTMLCombo($name = "inspeccion_especifica", $id = "inspeccion_especifica", $itmes, $opcionSeleccione = true,$extra = "class='combo2' style='width:477px; margin-bottom: 5px;'");//,false,$tipo_establecimiento_id);

        /*llena el comobo de los analisis*/
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", "habilitado=1", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_analisis__nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoAnalisis", $id = "cbTipoAnalisisNuevo", $items, $opcionSeleccione = true, $extra="style='width: 230px; margin-bottom: 12px;' class='select2' onchange='cargarComboAnalisisNuevo()'");
        $vars['cbTipoAnalisisNuevo'] = $combo_tipo_analisis__nuevo_html;


        $vars['comboInspeccionesEspecificas'] =$combo_inspecciones_especificas_html;
        $vars['comboTipoObjetivo'] =$combo_tipo_objetivo_html;
        $vars['comboInspectores'] = $combo_inspectores_html;
        $vars['id_encargado']=$id_encargado;

        $vars['nombre_colaborador']= $id_encargado;
        $vars['titulo']=" Región ".$nombre_region." :: Colaborador ".$nombre_colaborador."<br> Calendario de Inspecciones y Tomas de Muestras";
        $this->view->assignOld($vars);
        $temp_file = 'Calendario_de_inspecciones_y_muestreos.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


 /** este el que esta en uso 230215
     * Se encaragd de hacer el llamado para cargar el calendario de muestreos y inspecciones
  *     pero este carga la informacion del uauario y los datos dependiento de su estado
     */
    public function  cargarcalendarioAction(){

        $user_id = pnUserGetVar('uid');
        $colaborador = new Colaborador(NULL, $user_id);// id colaborador , id zkuser
        $colaborador = $colaborador->toArray();
        $vars = $colaborador;
        $vars['region']= Region::nombreregion($vars['id_region']);
        $id_region= $vars['id_region'];

        $evento_especifivo=$this->request->getParam('evento_especifico');
        $vars['id_de_evento_especifico_a_abrir']=$evento_especifivo;// sirve para que se abra el evento especifico , una vez se cargue el calendario, en el caso de que le manden el parametro

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipo_inspeccion", $id = "tipo_inspeccion", $items, $opcionSeleccione = true ,$extra = "class='entrada'");
        $whereinspectores='(inspector=1 OR tomadormuestra=1) AND habilitado=1';
        if($vars['administrador_central']!='1'){
            if($vars['administrador_regional']=='1'){ // si es administrador le muestra todos los de esa region
                $whereinspectores="(inspector=1 OR tomadormuestra=1) AND habilitado=1 AND (id_region=$id_region OR id_region_secundaria=$id_region) ";
            }else{
                $whereinspectores=" usuario_id=$user_id";
            }
        }
        $inspectores = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaColaboradores", $whereinspectores , $ordebBy = "nombre", $value = "id", $text = "nombre", $text2 = "identificacion");
        $combo_inspectores_html = $generadorHTMLCombos->generarHTMLCombo($name = "encargado", $id = "encargado", $inspectores, $opcionSeleccione = true,$extra = "class='entrada' style='width: 218px;'",false, $vars['id']);//,false,$tipo_establecimiento_id);

        /*Esta parte de cargar el combo de especificos es vara por que este siempre se recarga cada vesz que se abre el formulario de eventos*/

        if($vars['administrador_central']=='1'){ // si es administrador central le muestra todos los objetivos de todas las regiones
            $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='INSPECCION' AND estado='Pendiente' AND colaborador IS NULL", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "tipoobjetivo");
        }else{
            $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='INSPECCION' AND estado='Pendiente' AND colaborador IS NULL AND id_region='$id_region' ", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "tipoobjetivo");
        }
        $combo_inspecciones_especificas_html = $generadorHTMLCombos->generarHTMLCombo($name = "inspeccion_especifica", $id = "inspeccion_especifica", $itmes, $opcionSeleccione = true,$extra = "class='combo2' style='width:477px; margin-bottom: 5px;'");//,false,$tipo_establecimiento_id);


        /*llena el comobo de los analisis*/
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", "habilitado=1", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_analisis__nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoAnalisis", $id = "cbTipoAnalisisNuevo", $items, $opcionSeleccione = true, $extra="style='width: 230px; margin-bottom: 12px;' class='select2' onchange='cargarComboAnalisisNuevo()'");
        $vars['cbTipoAnalisisNuevo'] = $combo_tipo_analisis__nuevo_html;


        $vars['comboInspeccionesEspecificas'] =$combo_inspecciones_especificas_html;
        $vars['comboTipoObjetivo'] =$combo_tipo_objetivo_html;
        $vars['comboInspectores'] = $combo_inspectores_html;
        $vars['id_encargado']= $vars['id'];
        $vars['nombre_colaborador']=  $vars['nombre'];
        $vars['titulo']= $vars['nombre']  ;
        if($vars['administrador_central']=='1'){
            $vars['titulo'].= "| Región: TODAS<br> Calendario de Inspecciones y Tomas de Muestras para TODAS las regiónes";
        }elseif ($vars['administrador_regional']=='1'){
            $vars['titulo'].= "| Región:".$vars['region']."<br>Calendario de Inspecciones y Tomas de Muestras para TODA la región";
        }else{
            $vars['titulo'].= "| Región:".$vars['region']."<br>Calendario de Inspecciones y Tomas de Muestras PERSONAL";
        }

            $this->view->assignOld($vars);
        $temp_file = 'Calendario_inspeccionesymuestreos_conparametros.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }



    /**
     * se encarga de hacer la coneccion de los datos de la base con los del calendario, esto para que pueda cargar y modidficar eventos, esto usando los models "conector" */
    public function conectadatoscalendariomuestreoAction(){
        $res=mysql_connect( $this->host,$this->username,$this->password);/// LOS DATOS DE CONEXION
        mysql_select_db($this->dbname);
        $scheduler=new JSONSchedulerConnector($res,"MySQL"); /* objeto que se encarga de la coneccion de datos, definicion en models/conector/scheduler_conetor */
        //$scheduler->render_table("ia_eventos_muestreos","event_id","start_date,end_date,event_name,tipo,tipo_analisis,details,establecimiento,encargado,analisis,muestras_especificas");
        $sql="SELECT * FROM ia_eventos_inspecciones_muestreos WHERE estado_evento NOT LIKE '%Borrado%' AND tipo = 'Muestreo'";
        $scheduler->render_sql($sql,"event_id","start_date,end_date,event_name,tipo,details,establecimiento,encargado,laboratorio,objetivo_especifico,analisis_de_muestreo,estado_evento");
        //  $scheduler->render_table("ia_eventos_inspecciones_muestreos","event_id","start_date,end_date,event_name,tipo,tipo_inspeccion,details,establecimiento,encargado,laboratorio,objetivo_especifico,numero_de_seguimiento,formulario_numerodehojadevisita,analisis_de_muestreo,estado_evento");
        Zend_Registry::set('response', $scheduler); // aparate de esto el calendario requiere de uns js y una cofiguracion en el template
    }


    /**
     * Se encarga de hacer la coneccion de los datos de la base con los del calendario de inspecciones, esto para que pueda cargar y modidficar eventos, esto usando los models "conector"
     *
     *deberia recibir parametros dependiendo de las vistas que se quieren hacer
     *
     * region: para que filtre solo enevtos de una region especifica
     * encargado asigando: para la vista de encargado que solo muestre las que son de el
     * permiso: para la vista global para que no pueda cambiar algo
     *
     */
    public function conectadatoscalendarioinspeccionAction(){
        $region=false;
        $encargado=false;
        $quitarpermisos=false;
        $res=mysql_connect( $this->host,$this->username,$this->password);/// LOS DATOS DE CONEXION
        mysql_select_db($this->dbname);
        $scheduler=new JSONSchedulerConnector($res,"MySQL"); /* objeto que se encarga de la coneccion de datos, definicion en models/conector/scheduler_conetor */
        // $scheduler->render_table("ia_eventos_inspecciones","event_id","start_date,end_date,event_name,tipo,tipo_inspeccion,details,establecimiento,encargado,laboratorio,objetivo_especifico,numero_de_seguimiento,estado_evento,formulario_numerodehojadevisita");
        $sql="SELECT * FROM ia_eventos_inspecciones_muestreos WHERE estado_evento NOT LIKE '%Borrado%' AND tipo = 'Auditoria-Inspeccion'";
        if($region){
            $sql.=" AND id_region ='$region' ";
        }
        if($encargado){
            $sql.=" AND encargado ='$encargado' ";
        }
        if($quitarpermisos){//cambiar permisos
            $scheduler->access->deny("insert");
            $scheduler->access->deny("update");
            $scheduler->access->deny("delete");
        }
        $scheduler->render_sql($sql,"event_id","start_date,end_date,event_name,tipo,tipo_inspeccion,details,establecimiento,encargado,laboratorio,objetivo_especifico,numero_de_seguimiento,formulario_numerodehojadevisita,analisis_de_muestreo,estado_evento");

        Zend_Registry::set('response', $scheduler);// aparate de esto el calendario requiere de uns js y una cofiguracion en el template
    }



    /**
      * Se encarga de hacer la coneccion de los datos de la base con los del calendario, esto para que pueda cargar y modidficar eventos, esto usando los models "conector"
      *
      *deberia recibir parametros dependiendo de las vistas que se quieren hacer
     * tambien se encarga de la verificacion de datos para hacer el live update , en caso de que dos personas modifique el mismo evento
      *
      * region: para que filtre solo enevtos de una region especifica
      * encargado asigando: para la vista de encargado que solo muestre las que son de el
      * permiso: para la vista global para que no pueda cambiar algo
      *
      */
    public function conectadatoscalendarioinspeccionymuestreosAction(){
        $region=$this->request->getParam('region');
        $encargado=$this->request->getParam('encargado');
        $quitarpermisos=false;
        $res=mysql_connect( $this->host,$this->username,$this->password);/// LOS DATOS DE CONEXION
        mysql_select_db($this->dbname);
       //$scheduler=new JSONSchedulerConnector($res,"MySQL"); /* objeto que se encarga de la coneccion de datos, definicion en models/conector/scheduler_conetor */
       // $scheduler->render_table("ia_eventos_inspecciones","event_id","start_date,end_date,event_name,tipo,tipo_inspeccion,details,establecimiento,encargado,laboratorio,objetivo_especifico,numero_de_seguimiento,estado_evento,formulario_numerodehojadevisita");
        $sql="SELECT * FROM ia_eventos_inspecciones_muestreos WHERE estado_evento NOT LIKE '%Borrado%'";
        if($region){
            $sql.=" AND id_region ='$region'";
        }
        if($encargado){
            $sql.=" AND encargado ='$encargado'";
        }

      //  $scheduler->render_sql($sql,"event_id","start_date,end_date,event_name,tipo,tipo_inspeccion,details,establecimiento,encargado,laboratorio,objetivo_especifico,numero_de_seguimiento,formulario_numerodehojadevisita,analisis_de_muestreo,estado_evento");

       $scheduler = new schedulerConnector($res,"MySQL");
        if($quitarpermisos){//cambiar permisos
            $scheduler->access->deny("insert");
            $scheduler->access->deny("update");
            $scheduler->access->deny("delete");
        }
       $scheduler->enable_live_update('ia_actions_table');
       $scheduler->render_sql($sql,"event_id","start_date,end_date,event_name,tipo,tipo_inspeccion,details,establecimiento,establecimiento_id,encargado,laboratorio,objetivo_especifico,numero_de_seguimiento,formulario_numerodehojadevisita,analisis_de_muestreo,estado_evento,id_region");


        Zend_Registry::set('response', $scheduler);// aparate de esto el calendario requiere de uns js y una cofiguracion en el template
    }


/*******************************************************************************************************/



    /**
     * Se encarga de cargar el combo de objetivos especificos de inspeccion
     *
     * deberia recibir , la region para solo cargar los objetivos especificos de esa region
     *                  el id del encargado , para cargar los especificos que estan directamente asignados a ese encargado
     *                  el id de unobjetoespecifico, como solo se deberia mostrar los que estan pendiendes para hacer la expecccion para el caso donde es un especifo que ya se seleciono
     */
    public function recargarcombodeespecificosinspeccionesAction(){
        /*estos se deberiar recaragar cada vez que se abre el ligth box, tambien deberia cargar los que esta especificamente asignados a el encargado de primero y marcados de alguna manera*/
        $region=1;
        $vars= array();
        $vars['resultado']=true;
        $html="<option value=''>-- Seleccione --</option>";
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $id_objetivo_especifico = $this->request->getParam('id_objetivo_especifico');
        $id_encargado = $this->request->getParam('id_encargado');
        if(!is_null($id_objetivo_especifico) ){
            $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='INSPECCION' AND id=$id_objetivo_especifico", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "tipoobjetivo");
            foreach($itmes as $item){
                $html.= "<option value='".$item['value']."' selected >**".$item['text']."**</option>";
            }
        }
        if(!is_null($id_encargado) ){
            $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='INSPECCION' AND estado='Pendiente' AND id_colaborador = $id_encargado", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "tipoobjetivo");
            foreach($itmes as $item){
                $html.= "<option value='".$item['value']."' >".$item['text']." (*Este fue Asignado a usted Directamente) </option>";
            }

        }
        $itmes = $generadorHTMLCombos->getRegistrosTablaBDDosTexts($tabla = "DAOIaObjetivosespecificos", "tipo='INSPECCION' AND estado='Pendiente' AND colaborador IS NULL", $ordebBy = "nombreestablecimiento", $value = "id", $text = "nombreestablecimiento",$text2 = "tipoobjetivo");
        foreach($itmes as $item){
            $html.= "<option value='".$item['value']."' >".$item['text']."</option>";
        }
        $vars['comboInspeccionesEspecificas'] =$html;
        $this->retornarJSON($vars);
    }


    /**
     * Se encarga de cargar el combo de objetivos especificos de inspeccion y muestreos
     *
     * deberia recibir ,si solo va caraga de inspeccion o de muestreos o los dos
     *                  la region para solo cargar los objetivos especificos de esa region
     *                  el id del encargado , para cargar los especificos que estan directamente asignados a ese encargado
     *                  el id de unobjetoespecifico, como solo se deberia mostrar los que estan pendiendes para hacer la expecccion para el caso donde es un especifo que ya se seleciono
     */
    public function recargarcombodeespecificosinspeccionesymuestreosAction(){
        /*estos se deberiar recaragar cada vez que se abre el ligth box, tambien deberia cargar los que esta especificamente asignados a el encargado de primero y marcados de alguna manera*/

        $vars= array();
        $vars['resultado']=true;
        $html="<option value=''>-- Seleccione --</option>";
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $id_objetivo_especifico = $this->request->getParam('id_objetivo_especifico');
        $id_encargado = $this->request->getParam('id_encargado');
        $region=$this->request->getParam('id_region');
        $tipodeopjetivo = '0';//$this->request->getParam('tipo'); // 0 agrra los dos tipos

        //$region='0';

        $wheredetipo=" ";//whwere 1
        if ($tipodeopjetivo == "1"){
            $wheredetipo=" tipo='INSPECCION' AND ";
        }
        if ($tipodeopjetivo == "2"){
            $wheredetipo=" tipo='MUESTREO' AND ";
        }

        $wherederegion="";//whwere 1
        if ($region !='0' && $region !=''&& $region !=null){
            $wherederegion=" id_region ='$region' AND ";
        }


        if(!is_null($id_objetivo_especifico) && $id_objetivo_especifico!='0' && $id_objetivo_especifico!=''){// si se le mando un id de alguno especifico lo carga
            $itmes = $generadorHTMLCombos->getRegistrosTablaBDcuatroTexts($tabla = "DAOIaObjetivosespecificos", " id=$id_objetivo_especifico", $ordebBy = " tipo , nombreestablecimiento", $value = "id", $text = "tipo",$text2 = "nombreestablecimiento",$text3 = "tipoobjetivo",$text4 = "idestablecimiento");
            foreach($itmes as $item){
                $html.= "<option value='".$item['value']."' selected >**".$item['text']."**</option>";
            }
        }
        if(!is_null($id_encargado) && $id_encargado!='' ){// carga las que son especificamente del encargado
            $itmes = $generadorHTMLCombos->getRegistrosTablaBDcuatroTexts($tabla = "DAOIaObjetivosespecificos", " $wheredetipo estado='Pendiente' AND id_colaborador = $id_encargado", $ordebBy = "tipo , nombreestablecimiento", $value = "id", $text = "tipo",$text2 = "nombreestablecimiento",$text3 = "tipoobjetivo",$text4 = "idestablecimiento");
            foreach($itmes as $item){
                $html.= "<option value='".$item['value']."' >".$item['text']."(Asignado a usted Directamente)</option>";
            }

        }
        //esta ultima carga todos los demas objetivos especiales pendientes
        $itmes = $generadorHTMLCombos->getRegistrosTablaBDcuatroTexts($tabla = "DAOIaObjetivosespecificos", " $wheredetipo $wherederegion estado='Pendiente' AND id_colaborador IS NULL", $ordebBy = "tipo , nombreestablecimiento", $value = "id",$text = "tipo",$text2 = "nombreestablecimiento",$text3 = "tipoobjetivo",$text4 = "idestablecimiento");
        foreach($itmes as $item){
            $html.= "<option value='".$item['value']."' >".$item['text']."</option>";
        }
        $vars['comboInspeccionesEspecificas'] =$html;
        $this->retornarJSON($vars);
    }

    /**
     * Retorna todos los datos de un objetivo especifico por medio de json
     */
    public function datosobjetivoespecificoAction(){
        $id_objetivo_especifico = $this->request->getParam('id');
        try{
            $modelo = new ObjetivoEspecifico($id_objetivo_especifico);
            $array = $modelo->toArray();
            $respuesta['datos'] = $array;
            $respuesta['resultado'] = true;
        }
        catch(Exception $e){
            $respuesta['resultado'] = false;
        }
        $this->retornarJSON($respuesta);
    }


    /**
     *Se encarga de moficicar los datos de un objetivo especifico
     */
    public function modificarestadoobjetivoespecificoAction(){
        $datos_objetivo_especifico = $this->request->getParam('estado');
        $id_objetivo_especifico = $this->request->getParam('id_objetivo_especifico');
        $cast = $this->request->getParam('cast');
        $respuesta['resultado'] = false;

        if ($id_objetivo_especifico){
            try{

                $Obje= new ObjetivoEspecifico($id_objetivo_especifico);

                if($cast!=''){
                    $verifica=$Obje->toArray();
                    if($verifica ['cast']==$cast){

                        $Obje->modificar( array("estado" => $datos_objetivo_especifico));
                        $respuesta['resultado'] = true;
                        $respuesta['mensaje'] = 'Timestamp igual';
                    }else{

                        $respuesta['resultado'] = false;
                        $respuesta['mensaje'] = 'Timestamp diferente';
                    }
                }else{
                   ;
                    $Obje->modificar( array("estado" => $datos_objetivo_especifico));
                    $respuesta['resultado'] = true;
                    $respuesta['mensaje'] = 'Timestamp limpio';
                }


            }catch(Exception $e){
                $respuesta['resultado'] = false;
                $respuesta['mensaje'] = 'error de modificacion ';
            }
           // $establecimiento = $Obje->toArray();
           // $respuesta['datos'] = $establecimiento;
        }
        $this->retornarJSON($respuesta);
    }



    /**
     * Retorna todos los datos de un evento de inspeccion por medio de json
     */
    public function datoseventodeinspeccionAction(){
        $id = $this->request->getParam('id');
        try{
            $modelo = new EventoDeInspeccionesyMuestreos($id,null);
            $datosdeinspeccion = $modelo->toArray();
            $respuesta['datos'] = $datosdeinspeccion;
            $respuesta['resultado'] = true;
        }
        catch(Exception $e){
            $respuesta['resultado'] = false;
        }
        $this->retornarJSON($respuesta);
    }


    /**
     * Se encarga de guardar los datosd e  la tabala de evento de inspeccion
     *
     */
    public function guardardatoseventodeinspeccionAction(){
        $id = $this->request->getParam('id');
       // $camposaguardar= $this->request->getParams();
        $camposaguardar= $this->request->getParam('estado_evento');

        $respuesta = array();
        $result = false;
        echo $id;
        if ($id !=''){
            try{
                $eventoinspeccion = new EventoDeInspeccionesyMuestreos($id);
              //  $result = $eventoinspeccion->modificar($camposaguardar);
                $result = $eventoinspeccion->modificar( array("estado_evento" => $camposaguardar));
                $eventoinspeccion_fields = $eventoinspeccion->toArray();
                $respuesta['eventoinspeccion_fields']=$eventoinspeccion_fields;
            }
            catch(Exception $e){
                $result = false;
                $str_error = $e->getMessage();
            }
        }

        $respuesta['camposaguardar']=$camposaguardar;
        $respuesta['resultado'] = $result;

        $this->retornarJSON($respuesta);

    }





    /*devuele todos los analisis para un tipo de analisis de muestreo
     *  devuelve las opciones en forma de option html */
    public function obteneranalisisparamuestreoAction(){

        $tipo_analisis_id = $this->request->getParam('tipo_analisis_id');
        //@TODO limpiar y validar esta variable

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaAnalisislaboratorio", "tipoanalisis_id=".$tipo_analisis_id. " AND habilitado=1 ", $ordebBy = "nombre", $value = "id", $text = "nombre");
        if($items!= false){
            $options = '';
            foreach($items as $analisis){
                $nombre = $analisis['text'];
                $valor = $analisis['value'];
                $options .= "<option value=$valor>$nombre</option>";
            }
            $respuesta['resultado'] = true;
            $respuesta['options'] = $options;
        }else{
            $respuesta['resultado'] = false;
        }
        $this->retornarJSON($respuesta);
    }


    /**
     * devuelve los nombres de la hilera de analisis que se guarda con cada
     */
    public function decodificaranalisisdemuestreoAction(){

        $hilera = $this->request->getParam('hilera_a_decodificar');
        $piesas = explode(",", $hilera);
        $hileraderespuesta=array();
        $respuesta['resultado'] = true;
      //  echo $piesas;
        if(count($piesas)>0){
            foreach($piesas as $piesa){
                $analisisid = explode(".", $piesa);
                $nombres=AyudantedeCalendario::nombresdeclaseyanalisis($analisisid[0]);
               if($nombres){
                   $hileraderespuesta[]= array('nombre'=> $nombres[0]['nombre'] ,'nombret'=> $nombres[0]['nombretipo'] ,'id'=>$analisisid[0],'cantidad'=>$analisisid[1],);

               }
         }
        }else{
            $respuesta['resultado'] = false;
        }
        $respuesta['options'] = $hileraderespuesta;
        $this->retornarJSON($respuesta);
    }







    /**
     * Index de prueba para ver las funciones pricipales de cada modulo de forma mas simple
     */
    public function indexdepruebaAction()
    {
        echo "<center><h1>Index</h1>";
        echo "<p>Index con las principales funciones de cada modulo</p><br />";
        echo "<h2>CALENDARIO</h2>
                <a style='text-decoration: none;' href=\"/zf_Calendario/index/cargarcalendarioinspecciones\"><div class='botonverde2'>Calendario inspecciones de una region</div></a><br/>
				<a  style='text-decoration: none;'href=\"/zf_Calendario/index/cargarcalendariomuestreos\"><div class='botonverde2'>Calendario muestreos de una region</div></a><br/>
				<a  style='text-decoration: none;'href=\"/zf_Calendario/index/cargarcalendariodeinspeccionesymuestreos\"><div class='botonverde2'>Calendario de Inspecciones y Muestreos</div></a><br/>

			";
        echo "<h2>CENTRAL</h2>
                <a style='text-decoration: none;' href=\"/zf_Central/index/definicionobjetivosinspeccion\"><div class='botonverde2'>Definicion objetivos anuales inspeccion</div></a><br/>
                 <a style='text-decoration: none;' href=\"/zf_Central/index/definicionobjetivosinspeccionespecificos\"><div class='botonverde2'>Definicion objetivos de inspeccion Especificos</div></a><br/>
				<a style='text-decoration: none;' href=\"/zf_Central/index/definicionderegionesparaobjetivosinspeccion\"><div class='botonverde2'>Definicion de regiones para objetivos inspeccion anuales</div></a><br/><br/>

               <a style='text-decoration: none;' href=\"/zf_Central/index/definicionobjetivosanualesmuestra\"><div class='botonverde2'>Definicion objetivos anuales muestras</div></a><br/>
               <a style='text-decoration: none;' href=\"/zf_Central/index/definicionobjetivosmuestrasespecificos\"><div class='botonverde2'>Definicion objetivos de muestas Especificos</div></a><br/>
                <a style='text-decoration: none;' href=\"/zf_Central/index/definicionderegionesparaobjetivosmuestras\"><div class='botonverde2'>Definicion de regiones para objetivos muestrasanuales</div></a><br/>
			  			";
        echo "<h2>REGIONAL </h2>
                <a style='text-decoration: none;' href=\"/zf_Regional/index/busqueda\"><div class='botonverde2'>Busqueda establecimiento*</div></a><br/>
                <a style='text-decoration: none;' href=\"/zf_Regional/index/asignacionobjetivosespecificosinspeccion\"><div class='botonverde2'>Definicion objetivos de Inspeccion Especificos (regional)</div></a><br/>
				<a style='text-decoration: none;' href=\"/zf_Regional/index/asignacionobjetivosespecificosmuestras\"><div class='botonverde2'>Definicion objetivos de Muestras Especificos (regional) </div></a><br/>
				<a style='text-decoration: none;' href=\"/zf_Regional/index/distribucionobjetivosinspeccionregionales\"><div class='botonverde2'>Distribucion objetivos Inspeccion Regionales</div></a><br/>
                <a style='text-decoration: none;' href=\"/zf_Regional/index/asignaciondecolaboradoresdeobjetivosespecificosinspeccion\"><div class='botonverde2'>Asignacion de colaboradores de objetivos especificos inspeccion</div></a><br/>

               ";
        echo "<h2>INSPECCION</h2>
                <a style='text-decoration: none;' href=\"/zf_Inspeccion/index/formulariodeinspeccionnuevo\"><div class='botonverde2'>Inspeccion</div></a><br/>
                <a style='text-decoration: none;' href=\"/zf_Inspeccion/index/formulariodemuestranuevo\"><div class='botonverde2'>Muestra*</div></a><br/>
                <a style='text-decoration: none;' href=\"/zf_Inspeccion/index/listadeeventos\"><div class='botonverde2'>LISTA de todas</div></a><br/>
                ";
        echo "<h2>MANTENIMIENTO </h2>
                <a style='text-decoration: none;' href=\"/zf_Mantenimiento/index/index\"><div class='botonverde2'>Index Mantenimiento</div></a><br/>
                </center>";
    }

    public function paginadebienvenidaAction () {
        echo "<center><br><br><br><br><br><br><br><h2 style='font-size: 19px'>Bienvenido al SIGUMF <br><br>
        <span style='color: #98AD00'>EL sistema de seguimiento de solicitudes de PMD del</span> SINAC </h2><br><br>
        <a style='font-size: 16px;  color: #6fad00;font-weight: 600;' href='/index.php?module=Users&func=loginscreen'><div>Iniciar de sesión</div></a>
         </center>";
    }


    /**redicionador carga el indice o la pagina de inicio
     * Indice que se carga dependiendo de permisos o tipo de usuario
     *
     * publica
     */
    public function inicioAction(){

       $userUtil = new UserUtil();
        if(!$userUtil->getUserID()){ // si no estan logueados
            $urllogin = '/zf_Calendario/Index/paginadebienvenida';
            header("Location: $urllogin");
            die;
        }else{
            if($userUtil->PRUEBAS()){//condicion de solicitante
                $url = '/zf_Calendario/Index/indexdeprueba';
                header("Location: $url");
                die;

            }elseif($userUtil->administradorcentral()){
                $url = '/zf_Regional/Index/indiceadmincentral';
                header("Location: $url");
                die;

            }elseif($userUtil->administradorregional()){//condicion en
                $url = '/zf_Regional/Index/indiceadminregional';
                header("Location: $url");
                die;

            }else{//condicion default
                $url = '/zf_Regional/Index/indicecolaborador';
                header("Location: $url");
                die;
            }
        }


    }


}






