<?php

/**
 * Class EventoDeInspeccionesyMuestreos
 *
 * Clase objeto que se encarga de de la interaccion con la tabla de eventos de inspeccion y muestreos
 * @category     Model
 * @author       Addax Software SA
 */
class EventoDeInspeccionesyMuestreos extends DAOInit{
	private $eventoIM;

    /**
     * Constructor del objeto
     * @param null EventoDeInspeccionID
     */
    public function __construct($EventoDeInspeccionID= NULL,$seguimiento= NULL)
	{
		parent::__construct();
		$this->eventoIM_record = NULL;
		$this->eventoIM = array();
		error_log("InspeccionID=EventoDeInspeccionID");
        if(isset($seguimiento) && $seguimiento != null && $seguimiento >= 0 )
        {
            try
            {
                //Cargar HallazgoInspeccion.
                $q = Doctrine_Query::create()
                    ->from('DAOIaEventosInspeccionesMuestreos s')
                    ->where("s.numero_de_seguimiento  LIKE '%$seguimiento%'");
                $eventoIM_record = $q->fetchOne();
                $eventoIMCargado = false;
                if($eventoIM_record != null && isset($eventoIM_record))
                {
                    if($eventoIM_record->exists())
                    {
                        $eventoIMCargado = true;
                    }
                }
                if ( !$eventoIMCargado)
                {
                    error_log("NO HallazgoInspeccion Cargado");
                    $eventoIM_record = new DAOIaEventosInspeccionesMuestreos();
                    $this->setRecord($eventoIM_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("HallazgoInspeccion Cargado");
                    $this->setRecord($eventoIM_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }else if(isset($EventoDeInspeccionID) && $EventoDeInspeccionID != null && $EventoDeInspeccionID >= 0)
		{
			try
			{
				//Cargar HallazgoInspeccion.
				$q = Doctrine_Query::create()
					->from('DAOIaEventosInspeccionesMuestreos s')
					->where("s.event_id = $EventoDeInspeccionID");
				$eventoIM_record = $q->fetchOne();
				$eventoIMCargado = false;
				if($eventoIM_record != null && isset($eventoIM_record))
				{
					if($eventoIM_record->exists())
					{
						$eventoIMCargado = true;
					}
				}
				if ( !$eventoIMCargado)
				{
					error_log("NO HallazgoInspeccion Cargado");
                    $eventoIM_record = new DAOIaEventosInspeccionesMuestreos();
					$this->setRecord($eventoIM_record);
				}
				else //Cargar la aplicación si es necesario
				{
					error_log("HallazgoInspeccion Cargado");
					$this->setRecord($eventoIM_record);
				}
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
		else
		{
			try
			{
				$eventoIM_record = new DAOIaEventosInspeccionesMuestreos();
				$this->setRecord($eventoIM_record);
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
	}

    /**Retorna los datos del objeto eventoIM en forma de arreglo
     *
     * @return array
     */
	public function toArray()
	{
		$fields = $this->eventoIM_record->toArray();

		$eventoIM_fields = $this->eventoIM_record->toArray();

		//Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
		$fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
		$fields['fecha_ultima_modificacion'] = $this->MySQLDate2SpanishDate($fields['fecha_ultima_modificacion']);

		/*$eventoIM_fields['eventoIM_id'] = $eventoIM_fields['event_id'];
		unset($eventoIM_fields['event_id']);*/

		return array_merge($fields, $eventoIM_fields);
	}
    /**
     * Retorna si el objeto existe
     * @return mixed
     */
	public function existe()
	{
		return $this->eventoIM_record->exists();
	}
    private function MySQLDate2SpanishDate($StrMySQLDate)
    {
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }
    /**
     * Transforma a time un date
     *
     * @param $date
     * @param $format
     * @return int
     */
    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }
    /**
     * Cambia el formato de fecha de español al de  sql
     *
     * @param $StrSpanishDate
     * @return string
     */
    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }
    /**
     * Guarda lo cambios que se hayan hecho en las variables del objeto en la base de datos .
     *
     * @return bool
     * @throws Exception
     */
	public function salvar()
	{
		error_log("HallazgoInspeccion::salvar");
		try
		{
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
            }

			$eventoIM_record = &$this->eventoIM_record;
			$arreglo_datos = $eventoIM_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					case 'fecha_creacion':
						$eventoIM_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					case 'fecha_ultima_modificacion':
						$eventoIM_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					default:
						$eventoIM_record->{$key} = $this->{$key};
					break;
				}
			}
			$eventoIM_record->save();
			$new_eventoIM_id = $eventoIM_record['event_id'];
			error_log('NEW PDF ID = ' . $new_eventoIM_id);
			$this->setRecord($eventoIM_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /**
     * Modifica el objeto con el arreglo de mapeo que recibe por parametro.
     * @param $Parametros
     * @return bool
     * @throws Exception
     */
	public function modificar($Parametros)
	{
		error_log("HallazgosInspeccion::modificar");
		try
		{
			//protege de que vengan parametros fuera de los campos del Aplicante.
            $eventoIM_record= &$this->eventoIM_record;
			$arreglo_datos = $eventoIM_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				if(array_key_exists($key, $Parametros))
				{
					switch($key)
					{
						case 'fecha_creacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						case 'fecha_ultima_modificacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						default:
							error_log("modificando $key con valor " . $Parametros[$key]);
							$this->{$key} = $Parametros[$key];
							break;
					}
				}
			}
			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}

		return true;
	}

    /**
     * Setea los valores del objeto que recibe por parámetro
     * @param $Record
     * @return bool
     */
	public function setRecord(&$Record)
	{
		error_log("HallazgoInspeccion::setRecord");
		if(!is_null($this->eventoIM_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->eventoIM_record))
			{
				error_log("setRecord:: Record is not the same type as eventoIM_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->eventoIM_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{
				case 'fecha_creacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				case 'fecha_ultima_modificacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /**
     * Modifica el registro de la base para cambiarlo a estado eliminidado (no elimina nada).
     *
     * @param EventoDeInspeccionID
     * @return bool
     */
	public function eliminar($EventoDeInspeccionID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$eventoIM_fields = $this->eventoIM_record->toArray();
			if($EventoDeInspeccionID != $eventoIM_fields['event_id'])
			{
				return false;
			}

		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}

}