<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

class IndexController extends Zend_Controller_Action
{

    protected $version_actual;

	protected $_configparams;

    private $_defaultRepositorio;

    private $_tempPath;

	function __destruct() {
		$manager = Doctrine_Manager::getInstance();
		if($manager && !empty($manager)){
			$conns = $manager->getConnections();
			foreach ($conns as $conn) {
				$conn->close();
				//echo $conn->getName() . "";
			}
		}
	}

    /**
     * Inicializa el controlador, carga clases y modelos
     */
    public function init()
    {
		try
		{
			$controller = Zend_Controller_Front::getInstance();
			$this->request = $controller->getRequest();
            /*Zend_Loader::loadClass('DAOBaseGEOPSAHISTORIALCAPAS');
            Zend_Loader::loadClass('DAOGEOPSAHISTORIALCAPAS');



            Zend_Loader::loadClass('DAOBaseGEOPSACRITERIOS');
            Zend_Loader::loadClass('DAOGEOPSACRITERIOS');
*/

            //          Zend_Loader::loadClass('Usuario');
    //        Zend_Loader::loadClass('DAOInit');
            Zend_Loader::loadClass('DAOBaseSemCapas');
            Zend_Loader::loadClass('DAOSemCapas');
            //Zend_Loader::loadClass('GeneradorHTMLCombos');

            /*
            require_once(APPLICATION_PATH . "/models/DAOInit.php");
            Zend_Loader::loadClass('DAOInit');
            */

            require_once(APPLICATION_PATH . "/models/Capa.php");
            Zend_Loader::loadClass('Capa');

          /*  require_once(APPLICATION_PATH . "/models/Criterio.php");
            Zend_Loader::loadClass('Criterio');

            require_once(APPLICATION_PATH . "/models/HistorialCapas.php");
            Zend_Loader::loadClass('HistorialCapas');*/

            $this->_defaultRepositorio = "default"; //$this->config->repository->defaultrepository;
            $this->_configparams = Zend_Registry::get('options');
            $this->_tempPath = $this->_configparams["reporter"]["temporaryfiles"];
		}
		catch(Exception $e)
		{
			error_log("Excepcion iniciando index: [$e]");
			echo("Excepcion iniciando index: [$e]");
		}
		$this->_configparams = Zend_Registry::get('options');
    }

    /**
     * Carga la página base inicial del módulo
     */
    public function indexAction(){
        //$res = Usuario::verificarpermiso('GEOPSA_MANTENIMIENTO');
        $res = true;
        if (!$res) {
            return pnVarPrepHTMLDisplay(_MODULENOAUTH);
        }
        $titulo = "Mantenimiento Capas Base";

        $url = pnZendPopupURL("zf_Capas", "Index", "actualizarcapa");
        $url .= "/IdCapa/";

        $vars = array();
        try {

            $vars['titulo'] = $titulo;
            $vars['htmlTbl'] = $this->tablaCapas();
            $vars['infoUsr'] = $_SESSION["nombreUsuario"];
            //$vars['infoMenu'] = Usuario::getMenu();

            $this->view->assignOld($vars);
            $temp_file = 'Capas_Prioridad.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);
        }
        catch(Exception $e)
        {
            error_log("Excepcion nueva: [$e]");
            echo("Excepcion nueva: [$e]");
        }
    }


    /**
     * Genera la tabla de Capas para su mantenimiento
     * @return HTML de la tabla de Capas generada
     */
    public function tablaCapas()
    {
        $html = <<<EOD
            <table class="table table-striped" align="center" name="the_table" id="the_table" cellspacing="" border="0" style="width:80%;">
                <thead>
                    <tr>
                        <th>Capa</th>

                        <th>Prioridad</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
EOD;

        $consulta = "SELECT id, nombredespliegue, nombrecapa, orden, 0, 0 from sem_capas ";
        $consulta .= "ORDER BY orden";

        //$generadorHTMLCombos = new GeneradorHTMLCombos();
        //$items = Criterio::getCriterios();
        $items =array();
        //$combo_html = $generadorHTMLCombos->generarHTMLCombo($name = "dropdownCriterios", $id = "dropdownCriterios", $items, $opcionSeleccione = false, $extra = " style='font-size:11px;' onclick='return false'", $opcionTodas = false,'');
        $criterios = array();
        foreach($items as $item){
            $criterios[$item['value']] = $item['text'];
        }

        try{
            $dcon = Doctrine_Manager::connection();
            $resultados =  $dcon->fetchAll( $consulta );
            //echo $consulta ; die;
            //print_r($resultados); die;
            foreach($resultados as $resultado){
                $idcapa = $resultado['idcapa'];

                $despl = $resultado['nombredespliegue'];
                $nombre = $resultado['nombrecapa'];
                $espts = $resultado['escapapuntaje'];
                $idCrit = $resultado['idcriterio'];
                $prioridad = $resultado['orden'];
                $nomCrit = $criterios[$idCrit];

                $despl = iconv('iso-8859-1', "UTF-8",$despl);
                $prior_btn = "";
                if($prioridad > 1){
                    //$val = $idCrit . "_" . $prioridad;
                    $prior_btn = <<<EOD
                            <button type="button" class="btnPrioridad btn btn-default btn-xs" value="$idcapa" aria-label="Left Align">
                                <span class="glyphicon glyphicon-chevron-up" aria-hidden="true"></span>
                            </button>
EOD;
                }


                $html .= <<<EOD
                    <tr value=$idcapa>
                        <td><label class="nombreCapa" style="font-weight:100;">$despl</label></td>

EOD;

                $html .= <<<EOD



                        <td style="text-align:center;">
                            <input type='text' value='$prioridad'/>
                        </td>

                        <td style="vertical-align:middle;">
                            <div id="actualizarCapa_$idcapa" class="inputArchivos" value='$idcapa' cid='$idcapa' style="width:100%"></div>
                        </td>
                    </tr>
EOD;
            }
        } catch(Exception $e){
            error_log($e->getMessage());
            echo ("ERROR $e"); die;
        }
        $html .= <<<EOD
                </tbody>
            </table>
EOD;
        return $html;
    }

    public function actualizartablacapasAction(){
        $res = false;
        $result = array();
        try{
            $html = $this->tablaCapas();
            $res = true;
            $result['html'] = $html;
        } catch(Exception $e){
            error_log(__METHOD__ . " : [$e]");
            $result['mensaje'] = $e->getMessage();
        }
        $result['resultado'] = $res;
        echo json_encode($result);
    }

    /**
     * Permite actualizar algún campo de una capa
     * @param idCapa identificador de la capa que se desea actualizar
     * @param attr nombre del atributo de la capa que se desea modificar
     * @param val nuevo valor para el atributo a modificar
     * @return true en caso de que la actualización de la capa se realice con éxito o se genera una excepción en caso de error
     */
    public function actualizarcapainfoAction(){
        $idCapa = $this->request->getParam('IdCapa');
        $attr = $this->request->getParam('Attr');
        $val = $this->request->getParam('Val');
        error_log("ActualizarCapaInfo: $idCapa $attr $val");
        $res = false;
        $result = array();
        try {
            $capaObj = new Capa($idCapa);
            $capaObj->modificar(array(
                                strtolower($attr) => $val,
                                'ip' => $this->get_client_ip(),
                                'idusuario' => 1,
                                'navegador' => $_SERVER['HTTP_USER_AGENT']));
            $res = true;
        } catch (Exception $e) {
            error_log(__METHOD__ . " : [$e]");
            $result['mensaje'] = $e->getMessage();
        }
        $result['resultado'] = $res;
        echo json_encode($result);
    }

    /**
     * Permite incrementar la prioridad de una capa en 1 y consecuentemente bajar la prioridad de la capa con prioridad inmediatamente superior
     * @param idCapa identificador de la capa que se desea actualizar
     * @return true en caso de que la actualización de la capa se realice con éxito o se genera una excepción en caso de error
     */
    public function actualizarprioridadAction(){
        $idCapa = $this->request->getParam('idCapa');
        $res = false;
        $result = array();
        try {
            $capaObj = new Capa($idCapa);
            $capa = $capaObj->toArray();
            $idCrit = $capa['idcriterio'];
            $prioridad = $capa['prioridadcriterio'];

            $capaAnterior = new Capa($idCrit, $prioridad-1);

            $capaObj->modificar(array('prioridadcriterio' => $prioridad-1,
                                      'ip' => $this->get_client_ip(),
                                      'idusuario' => 1,
                                      'navegador' => $_SERVER['HTTP_USER_AGENT']));
            $capaAnterior->modificar(array('prioridadcriterio' => $prioridad,
                                        'ip' => $this->get_client_ip(),
                                        'idusuario' => 1,
                                        'navegador' => $_SERVER['HTTP_USER_AGENT']));

            $html = $this->tablaCapas();
            $result['html'] = $html;
            $res = true;
        } catch (Exception $e) {
            error_log(__METHOD__ . " : [$e]");
            $result['mensaje'] = $e->getMessage();
        }
        $result['resultado'] = $res;
        echo json_encode($result);
    }

    /**
     * Permite actualizar con un archivo de polígonos la información de una capa del sistema
     * @return JSON que reporta el resultado de la acción y un mensaje en caso de error
     */
    public function actualizarcapaAction(){
        $tipocapa = $this->request->getParam('cid');
        Zend_Loader::loadClass('ShpManager');
        $shpsmanager = new ShpManager();
        $result = $shpsmanager->agregarShpPrioridades($tipocapa, ShpManager::$POLYGON);

        echo json_encode($result);die;
    }

    /**
     * Obtiene dirección ip del cliente
     * @return dirección ip del cliente
     */
    private function get_client_ip()
    {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';

        return $ipaddress;
    }
}

