<?php
/*
*/
class Capa
{
	private $capa;

    /**
     * Constructor de la clase Capa
     * @param CapaID si Prioridad es NULL identifica la capa para la cual se desea obtener el detalle de la base de datos, o NULL en caso de que se quiere obtener una nueva instancia de Capa
     *        Si Prioridad no es null identifica el idCriterio de la capa
     * @param Prioridad identifica la prioridad de la capa con el idCriterio especificado
     * @return una nueva instancia de la clase Capa si el parámetro CapaID es nulo o la instancia correspondiente a la Capa identificada por CapaID
     */
    public function __construct($CapaID=NULL, $Prioridad=NULL)
	{
		parent::__construct();
		$this->capa_record = NULL;
		$this->capa = array();
		error_log("CapaID= $CapaID Prioridad= $Prioridad");
        if(isset($CapaID) && isset($CapaID) && $Prioridad != null && $Prioridad != null)
        {
            try
            {
                $q = Doctrine_Query::create()
                    ->from('DAOSemCapas o')
                    ->where("o.idcriterio = $CapaID and o.prioridadcriterio = $Prioridad");

                $capa_record = $q->fetchOne();
                $capaCargado = false;
                if($capa_record != null && isset($capa_record))
                {
                    if($capa_record->exists())
                    {
                        $capaCargado = true;
                    }
                }
                if ( !$capaCargado)
                {
                    error_log("NO Capa Cargado");
                    $capa_record = new DAOSemCapas();
                    $this->setRecord($capa_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Capa Cargado");
                    $this->setRecord($capa_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else{
            if(isset($CapaID) && $CapaID != null && $CapaID >= 0)
            {
                try
                {
                    //Cargar Capa.
                    $q = Doctrine_Query::create()
                        ->from('DAOSemCapas o')
                        ->where("o.idcapa = $CapaID");
                    error_log("ELSQLCAPA: " . $q->getSql());
                    $capa_record = $q->fetchOne();
                    $capaCargado = false;
                    if($capa_record != null && isset($capa_record))
                    {
                        if($capa_record->exists())
                        {
                            $capaCargado = true;
                        }
                    }
                    if ( !$capaCargado)
                    {
                        error_log("NO Capa Cargado");
                        $capa_record = new DAOSemCapas();
                        $this->setRecord($capa_record);
                    }
                    else //Cargar la aplicación si es necesario
                    {
                        error_log("Capa Cargado");
                        $this->setRecord($capa_record);
                    }
                }
                catch(Exception $e)
                {
                    error_log(__METHOD__ . " : [$e]");
                    throw $e;
                }
            }
            else
            {
                try
                {
                    $capa_record = new DAOSemCapas();
                    $this->setRecord($capa_record);
                }
                catch(Exception $e)
                {
                    error_log(__METHOD__ . " : [$e]");
                    throw $e;
                }
            }
        }
	}

    /**
     * Retorna los datos del Capa en un arreglo, en lugar de accederlos con el capa ->
     * @return Arreglo con los atributos de un registro de Capa
     */
	public function toArray()
	{
		$fields = $this->capa_record->toArray();

		$capa_fields = $this->capa_record->toArray();

		//$capa_fields['idcapa'] = $capa_fields['id'];
		//unset($capa_fields['id']);

		return array_merge($fields, $capa_fields);
	}

    /**
     * Indica si existe el registro capa_record
     * @return True si el registro existe, False en caso contrario
     */
	public function existe()
	{
		return $this->capa_record->exists();
	}

    /**
     * Traduce una fecha del formato en base de datos SQL al formato dd/mm/YYYY
     * @param StrMySQLDate fecha en formato de fecha de SQL
     * @return Fecha en formato dd/mm/YYYY
     */
	private function MySQLDate2SpanishDate($StrMySQLDate)
	{
		$dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

		//NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

		if ($dobcheck <= 0)
		{
			$date = $StrMySQLDate;
			$date = explode('-', $date);
			$Y = $date[0];

			$M = $date[1];
			$D = $date[2];
			$dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
		}
		else
		{
			$dobshow = date("d/m/Y",strtotime($StrMySQLDate));
		}

		error_log("MODIFYING $StrMySQLDate  to  $dobshow");

		return $dobshow;
	}

    /**
     * Traduce una fecha del formato dd/mm/YYYY al formato de fecha de base de datos SQL
     * @param StrSpanishDate Fecha en formato dd/mm/YYYY
     * @return Fecha en formato de base de datos SQL YYYY-mm-dd
     */
	private function SpanishDate2MySQLDate($StrSpanishDate)
	{
		$parts = explode("/", $StrSpanishDate);
		$result = implode("-", array_reverse($parts));
		error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");
		return $result;
	}

    /**
     * Guarda cambios que se hayan hecho en las variables del Capa.
     */
	public function salvar()
	{
		error_log("Capa::salvar");
		try
		{
            $this->fecha_actualizacion= date('Y-m-d H:i:s');
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
	            $this->usuario_creacion_id = pnUserGetVar('uid');
	            $this->usuario_creacion = pnUserGetVar('uname',$this->usuario_creacion_id);
            }
			$this->ultima_modificacion_usuario_id = pnUserGetVar('uid');
			$this->usuario_modificacion = pnUserGetVar('uname',$this->usuario_creacion_id);

			$capa_record = &$this->capa_record;
			$arreglo_datos = $capa_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					case 'fecha_actualizacion':
						$capa_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					case 'fecha_creacion':
						$capa_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					default:
						$capa_record->{$key} = $this->{$key};
					break;
				}
			}
			$capa_record->save();
			$new_capa_id = $capa_record['idcapa'];
			error_log('NEW MARCA ENCARGADO ID = ' . $new_capa_id);
			$this->setRecord($capa_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /*
     * Modifica el Capa con el arreglo de mapeo que recibe por parametro. 
     * Además se guarda en un historial la información del cambio realizado
     * @param Parametros arreglo con los atributos y valores que se desean modificar para la capa
     * @return True si la operación se realizó con éxito o False en caso contrario
     */
	public function modificar($Parametros)
	{
		error_log("Capa::modificar");
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
            $capa_record= &$this->capa_record;
			$arreglo_datos = $capa_record->toArray();

			foreach($arreglo_datos as $key=>$value)
			{
				if(array_key_exists($key, $Parametros))
				{
					switch($key)
					{
						case 'fecha_actualizacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						case 'fecha_creacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						default:
							error_log("modificando $key con valor " . $Parametros[$key]);
                            $arreglo_datos[$key] = $Parametros[$key];
							$this->{$key} = $Parametros[$key];
							break;
					}
				}
			}
			if($this->existe())//Si el registro ya existia , hay que copiarlo al historial
			{
				//Guardar Historial
				$historialcapa_record = new HistorialCapas();
				$arreglo_datos_para_historial = $arreglo_datos;


				//$arreglo_datos_para_historial['idcapa'] = $arreglo_datos['idcapa'];
				$arreglo_datos_para_historial['idusuario'] = $Parametros['idusuario'];
				$arreglo_datos_para_historial['ip'] = $Parametros['ip'];
				$arreglo_datos_para_historial['timestamp'] = date('Y-m-d H:i:s');
				$arreglo_datos_para_historial['navegador'] = $Parametros['navegador'];

				$historialcapa_record->modificar($arreglo_datos_para_historial);
			}

			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}
		$conn->commit();
		
		return true;
	}

    /*
     * Establece un registro que recibe por parámetro.
     * @param Record registro que se asignará al objeto
     */
	public function setRecord(&$Record)
	{
		error_log("Encargado::	setRecord");
		if(!is_null($this->capa_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->capa_record))
			{
				error_log("setRecord:: Record is not the same type as capa_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->capa_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{
				case 'fecha_actualizacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				case 'fecha_creacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /*
     * Elimina un capa cuyo id de solicitud recibe por parámetro
     * @param CapaID el identificador del capa que se desea eliminar.
     * @return True si la operación se realizó con éxito, o false en caso contrario.
     */
	public function eliminar($CapaID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$capa_fields = $this->capa_record->toArray();
			if($CapaID != $capa_fields['id'])
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}

}