<?php
/*
*/
class Criterio extends DAOInit
{
	private $criterio;

    /**
     * Constructor de la clase Criterio
     * @param CriterioID identifica la criterio para la cual se desea obtener el detalle de la base de datos, o NULL en caso de que se quiere obtener una nueva instancia de Criterio
     * @return una nueva instancia de la clase Criterio si el parámetro CriterioID es nulo o la instancia correspondiente a la Criterio identificada por CriterioID
     */
    public function __construct($CriterioID=NULL)
	{
		parent::__construct();
		$this->criterio_record = NULL;
		$this->criterio = array();
		error_log("CriterioID=CriterioID");
		if(isset($CriterioID) && $CriterioID != null && $CriterioID >= 0)
		{
			try
			{
				//Cargar Criterio.
				$q = Doctrine_Query::create()
					->from('DAOPsaCriterios o')
					->where("o.idcriterio = $CriterioID");
                $criterio_record = $q->fetchOne();
				$criterioCargado = false;
				if($criterio_record != null && isset($criterio_record))
				{
					if($criterio_record->exists())
					{
						$criterioCargado = true;
					}
				}
				if ( !$criterioCargado)
				{
					error_log("NO Criterio Cargado");
                    $criterio_record = new DAOPsaCriterios();
					$this->setRecord($criterio_record);
				}
				else //Cargar la aplicación si es necesario
				{
					error_log("Criterio Cargado");
					$this->setRecord($criterio_record);
				}
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
		else
		{
			try
			{
                $criterio_record = new DAOPsaCriterios();
				$this->setRecord($criterio_record);
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
	}

    /**
     * Retorna los datos del Criterio en un arreglo, en lugar de accederlos con el criterio ->
     * @return Arreglo con los atributos de un registro de Criterio
     */
	public function toArray()
	{
		$fields = $this->criterio_record->toArray();

		$criterio_fields = $this->criterio_record->toArray();

		//$criterio_fields['idcriterio'] = $criterio_fields['id'];
		//unset($criterio_fields['id']);

		return array_merge($fields, $criterio_fields);
	}

    /**
     * Indica si existe el registro criterio_record
     * @return True si el registro existe, False en caso contrario
     */
	public function existe()
	{
		return $this->criterio_record->exists();
	}

    /**
     * Traduce una fecha del formato en base de datos SQL al formato dd/mm/YYYY
     * @param StrMySQLDate fecha en formato de fecha de SQL
     * @return Fecha en formato dd/mm/YYYY
     */
	private function MySQLDate2SpanishDate($StrMySQLDate)
	{
		$dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

		//NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

		if ($dobcheck <= 0)
		{
			$date = $StrMySQLDate;
			$date = explode('-', $date);
			$Y = $date[0];

			$M = $date[1];
			$D = $date[2];
			$dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
		}
		else
		{
			$dobshow = date("d/m/Y",strtotime($StrMySQLDate));
		}

		error_log("MODIFYING $StrMySQLDate  to  $dobshow");

		return $dobshow;
	}

    /**
     * Traduce una fecha del formato dd/mm/YYYY al formato de fecha de base de datos SQL
     * @param StrSpanishDate Fecha en formato dd/mm/YYYY
     * @return Fecha en formato de base de datos SQL YYYY-mm-dd
     */
	private function SpanishDate2MySQLDate($StrSpanishDate)
	{
		$parts = explode("/", $StrSpanishDate);
		$result = implode("-", array_reverse($parts));
		error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");
		return $result;
	}

    /**
     * Guarda cambios que se hayan hecho en las variables del Criterio.
     */
	public function salvar()
	{
		error_log("Criterio::salvar");
		try
		{
            $this->fecha_actualizacion= date('Y-m-d H:i:s');
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
	            $this->usuario_creacion_id = pnUserGetVar('uid');
	            $this->usuario_creacion = pnUserGetVar('uname',$this->usuario_creacion_id);
            }
			$this->ultima_modificacion_usuario_id = pnUserGetVar('uid');
			$this->usuario_modificacion = pnUserGetVar('uname',$this->usuario_creacion_id);

			$criterio_record = &$this->criterio_record;
			$arreglo_datos = $criterio_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					case 'fecha_actualizacion':
						$criterio_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					case 'fecha_creacion':
						$criterio_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					default:
						$criterio_record->{$key} = $this->{$key};
					break;
				}
			}
			$criterio_record->save();
			$new_criterio_id = $criterio_record['idsolicitud'];
			error_log('NEW MARCA ENCARGADO ID = ' . $new_criterio_id);
			$this->setRecord($criterio_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /*
     * Modifica el Criterio con el arreglo de mapeo que recibe por parametro. 
     * Además se guarda en un historial la información del cambio realizado
     * @param Parametros arreglo con los atributos y valores que se desean modificar para la criterio
     * @return True si la operación se realizó con éxito o False en caso contrario
     */
	public function modificar($Parametros)
	{
		error_log("Criterio::modificar");
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
            $criterio_record= &$this->criterio_record;
			$arreglo_datos = $criterio_record->toArray();

			if($this->existe())//Si el registro ya existia , hay que copiarlo al historial
			{
				//Guardar Historial
				$historialcriterio_record = new HistorialCriterios();
				$arreglo_datos_para_historial = $arreglo_datos;


				//$arreglo_datos_para_historial['idcriterio'] = $arreglo_datos['idcriterio'];
				$arreglo_datos_para_historial['idusuario'] = $Parametros['idusuario'];
				$arreglo_datos_para_historial['ip'] = $Parametros['ip'];
				$arreglo_datos_para_historial['timestamp'] = date('Y-m-d H:i:s');
				$arreglo_datos_para_historial['navegador'] = $Parametros['navegador'];

				if(isset($Parametros['usrkey'])){
					$arreglo_datos_para_historial['usuariokey'] = $Parametros['usrkey'];
				}

				$historialcriterio_record->modificar($arreglo_datos_para_historial);
			}

			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					case 'fecha_actualizacion':
						$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					case 'fecha_creacion':
						$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					default:
						error_log("modificando $key con valor " . $value);
						$this->{$key} = $value;
						break;
				}
			}

			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}
		$conn->commit();
		
		return true;
	}

    /*
     * Establece un registro que recibe por parámetro.
     * @param Record registro que se asignará al objeto
     */
	public function setRecord(&$Record)
	{
		error_log("Encargado::	setRecord");
		if(!is_null($this->criterio_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->criterio_record))
			{
				error_log("setRecord:: Record is not the same type as criterio_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->criterio_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{
				case 'fecha_actualizacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				case 'fecha_creacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /*
     * Elimina un criterio cuyo id de solicitud recibe por parámetro
     * @param CriterioID el identificador del criterio que se desea eliminar.
     * @return True si la operación se realizó con éxito, o false en caso contrario.
     */
	public function eliminar($CriterioID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$criterio_fields = $this->criterio_record->toArray();
			if($CriterioID != $criterio_fields['id'])
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}

	/**
	 * Obtiene un arreglo con los criterios en el sistema
	 * @return Arreglo con el id y nombre de los criterios en el sistema o false en caso de error
	 */
	public static function getCriterios()
	{
		$datos = array();
		try
		{
			$consulta = "SELECT idcriterio, nombredespliegue from GEOPSA_CRITERIOS order by idcriterio";
			$dcon = Doctrine_Manager::connection();
			$datos = $dcon->fetchAll( $consulta );
			$items = array();
			foreach($datos as $dato){
				$item = array();
				$item['value'] = $dato['idcriterio'];
				$item['text'] = $dato['nombredespliegue'];
				$items[] = $item;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			return false;
		}
		return $items;
	}

}