<?php
/*
*/
class HistorialCapas extends DAOInit
{
	private $historial;

    /**
     * Constructor de la clase Historial
     * @param HistorialID identifica al historial de cambios de puntaje se desea obtener de la base de datos, o NULL en caso de que se quiere obtener una nueva instancia de Historial
     * @return una nueva instancia de la clase Historial si el parámetro HistorialID es nulo o la instancia correspondiente al Historial identificado por HistorialID
     */
    public function __construct($HistorialID=NULL)
	{
		parent::__construct();
		$this->historial_record = NULL;
		$this->historial = array();
		error_log("HistorialID=HistorialID");
		if(isset($HistorialID) && $HistorialID != null && $HistorialID >= 0)
		{
			try
			{
				//Cargar Historial.
				$q = Doctrine_Query::create()
					->from('DAOGEOPSAHISTORIALCAPAS o')
					->where("o.idhistorial = $HistorialID");
                $historial_record = $q->fetchOne();
				$historialCargado = false;
				if($historial_record != null && isset($historial_record))
				{
					if($historial_record->exists())
					{
						$historialCargado = true;
					}
				}
				if ( !$historialCargado)
				{
					error_log("NO Historial Cargado");
                    $historial_record = new DAOGEOPSAHISTORIALCAPAS();
					$this->setRecord($historial_record);
				}
				else //Cargar la aplicación si es necesario
				{
					error_log("Historial Cargado");
					$this->setRecord($historial_record);
				}
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
		else
		{
			try
			{
                $historial_record = new DAOGEOPSAHISTORIALCAPAS();
				$this->setRecord($historial_record);
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
	}

    /**
     * Retorna los datos del Historial en un arreglo, en lugar de accederlos con el historial ->
     * @return Arreglo con los atributos de un registro de Historial
     */
	public function toArray()
	{
		$fields = $this->historial_record->toArray();

		$historial_fields = $this->historial_record->toArray();

		//$historial_fields['idhistorial'] = $historial_fields['id'];
		//unset($historial_fields['id']);

		return array_merge($fields, $historial_fields);
	}

    /**
     * Indica si existe el registro historial_record
     * @return True si el registro existe, False en caso contrario
     */
	public function existe()
	{
		return $this->historial_record->exists();
	}

    /**
     * Traduce una fecha del formato en base de datos SQL al formato dd/mm/YYYY
     * @param StrMySQLDate fecha en formato de fecha de SQL
     * @return Fecha en formato dd/mm/YYYY
     */
	private function MySQLDate2SpanishDate($StrMySQLDate)
	{
		$dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

		//NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

		if ($dobcheck <= 0)
		{
			$date = $StrMySQLDate;
			$date = explode('-', $date);
			$Y = $date[0];

			$M = $date[1];
			$D = $date[2];
			$dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
		}
		else
		{
			$dobshow = date("d/m/Y",strtotime($StrMySQLDate));
		}

		error_log("MODIFYING $StrMySQLDate  to  $dobshow");

		return $dobshow;
	}

    /**
     * Traduce una fecha del formato dd/mm/YYYY al formato de fecha de base de datos SQL
     * @param StrSpanishDate Fecha en formato dd/mm/YYYY
     * @return Fecha en formato de base de datos SQL YYYY-mm-dd
     */
	private function SpanishDate2MySQLDate($StrSpanishDate)
	{
		$parts = explode("/", $StrSpanishDate);
		$result = implode("-", array_reverse($parts));
		error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");
		return $result;
	}

    /**
     * Guarda cambios que se hayan hecho en las variables del Historial.
     */
	public function salvar()
	{
		error_log("Historial::salvar");
		try
		{
            $this->fecha_actualizacion= date('Y-m-d H:i:s');
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
	            $this->usuario_creacion_id = pnUserGetVar('uid');
	            $this->usuario_creacion = pnUserGetVar('uname',$this->usuario_creacion_id);
            }
			$this->ultima_modificacion_usuario_id = pnUserGetVar('uid');
			$this->usuario_modificacion = pnUserGetVar('uname',$this->usuario_creacion_id);

			$historial_record = &$this->historial_record;
			$arreglo_datos = $historial_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					case 'fecha_actualizacion':
						$historial_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					case 'fecha_creacion':
						$historial_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					default:
						$historial_record->{$key} = $this->{$key};
					break;
				}
			}
			$historial_record->save();
			$new_historial_id = $historial_record['idhistorial'];
			error_log('NEW MARCA ENCARGADO ID = ' . $new_historial_id);
			$this->setRecord($historial_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /*
     * Modifica el Historial con el arreglo de mapeo que recibe por parametro.
     * @param Parametros arreglo con los atributos y valores que se desean modificar para el historial
     * @return True si la operación se realizó con éxito o False en caso contrario
     */
	public function modificar($Parametros)
	{
		error_log("Historial::modificar");
		try
		{
            $historial_record= &$this->historial_record;
			$arreglo_datos = $historial_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				if(array_key_exists($key, $Parametros))
				{
					switch($key)
					{
						case 'fecha_actualizacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						case 'fecha_creacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						default:
							error_log("modificando $key con valor " . $Parametros[$key]);
							$this->{$key} = $Parametros[$key];
							break;
					}
				}
			}
			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}

		return true;
	}

    /*
     * Establece un registro que recibe por parámetro.
     * @param Record registro que se asignará al objeto
     */
	public function setRecord(&$Record)
	{
		error_log("Encargado::setRecord");
		if(!is_null($this->historial_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->historial_record))
			{
				error_log("setRecord:: Record is not the same type as historial_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->historial_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{
				case 'fecha_actualizacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				case 'fecha_creacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /*
     * Elimina un historial cuyo id recibe por parámetro
     * @param HistorialID el identificador del historial que se desea eliminar.
     * @return True si la operación se realizó con éxito, o false en caso contrario.
     */
	public function eliminar($HistorialID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$historial_fields = $this->historial_record->toArray();
			if($HistorialID != $historial_fields['id'])
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}

}