<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{
	public function _initSmarty()
	{
		require_once 'Addax/Controller/Plugin/View/Smarty.php';
		Zend_Controller_Front::getInstance();
		$fc = Zend_Controller_Front::getInstance();
		
		$plugin = new Addax_Controller_Plugin_View_Smarty(APPLICATION_PATH . '/templates/smarty', ZIKULA_PATH . '/pnTemp/zfSmarty_compiled', ZIKULA_PATH . '/pnTemp/zfSmarty_cache');
		$fc->registerPlugin($plugin);
		
	}
	
	public function _initH2O()
	{
		require_once 'Addax/Controller/Plugin/View/H2O.php';
		require_once 'h2o.php';
		require_once 'ext/addax/addaxcontext.php';
		$this->setupAddaxH2OTags();
		
		Zend_Controller_Front::getInstance();
		$fc = Zend_Controller_Front::getInstance();
		$plugin = new Addax_Controller_Plugin_View_H2O(APPLICATION_PATH . '/templates/h2o', ZIKULA_PATH . '/pnTemp/zfH2O_cache');
		$fc->registerPlugin($plugin);
		
	}
	
	public function _initAddaxCRUD()
	{		
		Zend_Loader::loadClass('AddaxCRUD');
		Zend_Loader::loadClass('Addax_Controller_Crud');				
		Zend_Loader::loadClass('Zend_Controller_Action_HelperBroker');
		Zend_Controller_Action_HelperBroker::addPrefix('Addax_Controller_Action_Helper');		
	}
	
	public function setupAddaxH2OTags()
	{
		require_once 'ext/addax/tags/getconstant.php';
	}
	
	/* Se cambia por el siguiente debido a la nueva autorizacion en los modulos zend de zikula
	public function setupZFRouter()
	{
		require_once 'Addax/Controller/Router/Rewrite.php';
		require_once 'Addax/Controller/Router/Route/Zend.php';
		$fc = Zend_Controller_Front::getInstance();
		$router = new Addax_Controller_Router_Rewrite();
		$dispatcher = $fc->getDispatcher();
		$request = $fc->getRequest();
		$route = new Addax_Controller_Router_Route_Zend(array(), $dispatcher,$request);
		
		$router->addRoute('default',$route);
		$fc->setRouter($router);
		//$fc->setControllerDirectory(APPLICATION_PATH . '/controllers');
	}
	*/
	
	public function setupZFRouter()
	{
        require_once 'Addax/Controller/Router/Rewrite.php';
        require_once 'Addax/Controller/Router/Route/Zend.php';
        $fc = Zend_Controller_Front::getInstance();
        $router = new Addax_Controller_Router_Rewrite();
        $dispatcher = $fc->getDispatcher();
        $request = $fc->getRequest();
        $route = new Addax_Controller_Router_Route_Zend(array(), $dispatcher,$request);

        $router->addRoute('default',$route);
        $fc->setRouter($router);
        //$fc->setControllerDirectory(APPLICATION_PATH . '/controllers');

        require_once 'Addax/Controller/Plugin/ZikulaAcl.php';
        require_once 'Addax/ZikulaAcl.php';
        $acl = new Addax_ZikulaAcl();
        $fc->setParam('acl', $acl);        
        $plugin = new Addax_Controller_Plugin_ZikulaAcl($acl,ACCESS_DELETE);
        $fc->registerPlugin($plugin);
	}
	
	public function setupZKRouter()
	{
		require_once 'Addax/Controller/Router/Rewrite.php';
		require_once 'Addax/Controller/Router/Route/Zikula.php';
		$fc = Zend_Controller_Front::getInstance();
		$router = new Addax_Controller_Router_Rewrite();
		$dispatcher = $fc->getDispatcher();
		$request = $fc->getRequest();
		$route = new Addax_Controller_Router_Route_Zikula(array(), $dispatcher,$request);
		$router->addRoute('default',$route);
		$fc->setRouter($router);
	}

	protected function setupAutoload()
	{
		$moduleLoader = new Zend_Application_Module_Autoloader(array(
		'namespace' => '',
		'basePath' => APPLICATION_PATH));
		
		return $moduleLoader;
	}
	
	protected function _initDoctrine(){
		//Set doctrine path
		set_include_path(realpath(ZIKULA_PATH . "/includes/classes/doctrine/doctrine") . PATH_SEPARATOR . get_include_path());
		set_include_path(realpath(ZIKULA_PATH . "/includes/classes/doctrine/doctrine/Doctrine") . PATH_SEPARATOR . get_include_path());
		set_include_path(realpath(APPLICATION_PATH . "/models/generated") . PATH_SEPARATOR . get_include_path());
		set_include_path(realpath(ZIKULA_PATH . "/includes/classes/modelosdoctrine") . PATH_SEPARATOR . get_include_path());
		//define('PHPWORD_BASE_PATH', realpath(ZIKULA_PATH . "/includes/classes"));
		set_include_path(realpath(ZIKULA_PATH . "/includes/classes") . PATH_SEPARATOR . get_include_path());
		set_include_path(realpath(ZIKULA_PATH . "/includes/classes/addax/classes") . PATH_SEPARATOR . get_include_path());
		set_include_path(realpath(ZIKULA_PATH . "/includes/classes/PHPWord") . PATH_SEPARATOR . get_include_path());
        set_include_path(realpath(ZIKULA_PATH . "/includes/classes/PHPExcel") . PATH_SEPARATOR . get_include_path());
		//error_log("Init DOCTRINE");
		//error_log("includePath [" .get_include_path());
		
		
		$options = $this->getOptions();
		
		$adapter = $options['resources']['doctrine']['connections']['cx1']['dsn']['adapter'];
		$user = $options['resources']['doctrine']['connections']['cx1']['dsn']['user'];
		$pass = $options['resources']['doctrine']['connections']['cx1']['dsn']['pass'];
		$hostspec = $options['resources']['doctrine']['connections']['cx1']['dsn']['hostspec'];
		$database = $options['resources']['doctrine']['connections']['cx1']['dsn']['database'];
		
		$dsn = $adapter .':dbname='. $database .';host=' .$hostspec ;

        $options2 = array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        );

		$dbh = new PDO($dsn, $user, $pass );
		$conn = Doctrine_Manager::connection($dbh);
        $conn->setCharset('UTF8');
		$conn->setOption('username', $user);
		$conn->setOption('password', $password);
		
		$manager = Doctrine_Manager::getInstance();
		$manager->setAttribute(Doctrine_Core::ATTR_AUTO_ACCESSOR_OVERRIDE, true);
		
		
		//Doctrine_Core::loadModels(APPLICATION_PATH . "/models");
		
		
	}
	protected function _initZend()
	{
		$this->bootstrap('frontController');
		$this->setupAutoload();
		//$this->setupSmarty();
		$this->setupZFRouter();
		
		$options = $this->getOptions();
		$registry = Zend_Registry::getInstance();
		$registry->options = $options;
		
		$config = new Zend_Config_Ini( APPLICATION_PATH .'/configs/application.ini', 'production');
		Zend_Registry::set('config', $config);
		Zend_Registry::set('app_path', APPLICATION_PATH);
		
		Zend_Registry::set('baseURL',pnGetBaseURL());
		Zend_Registry::set('theme',pnUserGetTheme());
		Zend_Registry::set('pn_username', pnUserGetVar('uname'));
		Zend_Registry::set('pn_userid', pnUserGetVar('uid'));
	
		//error_log("config puesto[" .var_export($config, true) );
		//error_log("options puesto[" .var_export($options, true) );
	}	
	
	protected function _initZikula()
	{
		$this->bootstrap('frontController');
		$this->setupAutoload();
		//$this->setupSmarty();
		$this->setupZKRouter();
	}
}
