﻿<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
if(!defined('RUTASERVIDOR')) define('RUTASERVIDOR', "http://test_sirea.addax.cc:80/");
if(!defined('MDKEY')) define('MDKEY', 'ed923d6d3f9d47e8abdb3e16aac166a1');


class IndexController extends Zend_Controller_Action
{
	/*
		También puede invocarse así
		   $addaxcrud= $this->_helper->AddaxCRUD;
		   $tbl= $addaxcrud->prepareTable("Tipo","Tipo de Algo");
		
		
		Por defecto el controlador del crud es CrudController,
		   si se desea cambiar el nombre se puede usar
		   $tbl->setControllerName("Otro");
		   sin embargo el prefijo del controllador debe estar pnAddaxZF->pnzfExcludeThemeAccordingToController
		   para que no devuelva el html completo del tema en la salida.
		   
		Algunas opciones:
			//$tbl->showCheckbox = true;
			//$tbl->addWhereClause("id > 20");
			//$tbl->addWhereClause("id < 25");
			//$tbl->addWhereClause("id < 5", "OR");
			//$tbl->addOrderBy("id", "DESC");
			//$tbl->setLimit(5);
			//Otros
				//$tbl->addTableBorder();
				//$tbl->displayAddFormTop();
				//$tbl->disallowAdd();
				//$tbl->disallowEdit('habilitado');
				//$tbl->disallowDelete();
			
			$tbl->setFileUpload("nombre", "/tmp");			
			$tbl->addButtonToRow("Memberships", "membership.php", "all");		
			$tbl->addButton("View Permissions", "permission.php");
			$tbl->addButton("Back", "#", "onClick=\"history.go(-1);\"");	
	*/
	private $_configparams;


    public function init()
    {
        error_reporting(E_ALL);
        ini_set('display_errors', '1');
        /* Initialize action controller here */
        try
        {
           require_once(APPLICATION_PATH . "/models/DAOInit.php");
            Zend_Loader::loadClass('DAOInit');
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLCombos.php");
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLTablaObjetivos.php");
            require_once(APPLICATION_PATH . "/models/ObjetivosTomasMuestra.php");
            require_once(APPLICATION_PATH . "/models/ObjetivosAuditoriaInspeccion.php");
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLTablaObjetivosAuditoriaInspeccion.php");
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLTablaObjetivosAuditoriaInspeccionDistrubucionRegiones.php");
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLTablaObjetivosDistribucionRegiones.php");
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLTablaObjetivosAuditoriaInspeccionRegional.php");
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLResumenAnualObjEspecificosInspeccion.php");
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLResumenAnualObjEspecificosMuestreo.php");
            require_once(APPLICATION_PATH . "/models/FiltradoCombo.php");
            require_once(APPLICATION_PATH . "/models/ObjetivoEspecifico.php");
            require_once(APPLICATION_PATH . "/models/TipoAnalisis.php");
            require_once(APPLICATION_PATH . "/models/Analisis.php");
            require_once(APPLICATION_PATH . "/models/TipoEstablecimiento.php");
            require_once(APPLICATION_PATH . "/models/JustificacionObjetivos.php");
            $controller = Zend_Controller_Front::getInstance();
            $this->request = $controller->getRequest();

           Zend_Loader::loadClass('DAOBaseIaTipoanalisis');
            Zend_Loader::loadClass('DAOIaTipoanalisis');

            Zend_Loader::loadClass('DAOBaseIaAnalisislaboratorio');
            Zend_Loader::loadClass('DAOIaAnalisislaboratorio');

            Zend_Loader::loadClass('DAOBaseIaColaboradores');
            Zend_Loader::loadClass('DAOIaColaboradores');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosmuestras');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosmuestras');

            Zend_Loader::loadClass('DAOBaseIaTipoestablecimiento');
            Zend_Loader::loadClass('DAOIaTipoestablecimiento');

            Zend_Loader::loadClass('DAOBaseIaJustificacionobjetivos');
            Zend_Loader::loadClass('DAOIaJustificacionobjetivos');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosauditoriainspeccion');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosauditoriainspeccion');

            Zend_Loader::loadClass('DAOBaseIaObjetivosespecificos');
            Zend_Loader::loadClass('DAOIaObjetivosespecificos');

            Zend_Loader::loadClass('DAOBaseRegion');
            Zend_Loader::loadClass('DAORegion');

            Zend_Loader::loadClass('DAOBaseIaCalendarizador');
            Zend_Loader::loadClass('DAOIaCalendarizador');

            Zend_Loader::loadClass('DAOBaseIaEventosInspeccionesMuestreos');
            Zend_Loader::loadClass('DAOIaEventosInspeccionesMuestreos');

            Zend_Loader::loadClass('GeneradorHTMLCombos');

           $this->_configparams = Zend_Registry::get('options');
            $this->config = Zend_Registry::get('config');
            $this->estadoObjetivoEspecifico = $this->config->estadoObjetivoEspecifico->toArray();

        }
        catch(Exception $e)
        {
            error_log("Excepcion iniciando index: [$e]");
        }

        $this->_configparams = Zend_Registry::get('options');
    }

    /****************************************************************************************************/
    /****************************************************************************************************/
    /* FUNCIONES QUE ANTES ESTABAN EN ZF_MANTENIMINETO QUE CAMBIAMOS A ESTE MODULO ZF_CENTRAL*/


    /**
     * Retorna el JSON del arreglo que se recibe como parametro
     * @param arregloRespuesta Arreglo que se va a convertir en JSON
     * @return JSON del arreglo que se recibe como parametro
     */
    public  function retornarJSON($arregloRespuesta)
    {
        $retorno = json_encode($arregloRespuesta);
        $vars = array();
        $vars['valor'] = $retorno ;
        $this->view->assignOld($vars);
        $temp_file = 'Central_user_popup.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**Pantalla de definicion de objetivos ANUALES de Inspeccion y Auditoria en CENTRAL
     *
     * MODULO: CENTRAL
     * */
    public function  definicionobjetivosinspeccionAction(){
        $vars = array();
        $vars['titulo'] = "Definición de Objetivos Anuales de Auditoría e Inspección";

        $fecha_anio = date('Y');

        $generadorHTMLTablaObjAuditInsp = new GeneradorHTMLTablaObjetivosAuditoriaInspeccion();
        $registros = $generadorHTMLTablaObjAuditInsp->getRegistrosTabla("DAOIaTipoestablecimiento","DAOIaPeriodoobjetivosauditoriainspeccion","nombre",$fecha_anio);
        $htmlFilas = $generadorHTMLTablaObjAuditInsp->generarHTMLFilasObjetivos($registros);

        $sede = 'CENTRAL';
        $tipo = 'INSPECCION';
        $periodo = date('Y');
        $justificacion = JustificacionObjetivos::getJustificacion($sede,$tipo,$periodo);

        $vars['objetivos'] = $htmlFilas;
        $vars['justificacion'] = $justificacion;
        $this->view->assignOld($vars);
        $temp_file = 'definicionObjetivosInspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /*Metodo para refrescar por medio de ajax la tabla de objetivos de inspeccion al hacer algún cambio de específicos*/
    public function obtenerfilasobjetivosinspeccionAction(){
        $vars = array();
        $fecha_anio = date('Y');
        $generadorHTMLTablaObjAuditInsp = new GeneradorHTMLTablaObjetivosAuditoriaInspeccion();
        $registros = $generadorHTMLTablaObjAuditInsp->getRegistrosTabla("DAOIaTipoestablecimiento","DAOIaPeriodoobjetivosauditoriainspeccion","nombre",$fecha_anio);
        $htmlFilas = $generadorHTMLTablaObjAuditInsp->generarHTMLFilasObjetivos($registros);
        foreach ($htmlFilas as $fila) {
            echo $fila;
        }
    }

    /*Pantalla de definicion de objetivos ESPECIFICOS de Inspeccion y Auditoria en CENTRAL*/
    /* MODULO: CENTRAL  */
    public function definicionobjetivosinspeccionespecificosAction(){
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $estados = $this->getEstadosEspecificos();
        $combo_estados_html = $generadorHTMLCombos->generarHTMLCombo($name = "cbEstado", $id = "cbEstado", $estados, $opcionSeleccione = true,$extra = 'style="width: 200px;"');
        $combo_tipo_establecimiento_html = $generadorHTMLCombos->generarHTMLCombo($name = "cbTipoEstablecimiento", $id = "cbTipoEstablecimiento", $items, $opcionSeleccione = true, $extra = "", $opcionTodas = false);

        $anio_actual = date('Y');
        $anio_anterior = $anio_actual - 1;
        $anio_siguiente = $anio_actual + 1;
        $opciones_cbPeriodoNuevo = "<option value='".$anio_anterior."'>".$anio_anterior."</option><option value='".$anio_actual."' selected='selected'>".$anio_actual."</option><option value='".$anio_siguiente."'>".$anio_siguiente."</option>";

        $vars = array();
        $vars['titulo'] = "Objetivos Específicos Anuales de Auditoría e Inspección";
        $vars['cbTipoEstablecimiento'] = $combo_tipo_establecimiento_html;
        $vars['cbEstado'] = $combo_estados_html;
        $vars['cbPeriodoNuevo'] = $opciones_cbPeriodoNuevo;
        $vars['tabla'] = $this->listarobjetivosespecificos("INSPECCION","Tipo Objetivo","","","",$anio_actual);

        $this->view->assignOld($vars);
        $temp_file = 'definicionObjetivosInspeccionEspecificos.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * devuelve la plantilla para agregar un objetivo especifico de inspeccion nuevo para ser embebida en un 'dialog'
     * esto para no utilizar la ventana que despliega el listado de objetivos innecesariamente (ver definicionobjetivosinspeccionespecificos)
     *
     * @MODULO: central
     */
    public function nuevoobjetivoespecificoinspeccionembebidoAction(){
        $tipo_establecimiento_id = 0;
        $tipo_establecimiento_id = $this->request->getParam('EstablecimientoID');

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = ('id='.$tipo_establecimiento_id), $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_establecimiento_nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoEstablecimiento", $id = "cbTipoEstablecimientoNuevo", $items, $opcionSeleccione = false, $extra = "", $opcionTodas = false, $tipo_establecimiento_id);

        $anio_actual = date('Y');
        $anio_anterior = $anio_actual - 1;
        $anio_siguiente = $anio_actual + 1;
        $opciones_cbPeriodoNuevo = "<option value='".$anio_anterior."'>".$anio_anterior."</option><option value='".$anio_actual."' selected='selected'>".$anio_actual."</option><option value='".$anio_siguiente."'>".$anio_siguiente."</option>";

        $vars = array();
        $vars['cbTipoEstablecimientoNuevo'] = $combo_tipo_establecimiento_nuevo_html;
        $vars['cbPeriodoNuevo'] = $opciones_cbPeriodoNuevo;

        $this->view->assignOld($vars);
        $temp_file = 'nuevoObjEspecificoAuditoriaInspeccion.htm'; //'definicionObjetivosInspeccionEspecificos.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * carga el form para la creacion de un nuevo objetivo especifico de inspeccion desde el central
     *  el submit del form se llama a una funcion de gaurdar en el modulo regional
     *
     * @MODULO: central
     */
    public function nuevoobjetivoespecificoinspeccionAction(){
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_establecimiento_nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoEstablecimiento", $id = "cbTipoEstablecimientoNuevo", $items, $opcionSeleccione = false, $extra = "", $opcionTodas = false);

        $anio_actual = date('Y');
        $anio_anterior = $anio_actual - 1;
        $anio_siguiente = $anio_actual + 1;
        $opciones_cbPeriodoNuevo = "<option value='".$anio_anterior."'>".$anio_anterior."</option><option value='".$anio_actual."' selected='selected'>".$anio_actual."</option><option value='".$anio_siguiente."'>".$anio_siguiente."</option>";

        $vars = array();
        $vars['cbTipoEstablecimientoNuevo'] = $combo_tipo_establecimiento_nuevo_html;
        $vars['cbPeriodoNuevo'] = $opciones_cbPeriodoNuevo;

        $this->view->assignOld($vars);
        $temp_file = 'nuevoObjEspecificoAuditoriaInspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    public function verobjetivoespecificoinspeccionAction(){
        $id =$this->request->getParam('id_objetivo');
        $objetivo_especifico = new ObjetivoEspecifico($id);
        $datos = array();
        $datos = $objetivo_especifico->toArray();
        $datos["nombre_region"] = ObjetivoEspecifico::getNombreRegion($datos["id_region"]);

        $this->view->assignOld($datos);
        $temp_file = 'verObjEspecificoAuditoriaInspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    public function editarobjetivoespecificoinspeccionAction(){
        $id =$this->request->getParam('id_objetivo');
        $objetivo_especifico = new ObjetivoEspecifico($id);
        $datos = array();
        $datos = $objetivo_especifico->toArray();
        $datos["nombre_region"] = ObjetivoEspecifico::getNombreRegion($datos["id_region"]);

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_establecimiento_nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoEstablecimiento", $id = "cbTipoEstablecimientoNuevo", $items, $opcionSeleccione = false, $extra = "", $opcionTodas = false, $datos["id_tipoobjetivo"]);

        $anio_actual = intval($datos["periodo"], 10);
        $anio_anterior = $anio_actual - 1;
        $anio_siguiente = $anio_actual + 1;
        $opciones_cbPeriodoNuevo = "<option value='".$anio_anterior."'>".$anio_anterior."</option><option value='".$anio_actual."' selected='selected'>".$anio_actual."</option><option value='".$anio_siguiente."'>".$anio_siguiente."</option>";

        $datos['cbTipoEstablecimientoNuevo'] = $combo_tipo_establecimiento_nuevo_html;
        $datos['cbPeriodoNuevo'] = $opciones_cbPeriodoNuevo;

        $this->view->assignOld($datos);
        $temp_file = 'editarObjEspecificoAuditoriaInspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    public function borrarobjetivoespecificoinspeccionAction(){
        $id =$this->request->getParam('id_objetivo');
        $objetivo_especifico = new ObjetivoEspecifico($id);
        $datos = array();
        $datos = $objetivo_especifico->toArray();
        $datos["estado"] = 'Eliminado';
        $return = array();
        $return["resultado"] = $objetivo_especifico->modificar($datos);
        /*esta parte descuenta un objetivo del total, se eliminó porque ahora se realizan counts cuando se quiera desplegar la cantidad total*/
        /*if ($return["resultado"]) {
            $cantidad = ObjetivoEspecifico::getCountObjetivosEspecificosInspeccion($datos["tipo"], $datos["periodo"], $datos["id_tipoobjetivo"]);
            if ($cantidad !== null){
                $id = ObjetivosAuditoriaInspeccion::getId($datos["periodo"], $datos["id_tipoobjetivo"]);
                $datos['id'] = $id;
                $objAuditoriaInspeccion = new ObjetivosAuditoriaInspeccion($id);
                $array = array();
                $array["meta_especificos"] = $cantidad;
                $objAuditoriaInspeccion->modificar($array);
            }
        }*/
        $this->retornarJSON($return);
    }

    /* MODULO: CENTRAL  */
    public function obtenerobjetivosespecificosinspeccionAction(){
        $nombre_establecimiento =$this->request->getParam('nombre_establecimiento');
        $codigo_establecimiento = $this->request->getParam('codigo_establecimiento');
        $estado =$this->request->getParam('estado_objetivo');
        $tipo=$this->request->getParam('tipo_objetivo');
        $periodo = $this->request->getParam('periodo_objetivo');

        $html_tabla = $this->listarobjetivosespecificos("INSPECCION","Tipo Objetivo",$nombre_establecimiento,$codigo_establecimiento,$estado,$periodo,"","",$tipo);
        $pattern = '#\/zf_Central\/Popup\/obtenerobjetivosespecificosinspeccion\/#';
        $replacement = '/zf_Central/index/definicionobjetivosinspeccionespecificos/';
        //para solucionar el problema con los links generados por el CRUD
        $tabla = preg_replace($pattern,$replacement,$html_tabla);
        $vars = array();
        $vars['valor'] = $tabla;
        $this->view->assignOld($vars);
        $temp_file = 'Central_user_popup.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }
    /*FIN Pantalla de definicion de objetivos ESPECIFICOS de Inspeccion y Auditoria en CENTRAL*/


    /*Pantalla de definicion de objetivos ANUALES de Muestreo en CENTRAL*/
    /* MODULO: CENTRAL  */
    public function definicionobjetivosanualesmuestraAction(){

        $fecha_anio = date('Y');

        $sede = 'CENTRAL';
        $tipo = 'MUESTREO';
        $periodo = date('Y');
        $justificacion = JustificacionObjetivos::getJustificacion($sede,$tipo,$periodo);

        $vars = array();
        $generadorHTMLTablaObjetivos = new GeneradorHTMLTablaObjetivos();
        $items = $generadorHTMLTablaObjetivos->getRegistrosFkTablas("DAOIaTipoanalisis","DAOIaAnalisislaboratorio","DAOIaPeriodoobjetivosmuestras","nombre","nombre",$fecha_anio);
        $vars['acordion'] = $generadorHTMLTablaObjetivos->generarHTMLSeccionAcordion($items);
        $vars['titulo'] = "Definición de Objetivos Anuales de Tomas de Muestra";
        $vars['justificacion'] = $justificacion;
        $this->view->assignOld($vars);
        $temp_file = 'definicionObjetivosAnualesMuestra.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);

    }
    /* FIN Pantalla de definicion de objetivos ANUALES de Muestreo en CENTRAL*/

    public function generaropcionesAction(){
        $opciones = "<option value='' selected='selected'>-- Seleccione --</option>";
        $combo=$this->request->getParam('combo');
        $padre=$this->request->getParam('padre');
        $registros = array();
        switch($combo){
            case "analisis":
                $registros = Analisis::obtenerRegistrosPorTipo($padre);
                break;
        }
        foreach ($registros as $registro) {
            $opciones .= "<option value='".$registro['id']."'>".$registro['nombre']."</option>";
        }
        echo $opciones;
    }

    /*Pantalla de definicion de objetivos ESPECIFICOS de Muestras en CENTRAL*/
    /* MODULO: CENTRAL  */
    public function definicionobjetivosmuestrasespecificosAction(){
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", $select = "habilitado = 1", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_analisis_html = $generadorHTMLCombos->generarHTMLCombo($name = "cbTipoAnalisis", $id = "cbTipoAnalisis", $items, $opcionSeleccione = true,$extra = "style=\"width: 100%;\"", $opcionTodas = false);

        $estados = $this->getEstadosEspecificos();
        $combo_estados_html = $generadorHTMLCombos->generarHTMLCombo($name = "cbEstado", $id = "cbEstado", $estados, $opcionSeleccione = true,$extra = "style=\"width: 100%;\"");

        $anio_actual = date('Y');
        $anio_anterior = $anio_actual - 1;
        $anio_siguiente = $anio_actual + 1;
        $opciones_cbPeriodoNuevo = "<option value='".$anio_anterior."'>".$anio_anterior."</option><option value='".$anio_actual."' selected='selected'>".$anio_actual."</option><option value='".$anio_siguiente."'>".$anio_siguiente."</option>";

        $vars = array();
        $vars['titulo'] = "Definición de Objetivos Específicos de Toma de Muestras";
        $vars['cbTipoAnalisis'] = $combo_tipo_analisis_html;
        $vars['cbEstado'] = $combo_estados_html;
        $vars['opciones_cbPeriodo'] = $opciones_cbPeriodoNuevo;
        $vars['tabla'] = $this->listarobjetivosespecificos("MUESTREO","Análisis","","","",$anio_actual);
        $this->view->assignOld($vars);
        $temp_file = 'definicionObjetivosMuestrasEspecificos.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /** carga el form para la creacion de un nuevo objetivo especifico de toma de muestra desde el central
     *  el submit del form se llama a una funcion de guardar en el modulo regional
     *
     * @MODULO: CENTRAL
     */
    public function nuevoobjetivoespecificotomamuestraembebidoAction(){
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", " habilitado=1 ", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_analisis_nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoAnalisis", $id = "cbTipoAnalisisNuevo", $items, $opcionSeleccione = true,$extra = "style='width: 250px;' class='select2' ", $opcionTodas = false);

        $anio_actual = date('Y');
        $anio_anterior = $anio_actual - 1;
        $anio_siguiente = $anio_actual + 1;
        $opciones_cbPeriodoNuevo = "<option value='".$anio_anterior."'>".$anio_anterior."</option><option value='".$anio_actual."' selected='selected'>".$anio_actual."</option><option value='".$anio_siguiente."'>".$anio_siguiente."</option>";

        $vars = array();
        $vars['cbTipoAnalisisNuevo'] = $combo_tipo_analisis_nuevo_html;
        $vars['opciones_cbPeriodoNuevo'] = $opciones_cbPeriodoNuevo;
        $this->view->assignOld($vars);
        $temp_file = 'nuevoObjEspecificoTomaMuestra.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /** carga el form para la creacion de un nuevo objetivo especifico de toma de muestra desde el central
     *  el submit del form se llama a una funcion de guardar en el modulo regional
     *
     * @MODULO: CENTRAL
     */
    public function nuevoobjetivoespecificotomamuestraAction(){
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", " habilitado=1 ", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_analisis_nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoAnalisis", $id = "cbTipoAnalisisNuevo", $items, $opcionSeleccione = true,$extra = "style='width: 250px;' class='select2' ", $opcionTodas = false);

        $vars = array();
        $vars['cbTipoAnalisisNuevo'] = $combo_tipo_analisis_nuevo_html;
        $this->view->assignOld($vars);
        $temp_file = 'nuevoObjEspecificoTomaMuestra.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    private function obtenerAnalisisParaSelect2($str_analisislaboratorio){
        $analisis = array();
        $analisis_laboratorio = explode(",", $str_analisislaboratorio);
        $count = 0;
        foreach ($analisis_laboratorio as $a_l) {
            $analisis_especifico = explode(".", $a_l);
            $id_analisislaboratorio = $analisis_especifico[0];
            $cantidad_analisislaboratorio = $analisis_especifico[1];
            $obj_analisislaboratorio = new Analisis($id_analisislaboratorio);
            $datos_analisislaboratorio = $obj_analisislaboratorio->toArray();
            $obj_tipoanalisis = new TipoAnalisis($datos_analisislaboratorio["tipoanalisis_id"]);
            $datos_tipoanalisis = $obj_tipoanalisis->toArray();
            $analisis[$count]["tipoanalisis"] = $datos_tipoanalisis["nombre"];
            $analisis[$count]["analisislaboratorio"] = $datos_analisislaboratorio["nombre"];
            $analisis[$count]["id_analisislaboratorio"] = $datos_analisislaboratorio["id"];
            $analisis[$count]["cantidad"] = $cantidad_analisislaboratorio;
            $count++;
        }
        return $analisis;
    }

    public function verobjetivoespecificomuestreoAction(){
        $id =$this->request->getParam('id_objetivo');
        $objetivo_especifico = new ObjetivoEspecifico($id);
        $datos = array();
        $datos = $objetivo_especifico->toArray();
        $datos["nombre_region"] = ObjetivoEspecifico::getNombreRegion($datos["id_region"]);
        $datos["analisis"] = $this->obtenerAnalisisParaSelect2($datos["analisislaboratorio"]);

        $this->view->assignOld($datos);
        $temp_file = 'verObjEspecificoMuestreo.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    public function editarobjetivoespecificomuestreoAction(){
        $id =$this->request->getParam('id_objetivo');
        $objetivo_especifico = new ObjetivoEspecifico($id);
        $datos = array();
        $datos = $objetivo_especifico->toArray();
        $datos["nombre_region"] = ObjetivoEspecifico::getNombreRegion($datos["id_region"]);
        $datos["analisis"] = $this->obtenerAnalisisParaSelect2($datos["analisislaboratorio"]);

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", " habilitado=1 ", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_analisis_nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoAnalisis", $id = "cbTipoAnalisisNuevo", $items, $opcionSeleccione = true,$extra = "style='width: 250px;' class='select2' ", $opcionTodas = false);
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combo_tipo_establecimiento_nuevo_html = $generadorHTMLCombos->generarHTMLCombo($name = "tipoEstablecimiento", $id = "cbTipoEstablecimientoNuevo", $items, $opcionSeleccione = false, $extra = "", $opcionTodas = false, $datos["id_tipoobjetivo"]);

        $anio_actual = intval($datos["periodo"], 10);
        $anio_anterior = $anio_actual - 1;
        $anio_siguiente = $anio_actual + 1;
        $opciones_cbPeriodoNuevo = "<option value='".$anio_anterior."'>".$anio_anterior."</option><option value='".$anio_actual."' selected='selected'>".$anio_actual."</option><option value='".$anio_siguiente."'>".$anio_siguiente."</option>";

        $datos['cbTipoEstablecimientoNuevo'] = $combo_tipo_establecimiento_nuevo_html;
        $datos['opciones_cbPeriodoNuevo'] = $opciones_cbPeriodoNuevo;
        $datos['cbTipoAnalisisNuevo'] = $combo_tipo_analisis_nuevo_html;

        $this->view->assignOld($datos);
        $temp_file = 'editarObjEspecificoMuestreo.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    public function borrarobjetivoespecificomuestreoAction(){
        $id =$this->request->getParam('id_objetivo');
        $objetivo_especifico = new ObjetivoEspecifico($id);
        $datos = array();
        $datos["estado"] = 'Eliminado';
        $return = array();
        $return["resultado"] = $objetivo_especifico->modificar($datos);
        $this->retornarJSON($return);
    }

    /* MODULO: CENTRAL  */
    public function obtenerobjetivosespecificostomamuestraAction(){
        $nombre_establecimiento =$this->request->getParam('nombre_establecimiento');
        $codigo_establecimiento = $this->request->getParam('codigo_establecimiento');
        $estado =$this->request->getParam('estado_objetivo');
        $periodo = $this->request->getParam('periodo_objetivo');
        $tipo_analisis =$this->request->getParam('tipo_analisis_objetivo');
        $analisis=$this->request->getParam('analisis_objetivo');

        $html_tabla = $this->listarobjetivosespecificos("MUESTREO","Análisis",$nombre_establecimiento,$codigo_establecimiento,$estado,$periodo,$tipo_analisis,$analisis);
        $pattern = '#\/zf_Central\/Popup\/obtenerobjetivosespecificostomamuestra\/#';
        $replacement = '/zf_Central/index/definicionobjetivosmuestrasespecificos/';
        //para solucionar el problema con los links generados por el CRUD
        $tabla = preg_replace($pattern,$replacement,$html_tabla);
        $vars = array();
        $vars['valor'] = $tabla;
        $this->view->assignOld($vars);
        $temp_file = 'Central_user_popup.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    public function guardarjustificacionAction(){
        $sede = $this->request->getParam('sede');
        $tipo =$this->request->getParam('tipo');
        $justificacion=$this->request->getParam('justificacion');
        $periodo = date('Y');
        $retornar = array();
        $retornar["resultado"] = JustificacionObjetivos::insertJustificacion($sede,$tipo,$periodo,$justificacion);
        $this->retornarJSON($retornar);
    }

    /*FIN Pantalla de definicion de objetivos ESPECIFICOS de Muestras en CENTRAL*/


    /*Usada para llenar los combos de estados en todas las pantallas de objetivos especificos*/
    private function getEstadosEspecificos(){
        $val = 1;
        $estados = array();
        foreach($this->estadoObjetivoEspecifico as $text){
            if($text != "Eliminado"){
                $item = array();
                $item['value'] = $val;
                $item['text']= $text;
                $estados[]= $item;
                $val = $val+1;
            }

        }
        return $estados;
    }

    /*Usada para obtener el nombre de un estado a partir de un id de estado*/
    private function obtenerNombreEstado($id_estado){
        $val = 1;
        $nombre_estado = "";
        foreach($this->estadoObjetivoEspecifico as $text){
            if($text != "Eliminado"){
                if($val == $id_estado){
                    $nombre_estado = $text;
                }
                $val = $val+1;
            }
        }
        return $nombre_estado;
    }

    /*  PARA IMPRIMIR TABLA DE OBJETIVOS ESPECIFICOS, MODULO: REGIONAL y CENTRAL  */
    public function listarobjetivosespecificos($tipo,$nombreObjetivo,$nombre ='',$codigo='',$estado='', $periodo='',$tipo_analisis='',$analisis='',$tipo_objetivo='',$inspector=''){
        try{
            $tbl= $this->_helper->AddaxCRUD("DAOIaObjetivosespecificos","Objetivos Específicos","Objetivos Específicos");
            $tbl->disallowAdd();
            $tbl->disallowDelete();
            $tbl->omitFieldCompletely("id");
            $tbl->omitFieldCompletely("tipo");
            $tbl->omitFieldCompletely("id_tipoobjetivo");
            $tbl->omitFieldCompletely("id_colaborador");
            $tbl->omitFieldCompletely("calendarizador_id");
            $tbl->omitFieldCompletely("fecha");
            $tbl->omitFieldCompletely("fecha_creacion");
            $tbl->omitFieldCompletely("fecha_ultima_actualizacion");
            $tbl->omitFieldCompletely("justificacion");
            $tbl->omitFieldCompletely("origen");
            $tbl->omitFieldCompletely("id_region");
            $tbl->omitFieldCompletely("cast");
            $tbl->omitFieldCompletely("tipoanalisis");
            $tbl->omitFieldCompletely("analisislaboratorio");

            $tbl->addButtonToRow("Ver", "", "", "", "verObjetivo", array(
                'estado' => array(
                    'Definido','Pendiente','No Ejecutado','Asignado','Calendarizado','Ejecutado','Archivado','Pendiente Revisión'
                )));

            $tbl->addButtonToRow("Editar", "", "", "", "editarObjetivo",  array(
                'estado' => array(
                    'Pendiente'
                )));

            $tbl->addButtonToRow("Borrar", "", "", "",  "borrarObjetivo", array(
                'estado' => array(
                    'Pendiente'
                )));

            if($tipo=="MUESTREO_REGIONAL" || $tipo=="INSPECCION_REGIONAL"){
                $urlAsignar = pnZendPopupURL("zf_Regional", "Index", "");
                $tbl->addButtonToRow("Asignar", $urlAsignar, "id", "", "", array(
                        'estado' => array(
                            'Definido','Pendiente','Asignado', 'No Ejecutado'
                        ))
                );
            }

            if($tipo == "MUESTREO"){
                $tbl->omitFieldCompletely("tipoobjetivo");
                $tbl->omitFieldCompletely("colaborador");
            }
            else{
                if($tipo == "INSPECCION"){
                    $tbl->omitFieldCompletely("colaborador");
                    $tbl->displayAs("tipoobjetivo",$nombreObjetivo);
                    $tbl->disallowEdit("tipoobjetivo");
                }
                else{
                    if($tipo =="INSPECCION_REGIONAL"){
                        $tbl->displayAs("tipoobjetivo",$nombreObjetivo);
                        $tbl->displayAs("colaborador","Inspector");
                        $tbl->disallowEdit("tipoobjetivo");
                        $tbl->disallowEdit("colaborador");
                        $tipo = "INSPECCION";
                    }
                    else{
                        if($tipo == "MUESTREO_REGIONAL"){
                            $tbl->omitFieldCompletely("tipoobjetivo");
                            $tbl->displayAs("colaborador","Inspector");
                            $tbl->disallowEdit("colaborador");
                            $tipo = "MUESTREO";
                        }
                    }
                }
            }

            $tbl->displayAs("idestablecimiento","ID Establecimiento");
            $tbl->displayAs("nombreestablecimiento","Establecimiento");
            $tbl->displayAs("periodo","Período");
            $tbl->displayAs("estado","Estado");

            $tbl->disallowEdit("idestablecimiento");
            $tbl->disallowEdit("nombreestablecimiento");
            $tbl->disallowEdit("periodo");
            $tbl->disallowEdit("estado");

            $where = "tipo ='".$tipo."' AND estado != 'Eliminado'";
            if($nombre != ""){
                $where.= " AND nombreestablecimiento like '%$nombre%'";
            }
            if($codigo != ""){
                $where.= " AND idestablecimiento='".$codigo."'";
            }
            $estado = $this->obtenerNombreEstado($estado);
            if($estado!=""){
                $where.=" AND estado='".$estado."'";
            }
            if($periodo != ""){
                $where .= " AND periodo ='".$periodo."'";
            }
            if($tipo_analisis != ""){
                $analsis_por_tipo = Analisis::obtenerRegistrosPorTipo($tipo_analisis);
                if ($analsis_por_tipo !== false && !empty($analsis_por_tipo)){
                    foreach ($analsis_por_tipo as $a) {
                        $ids = ObjetivoEspecifico::obtenerIdsPorAnalisis($a["id"]);
                        if ($ids !== 0 && !empty($ids)){
                            $where.= " AND";
                            foreach ($ids as $id) {
                                $where.= " id = ".$id;
                                $where.= " OR";
                            }
                            $posicion = strrpos($where, " OR");
                            $where = substr_replace($where, "", $posicion);
                        } else {
                            $where.= " AND id = 0";
                        }
                    }
                }
            }
            if($analisis != ""){
                $ids = ObjetivoEspecifico::obtenerIdsPorAnalisis($analisis);
                if ($ids !== 0 && !empty($ids)){
                    $where.= " AND";
                    foreach ($ids as $id) {
                        $where.= " id = ".$id;
                        $where.= " OR";
                    }
                    $posicion = strrpos($where, " OR");
                    $where = substr_replace($where, "", $posicion);
                } else {
                    $where.= " AND id = 0";
                }
            }
            if($tipo_objetivo !=""){
                $where.= " AND id_tipoobjetivo=".$tipo_objetivo;
            }
            if($inspector !=""){
                $where.=" AND colaborador='".$inspector."'";
            }

            $tbl->addWhereClause($where);

            //Paginación
            $page = $this->request->getParam('page');
            /*Si el parametro de pagina debe llamarse diferente a 'page', antes hay que configurarlo con
               $tbl->setPageParameterName('pid'); */
            $rowsxpage = 5;
            $tbl->turnOnPaging($page, $rowsxpage);

            //Ordenamiento

            $sort_field = $this->request->getParam('sort-field');
            if (empty($sort_field))
            {
                $sort_field ="fecha_creacion";
            }
            $sort_dir = $this->request->getParam('sort-dir');
            if (empty($sort_dir))
            {
                $sort_dir ="ASC";
            }
            $tbl->turnOnSorting($sort_field, $sort_dir);

            ob_start();
            $tbl->showTable();
            $htmlTbl = ob_get_contents();
            ob_end_clean();
            return  $htmlTbl;
        }
        catch(Exception $e)
        {
            error_log("No se ha podido cargar el crud-objetivosEspecificos [$e]");
            return false;
        }
    }

    /*estas vienen del popupcontroller


    public function obteneranalisisAction(){

        $tipo_analisis_id = $this->request->getParam('tipo_analisis_id');
        //@TODO limpiar y validar esta variable


        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaAnalisislaboratorio", "tipoanalisis_id=".$tipo_analisis_id, $ordebBy = "nombre", $value = "id", $text = "nombre");
        if($items!= false){
            $options = '';
            foreach($items as $analisis){
                $nombre = $analisis['text'];
                $valor = $analisis['value'];
                $options .= "<option value=$valor>$nombre</option>";
            }
            $respuesta['resultado'] = true;
            $respuesta['options'] = $options;
        }else{
            $respuesta['resultado'] = false;
        }
        $this->retornarJSON($respuesta);
    }


    /*modulo central*/
    public function guardarobjetivoanualtomamuestraAction(){
        $id = $this->request->getParam('id');
        $metaActual = $this->request->getParam('metaActual');
        $metaEspecificos = $this->request->getParam('metaEspecificos');
        $tipoAnalisisId = $this->request->getParam('tipoAnalisisId');
        $analisisId = $this->request->getParam('analisisId');
        $periodo = $this->request->getParam('periodo');



        //@TODO limpiar y validar estas variables
        try{
            $ObjetivosTomasMuestra = new ObjetivosTomasMuestra($id);
            $datos = array();
            $datos['meta_actual']= $metaActual;
            $datos['meta_especificos']= $metaEspecificos;
            $datos['tipoanalisis_id']= $tipoAnalisisId;
            $datos['analisislaboratorio_id']= $analisisId;
            $datos['anio']= $periodo;
            $ObjetivosTomasMuestra->modificar($datos);
            $respuesta['id'] = $ObjetivosTomasMuestra->objetivo_record['id'];
            $respuesta['resultado'] = true;
        }
        catch(Exception $e){
            $respuesta['resultado'] = false;
        }
        $this->retornarJSON($respuesta);
    }


    /**
     * modulo central
     */
    public function guardarobjetivoanualauditoriainspeccionAction(){

        //@TODO limpiar y validar estas variables y verificar que los especificos sean menores que la meta
        $id = $this->request->getParam('id');
        $objetivosAsignados = $this->request->getParam('objetivosAsignados');
        $metaObjEspecificos = $this->request->getParam('metaObjEspecificos');
        $tipoEstablecimientoId = $this->request->getParam('tipoEstablecimientoId');
        $periodo = $this->request->getParam('periodo');

        try{
            $ObjetivosAuditoriaInspeccion = new ObjetivosAuditoriaInspeccion($id);
            $datos = array();
            $datos['meta_actual']= $objetivosAsignados;
            $datos['meta_especificos']= $metaObjEspecificos;
            $datos['tipoestablecimiento_id']= $tipoEstablecimientoId;
            $datos['anio']= $periodo;
            $ObjetivosAuditoriaInspeccion->modificar($datos);
            $respuesta['id'] = $ObjetivosAuditoriaInspeccion->objetivo_record['id'];
            $respuesta['resultado'] = true;
        }
        catch(Exception $e){
            $respuesta['resultado'] = false;
        }
        $this->retornarJSON($respuesta);
    }

    private function guardarObjetivoEspecificoInspeccion($id_objetivo, $idestablecimiento, $tipo, $tipoobjetivo, $id_tipoobjetivo,
                                                         $nombreestablecimiento, $colaborador = null, $id_colaborador = null, $periodo,
                                                         $estado, $fecha_creacion, $justificacion, $origen, $id_region){
        $objetivoEspecifico = new ObjetivoEspecifico($id_objetivo);
        $datos = array();
        $datos["idestablecimiento"] = $idestablecimiento;
        $datos["tipo"] = $tipo;
        $datos["tipoobjetivo"] = $tipoobjetivo;
        $datos["id_tipoobjetivo"] = $id_tipoobjetivo;
        $datos["nombreestablecimiento"] = $nombreestablecimiento;
        $datos["periodo"] = $periodo;
        $datos["estado"] = $estado;
        $datos["origen"] = $origen;
        $datos["id_region"] = $id_region;
        $datos["colaborador"] = $colaborador;
        $datos["id_colaborador"] = $id_colaborador;
        $datos["justificacion"] = $justificacion;
        $datos["fecha_creacion"] = $fecha_creacion;
        $resultBD = $objetivoEspecifico->modificar($datos);
        /*se realiza nuevamente el conteo de inspecciones para guardar el dato en la tabla de periodoobjetivos,
        en este caso se quita porque se decidió realizar el conteo cada vez que se quiera mostrar la cantidad total*/
        /*if ($resultBD) {
            $cantidad = ObjetivoEspecifico::getCountObjetivosEspecificosInspeccion($tipo, $periodo, $id_tipoobjetivo);
            if ($cantidad !== null){
                $id = ObjetivosAuditoriaInspeccion::getId($periodo, $id_tipoobjetivo);
                $datos['id'] = $id;
                $objAuditoriaInspeccion = new ObjetivosAuditoriaInspeccion($id);
                $array = array();
                $array["meta_especificos"] = $cantidad;
                $objAuditoriaInspeccion->modificar($array);
            }
        }*/
        $datos['resultado'] = $resultBD;
        return $datos;
    }

    private function guardarObjetivoEspecificoMuestreo($id_objetivo, $idestablecimiento, $tipo, $tipoanalisis, $analisislaboratorio,
                                                       $nombreestablecimiento, $periodo, $estado, $fecha_creacion,
                                                       $justificacion, $origen, $id_region){
        $objetivoEspecifico = new ObjetivoEspecifico($id_objetivo);
        $datos = array();
        $datos["idestablecimiento"] = $idestablecimiento;
        $datos["tipo"] = $tipo;
        $datos["tipoanalisis"] = $tipoanalisis;
        $datos["analisislaboratorio"] = $analisislaboratorio;
        $datos["nombreestablecimiento"] = $nombreestablecimiento;
        $datos["periodo"] = $periodo;
        $datos["estado"] = $estado;
        $datos["origen"] = $origen;
        $datos["id_region"] = $id_region;
        $datos["justificacion"] = $justificacion;
        $datos["fecha_creacion"] = $fecha_creacion;
        $resultBD = $objetivoEspecifico->modificar($datos);
        if ($resultBD) {
            $partes = explode(",", $analisislaboratorio);
            foreach ($partes as $parte){
                $p = explode(".", $parte);
                $analisis = $p[0];
                $cantidad = $p[1];
                //guardar esta cantidad + la cantidad anterior de este analisis especifico en la region especifica
                //para cada region y que tenga este analisis
                    //sumar las cantidades de especificos y asignar ese valor al general (que no tiene region)
            }

            /*$cantidad = ObjetivoEspecifico::getCountObjetivosEspecificosInspeccion($tipo, $periodo, $id_tipoobjetivo);
            if ($cantidad !== null){
                $id = ObjetivosAuditoriaInspeccion::getId($periodo, $id_tipoobjetivo);
                $datos['id'] = $id;
                $objAuditoriaInspeccion = new ObjetivosAuditoriaInspeccion($id);
                $array = array();
                $array["meta_especificos"] = $cantidad;
                $objAuditoriaInspeccion->modificar($array);
            }*/
        }
        $datos['resultado'] = $resultBD;
        return $datos;
    }

    public function guardarobjetivoespecificoAction(){
        try{
            $id_objetivo = $this->request->getParam('id_objetivo');
            if ($id_objetivo == "") {
                $id_objetivo = null;
            }
            $origen = $this->request->getParam('origen');
            switch($origen){
                case 0;
                    $origen = "CENTRAL";
                    break;
                case 1;
                    $origen = "REGIONAL";
                    break;
            }
            $nombreEstablecimiento = $this->request->getParam('nombreEstablecimiento');
            $partes = explode("---",$nombreEstablecimiento);
            $nombre_establecimiento = $partes[0]==""? null :$partes[0];
            $codigo_establecimiento = $partes[1]==""? null :$partes[1];
            $periodo = $this->request->getParam('periodo');
            $estado = $this->request->getParam('estado');
            $justificacion = $this->request->getParam('justificacion');
            date_default_timezone_set('America/Costa_Rica');
            $fecha = date('Y-m-d');
            $id_region_obj = $this->request->getParam('id_region');
            $tipo = $this->request->getParam('tipo');
            $resultado = array();
            switch($tipo){
                case "INSPECCION":
                    $nombre_inspector = $this->request->getParam('nombre_inspector');
                    $id_inspector = $this->request->getParam('id_inspector');
                    $id_tipoEstablecimiento = $this->request->getParam('tipoEstablecimiento');
                    $tipoEstablecimiento = TipoEstablecimiento::getNombreTipoEstablecimiento($id_tipoEstablecimiento);
                    $resultado = $this->guardarObjetivoEspecificoInspeccion($id_objetivo, $codigo_establecimiento, $tipo, $tipoEstablecimiento, $id_tipoEstablecimiento, $nombre_establecimiento, $nombre_inspector, $id_inspector, $periodo, $estado, $fecha, $justificacion, $origen, $id_region_obj);
                break;
                case "MUESTREO":
                    $tipoAnalisis = 0;
                    $analisis1 = "";
                    foreach($this->request->getParam('cbAnalisisEscogidos') as $analisisItem){
                        $tipoAnalisis ++;
                        if($analisis1!=""){
                            $analisis1 .= ",".$analisisItem;
                        }else{
                            $analisis1 .= $analisisItem;
                        }
                    }
                    $analisis = $analisis1;
                    $resultado = $this->guardarObjetivoEspecificoMuestreo($id_objetivo, $codigo_establecimiento, $tipo, $tipoAnalisis, $analisis, $nombre_establecimiento, $periodo, $estado, $fecha, $justificacion, $origen, $id_region_obj);
                break;
            }
        }
        catch(Exception $e){
            $resultado['resultado'] = false;
        }
        $this->retornarJSON($resultado);
    }

    public function borrarobjetivoAction(){
        try{
            $objetivo_id = $this->request->getParam('IdObjetivo');
            $objetivoEspefico = new ObjetivoEspecifico($objetivo_id);
            $datos["estado"] = "Eliminado";
            $objetivoEspefico->modificar($datos);
            $respuesta['resultado'] = true;
        }
        catch(Exception $e){
            $respuesta['resultado'] = false;
        }
        $this->retornarJSON($respuesta);
    }

    /*FIN DE FUNCIONES QUE VIENEN DE ZF_MANTENIMIENTO*/
    /****************************************************************************************************/
    /****************************************************************************************************/


    public function indexAction()
    {
        echo "<h1>MODULO ZF_CENTRAL</h1>";
        echo "<h1>Bienvenido</h1>";
        echo "<center><br />
                <a href=\"/zf_Central/index/definicionobjetivosanualesmuestra\">Definicion objetivos anuales muestra</a><br/>
				<a href=\"/zf_Central/index/definicionobjetivosinspeccion\">Definicion objetivos inspeccion</a><br/>
			    <a href=\"/zf_Central/index/distribucionregionalobjetivosanuales\">distribucionregionalobjetivosanuales(sin funcionalidad)</a><br/>
			</center>";


    }

    /**Pantalla de definicion de objetivos ANUALES de Inspeccion y Auditoria por regiones
     *
     *
     * @MODULO: CENTRAL
     *
     * */
    public function  definicionderegionesparaobjetivosinspeccionAction(){
        $anno= date('Y');
        $vars = array();
        $vars['titulo'] = "Definición de objetivos Anuales de Auditoría e Inspección para las regiones ".$anno;
        $vars['leyenda'] = "*No se toman en cuenta los objetivos específicos";
        $vars['anno']= $anno;
        $generadorHTMLTablaObjAuditInsp = new GeneradorHTMLTablaObjetivosAuditoriaInspeccionDistrubucionRegiones();
        $registros = $generadorHTMLTablaObjAuditInsp->getRegistrosTabla("DAOIaTipoestablecimiento","DAOIaPeriodoobjetivosauditoriainspeccion","DAORegion","nombre",$anno);
        $htmlFilas = $generadorHTMLTablaObjAuditInsp->generarHTMLFilasObjetivos($registros);
        $vars['primera_fila'] = $generadorHTMLTablaObjAuditInsp->generarHTMLPrimerafilaFila();
        $vars['objetivos'] = $htmlFilas;
        $vars['action_formulario'] =  pnZendPopupURL("zf_Central", "Popup", "guardarobjetivoanualauditoriainspeccionporregiones");
        $this->view->assignOld($vars);
        $temp_file = 'definicionDeRegionesParaObjetivosInspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * Guarda todos el form de objetivos de anuales de inspecion por regiones
     *
     * @MODULO: CENTRAL
     */
    public function guardarobjetivoanualauditoriainspeccionporregionesAction(){

        //@TODO limpiar y validar estas variables
        $anio = $this->request->getParam('anio');
        $datos = $this->request->getParam('dataa');// todas la variables del request

              try{

            foreach($datos as $item){
            /*el nombre de los inputs de datos corresponden a esta
            decodificacion [odjectivoid]_[testablecimientoid]_[regionid]_[parentid]
            por eso hay que explode
            */
                $name=$item['name'];
                $pieces = explode("_", $name);
                $idobjetivo =$pieces[0];
                $idtipoestablecimiento =$pieces[1];
                $idregion=$pieces[2];
                $idparent=$pieces[3];
                $meta=$item['value'];
                if(!($meta=="0" && $idobjetivo=="")){
                    $ObjetivosAuditoriaInspeccion = new ObjetivosAuditoriaInspeccion($idobjetivo);
                    $dato = array();
                    $dato['meta_actual']= $meta;
                    $dato['tipoestablecimiento_id']= $idtipoestablecimiento;
                    $dato['anio']= $anio;
                    $dato['region_id']=$idregion;
                    $dato['parent_id']=$idparent;
                    $ObjetivosAuditoriaInspeccion->modificar($dato);
                }
            }
            $respuesta['resultado'] = true;
                  /*Creamos la tabala nuevamente para que se vuelva generar con los ids que acabo de los registros recien ingresados*/
              $generadorHTMLTablaObjAuditInsp = new GeneradorHTMLTablaObjetivosAuditoriaInspeccionDistrubucionRegiones();
              $registros = $generadorHTMLTablaObjAuditInsp->getRegistrosTabla("DAOIaTipoestablecimiento","DAOIaPeriodoobjetivosauditoriainspeccion","DAORegion","nombre",$anio);
              $htmltabla =$generadorHTMLTablaObjAuditInsp->generarHTMLPrimerafilaFila()." <tbody> ";
              $aa = $generadorHTMLTablaObjAuditInsp->generarHTMLFilasObjetivos($registros);
              foreach( $aa as $objetivo){
                  $htmltabla .= $objetivo;
               }
                $htmltabla .=" <tbody> ".
            $respuesta['tablanueva'] = $htmltabla;
        }
        catch(Exception $e){
            $respuesta['resultado'] = false;
        }

        $this->retornarJSON($respuesta);
    }


    /**Pantalla de definicion de objetivos ANUALES de Inspeccion y Auditoria por regiones
     *
     *
     * @MODULO: CENTRAL
     *
     * */
    public function  definicionderegionesparaobjetivosmuestrasAction(){
        $anno=date('Y');
        $vars = array();
        $vars['titulo'] ="Definición de regiones para objetivos Anuales de Tomas de muestras ".$anno."";
        $vars['anno']= $anno;
        $generadorHTMLTablaObjetivos = new GeneradorHTMLTablaObjetivosDistribucionRegiones();
        $items = $generadorHTMLTablaObjetivos->getRegistrosFkTablas("DAOIaTipoanalisis","DAOIaAnalisislaboratorio","DAOIaPeriodoobjetivosmuestras","nombre","nombre","DAORegion",$anno);
        $vars['acordion'] = $generadorHTMLTablaObjetivos->generarHTMLSeccionAcordion($items);
        $this->view->assignOld($vars);
        $temp_file = 'definicionDeRegionesParaObjetivosAnualesMuestra.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


    /**
     * Guarda todos el form de objetivos de anuales de inspecion por regiones
     *
     * @MODULO: CENTRAL
     */
    public function guardarobjetivoanualmuestrasporregionesAction(){

        //@TODO limpiar y validar estas variables

        $anio = $this->request->getParam('anio');
        $dataa = $this->request->getParam('dataa');// todas la variables del request
        $datos =  json_decode($dataa,true); // esto por que venia decodificado en un json string
       try{

            foreach($datos as $item){
                //el nombre de los inputs de datos corresponden a esta decodificacion ·[tipodeanalisis]_[odjectivoid]_[testablecimientoid]_[regionid]_[parentid] por eso hay que explode

                $name=$item['name'];
                $pieces = explode("_", $name);
                $idtipoanalisis =$pieces[0];
                $idobjetivo =$pieces[1];
                $idanalsis =$pieces[2];
                $idregion=$pieces[3];
                $idparent=$pieces[4];
                $meta=$item['value'];
                if(!($meta=="0" && $idobjetivo=="")){
                    $ObjetivosAuditoriaInspeccion = new ObjetivosTomasMuestra($idobjetivo);
                    $dato = array();
                    //echo $anio;
                    $dato['meta_actual']= $meta;
                    $dato['tipoanalisis_id']= $idtipoanalisis;
                    $dato['analisislaboratorio_id']= $idanalsis;
                    $dato['anio']= $anio;
                    $dato['region_id']=$idregion;
                    $dato['parent_id']=$idparent;
                    $ObjetivosAuditoriaInspeccion->modificar($dato);
                }

            }
            $respuesta['resultado'] = true;
            //Creamos la tabala nuevamente para que se vuelva generar con los ids que acabo de los registros recien ingresados
            // esta es la que mas lag genera
             $generadorHTMLTablaObjetivos = new GeneradorHTMLTablaObjetivosDistribucionRegiones();
           $items = $generadorHTMLTablaObjetivos->getRegistrosFkTablas("DAOIaTipoanalisis","DAOIaAnalisislaboratorio","DAOIaPeriodoobjetivosmuestras","nombre","nombre","DAORegion",$anio);
           $respuesta['tablanueva'] = $generadorHTMLTablaObjetivos->generarHTMLSeccionAcordion($items);

        }
        catch(Exception $e){
            $respuesta['resultado'] = false;
        }

        $this->retornarJSON($respuesta);
    }





}






