<?php
// Grupos
if(!defined('USERS')) define('USERS', "Users");
if(!defined('ADMINISTRATORS')) define('ADMINISTRATORS', "Administrators");
// Otros
if(!defined('OPCION_SELECCIONE')) define('OPCION_SELECCIONE', "-- Seleccione --");

/**
 * Class IndexController
 *
 * Controlador principal del modulo ZF_Filemanager
 * que se encaga del manejo de archivo dentro de la aplicacion
 *
 * @category     Controller
 * @author       Addax Software SA
 */
class IndexController extends Zend_Controller_Action
{	
    private $_Repositorios;

	private $_defaultRepositorio;

	private $_ChunksPath;

    /**
     * Inicializa las clases y variable nesesarias
     */
    public function init(){
		try{
			$controller = Zend_Controller_Front::getInstance();
			$this->request = $controller->getRequest();


            Zend_Loader::loadClass('DAOBaseIaFiles');
            Zend_Loader::loadClass('DAOIaFiles');
            require_once(APPLICATION_PATH . "/models/DAOInit.php");
            Zend_Loader::loadClass('DAOInit');
			//require_once(APPLICATION_PATH . "/models/UploadHandler.php");
			//Zend_Loader::loadClass('UploadHandler');

			require_once(APPLICATION_PATH . "/models/Files.php");
			Zend_Loader::loadClass('Files');


            $this->config = Zend_Registry::get('config');
			$this->retag = $this->config->retag; 
			$this->bits_extra = $this->config->bits_extra;

			$this->_Repositorios = array();
			foreach($this->config->repository->repositorios as $repositorio)
			{
				$this->_Repositorios[$repositorio] = $this->repository_path = $this->config->repository->$repositorio->path;
			}
			$this->_defaultRepositorio = $this->config->repository->defaultrepository;
			$this->_ChunksPath = $this->config->repository->chunks->path;
		}
		catch(Exception $e){
			error_log("Excepcion iniciando index: [$e]");
		}
    }

    /**
     * Funcion de prueba
     * @return string
     */
    public function indexAction()
	{
		if (!pnSecAuthAction(0, 'zf_FileManager::', '::', ACCESS_ADMIN)) {
			return pnVarPrepHTMLDisplay(_MODULENOAUTH);
		}
		// $this->init();

		$vars = array();

		//$vars['htmlTbl'] = $this->loadCrudPdfs($nombre, $estado, $tipo, $identificacion);
		$vars['valor'] = "PRUEBA DESDE modulo FILEMANAGER";
		$this->view->assignOld($vars);
		$temp_file = 'FileManager_user_popup.htm';
		$smarty = $this->view->getEngine();
		$smarty->force_compile = true;
		$m_html = $this->view->render($temp_file);
		Zend_Registry::set('response', $m_html);
	}



	/**
	 * Retorna el JSON del arreglo que se recibe como parametro
     *
	 * @param arregloRespuesta Arreglo que se va a convertir en JSON
	 * @return JSON del arreglo que se recibe como parametro
	 */
	private function retornarJSON($arregloRespuesta)
	{
		$retorno = json_encode($arregloRespuesta);
		$vars = array();
		$vars['valor'] = $retorno ;
		$this->view->assignOld($vars);
		$temp_file = 'FileManager_user_popup.htm';
		$smarty = $this->view->getEngine();
		$smarty->force_compile = true;
		$m_html = $this->view->render($temp_file);
		Zend_Registry::set('response', $m_html);
	}

    /**
     * Permite visaulizar el pdf correspondiente al id recibido como parametro por medio de un request
     *
     * @return string
     */
    public function verAction()//@todo hacer que se asegure de forma que las fotos las pueda ver solo quien sea admin o dueño de la solicitud
	{
		if (!pnSecAuthAction(0, 'zf_FileManager::', '::', ACCESS_ADMIN))
		{
			return pnVarPrepHTMLDisplay(_MODULENOAUTH);
		}
		$file_id = $this->request->getParam('pdf_id');
		$file = new Files($file_id, null, true ,true);
		$file_fields = $file->toArray();
		//@todo leer el path real del pdf, en lugar del tempname
		header('Content-Type: application/pdf');
		header('Content-disposition: filename="'.$file_fields["nombre_original"].'"');

		$file = $file_fields["tempname"];
		$filename = $file_fields["nombre_original"]; /* Note: Always use .pdf at the end. */

		header('Content-type: application/pdf');
		header('Content-Disposition: inline; filename="' . $filename . '"');
		header('Content-Transfer-Encoding: binary');
		header('Content-Length: ' . filesize($file));
		header('Accept-Ranges: bytes');

		@readfile($file);
		die;
	}



/**
 * este funciona para pdf y para imagenes
 */
    public function verarchivoAction()//@todo hacer que se asegure de forma que las fotos las pueda ver solo quien sea admin o dueño de la solicitud
    {
        if (!pnSecAuthAction(0, 'zf_FileManager::', '::', ACCESS_ADMIN))
        {
            return pnVarPrepHTMLDisplay(_MODULENOAUTH);
        }
        $file_id = $this->request->getParam('id');
        $file = new Files($file_id, null, true ,true);
        $file_fields = $file->toArray();

        $porciones= explode(" ", $file_fields["nombre_original"]);
        $tipo=end($porciones);
         echo $tipo;
        if($tipo == 'pdf'||$tipo == 'PDF'){
            //@todo leer el path real del pdf, en lugar del tempname
            header('Content-Type: application/pdf');
            header('Content-disposition: filename="'.$file_fields["nombre_original"].'"');

            $file = $file_fields["tempname"];
            $filename = $file_fields["nombre_original"]; /* Note: Always use .pdf at the end. */

            header('Content-type: application/pdf');
            header('Content-Disposition: inline; filename="' . $filename . '"');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file));
            header('Accept-Ranges: bytes');

            @readfile($file);
            die;
        }else{
            $file = $file_fields["tempname"];
            $filename = $file_fields["nombre_original"]; /* Note: Always use .pdf at the end. */

            header("Content-type: image/jpeg");
            header("Content-Length: " . filesize($file));
            header("Content-Disposition: attachment; filename=$filename");
            header('Content-Transfer-Encoding: binary');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            ob_end_clean();
            @readfile($file);
            die;

        }


    }


    /**
     * Permite visaulizar la fotogarfia correspondiente al id recibido como parametro por medio de un request
     *
     * @return string
     */
    public function verfotografiasAction()//@todo hacer que se asegure de forma que las fotos las pueda ver solo quien sea admin o dueño de la solicitud
    {
        ob_start();
        if (!pnSecAuthAction(0, 'zf_FileManager::', '::', ACCESS_ADMIN))
        {
            return pnVarPrepHTMLDisplay(_MODULENOAUTH);
        }
        $file_id = $this->request->getParam('foto_id');
        $file = new Files($file_id, null, true ,true);
        $file_fields = $file->toArray();
        //@todo leer el path real del pdf, en lugar del tempname

        $file = $file_fields["tempname"];
        $filename = $file_fields["nombre_original"]; /* Note: Always use .pdf at the end. */

            header("Content-type: image/jpeg");
            header("Content-Length: " . filesize($file));
            header("Content-Disposition: attachment; filename=$filename");
            header('Content-Transfer-Encoding: binary');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            ob_end_clean();
            @readfile($file);
            die;
    }

    /**
     * Se encarga de guardar el pdf de indentificacion de un solicitantes y darle la identificacion para que se accesible
     */
    public function guardardocumentoidentificacionAction()
	{

		$solicitante_id = $this->request->getParam('Solicitante_id');
		if(!isset($solicitante_id) || is_null($solicitante_id) || $solicitante_id <= 0)
		{
			$solicitante_id = null;
		}
		$solicitante_name = "";
		if(!is_null($solicitante_id))
		{
			$solicitante = new Solicitante($solicitante_id, null, true ,true);
			$solicitante_fields = $solicitante->toArray();
			$solicitante_name = $solicitante_fields['nombre'];
		}
		$this->guardarDocumento('HOMOLOGACION_TERMINAL_MOVIL', 'IDENTIFICACION', $solicitante_id, $solicitante_name);
	}


    /**
     * Obtiene los datos de la marca especifica  de un solicitante especifico recibido por parametos y los devuelve en forma de array
     * @return array
     */
    private function _getMarcaSolicitanteParams()
	{
		$solicitante_id = $this->request->getParam('Solicitante_id');
		if(!isset($solicitante_id) || is_null($solicitante_id) || $solicitante_id <= 0)
		{
			$solicitante_id = null;
		}
		$solicitante_name = "";
		if(!is_null($solicitante_id))
		{
			$solicitante = new Solicitante($solicitante_id, null, true ,true);
			$solicitante_fields = $solicitante->toArray();
			$solicitante_name = $solicitante_fields['nombre'];
		}
		else
		{
			$respuesta['resultado'] = false;
			$respuesta['error'] = 'Falta el id del solicitante';
			$respuesta['mensaje'] = $respuesta['error'];
			$this->retornarJSON($respuesta);
		}

		$marcasolicitante_id = $this->request->getParam('MarcaSolicitante_id');
		if(!isset($marcasolicitante_id) || is_null($marcasolicitante_id) || $marcasolicitante_id <= 0)
		{
			$marcasolicitante_id = null;
		}
		$marcasolicitante_name = "";
		if(!is_null($marcasolicitante_id))
		{
			$marcasolicitante = new MarcaSolicitante($marcasolicitante_id);
			$marcasolicitante_fields = $marcasolicitante->toArray();
			$marcasolicitante_name = $marcasolicitante_fields['marca_nombre'];
		}

        $marca_id = $this->request->getParam('Marca_id');//aqui viene el id de la marca en caso de que el pdf sea nuevo
        if(!isset($marca_id) || is_null($marca_id) || $marca_id <= 0)
        {
            $marca_id = null;
        }

        $modelo_id = $this->request->getParam('Modelo_id');
        if(!isset($modelo_id) || is_null($modelo_id) || $modelo_id <= 0)
        {
            $modelo_id = null;
        }
        $modelo_name = "";
        if(!is_null($modelo_id))
        {
            $modelo = new MarcaSolicitante($modelo_id);
            $modelo_fields = $modelo->toArray();
            $modelo_name = $modelo_fields['nombre'];
        }

		return array('solicitante_id' => $solicitante_id,
					'solicitante_name' => $solicitante_name,
					'marcasolicitante_id' => $marcasolicitante_id,
					'marcasolicitante_name' => $marcasolicitante_name,
                    'marca_id' => $marca_id,
                    'modelo_id' => $modelo_id,
                    'modelo_name' => $modelo_name
                    );
	}



    /**Devuelve los datos en un array  de la solicitud de banda libre
     *
     * Devuelve los datos en un array  de la solicitud de banda libre
     * , del solicictante que coincide con el paremetro enviado
     *
     * @return array
     */
    private function _getBandaLibreParams()
    {
        $solicitante_id = $this->request->getParam('Solicitante_id');

        if(!isset($solicitante_id) || is_null($solicitante_id) || $solicitante_id <= 0)
        {
            $solicitante_id = null;
        }
        $solicitante_name = "";

        if(!is_null($solicitante_id))
        {
            $solicitante = new Solicitante($solicitante_id, null, true ,true);
            $solicitante_fields = $solicitante->toArray();
            $solicitante_name = $solicitante_fields['nombre'];
        }

        $solicitud_id = $this->request->getParam('Solicitud_id');
        if(!isset($solicitud_id) || is_null($solicitud_id) || $solicitud_id <= 0)
        {
            $solicitud_id = null;
        }
        $solicitante_name = "";

        if(!is_null($solicitud_id))
        {
            $solicitud = new SolicitudBandaLibre($solicitud_id, null, true ,true);
            $solicitud_fields = $solicitud->toArray();
            $solicitante_name_banda_libre = $solicitud_fields['nombre'];
        }

        return array('solicitante_id' => $solicitante_id,
            'solicitante_name' => $solicitante_name,
            'solicitud_id'=>$solicitud_id,
            'solicitante_nombre_banda_libre'=>$solicitante_name_banda_libre
        );
    }

    /**
     * Se encarga de guarda la fotografia delantera de una solicitud
     */
    /**
     * Se encarga de guarda la fotografia delantera de una solicitud
     */
    public function guardarfotografiaAction()
    {

        $dato1=$this->request->getParam('Numerodeseguiento');
        $dato2=$this->request->getParam('iditem');
        $dato3=$this->request->getParam('numeroadjunto');
        $this->guardarDocumento('NSeguimiento_'.$dato1.'_IdItiem_'.$dato2,
            'Adjunto_hallazgo_'.$dato3,
            'solicitante_id',
            'solicitante_name',
            'marcasolicitante_id',
            'marcasolicitante_name');
    }

    /**
     * Se encarga de guarda la fotografia delantera de una solicitud
     */
    public function guardararchivoAction()
    {

        $dato1=$this->request->getParam('id');
        $dato2=$this->request->getParam('tipo');
        $dato3=$this->request->getParam('numeroadjunto');
        $dato4= pnUserGetVar('uid');
        $this->guardarDocumento('Solicitud_'.$dato1.'_tipo_'.$dato2,
            'Adjunto_desolicitud',
            'solicitante_id_'.$dato4,
            'solicitante_name',
            'marcasolicitante_id',
            'marcasolicitante_name');
    }


    public function guardarcartadeprorrogaparahallazgoAction()
    {

        $dato1=$this->request->getParam('Numerodeseguiento');
        $dato2=$this->request->getParam('iditem');
        $dato3=$this->request->getParam('prorroga');
        $this->guardarDocumento('NSeguimiento_'.$dato1.'_IdItiem_'.$dato2,
            'carta_para_prorroga_'.$dato3,
            'solicitante_id',
            'solicitante_name',
            'marcasolicitante_id',
            'marcasolicitante_name');
    }
 /**
     * Se encarga de guarda la fotografia delantera de una solicitud
     */
    public function guardarpdfdeayudaAction(){
        $dato1=$this->request->getParam('id_item');
        $this->guardarDocumento('pdf_de_ayuda_de_item_id'.$dato1,
            'pdf_de_ayuda_de_item_de_formulario',
            'solicitante_id',
            'solicitante_name',
            'marcasolicitante_id',
           'marcasolicitante_name');
    }



    /**optiene la ip del cliente
     * @return string
     */
    private function get_client_ip()
	{
		$ipaddress = '';
		if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
			$ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';

		return $ipaddress;
	}

    /**
     * Funcion principal Se encarga de guardar en el sistema el documento recibido
     *
     * Guarda dentro de una carpeta del sistema el documneto recibido ademas le adjunta la
     * metadata nesesaria para su manejo e identificacion los parametros son parte la info que se guardara
     *
     * @param $Proceso
     * @param $Tipo
     * @param null $SolicitanteId
     * @param null $SolicitanteName
     * @param null $MarcaSolicitanteId
     * @param null $MarcaSolicitanteName
     * @param null $solicitud_bandaLibre_id
     * @return array|string
     */
    private function guardarDocumento($Proceso, $Tipo, $SolicitanteId = NULL, $SolicitanteName = NULL, $MarcaSolicitanteId = NULL, $MarcaSolicitanteName = NULL, $solicitud_bandaLibre_id = NULL)
	{
		if (!pnSecAuthAction(0, 'zf_FileManager::', '::', ACCESS_ADMIN))
		{
			return pnVarPrepHTMLDisplay(_MODULENOAUTH);
		}

		$method = $_SERVER["REQUEST_METHOD"];
		$tempfilepath = tempnam(sys_get_temp_dir(), "PDF"); //$this->_Repositorios[0]; //
		$upload_result = array();
		if ($method != "POST") //html5 ajax //@todo averiguar como se veria si fuera de ajax
		{
			error_log("NO POST ACCESS");
			// i.e. do HTML5 streaming upload
			$pathinfo = pathinfo($_GET['qqfile']);
			$filename = $pathinfo['filename'];
			$ext = @$pathinfo['extension'];
			$ext = ($ext == '') ? $ext : '.' . $ext;
			$uploadname = $filename . $ext;
			$input = fopen('php://input', 'r');
			$temp = fopen($tempfilepath, 'w');
			$realsize = stream_copy_to_stream($input, $temp); // write stream to temp file
			@chmod($tempfilepath, 0644);
			fclose($input);
			if ($realsize != (int)$_SERVER['CONTENT_LENGTH'])
			{
				$results = array('error' => 'Could not save upload file.');
			}
			else
			{
				$upload_result = array('success' => true,
										"uploadName" => $uploadname,
										"id" => 10);
			}
		}
		elseif ($method == "POST")
		{
			error_log("POST ACCESS");
			// else do regular POST upload (i.e. for old non-HTML5 browsers)
			$size = $_FILES['qqfile']['size'];
			if ($size == 0)
			{
				return array('error' => 'File is empty.');
			}
			$pathinfo = pathinfo($_FILES['qqfile']['name']);
			$filename = $pathinfo['filename'];
			$ext = @$pathinfo['extension'];
			$ext = ($ext == '') ? $ext : '.' . $ext;
			$uploadname = $filename . $ext;
			$md5 = md5_file($tempfilepath);
			if (!move_uploaded_file($_FILES['qqfile']['tmp_name'], $tempfilepath))
			{
				$upload_result = array('error' => 'Could not save upload file.',
										"uploadName" => $uploadname,
										"size" => $size,
										"md5" => $md5,
										"tempname" => $tempfilepath);
			}
			else
			{
				@chmod($tempfilepath, 0644);
				$upload_result = array('success' => true,
										"uploadName" => $uploadname,
										"size" => $size,
										"md5" => $md5,
										"tempname" => $tempfilepath);
			}
		}

		$file = new Files(NULL, NULL); //Siempre es un documento nuevo

		$file_id = -1;
		try
		{
			if(!is_null($SolicitanteId))//si el solicitante existe
			{
				//$solicitante_name;
			}

            $fecha= date('Y-m-d H:i:s');
			$uid = pnUserGetVar('uid');
			$uname = pnUserGetVar('uname',$uid);
			$result = $file->modificar(array(
					'tipo' => $Tipo,
					'proceso' => $Proceso,
					'nombre_original' => $upload_result['uploadName'],
					'path' => "/",
					'tempname' => $upload_result['tempname'],
					'archivado' => 0,
					'repositorio' => $this->_defaultRepositorio,
					'byte_size' => $upload_result['size'],
					'md5sum' => $upload_result['md5'],
					'source_ip' => $this->get_client_ip(),
					'usuario_id' => $uid, //@todo sacar el id de verdad
					'usuario_creacion' => $uname, //@todo sacar el username de verdad
					'fecha_archivado' => $fecha//@
				)
			);
			//@todo, si el Id del solicitante o el Id de la marcasolicitante no son nulo, entonces hay que actualizar el historial
			//@todo, analizar el caso en que el solicitante_id no es nulo, pero la marca_id sí, y es porque es una nueva marca que se está guardando (ya se salva en el modelo de la marcasolicitante?)
			$file_fields = $file->toArray();
			$file_id = $file_fields['id'];
		}
		catch(Exception $e)
		{
			$result = false;
			$str_error = $e->getMessage();
		}
		$respuesta = array();

		$respuesta['resultado'] = $result;
		$respuesta['uploadName'] = $upload_result['uploadName'];
		$respuesta['id'] = $file_id;
		$respuesta['success'] = $upload_result['success'];
		$respuesta['error'] = $upload_result['error'];
		if($result)
		{
			$respuesta['mensaje'] = '';
		}
		else
		{
			$respuesta['mensaje'] = $str_error;
		}

		$this->retornarJSON($respuesta);
	}


    /**
     * Retorna el html de la tabla de la petición con los filtrados recibidos como parametros aplicados
     */
    public function loadtableAction()
	{
		if (!pnSecAuthAction(0, 'zf_FileManager::', '::', ACCESS_ADMIN))
		{
			Zend_Registry::set('response', pnVarPrepHTMLDisplay(_MODULENOAUTH));

			return;
		}
		try
		{
			$nombre = $this->request->getParam('filtro_nombre');
			$estado = $this->request->getParam('filtro_estado');
			$tipo = $this->request->getParam('filtro_tipo');
			$identificacion = $this->request->getParam('filtro_identificacion');

			$vars = array();

			$vars['valor'] = $this->loadCrudPdfs($nombre, $estado, $tipo, $identificacion);$this->view->assignOld($vars);

			$temp_file = 'FileManager_user_popup.htm';
			$m_html = $this->view->render($temp_file);

			Zend_Registry::set('response', $m_html);
		}
		catch(Exception $e)
		{
			error_log("Error en loadtable [$e]");
		}
	}
}