<?php

/**
 * Class TableUtil
 *
 * Clase que se encaraga de la manipilacion de la una tabla de la base de datos
 *
 * @category     Model
 * @author       Addax Software SA
 */
class TableUtil extends DAOInit{

	protected $_table_name;	
	protected $_table;	
	protected $_columns = array();
	protected $_columns_types = array();
	protected $_enum_columns_values = array();
	protected $_primary_key_columns = array();
	
	/**
	 * Constructor
	 * @param string Doctrine Table Name
	 */
	public function __construct($tablename){
		parent::__construct();
		//Crea la tabla
		try{
			$this->_table_name = $tablename;
			$this->_table = Doctrine_Core::getTable($tablename);
			
			//Define las columnas y quienes son llave primarias
			$colnames = $this->_table->getColumnNames();
			$coldefs = $this->_table->getColumns();
			
			foreach ($colnames as $id => $colname){
				$this->_columns[$colname] = $coldefs[$id];						
				if ($coldefs[$colname][primary]){
					$this->_primary_key_columns[] = $colname;
				}			
				$this->_columns_types[$colname] =  $coldefs[$colname][type];
				if ($coldefs[$colname][type] == "enum"){
					$this->_enum_columns_values[$colname] = $coldefs[$colname][values];
				}
			}
		}
		catch(Exception $e){
			echo ("Exception TableUtil::__construct [$e]");
		}			
    }
    /**Retorna el numero columnas de la tabla
     * @return array
     */
	public function getColumns()
	{
		return $this->_columns;
	}
    /**
     * Retorna el nombre de las columans de la tabla
     * @return array
     */
	public function getColumnNames()
	{
		return array_keys($this->_columns);
	}
    /**
     * Devuelve los regitros de la tabla correspondientes a las parametros ingresados
     *
     * @param null $where , condicion
     * @param null $orderby , orden
     * @param null $limit , limite
     * @param null $offset , extra
     * @return array
     */
	public function getRows($where = null, $orderby = null, $limit = null , $offset = null){
		$q = $this->_table->createQuery('t');
		if ($where != null){
			$q->where($where);
		}
		if ($orderby != null){
			$q->orderBy($orderby);
		}
		if ($limit != null){
			$q->limit($limit);
		}	
		if ($offset != null){
			$q->offset($offset);
		}
		$query  = $q->getSqlQuery();
		error_log("CONSULTA GET ROWS $query ");
			
		$rs = $q->execute();
		return $rs->toArray();
	}
    /**
     * Devuelve los regitros de la tabla correspondientes a las parametros ingresados , admite varias condiciones where
     *
     * @param null $where , condicion
     * @param null $where2
     * @param null $where3
     * @param null $orderby , orden
     * @param null $limit , limite
     * @param null $offset , extra
     * @return array

     */
public function getRowsConWheres($where = null,$where2 = null,$where3 = null, $orderby = null, $limit = null , $offset = null){
		$q = $this->_table->createQuery('t');
		if ($where != null){
			$q->where($where);
		}
		if ($where2 != null){
			$q->addwhere($where2);
		}
		if ($where3 != null){
			$q->addwhere($where3);
		}
		if ($orderby != null){
			$q->orderBy($orderby);
		}
		if ($limit != null){
			$q->limit($limit);
		}	
		if ($offset != null){
			$q->offset($offset);
		}
		$rs = $q->execute();
		return $rs->toArray();
	}


}
?>
