<?php

/**
 * Class EstablecimientosSIREA
 * Este modelo se va a encargar de conectase a sirea y jala la informacion de los establemcimientos
 * encapsula lo que es ir a sirea y traer la informacion de los establecimeitos
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');
if(!defined('RUTASERVIDOR')) define('RUTASERVIDOR', "http://test_sirea.addax.cc:80/");
if(!defined('MDKEY')) define('MDKEY', 'ed923d6d3f9d47e8abdb3e16aac166a8');


class EstablecimientosSIREA  extends DAOInit{

    // para pruebas desde el browser
    //http://test-sirea.addax.cc/zf_Conexion/Popup/obtenerinformacionestablecimiento/key/ed923d6d3f9d47e8abdb3e16aac166a8/codigo/119-004059
    //http://test-sirea.addax.cc/zf_Conexion/Popup/consultamultipleestablecimientos/key/ed923d6d3f9d47e8abdb3e16aac166a8/identificador/119-004059

    public function __construct(){
            parent::__construct();
            Zend_Loader::loadClass('TableUtil');
    }



    /*--- Consumo de servicio ---*/
    /* PARA CONECTASE CON EL API DE SIREA PARA OBTENER LOS DATOS DE LOS ESTABLECIMIENTOS*/
    public function hacerLlamadoCurlEstablecimientos($funcion,$_postdata = null){
        $url = RUTASERVIDOR."zf_Registro/Api/".$funcion;
        $referer = RUTASERVIDOR;
        if(isset($_postdata) && !empty($_postdata)){
            $postdata = "codedkey=".MDKEY."&".$_postdata;
        }
        else{
            $postdata = "codedkey=".MDKEY;
        }
        $result = $this->postFormData($url, $postdata, $referer, null);
        if($result[0]!="{" || $result[0]!="["){
            $pos_corchete = strpos($result,"{");
            $pos_cuadrado = strpos($result,"[");
            if ($pos_corchete < $pos_cuadrado){
                $result = substr($result,$pos_corchete);
            } else {
                $result = substr($result,$pos_cuadrado);
            }
        }
        $datos = json_decode($result,true);
        return $datos;
    }

    /* PARA CONECTASE CON EL API DE SIREA PARA OBTENER LOS DATOS DE LAS TABLAS: TIPO, CLASE Y SUBCLASE*/
    public function hacerLlamadoCurl($funcion,$_postdata = null){
        $url = RUTASERVIDOR."zf_Conexion/Popup/".$funcion;
        $referer = RUTASERVIDOR;
        if(isset($_postdata) && !empty($_postdata)){
            $postdata = "key=".MDKEY;
            $param = array();
            $param = explode(",", $_postdata);
            foreach ($param as $p) {
                $postdata .= "&".$p;
            }
        }
        else{
            $postdata = "key=".MDKEY;
        }
        $result = $this->postFormData($url, $postdata, $referer, null);
        if($result[0]!="{" || $result[0]!="["){
            $pos_corchete = strpos($result,"{");
            $pos_cuadrado = strpos($result,"[");
            if ($pos_corchete < $pos_cuadrado){
                $result = substr($result,$pos_corchete);
            } else {
                $result = substr($result,$pos_cuadrado);
            }
        }
        $datos = json_decode($result,true);
        return $datos;
    }

    //Llamados con CURL
    public function postFormData($url, $postData, $referer, $cookieFile=null) {
        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $url);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt ($ch, CURLOPT_USERAGENT, AGENTE);
        curl_setopt ($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt ($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($ch, CURLOPT_REFERER, $referer);
        curl_setopt ($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt ($ch, CURLOPT_POST, true);
        if($cookieFile != null){
            curl_setopt ($ch, CURLOPT_COOKIEJAR, $cookieFile);
            curl_setopt ($ch, CURLOPT_COOKIEFILE, $cookieFile);
        }
        $result = curl_exec ($ch);
        curl_close($ch);
        return $result;
    }
    /*--- FIN Consumo de servicio ---*/


    /** se conecta a SIREA y devuelve toda la info de un establacimento
     * @param $codigo
     * @return bool|mixed
     *
     * esto es un ejemplo de lo que devuelve
     * {"id":"8376","identificador":"119-004059","fecha_inicio":"2013-04-04","fecha_final":"2014-04-04","listo":"1","digitador":null,"fecha_digitado":null,"confirmador":"330","fecha_confirmado":"2013-04-04","nombre":"CENTRO NUTRICIONAL MASCOTAS DEL VALLE","estado":"Completo","codigo_anterior":"11901-0008","clase":"1","subclase":"20","actividad_principal":"174","pais":"60","region":"1","provincia":"1","canton":"19","distrito":"1","caserio":"SANTA CECILIA ","cuadricula":"1815","ubicacion_geografica":"09.38720;-83.71890","latitud":"9.3872","longitud":"-83.7189","direccion":"300 M AL ESTE DE LA CADENA DE DETALLISTAS DEL SUR","area_produccion_cultivo":"80000","area_construccion":"0","area_bosque":"0","area_no_aprovechadas":"0","electricidad":"0","fax":"0","alcantarillado":"0","agua":"0","internet":"0","telefono":"0","recoleccion_desechos":"0","importado":"1","centroide":"1","numero_telefono":"","numero_fax":"","correo":"","sitio_web":"","insercion_movil":null,"actualizacion_movil":null,"nivel_bloqueo":null,"motivo_bloqueo_publico":null,"motivo_bloqueo_privado":null,"CVO":{"numero_cvo":"004059-01","numero_cvo_anterior":"","numero_actualizaciones":"0","establecimiento_identificador":"119-004059","fecha_emision":"2013-04-04 00:00:00","fecha_creado_registro":"2013-04-04 12:54:26","fecha_actualizacion":"2013-04-04 12:54:26","fecha_ultima_renovacion":null,"fecha_vencimiento":"2014-04-04","observaciones":"","estado":"Vigente","tramitante_nombre":"REYES LARA JUAN","autoriza":"DRA. ROCIO RAMIREZ CRUZ","nombre_sede":"Per\u00e9z Zeled\u00f3n\/Senasa"}}
     */
    public function getinfoestablecimiento($codigo){
        try{
          // $establecimiento = $this->hacerLlamadoCurl("consultamultipleestablecimientos","identificador=$codigo"); // hay que cambiar este por que no me devuelve toda la info que ocupo

           $establecimiento = $this->hacerLlamadoCurl("obtenerinformacionestablecimiento","codigo=$codigo");
           // return $establecimiento;
            if( count($establecimiento)>= 0){
                return $establecimiento;
            }
            return  false;
        }
        catch(Exception $e){
            return  false;
        }
    }


    /* LISTADO DE TABLA DE ESTABLECIMIENTOS , MODULO: CENTRAL Y REGIONAL  */
    /* PIENSO QUE ESTA LISTA DE ESTABLECIMIENTOS DEBRIA SER JALADA DE OTRO LADO O DE OTRA TABLA */
    public function obtenerinformacionestablecimiento($whereStmt){
        $establecimientos = array();
        $establecimientos = $this->hacerLlamadoCurl("consultamultipleestablecimientos",$whereStmt);
        $tabla = "<table id='lista_establecimientos' class='tabla_azul' style='height: auto; width: 100%;'>
                    <thead>
                        <tr>
                            <th style='width: 10%;'>Identificador</th>
                            <th style='width: 30%;'>Nombre</th>
                            <th style='width: 10%;'>Estado</th>
                            <th style='width: 30%;'>Responsable</th>
                            <th style='width: 20%;'>Region</th>
                        </tr>
                    </thead>
                    <tbody>";
        $cant_est = count($establecimientos);
        if ($cant_est > 0){
            foreach ($establecimientos as $establecimiento) {
                $tabla .= "<tr>";
                $tabla .= "<td name='identificador_establecimiento'>".$establecimiento["identificador"]."</td>";
                $tabla .= "<td name='nombre_establecimiento'>".$establecimiento["nombre"]."</td>";
                $tabla .= "<td>".$establecimiento["estado"]."</td>";
                $tabla .= "<td>".$establecimiento["responsable"]."</td>";
                $tabla .= "<td name='region_establecimiento'>".$establecimiento["region_nombre"]."<input name='id_region' type='hidden' value='".$establecimiento["region"]."'></td>";
                $tabla .= "</tr>";
            }
        } else {
            $tabla .= "<tr>";
            $tabla .= "<td colspan='5' style='text-align: center;'>No se encontraron resultados</td>";
            $tabla .= "</tr>";
        }
        $tabla .= "</tbody></table>";
        return $tabla;
    }


    /* PARRA LISTAR ESTABLECIMIENTOS, MODULO: CENTRAL Y REGIONAL  */
    public function obtenerinformacionestablecimientoa(){
        $codigoActual=$this->request->getParam('codigoActual');
        $codigoAnterior=$this->request->getParam('codigoAnterior');
        $nombreEstablecimiento=$this->request->getParam('nombreEstablecimiento');
        $estado=$this->request->getParam('estado');
        $region=$this->request->getParam('region');
        $provincia=$this->request->getParam('provincia');
        $canton=$this->request->getParam('canton');
        $distrito=$this->request->getParam('distrito');
        $cuadricula=$this->request->getParam('cuadricula');
        $subclase=$this->request->getParam('subclase');
        $clase=$this->request->getParam('clase');
        $tipo=$this->request->getParam('tipo');
        $nombreResponsable=$this->request->getParam('nombre_responsable');
        $cedulaResponsable=$this->request->getParam('cedula_responsable');
        $whereStmt = "";
        if ($codigoActual !== ""){
            $whereStmt .= ",identificador=".$codigoActual;
        }
        if ($codigoAnterior !== ""){
            $whereStmt .= ",codigo_anterior=".$codigoAnterior;
        }
        if ($nombreEstablecimiento !== ""){
            $whereStmt .= ",nombre=".$nombreEstablecimiento;
        }
        if ($estado !== ""){
            $whereStmt .= ",estado=".$estado;
        }
        if ($region !== ""){
            $whereStmt .= ",region=".$region;
        }
        if ($provincia !== ""){
            $whereStmt .= ",provincia=".$provincia;
        }
        if ($canton !== ""){
            $whereStmt .= ",canton=".$canton;
        }
        if ($distrito !== ""){
            $whereStmt .= ",distrito=".$distrito;
        }
        if ($cuadricula !== ""){
            $whereStmt .= ",cuadricula=".$cuadricula;
        }
        if ($tipo !== ""){
            $whereStmt .= ",tipo=".$tipo;
        }
        if ($clase !== ""){
            $whereStmt .= ",clase=".$clase;
        }
        if ($subclase !== ""){
            $whereStmt .= ",subclase=".$subclase;
        }
        if ($nombreResponsable !== ""){
            $whereStmt .= ",responsable=".$nombreResponsable;
        }
        if ($cedulaResponsable !== ""){
            $whereStmt .= ",cedresponsable=".$cedulaResponsable;
        }
        if ($whereStmt !== "") {
            $whereStmt = substr($whereStmt,0);
        }else{
            $whereStmt = null;
        }
        $html_tabla = $this->listarestablecimiento($whereStmt);
        $vars = array();
        $vars['valor'] =$html_tabla;
        $this->view->assignOld($vars);
        $temp_file = 'Regional_user_popup.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


}

