<?php

/**
 * Class Files
 *
 * Clase objeto que se encarga de de la interaccion con la tabla de file
 * @category     Model
 * @author       Addax Software SA
 */
class Files extends DAOInit
{
	private $file;

    /**
     * Constructor del objeto
     * @param null $FilesID
     */
    public function __construct($FilesID= NULL)
	{
		parent::__construct();
		$this->file_record = NULL;
		$this->file = array();
		error_log("FilesID=$FilesID");
		if(isset($FilesID) && $FilesID != null && $FilesID >= 0)
		{
			try
			{
				//Cargar Files.
				$q = Doctrine_Query::create()
					->from('DAOIaFiles s')
					->where("s.id = $FilesID");
				$file_record = $q->fetchOne();
				$fileCargado = false;
				if($file_record != null && isset($file_record))
				{
					if($file_record->exists())
					{
						$fileCargado = true;
					}
				}
				if ( !$fileCargado)
				{
					error_log("NO Files Cargado");
                    $file_record = new DAOIaFiles();
					$this->setRecord($file_record);
				}
				else //Cargar la aplicación si es necesario
				{
					error_log("Files Cargado");
					$this->setRecord($file_record);
				}
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
		else
		{
			try
			{
				$file_record = new DAOIaFiles();
				$this->setRecord($file_record);
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
	}

    /**Retorna los datos del objeto file en forma de arreglo
     *
     * @return array
     */
	public function toArray()
	{
		$fields = $this->file_record->toArray();

		$file_fields = $this->file_record->toArray();

		//Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
		$fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
		$fields['fecha_archivado'] = $this->MySQLDate2SpanishDate($fields['fecha_archivado']);

		$file_fields['file_id'] = $file_fields['id'];
		unset($file_fields['id']);

		return array_merge($fields, $file_fields);
	}
    /**
     * Retorna si el objeto existe
     * @return mixed
     */
	public function existe()
	{
		return $this->file_record->exists();
	}
    /**
     * Cambia de formato a una fecha de y/m/d a d/m/y
     * @param $StrMySQLDate
     * @return bool|string
     */
	private function MySQLDate2SpanishDate($StrMySQLDate)
	{
		$dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

		//NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

		if ($dobcheck <= 0)
		{
			$date = $StrMySQLDate;
			$date = explode('-', $date);
			$Y = $date[0];

			$M = $date[1];
			$D = $date[2];
			$dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
		}
		else
		{
			$dobshow = date("d/m/Y",strtotime($StrMySQLDate));
		}

		error_log("MODIFYING $StrMySQLDate  to  $dobshow");

		return $dobshow;
	}
    /**
     * Transforma a time un date
     *
     * @param $date
     * @param $format
     * @return int
     */
	private function strotimeformat($date, $format)
	{
		$d = strptime($date, $format);
		return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
	}
    /**
     * Cambia el formato de fecha de español al de  sql
     *
     * @param $StrSpanishDate
     * @return string
     */
	private function SpanishDate2MySQLDate($StrSpanishDate)
	{
		//$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

		//$result = date("Y-m-d", $time);
		$parts = explode("/", $StrSpanishDate);
		$result = implode("-", array_reverse($parts));

		error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

		return $result;
	}

    /**
     * Guarda lo cambios que se hayan hecho en las variables del objeto en la base de datos .
     *
     * @return bool
     * @throws Exception
     */
	public function salvar()
	{
		error_log("Files::salvar");
		try
		{
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
                $this->fecha_archivado= date('Y-m-d H:i:s');
            }

			$file_record = &$this->file_record;
			$arreglo_datos = $file_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					case 'fecha_creacion':
						$file_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					case 'fecha_archivado':
						$file_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
					default:
						$file_record->{$key} = $this->{$key};
					break;
				}
			}
			$file_record->save();
			$new_file_id = $file_record['id'];
			error_log('NEW PDF ID = ' . $new_file_id);
			$this->setRecord($file_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /**
     * Modifica el objeto con el arreglo de mapeo que recibe por parametro.
     * @param $Parametros
     * @return bool
     * @throws Exception
     */
	public function modificar($Parametros)
	{
		error_log("Files::modificar");
		try
		{
			//protege de que vengan parametros fuera de los campos del Aplicante.
            $file_record= &$this->file_record;
			$arreglo_datos = $file_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				if(array_key_exists($key, $Parametros))
				{
					switch($key)
					{
						case 'fecha_creacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						case 'fecha_archivado':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;
						default:
							error_log("modificando $key con valor " . $Parametros[$key]);
							$this->{$key} = $Parametros[$key];
							break;
					}
				}
			}
			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}

		return true;
	}

    /**
     * Setea los valores del objeto que recibe por parámetro
     * @param $Record
     * @return bool
     */
	public function setRecord(&$Record)
	{
		error_log("Files::setRecord");
		if(!is_null($this->file_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->file_record))
			{
				error_log("setRecord:: Record is not the same type as file_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->file_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{
				case 'fecha_creacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				case 'fecha_archivado':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /**
     * Modifica el registro de la base para cambiarlo a estado eliminidado (no elimina nada).
     *
     * @param $FilesID
     * @return bool
     */
	public function eliminar($FilesID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$file_fields = $this->file_record->toArray();
			if($FilesID != $file_fields['id'])
			{
				return false;
			}

			/*  @MISSING@ Falta decidir qué revisiones realizar antes de permitir eliminar al file, si tiene marcas, certificados, solicitudes en proceso, etc
			$campos = "ea.aplicacion_id as aplicacion_id";
			$select = "SELECT $campos FROM ra_Examen_Aplicacion as ea";
			$where = " WHERE ea.aplicacion_id=$AplicacionID AND ( ea.estado is not null AND ea.estado != 'Invitado' AND ea.estado != 'ErrorVerificacion' AND ea.estado != '')"; //Solo se eliminan aplicaciones invitadas , o que no tienen invitacion
			$orderby = '';
			$select .= " $where $orderby";
			error_log("SQL=$select");
			$results = Doctrine_Manager::connection()->fetchAll($select);

			$tiene_solicitudes_pendientes = false;
			foreach($results as $result)
			{
				$tiene_invitaciones_ejecutadas = true;
			}
			if(!$tiene_invitaciones_ejecutadas)
			{
				//protege de que vengan parametros fuera de los campos de la Temática.
				//$examen_record = &$this->examen_record;
				$this->aplicacion_record->{'eliminado'} = 'Sí';
				$this->aplicacion_record->save();
				$conn->commit();
			}
			*/
		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}
}