<?php

/**
 * Class HallazgoInspeccion
 *
 * Clase objeto que se encarga de de la interaccion con la tabla de hallazgo
 * @category     Model
 * @author       Addax Software SA
 */
class HallazgosInspeccion extends DAOInit
{
	private $hallazgo;

    /**
     * Constructor del objeto
     * @param null $HallazgoInspeccionID
     */
    public function __construct($HallazgoInspeccionID= NULL,$item= NULL,$seguimiento= NULL)
	{
		parent::__construct();
		$this->hallazgo_record = NULL;
		$this->hallazgo = array();
		error_log("HallazgoInspeccionID=$HallazgoInspeccionID");
        if(isset($seguimiento) && $seguimiento != null && $seguimiento >= 0 && isset($item) && $item != null && $item >= 0 )
        {
            try
            {
                //Cargar HallazgoInspeccion.
                $q = Doctrine_Query::create()
                    ->from('DAOIaHallazgosinspeccion s')
                    ->where("s.id_item = '$item' AND s.numero_de_seguimiento  LIKE '%$seguimiento%'");
                $hallazgo_record = $q->fetchOne();
                $hallazgoCargado = false;
                if($hallazgo_record != null && isset($hallazgo_record))
                {
                    if($hallazgo_record->exists())
                    {
                        $hallazgoCargado = true;
                    }
                }
                if ( !$hallazgoCargado)
                {
                    error_log("NO HallazgoInspeccion Cargado");
                    $hallazgo_record = new DAOIaHallazgosinspeccion();
                    $this->setRecord($hallazgo_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("HallazgoInspeccion Cargado");
                    $this->setRecord($hallazgo_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }else if(isset($HallazgoInspeccionID) && $HallazgoInspeccionID != null && $HallazgoInspeccionID >= 0)
		{
			try
			{
				//Cargar HallazgoInspeccion.
				$q = Doctrine_Query::create()
					->from('DAOIaHallazgosinspeccion s')
					->where("s.id = $HallazgoInspeccionID");
				$hallazgo_record = $q->fetchOne();
				$hallazgoCargado = false;
				if($hallazgo_record != null && isset($hallazgo_record))
				{
					if($hallazgo_record->exists())
					{
						$hallazgoCargado = true;
					}
				}
				if ( !$hallazgoCargado)
				{
					error_log("NO HallazgoInspeccion Cargado");
                    $hallazgo_record = new DAOIaHallazgosinspeccion();
					$this->setRecord($hallazgo_record);
				}
				else //Cargar la aplicación si es necesario
				{
					error_log("HallazgoInspeccion Cargado");
					$this->setRecord($hallazgo_record);
				}
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
		else
		{
			try
			{
				$hallazgo_record = new DAOIaHallazgosinspeccion();
				$this->setRecord($hallazgo_record);
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
	}

    /**Retorna los datos del objeto hallazgo en forma de arreglo
     *
     * @return array
     */
	public function toArray()
	{
		$fields = $this->hallazgo_record->toArray();

		$hallazgo_fields = $this->hallazgo_record->toArray();

		//Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
		$fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
		//$fields['fecha_ultima_modificacion'] = $this->MySQLDate2SpanishDate($fields['fecha_ultima_modificacion']);

		$hallazgo_fields['hallazgo_id'] = $hallazgo_fields['id'];
		unset($hallazgo_fields['id']);

		return array_merge($fields, $hallazgo_fields);
	}
    /**
     * Retorna si el objeto existe
     * @return mixed
     */
	public function existe()
	{
		return $this->hallazgo_record->exists();
	}
    private function MySQLDate2SpanishDate($StrMySQLDate)
    {
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }
    /**
     * Transforma a time un date
     *
     * @param $date
     * @param $format
     * @return int
     */
    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }
    /**
     * Cambia el formato de fecha de español al de  sql
     *
     * @param $StrSpanishDate
     * @return string
     */
    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }
    /**
     * Guarda lo cambios que se hayan hecho en las variables del objeto en la base de datos .
     *
     * @return bool
     * @throws Exception
     */
	public function salvar()
	{
		error_log("HallazgoInspeccion::salvar");
		try
		{
            if(!$this->existe() ) {
                $this->fecha_creacion= date('Y-m-d H:i:s');
            }

			$hallazgo_record = &$this->hallazgo_record;
			$arreglo_datos = $hallazgo_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					/*case 'fecha_creacion':
						$hallazgo_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;
*/
					default:
						$hallazgo_record->{$key} = $this->{$key};
					break;
				}
			}
			$hallazgo_record->save();
			$new_hallazgo_id = $hallazgo_record['id'];
			error_log('NEW PDF ID = ' . $new_hallazgo_id);
			$this->setRecord($hallazgo_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /**
     * Modifica el objeto con el arreglo de mapeo que recibe por parametro.
     * @param $Parametros
     * @return bool
     * @throws Exception
     */
	public function modificar($Parametros)
	{
		error_log("HallazgosInspeccion::modificar");
		try
		{
			//protege de que vengan parametros fuera de los campos del Aplicante.
            $hallazgo_record= &$this->hallazgo_record;
			$arreglo_datos = $hallazgo_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				if(array_key_exists($key, $Parametros))
				{
					switch($key)
					{
						/*case 'fecha_creacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;*/

						default:
							error_log("modificando $key con valor " . $Parametros[$key]);
							$this->{$key} = $Parametros[$key];
							break;
					}
				}
			}
			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}

		return true;
	}

    /**
     * Setea los valores del objeto que recibe por parámetro
     * @param $Record
     * @return bool
     */
	public function setRecord(&$Record)
	{
		error_log("HallazgoInspeccion::setRecord");
		if(!is_null($this->hallazgo_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->hallazgo_record))
			{
				error_log("setRecord:: Record is not the same type as hallazgo_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->hallazgo_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{
				/*case 'fecha_creacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;
*/
				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /**
     * Modifica el registro de la base para cambiarlo a estado eliminidado (no elimina nada).
     *
     * @param $HallazgoInspeccionID
     * @return bool
     */
	public function eliminar($HallazgoInspeccionID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$hallazgo_fields = $this->hallazgo_record->toArray();
			if($HallazgoInspeccionID != $hallazgo_fields['id'])
			{
				return false;
			}

			/*  @MISSING@ Falta decidir qué revisiones realizar antes de permitir eliminar al hallazgo, si tiene marcas, certificados, solicitudes en proceso, etc
			$campos = "ea.aplicacion_id as aplicacion_id";
			$select = "SELECT $campos FROM ra_Examen_Aplicacion as ea";
			$where = " WHERE ea.aplicacion_id=$AplicacionID AND ( ea.estado is not null AND ea.estado != 'Invitado' AND ea.estado != 'ErrorVerificacion' AND ea.estado != '')"; //Solo se eliminan aplicaciones invitadas , o que no tienen invitacion
			$orderby = '';
			$select .= " $where $orderby";
			error_log("SQL=$select");
			$results = Doctrine_Manager::connection()->fetchAll($select);

			$tiene_solicitudes_pendientes = false;
			foreach($results as $result)
			{
				$tiene_invitaciones_ejecutadas = true;
			}
			if(!$tiene_invitaciones_ejecutadas)
			{
				//protege de que vengan parametros fuera de los campos de la Temática.
				//$examen_record = &$this->examen_record;
				$this->aplicacion_record->{'eliminado'} = 'Sí';
				$this->aplicacion_record->save();
				$conn->commit();
			}
			*/
		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}

    /**CArga todos los hallazgos de unaa inspeccion
     * @param $seguimiento
     * @return array|bool
     */
    public static  function cargartodosloshallazgosdeunainspeccion($seguimiento){
        $consultaClases = "SELECT id,id_item
            FROM ia_hallazgosinspeccion
            where habilitado = '1' AND numero_de_seguimiento LIKE '%$seguimiento%'
            order by id_item asc ";
        //echo $consultaClases;
        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
          if (empty($resultados)){
              return false;
          }
        $respuesta = array();

        foreach($resultados as $item){
            $respuesta[]=$item['id_item'];
        }
        return $respuesta;
    }

    public static  function cargartodosloshallazgospendientesdeunestablecimiento($establecimiento_id){
        $consultaClases = "
            SELECT h.id, h.id_item, h.numero_de_seguimiento, e.event_id
            FROM ia_hallazgosinspeccion h
            INNER JOIN ia_eventos_inspecciones_muestreos e ON UPPER(TRIM(e.numero_de_seguimiento)) = UPPER(TRIM(h.numero_de_seguimiento))
            WHERE h.habilitado =  '1'
            AND establecimiento_id = '$establecimiento_id'
       /*     AND hallazgo_corregido = '0'*/
         ORDER by h.hallazgo_corregido asc,h.fecha_limite asc ";// el upper trim es por que son varcahr
        //hay que ponerle la restriccion de fecha
        //echo $consultaClases;
        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        if (empty($resultados)){
            return false;
        }

        return $resultados;
    }

    public static  function cargarinfodeitem($item_id){
        $consultaClases = "
            SELECT *
            FROM  ia_camposformularioinspeccion
            WHERE habilitado =  '1'
            AND id = '$item_id'";// el upper trim es por que son varcahr
        //echo $consultaClases;
        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        if (empty($resultados)){
            return false;
        }
        return $resultados[0];
    }
}