<?php
/**
 * Created by PhpStorm.
 * User: jrojas
 * Date: 2/14/14
 * Time: 10:00 AM
 */

class ObjetivoEspecifico extends DAOInit {
    private $objetivo;
    public function __construct($ObjetivoID){
        parent::__construct();
        $this->objetivo_record = NULL;
        $this->objetivo = array();
        if(isset($ObjetivoID) && $ObjetivoID != null && $ObjetivoID >= 0){
            try{
                //cargar objetivo
                $q = Doctrine_Query::create()
                    ->from('DAOIaObjetivosespecificos o')
                    ->where("o.id = $ObjetivoID");
                $objetivo_record = $q->fetchOne();
                $objetivoCargado = false;
                if($objetivo_record != null && isset($objetivo_record))
                {
                    if($objetivo_record->exists())
                    {
                        $objetivoCargado = true;
                    }
                }
                if (!$objetivoCargado)
                {
                    error_log("NO Objetivo Especifico Cargado");
                    $objetivo_record = new DAOIaObjetivosespecificos();
                    $this->setRecord($objetivo_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Objetivo Especifico Cargado");
                    $this->setRecord($objetivo_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $objetivo_record = new DAOIaObjetivosespecificos();
                $this->setRecord($objetivo_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }

    }

    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->objetivo_record->toArray();
        return $fields;
    }


    public function existe()
    {
        return $this->objetivo_record->exists();
    }


    public function setRecord(&$Record)
    {
        error_log("ObjetivoEspecifico::setRecord");
        if(!is_null($this->objetivo_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->objetivo_record))
            {
                error_log("setRecord:: Record is not the same type as objetivoespecifico_record");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->objetivo_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }


    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("ObjetivoEspecifico::salvar");
        try
        {
            $nuevo_registro = false;
            if(! $this->existe() )
            {
                $nuevo_registro = true;
            }

            $objetivo_record = &$this->objetivo_record;

            $arreglo_datos = $objetivo_record->toArray();
            foreach($arreglo_datos as $key=>$value) //todo no parece necesario
            {
                switch($key)
                {
                    default:
                        $objetivo_record->{$key} = $this->{$key};
                        break;
                }
            }
            $objetivo_record->save();
            $new_objetivo_id = $objetivo_record['id'];
            if($nuevo_registro)
            {
                error_log('NEW SOLICITUD ID = ' . $new_objetivo_id);
            }
            $this->setRecord($objetivo_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }

    //Modifica el objetivo con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("ObjetivoEspecifico::modificar");
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $objetivo_record= &$this->objetivo_record;
            $arreglo_datos = $objetivo_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }
        $conn->commit();

        return true;
    }

    public static function getCountObjetivosEspecificosInspeccion($tipo, $periodo, $id_tipoEstablecimiento){
        $query = "SELECT COUNT(*) as cantidad
				  FROM ia_objetivosespecificos obj
				  WHERE obj.tipo = '$tipo' AND obj.periodo = '$periodo' AND obj.id_tipoobjetivo = $id_tipoEstablecimiento AND obj.estado != 'Eliminado'";
        try{
            $conn = Doctrine_Manager::connection();
            $vals = $conn->fetchAll($query);
            if(count($vals) <= 0){
                return 0;
            }
            $return= $vals[0]['cantidad'];
        }
        catch(Exception $e){
            $return = null;
        }
        return $return;
    }

    public static function getNombreRegion($id_region){
        $query = "SELECT region.nombre as nombre_region
				  FROM ia_objetivosespecificos obj
				        INNER JOIN region ON obj.id_region = region.id
				  WHERE obj.id_region = $id_region";
        try{
            $conn = Doctrine_Manager::connection();
            $vals = $conn->fetchAll($query);
            if(count($vals) <= 0){
                return "";
            }
            $return= $vals[0]['nombre_region'];
        }
        catch(Exception $e){
            $return = "";
        }
        return $return;
    }


    /** devuelve los ids de los ids de los obejtivos que poseen esos analisis
     * @param $id_analisis_laboratorio
     * @return array|int
     */
    public static function obtenerIdsPorAnalisis($id_analisis_laboratorio){
        $like_str = $id_analisis_laboratorio . ".";
        $query = "SELECT id, analisislaboratorio
                  FROM ia_objetivosespecificos
				  WHERE analisislaboratorio like '%$like_str%'";
        try{
            $conn = Doctrine_Manager::connection();
            $vals = $conn->fetchAll($query);
            if(count($vals) <= 0){
                $return = 0;
            } else {
                $return = array();
                foreach ($vals as $val){
                    $analsis_laboratorio = $val["analisislaboratorio"];
                    $analisis = explode(",", $analsis_laboratorio);
                    foreach ($analisis as $a){
                        $partes = explode(".", $a);
                        if ($partes[0] === $id_analisis_laboratorio) {
                            $return[] = $val["id"];
                        }
                    }
                }
            }
        }
        catch(Exception $e){
            $return = 0;
        }
        return $return;
    }
} 