<?php
/*
*/
//set_include_path(realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."includes". DIRECTORY_SEPARATOR . "classes" . DIRECTORY_SEPARATOR . "PHPExcel") . PATH_SEPARATOR . get_include_path());
$directorioPHPExcel = realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."includes". DIRECTORY_SEPARATOR . "classes" . DIRECTORY_SEPARATOR . "PHPExcel");
require_once($directorioPHPExcel . DIRECTORY_SEPARATOR . "PHPExcel.php");
require_once($directorioPHPExcel .  DIRECTORY_SEPARATOR . "PHPExcel" .DIRECTORY_SEPARATOR . "Writer".DIRECTORY_SEPARATOR."Excel2007.php");
class PHPExcelHandler
{
    private $_archivostemporales;

    public function __construct()
    {

        //Incluir el PHPEXCEL
        $this->_configparams = Zend_Registry::get('options');

        $this->_archivostemporales = $this->_configparams["reporter"]["temporaryfiles"];

    }

    public function getRowCol($celda){
        $rowcol = array();
        if(strlen($celda) == 2){
            $rowcol['col'] = $celda[0];
            $rowcol['row'] = $celda[1];
        }
        else{
            $i = strlen($celda) - 1;
            error_log("REVCELDA:" . $celda[$i]);
            while(is_numeric($celda[$i] && $i>0)){
                error_log("REVCELDA:" . $celda[$i]);
                $i--;
            }
            $i++;
            error_log("I:$i");
            $i = 1;
            $rowcol['row'] = substr($celda,$i);
            $rowcol['col'] = substr($celda, 0, $i);
        }
        return $rowcol;
    }

    public function generarSheet($archivoXLS, $nombreSheet, $rango){
        error_log("CARGAR PLANTILLA " . APPLICATION_PATH . "/" . $archivoXLS);
        $objReader = PHPExcel_IOFactory::createReaderForFile(APPLICATION_PATH . "/" . $archivoXLS);

        $objReader->setLoadSheetsOnly(array($nombreSheet));
        $objReader->setReadDataOnly(false);

        $celdas = explode(":", $rango);
        error_log("CELDAS: " . print_r($celdas,true));
        $c1 = $this->getRowCol($celdas[0]);
        $c2 = $this->getRowCol($celdas[1]);
        error_log("CELDAS SEP " . $c1['col'] . "-" . $c1['row'] . "x" . $c2['col'] . "-" . $c2['row']);

        $objPHPExcel = $objReader->load(APPLICATION_PATH . "/" . $archivoXLS);
        $worksheet =  $objPHPExcel->setActiveSheetIndex(0);
        //$highestColumm = $objPHPExcel->setActiveSheetIndex(0)->getHighestColumn();
        //$highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
        //error_log("Rango: $highestColumm $highestRow");
        $html = '<table border="1" style="border-collapse: collapse;" class="tabla_excel">';
        /*
        foreach ($objPHPExcel->setActiveSheetIndex(0)->getRowIterator() as $row) {
            $cellIterator = $row->getCellIterator();
            $cellIterator->setIterateOnlyExistingCells(false);
            $html .= '<tr>';
            foreach ($cellIterator as $cell) {
                if (!is_null($cell)) {
                    $value = $cell->getCalculatedValue();
                    $html .= '<td>';
                    $html .= $value . '&nbsp;';
                    $html .= '</td>';
                }
            }
            $html .= '</tr>';
        }
        */
        $lastColumn = $c2['col'];
        error_log("LAST COL: $lastColumn");
        $lastColumn++;
        error_log("LAST COL: $lastColumn");
        $lastRow = $c2['row'];
        error_log("LAST ROW: $lastRow");

        for ($row = $c1['row']; $row <= $lastRow; $row++) {
            $html .= '<tr>';
            for ($column = $c1['col']; $column != $lastColumn; $column++) {
                $cell = $worksheet->getCell($column.$row);
                $isBold = $cell->getStyle()->getFont()->getBold();
                $color = $cell->getStyle()->getFill()->getStartColor()->getRGB();
                $width = $worksheet->getColumnDimension($column)->getWidth();
                if (!is_null($cell)) {
                    $value = $cell->getCalculatedValue();
                    $html .= '<td style="width:' . $width . ';">';
                    //$html .= '<td style="width:' . $width . ';   background-color: '.$color.'">';
                    if($isBold){
                        $html .= '<b>' . $value . '&nbsp;' . '<b>';
                    }
                    else{
                        $html .= $value . '&nbsp;';
                    }
                    $html .= '</td>';
                }
            }
            $html .= '</tr>';
        }
        $html .= '</table>';
        error_log("HTML EXCEL: " . $html);
        return $html;
    }

    /*
     * Genera un archivo XLSX con la información de servicios y operadores en hojas diferentes.
     * @param Titulo es el nombre del documento, se asigna al titulo, tema y descripción del documento generado
     * @param Servicios arreglos con los nombres de los servicios del sistema, se listarán en una hoja
     * @param Columnas arreglo con los nombres de la información de las columnas de datos (Servicios y Operadores)
     * @param Arraydatosasociativo arreglo con los datos a insertar en las columnas respectivas
     * @return La ruta y nombre del archivo XLSX generado
     */
    public function generarExcel4($Titulo, $Servicios, $Columnas, $Arraydatosasociativo){
        $filename = false;
        try{
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Addax Software");
            $objPHPExcel->getProperties()->setLastModifiedBy("Addax Software");
            $objPHPExcel->getProperties()->setTitle($Titulo);
            $objPHPExcel->getProperties()->setSubject($Titulo);
            $objPHPExcel->getProperties()->setDescription($Titulo);

            //Hoja con listado de servicios
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Servicios');
            $fila = 2;
            foreach($Servicios as $key => $servicio){
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$fila, $servicio);
                $fila++;
            }
            $objPHPExcel->getActiveSheet()->setTitle('Servicios');
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A1')->getFont()->setBold(true);

            //Hoja con los operadores para cada servicio
            $objPHPExcel->createSheet();
            $objPHPExcel->setActiveSheetIndex(1);

            $letra = "A";
            $fila = 1;
            foreach($Columnas as $key =>$columna){
                $displayname = $columna["display"];
                $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $displayname);
                $letra++;
            }

            $fila++;
            $letra = "A";
            $filainit = $fila;
            foreach($Columnas as $key =>$columna){
                $internalname = $columna["internal"];

                $fila = $filainit;
                foreach ($Arraydatosasociativo as $datoactual) {
                    $value = $datoactual[$internalname];
                    if(array_key_exists("decode", $columna) ){
                        switch($columna["decode"]){
                            case "json":
                                $value = json_decode($value);
                                break;
                        }
                    }
                    $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $value . "");
                    $fila++;
                }
                $letra++;
            }
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

            $objPHPExcel->getActiveSheet()->getStyle('A1:B1')->getFont()->setBold(true);

            $objPHPExcel->getActiveSheet()->setTitle('Operadores');

            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);

            $filename = $this->_archivostemporales . $Titulo . ".xlsx";

            $objWriter->save($filename);
        }catch (Exception $ee){
            echo ("ERROR $ee");
        }

        return $filename;
    }

    /*
     * Genera un archivo XLSX con los datos de cumplimiento de operadores de u tipo de servicio
     * @param Servicio el nombre del tipo de servicio para el cual se están exportando los datos
     * @param Datos arreglo con los datos de operadores para diferentes períodos de cada cumplimiento del tipo de servicio
     * @return La ruta y nombre del archivo XLSX generado
     */
    public function generarExcel3($Servicio, $Datos){
        $filename = false;
        $nombresPeriodos = array("Mensual", "Bimestral", "Trimestral", "Cuatrimestral", "", "Semestral", "", "", "", "", "", "Anual");
        try{
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Addax Software");
            $objPHPExcel->getProperties()->setLastModifiedBy("Addax Software");
            $objPHPExcel->getProperties()->setTitle($Servicio);
            $objPHPExcel->getProperties()->setSubject($Servicio);
            $objPHPExcel->getProperties()->setDescription($Servicio);

            $hojaActual = 0;
            foreach ($Datos as $cumplimiento => $datosCumplimiento){
                if($hojaActual > 0){
                    $objPHPExcel->createSheet();
                }
                $objPHPExcel->setActiveSheetIndex($hojaActual);
                $nombreHoja = $datosCumplimiento['nombre'];
                //Hay un límite de 31 caracteres para los nombres de las hojas
                if(strlen($nombreHoja)>31){
                    $nombreHoja = substr($nombreHoja,0,31);
                }
                $objPHPExcel->getActiveSheet()->setTitle($nombreHoja);

                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Servicio');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', $datosCumplimiento['servicio']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Cumplimiento');
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', $datosCumplimiento['nombre']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A3', 'Clasificación');
                $objPHPExcel->getActiveSheet()->SetCellValue('B3', $datosCumplimiento['clasificacion']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A4', 'Periodicidad');
                $objPHPExcel->getActiveSheet()->SetCellValue('B4', $nombresPeriodos[$datosCumplimiento['tipoperiodo']-1]);
                $objPHPExcel->getActiveSheet()->SetCellValue('A5', 'Umbral Vigente');
                $objPHPExcel->getActiveSheet()->SetCellValue('B5', $datosCumplimiento['umbral']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'Unidad Datos/Umbral');
                $objPHPExcel->getActiveSheet()->SetCellValue('B6', $datosCumplimiento['unidad']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A7', 'Períodos Gráfico');
                $objPHPExcel->getActiveSheet()->SetCellValue('B7', $datosCumplimiento['cantidadperiodoscomparativo']);
                $objPHPExcel->getActiveSheet()->getStyle('B5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                $objPHPExcel->getActiveSheet()->getStyle('B7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                /*
                $objPHPExcel->getActiveSheet()->getStyle('B6')->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()->setARGB('FFFDEADA');
                */
                $objPHPExcel->getActiveSheet()->SetCellValue('A8', 'Texto Ayuda');
                $objPHPExcel->getActiveSheet()->SetCellValue('B8', $datosCumplimiento['textoayuda']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'Nota (opcional)');
                $objPHPExcel->getActiveSheet()->SetCellValue('B9', $datosCumplimiento['nota']);

                $objPHPExcel->getActiveSheet()->SetCellValue('A10', 'Operadores');
                $objPHPExcel->getActiveSheet()->getColumnDimension()->setAutoSize(true);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);

                $objPHPExcel->getActiveSheet()->getStyle('A:A')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->getStyle('10:10')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->getStyle('A:B')->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()->setARGB('FFFDEADA');
                $objPHPExcel->getActiveSheet()->getStyle('10:10')->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()->setARGB('FFFDEADA');

                //Periodos en orden descendente a partir de celda C10
                $precol = "";
                $col = "C";
                $fila = 10;
                $posPeriodos = array();
                for($i=0;$i<count($datosCumplimiento['periodos']);$i++){
                    $objPHPExcel->getActiveSheet()->SetCellValue($precol.$col.$fila, $datosCumplimiento['periodos'][$i]);
                    $posPeriodos[$datosCumplimiento['periodos'][$i]] = $precol.$col;
                    if($col=="Z"){
                        $col = "A";
                        if($precol == ""){
                            $precol = "A";
                        }
                        else{
                            $precol++;
                        }
                    }
                    else{
                        $col++;
                    }
                }

                //Operadores y sus datos
                foreach($datosCumplimiento['datos'] as $operador => $datosOperador){
                    $fila++;
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$fila, $operador);
                    $objPHPExcel->getActiveSheet()->mergeCells('A'.$fila.':B'.$fila);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$fila)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                    foreach($datosOperador as $periodo =>$valor){
                        $objPHPExcel->getActiveSheet()->SetCellValue($posPeriodos[$periodo].$fila, $valor);
                    }
                }

                $hojaActual++;
            }
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $filename = $this->_archivostemporales . $Servicio . time() . session_id() . ".xlsx";
            $objWriter->save($filename);

        }catch (Exception $ee){
            echo ("ERROR $ee");
        }


        return $filename;
    }

    /*
     * Genera un archivo XLSX con la información de entrada.
     * @param Titulo es el nombre del documento, se asigna al titulo, tema y descripción del documento generado
     * @param Columnas arreglo con los nombres de la información de las columnas de datos
     * @param Arraydatosasociativo arreglo con los datos a insertar en las columnas respectivas
     * @param TituloSum especifica el nombre de la hoja de datos
     * @param Encabezados Indica si se imprimen o no encabezados sobre cada columna de datos
     * @return La ruta y nombre del archivo XLSX generado
     */
    public function generarExcel2($Titulo, $Columnas, $Arraydatosasociativo, $TituloSum = "",$Encabezados=false){
        $filename = false;
        try{
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Addax Software");
            $objPHPExcel->getProperties()->setLastModifiedBy("Addax Software");
            $objPHPExcel->getProperties()->setTitle($Titulo);
            $objPHPExcel->getProperties()->setSubject($Titulo);
            $objPHPExcel->getProperties()->setDescription($Titulo);

            $objPHPExcel->setActiveSheetIndex(0);

            $letra = "A";
            $fila = 1;
            if($Encabezados){
                foreach($Columnas as $key =>$columna){
                    $displayname = $columna["display"];
                    $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $displayname);
                    $letra++;
                }
                $fila++;
            }
            $letra = "A";
            $filainit = $fila;
            foreach($Columnas as $key =>$columna){
                $internalname = $columna["internal"];

                $fila = $filainit;
                foreach ($Arraydatosasociativo as $datoactual) {
                    $value = $datoactual[$internalname];
                    if(array_key_exists("decode", $columna) ){
                        switch($columna["decode"]){
                            case "json":
                                $value = json_decode($value);
                                break;
                        }
                    }
                    $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $value . "");
                    $fila++;
                }
                $letra++;
            }
            $objPHPExcel->getActiveSheet()->getColumnDimension()->setAutoSize(true);

            if(empty($TituloSum)){$TituloSum = "Resultado";}
            $objPHPExcel->getActiveSheet()->setTitle($TituloSum);

            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $filename = $this->_archivostemporales . time() . session_id() . ".xlsx";

            $objWriter->save($filename);
        }catch (Exception $ee){
            echo ("ERROR $ee");
        }

        return $filename;
    }

    /*
     * Genera un archivo XLSX con la información de entrada.  Se utiliza para el reporte de datos faltantes
     * @param Titulo es el nombre del documento, se asigna al titulo, tema y descripción del documento generado
     * @param Columnas arreglo con los nombres de la información de las columnas de datos
     * @param Arraydatosasociativo arreglo con los datos a insertar en las columnas respectivas
     * @param TituloSum especifica el nombre de la hoja de datos
     * @return La ruta y nombre del archivo XLSX generado
     */
    public function generarExcel($Titulo, $Columnas, $Arraydatosasociativo, $TituloSum = ""){
        $filename = false;
        try{
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Addax Software");
            $objPHPExcel->getProperties()->setLastModifiedBy("Addax Software");
            $objPHPExcel->getProperties()->setTitle($Titulo);
            $objPHPExcel->getProperties()->setSubject($Titulo);
            $objPHPExcel->getProperties()->setDescription($Titulo);

            $objPHPExcel->setActiveSheetIndex(0);

            $letra = "A";
            $fila = 1;
            foreach($Columnas as $key =>$columna){
                $displayname = $columna["display"];
                $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $displayname);
                $letra++;
            }

            $fila++;$letra = "A";
            $filainit = $fila;
            foreach($Columnas as $key =>$columna){
                $internalname = $columna["internal"];

                $fila = $filainit;
                foreach ($Arraydatosasociativo as $datoactual) {
                    $value = $datoactual[$internalname];
                    if(array_key_exists("decode", $columna) ){
                        switch($columna["decode"]){
                            case "json":
                                $value = json_decode($value);
                                break;
                        }
                    }
                    $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $value . "");
                    $fila++;
                }
                $letra++;
            }
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);

            if(empty($TituloSum)){$TituloSum = "Resultado";}
            $objPHPExcel->getActiveSheet()->setTitle($TituloSum);

            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);

            $filename = $this->_archivostemporales . "Datos Faltantes-" . $TituloSum . ".xlsx";

            $objWriter->save($filename);
        }catch (Exception $ee){
            echo ("ERROR $ee");
        }

        return $filename;
    }

}