<?php

/**
 * Class SolicitudPMB
 *
 * Clase objeto que se encarga de de la interaccion con la tabla de eventos de inspeccion
 * @category     Model
 * @author       Addax Software SA
 */
class SolicitudPMB extends DAOInit
{
	private $solicitud;

    /**
     * Constructor del objeto
     * @param null SolicitudPMBID
     */
    public function __construct($SolicitudPMBID= NULL,$seguimiento= NULL){
		parent::__construct();
		$this->solicitud_record = NULL;
		$this->solicitud = array();
		error_log("HallazgoInspeccionID=SolicitudPMBID");
        if(isset($SolicitudPMBID) && $SolicitudPMBID != null && $SolicitudPMBID >= 0 ){
            try{
                //Cargar HallazgoInspeccion.
                $q = Doctrine_Query::create()
                    ->from('DAOSuSolicitudesPmb s')
                    ->where("s.id = '$SolicitudPMBID'");
                $solicitud_record = $q->fetchOne();
                $solicitudCargado = false;
                if($solicitud_record != null && isset($solicitud_record)){
                    if($solicitud_record->exists()) {
                        $solicitudCargado = true;
                    }
                }
                if ( !$solicitudCargado) {
                    error_log("NO DAOSuSolicitudesPmb ");
                    $solicitud_record = new DAOSuSolicitudesPmb();
                    $this->setRecord($solicitud_record);
                }else //Cargar la aplicación si es necesario
                {
                    error_log("DAOSuSolicitudesPmb Cargado");
                    $this->setRecord($solicitud_record);
                }
            }
            catch(Exception $e){
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }else{
			try
			{
				$solicitud_record = new DAOSuSolicitudesPmb();
				$this->setRecord($solicitud_record);
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
	}

    /**Retorna los datos del objeto solicitud en forma de arreglo
     *
     * @return array
     */
	public function toArray(){
		$fields = $this->solicitud_record->toArray();
		$solicitud_fields = $this->solicitud_record->toArray();
		$fields['fecha_registro'] = $this->MySQLDate2SpanishDate($fields['fecha_registro']); //Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
		$fields['fecha_ultima_modificacion'] = $this->MySQLDate2SpanishDate($fields['fecha_ultima_modificacion']);
		return array_merge($fields, $solicitud_fields);
	}

    /**
     * Retorna si el objeto existe
     * @return mixed
     */
	public function existe(){
		return $this->solicitud_record->exists();
	}

    private function MySQLDate2SpanishDate($StrMySQLDate){
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }
    /**
     * Transforma a time un date
     *
     * @param $date
     * @param $format
     * @return int
     */
    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }
    /**
     * Cambia el formato de fecha de español al de  sql
     *
     * @param $StrSpanishDate
     * @return string
     */
    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }
    /**
     * Guarda lo cambios que se hayan hecho en las variables del objeto en la base de datos .
     *
     * @return bool
     * @throws Exception
     */
	public function salvar()
	{
		error_log("HallazgoInspeccion::salvar");
		try
		{
            if(! $this->existe() )
            {
                $this->fecha_registro= date('Y-m-d H:i:s');
            }

			$solicitud_record = &$this->solicitud_record;
			$arreglo_datos = $solicitud_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{

					default:
						$solicitud_record->{$key} = $this->{$key};
					break;
				}
			}
			$solicitud_record->save();
			//$new_solicitud_id = $solicitud_record['event_id'];
			//error_log('NEW PDF ID = ' . $new_solicitud_id);
			$this->setRecord($solicitud_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /**
     * Modifica el objeto con el arreglo de mapeo que recibe por parametro.
     * @param $Parametros
     * @return bool
     * @throws Exception
     */
	public function modificar($Parametros)
	{
		error_log("HallazgosInspeccion::modificar");
		try
		{
			//protege de que vengan parametros fuera de los campos del Aplicante.
            $solicitud_record= &$this->solicitud_record;
			$arreglo_datos = $solicitud_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				if(array_key_exists($key, $Parametros))
				{
					switch($key)
					{

						default:
							error_log("modificando $key con valor " . $Parametros[$key]);
							$this->{$key} = $Parametros[$key];
							break;
					}
				}
			}
			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}

		return true;
	}

    /**
     * Setea los valores del objeto que recibe por parámetro
     * @param $Record
     * @return bool
     */
	public function setRecord(&$Record)
	{
		error_log("HallazgoInspeccion::setRecord");
		if(!is_null($this->solicitud_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->solicitud_record))
			{
				error_log("setRecord:: Record is not the same type as solicitud_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->solicitud_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{

				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /**
     * Modifica el registro de la base para cambiarlo a estado eliminidado (no elimina nada).
     *
     * @param SolicitudPMBID
     * @return bool
     */
	public function eliminar($SolicitudPMBID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$solicitud_fields = $this->solicitud_record->toArray();
			if($SolicitudPMBID != $solicitud_fields['event_id'])
			{
				return false;
			}

		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}


    /*devuelve el id de colaborador */
    public static function gettodalainfodesolicitudconjoins($id){
        $query = "SELECT sol.* ,

                    cola.nombre as nombre_solicitante ,
                    cola2.nombre as nombre_tecnico,
                    cola3.nombre as nombre_usuario_registro,
                    are.nombre as nombre_area_conservacion ,
                    sub.nombre as nombre_subregion,
                    est.nombre as nombre_estado,

                    prov.nom_prov as nombre_provincia,
                    can.nom_cant as nombre_canton,
                    dis.nom_dist as nombre_distrito

                    FROM su_solicitudes_PMB sol
                    inner join  ia_colaboradores cola on sol.solicitante_id = cola.id
                    left join  ia_colaboradores cola2 on sol.tecnico_asignado = cola2.id
                    left join  ia_colaboradores cola3 on sol.usuario_registro = cola3.usuario_id
                    left join  area_conservacion are on sol.area_de_conservacion= are.id
                    left join  subregion_conservacion sub on sol.subregion= sub.id
                    left join  su_estados_de_solicitud est on sol.estado_id= est.id

                    left join capa_sobrepuestas_provincia prov on sol.provincia= prov.id
                    left join capa_sobrepuestas_canton can on sol.canton= can.id
                    left join capa_sobrepuestas_distrito dis on sol.distrito= dis.id

                    WHERE sol.id = $id";
        try{
            $conn = Doctrine_Manager::connection();
            $vals = $conn->fetchAll($query);
            if(count($vals) <= 0){
                return null;
            }
            return $vals[0];
        }
        catch(Exception $e){
            return null;
        }

    }


}