<?php

/**
 * DAOBaseTiDispositivos
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property string $identificador_individuo
 * @property integer $tipo_dispositivo_id
 * @property timestamp $fecha_ingreso_sistema
 * @property string $empaque_individual
 * @property integer $unidad_empaque_id
 * @property enum $estado
 * @property integer $establecimiento_id
 * @property integer $especie_id
 * @property TiUnidadEmpaque $TiUnidadEmpaque
 * @property TiTipoDispositivos $TiTipoDispositivos
 * @property TiEspecies $TiEspecies
 * @property Doctrine_Collection $TiDispositivoIndividuo
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 6401 2009-09-24 16:12:04Z guilhermeblanco $
 */
abstract class DAOBaseTiDispositivos extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('ti_dispositivos');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             'unsigned' => 0,
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('identificador_individuo', 'string', 23, array(
             'type' => 'string',
             'length' => 23,
             'fixed' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             ));
        $this->hasColumn('tipo_dispositivo_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             'unsigned' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             ));
        $this->hasColumn('fecha_ingreso_sistema', 'timestamp', null, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('empaque_individual', 'string', 15, array(
             'type' => 'string',
             'length' => 15,
             'fixed' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('unidad_empaque_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('estado', 'enum', 13, array(
             'type' => 'enum',
             'length' => 13,
             'fixed' => false,
             'values' => 
             array(
              0 => 'Inactivo',
              1 => 'Notificado',
              2 => 'Activo',
              3 => 'Deshabilitado',
              4 => 'Perdido',
              5 => 'NoTrazable',
              6 => 'EnEspera',
             ),
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             ));
        $this->hasColumn('establecimiento_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             'unsigned' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             ));
        $this->hasColumn('especie_id', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             'unsigned' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             ));
    }

    public function setUp()
    {
        parent::setUp();
    $this->hasOne('DAOTiUnidadEmpaque', array(
             'local' => 'unidad_empaque_id',
             'foreign' => 'id'));

        $this->hasOne('DAOTiTipoDispositivos', array(
             'local' => 'tipo_dispositivo_id',
             'foreign' => 'id'));

        $this->hasOne('DAOTiEspecies', array(
             'local' => 'especie_id',
             'foreign' => 'id'));

        $this->hasMany('DAOTiDispositivoIndividuo', array(
             'local' => 'id',
             'foreign' => 'dispositivo_id'));
    }
}