﻿<?php

error_reporting(E_ALL);
ini_set('display_errors', '1');

/**
 * Class IndexController
 *
 * Controlador principal del modulo de inspecciones que se encaga del manejo de formularios de inspecciones y muestreos
 */
class IndexController extends Zend_Controller_Action
{

	private $_configparams;
	
    public function init()
    {
		error_reporting(E_ALL);
        ini_set('display_errors', '1');
        /* Initialize action controller here */
		try
		{

			$controller = Zend_Controller_Front::getInstance();		
			$this->request = $controller->getRequest();


            Zend_Loader::loadClass('DAOBaseIaTipoanalisis');
            Zend_Loader::loadClass('DAOIaTipoanalisis');

            Zend_Loader::loadClass('DAOBaseIaAnalisislaboratorio');
            Zend_Loader::loadClass('DAOIaAnalisislaboratorio');

            Zend_Loader::loadClass('DAOBaseIaColaboradores');
            Zend_Loader::loadClass('DAOIaColaboradores');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosmuestras');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosmuestras');

            Zend_Loader::loadClass('DAOBaseIaTipoestablecimiento');
            Zend_Loader::loadClass('DAOIaTipoestablecimiento');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosauditoriainspeccion');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosauditoriainspeccion');

            Zend_Loader::loadClass('DAOBaseIaObjetivosespecificos');
            Zend_Loader::loadClass('DAOIaObjetivosespecificos');

            Zend_Loader::loadClass('DAOBaseIaCamposformularioinspeccion');
            Zend_Loader::loadClass('DAOIaCamposformularioinspeccion');

            Zend_Loader::loadClass('DAOBaseIaLaboratorios');
            Zend_Loader::loadClass('DAOIaLaboratorios');

            Zend_Loader::loadClass('DAOBaseIaHallazgosinspeccion');
            Zend_Loader::loadClass('DAOIaHallazgosinspeccion');

            Zend_Loader::loadClass('DAOBaseIaTomasdemuestra');
            Zend_Loader::loadClass('DAOIaTomasdemuestra');

            Zend_Loader::loadClass('DAOBaseRegion');
            Zend_Loader::loadClass('DAORegion');

            Zend_Loader::loadClass('DAOBaseIaEventosInspeccionesMuestreos');
            Zend_Loader::loadClass('DAOIaEventosInspeccionesMuestreos');


            require_once(APPLICATION_PATH . "/models/DAOInit.php");
            Zend_Loader::loadClass('DAOInit');
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLCombos.php");
            Zend_Loader::loadClass('GeneradorHTMLCombos');
            require_once(APPLICATION_PATH . "/models/GeneradorDeHTMLDeItemsFormularioInspeccion.php");
            Zend_Loader::loadClass('GeneradorDeHTMLDeItemsFormularioInspeccion');
            require_once(APPLICATION_PATH . "/models/GeneradorDeHTMLDeinspecionesAnteriores.php");
            Zend_Loader::loadClass('GeneradorDeHTMLDeinspecionesAnteriores');
            require_once(APPLICATION_PATH . "/models/EstablecimientosSIREA.php");
            Zend_Loader::loadClass('EstablecimientosSIREA');
            require_once(APPLICATION_PATH . "/models/ObjetivoEspecifico.php");
            Zend_Loader::loadClass('ObjetivoEspecifico');
            require_once(APPLICATION_PATH . "/models/Region.php");
            Zend_Loader::loadClass('Region');
            require_once(APPLICATION_PATH . "/models/Analisis.php");
            Zend_Loader::loadClass('Analisis');
            require_once(APPLICATION_PATH . "/models/HallazgosInspeccion.php");
            Zend_Loader::loadClass('HallazgosInspeccion');
            require_once(APPLICATION_PATH . "/models/TomaDeMuestra.php");
            Zend_Loader::loadClass('TomaDeMuestra');
            require_once(APPLICATION_PATH . "/models/EventoDeInspeccionesyMuestreos.php");
            Zend_Loader::loadClass('EventoDeInspeccionesyMuestreos');
            require_once(APPLICATION_PATH . "/models/UserUtil.php");
            Zend_Loader::loadClass('UserUtil');

            require_once(APPLICATION_PATH . "/models/TipoAnalisis.php");

            require_once(APPLICATION_PATH . "/models/TipoEstablecimiento.php");
            require_once(APPLICATION_PATH . "/models/Colaborador.php");

        }
		catch(Exception $e){
			error_log("Excepcion iniciando index: [$e]");
		}
		$this->_configparams = Zend_Registry::get('options');
    }

    /**
     * para pruebas por ahora
     */
    public function indexAction(){
        $aa= '119-004059';
		echo "hola desde modulo inspeccion   $aa    ";
        $establecimiento_sirea= new EstablecimientosSIREA();
        print_r($establecimiento_sirea->getinfoestablecimiento($aa)) ;

        //$asasd= new EstablecimientosSIREA();
       // print_r($asasd->hacerLlamadoCurl("consultamultipleestablecimientos"));
    }


    /**
     * Retorna el JSON del arreglo que se recibe como parametro
     * @param arregloRespuesta Arreglo que se va a convertir en JSON
     * @return JSON del arreglo que se recibe como parametro
     */
    public  function retornarJSON($arregloRespuesta)
    {
        $retorno = json_encode($arregloRespuesta);
        $vars = array();
        $vars['valor'] = $retorno ;
        $this->view->assignOld($vars);
        $temp_file = 'Inspeccion_user_popup.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


    /***************************************************************************************************************************************/
    /***************************************************************************************************************************************/
    /***************************************************************************************************************************************/
    /*ESTA PARTE TIENE QUE VER CON LAS INSPECCIONES Y HALLAZGOS */



    /**
     * Muestra una pantalla con un resumen de los datos del evento
     *
     * Requiere que todos los datos se le envien por parametro
     * TODAVIA NO SE USA y no hace mucho
     *
     * @MODULO: INSPECCION
     */
     public function resumendeeventoinspeccionAction(){
         //$numero_seguimiento = $this->request->getParam('numero_seguimiento');
        // $establecimiento = $this->request->getParam('establecimiento');
         $numero_seguimiento="123123";
         $establecimiento="establecimiento imaginario";
         $vars = array();
         $vars['titulo'] = "Resumen inspeccion";
         $vars['1'] = "AAAAAAAAAA";
         $vars['num_seguimiento'] = $numero_seguimiento;
         $vars['establecimiento'] = $establecimiento;

         $this->view->assignOld($vars);
         $temp_file = 'Resumen_datos_evento_Inspeccion.htm';
         $smarty = $this->view->getEngine();
         $smarty->force_compile = true;
         $m_html = $this->view->render($temp_file);
         Zend_Registry::set('response', $m_html);
     }


    /**Carga la Pantalla del FORMULARIO DE INSPECCION vacio
     *
     * @MODULO: INSPECCION
     *
     * */
    public function formulariodeinspeccionnuevoAction(){

        $anno=date('Y');


        $id_evento= $this->request->getParam('id_evento');
        $Numero_de_seguimiento= $this->request->getParam('numero_seguimiento_inspeccion');
        $tipodeestablecimiento= $this->request->getParam('tipo_de_establecimiento');
        if($id_evento!=''&& $id_evento!=null ){
            $evento= new EventoDeInspeccionesyMuestreos($id_evento,null);
            $evento= $evento->toArray();
            $Numero_de_seguimiento= $evento['numero_de_seguimiento'];
            $tipodeestablecimiento= $evento['tipo_inspeccion'];
        }

        $vars = array();
        $vars['titulo'] = "Formulario de Inspección/Auditoría";
        $vars['Numero_de_seguimiento']=$Numero_de_seguimiento;
        $vars['anno']= $anno;
        $generadoritems = new GeneradorDeHTMLDeItemsFormularioInspeccion();
        $preguntas = $generadoritems->getItmesPreguntas("DAOIaCamposformularioinspeccion","aquitabladerespuestas",$Numero_de_seguimiento,$tipodeestablecimiento);
        $vars['tabla_de_items'] = $generadoritems->generarHTMLAcordionPreguntas($preguntas);

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD2($tabla = "DAOIaColaboradores", $select = "habilitado =1 ", $ordebBy = "nombre", $value = "id", $text = "identificacion", $text2 = "nombre");
        $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "formulario_acompannantes[]", $id = "formulario_acompannantes", $items, $opcionSeleccione = false, $extra = "multiple class='inputmantenimiento2' style='width: 450px;'");
       // $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "formulario_acompannantes[]", $id = "formulario_acompannantes", $items, $opcionSeleccione = false, $extra = "multiple class='inputmantenimiento2'", false, json_decode($vars['establecimientos']));
        $vars['combo_acompannantes'] =$combo_tipo_objetivo_html;

        //$vars['tabla_de_items'] = "Tabla de items aca ";
        $this->view->assignOld($vars);
        $temp_file = 'Formulario_de_inspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


    /**
     * Muestra el cuadro de hallazgo para un inten que imcumple en el formulario de inspeccion
     *
     * REcibe dos parametros el numero de seguimiento del formulario y el id del item con estos deberia buscar en la base de datos para llenar los datos
     * si no recibe nada debria estar vacio
     *
     *
     * @MODULO: INSPECCION
     */
    public function hallazgosdeformulacioninspeccionAction(){
        $numero_seguimiento = $this->request->getParam('numero_seguimiento');
        $id_item = $this->request->getParam('itemid');
        $vars = array();
        $hallazgo = new HallazgosInspeccion(null,$id_item,$numero_seguimiento);
        if ($hallazgo){
            $vars1= $hallazgo->toArray();
            if ($vars1['habilitado']=='1'){
                $vars=$vars1;
                $eventoinspeccion = new EventoDeInspeccionesyMuestreos(null,$numero_seguimiento);
                $v=  $eventoinspeccion->toArray();
                $vars['estado_evento']=$v['estado_evento'];
            }
        }
        $vars['numero_de_seguimiento'] = $numero_seguimiento;
        $vars['id_item'] = $id_item;
        $this->view->assignOld($vars);
        $temp_file = 'Cuadro_de_hallazgo_formulario_Inspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * Se encarga de guardar un hallazgo de un inspeccion nuevo o viejo
     *
     * @param $Proceso
     * @param $Tipo
     * @param null $SolicitanteId
     */
    public function guardarhallazgoinspeccionAction(){
      $hallazgoid = $this->request->getParam('id_hallazgo');
       // $camposaguardar = array(); // no se si hace falta revisar qu este vacios
        $camposaguardar= $this->request->getParams();

       /* $camposaguardar['id_item']= $this->request->getParam('id_item');
        $camposaguardar['numero_de_seguimiento'] = $this->request->getParam('numero_de_seguimiento');
        $camposaguardar['detalles'] = $this->request->getParam('detalles');
        $camposaguardar['adjunto1'] = $this->request->getParam('adjunto1');
        $camposaguardar['adjunto2'] = $this->request->getParam('adjunto2');
        $camposaguardar['adjunto3'] = $this->request->getParam('adjunto3');
        $camposaguardar['nivel_disconformidad'] = $this->request->getParam('nivel_disconformidad');
        $camposaguardar['arreglo_inmediato'] = $this->request->getParam('arreglo_inmediato');
        $camposaguardar['fecha_limite'] = $this->request->getParam('fecha_limite');*/
        if($camposaguardar['arreglo_inmediato']=="Si"){
            $camposaguardar['hallazgo_corregido']=1;
            $camposaguardar['fecha_correccion'] = date('Y-m-d H:i:s');
        }
        $camposaguardar['fecha_ultima_modificacion'] = date('Y-m-d H:i:s');
        $camposaguardar['usuario_ultima_modificacion'] =  pnUserGetVar('uid');
        try{
           $hallazgo = new HallazgosInspeccion($hallazgoid,null,null);// obtener id ,si es nuevo crear, sino modificar
            $result = $hallazgo->modificar($camposaguardar);
            $hallazgo_fields = $hallazgo->toArray();
            $hallazgo_id = $hallazgo_fields['id'];//12;//
        }
        catch(Exception $e){
            $result = false;
            $str_error = $e->getMessage();
        }
        $respuesta = array();

        $respuesta['resultado'] = $result;
        $respuesta['id'] = $hallazgo_id;
        $respuesta['hallazgo_fields']=$hallazgo_fields;
        $this->retornarJSON($respuesta);
    }


    /**
     *Se encarga de moficicar el estado de un hallazgo para asi poder borrarlos
     */
    public function modificarestadodehallazgoAction(){
        $respuesta['resultado'] = false;
        $hallazgoid = $this->request->getParam('id_hallazgo');
        $estado = $this->request->getParam('estado');
        $para_habilitar='1';
        if ($estado=='Desabilitar'){
            $para_habilitar='0';
        }
        if ($hallazgoid){
            try{
                $Obje= new HallazgosInspeccion($hallazgoid,null,null);
                $Obje->modificar( array("habilitado" => $para_habilitar));
                $respuesta['resultado'] = true;
            }catch(Exception $e){
                $respuesta['resultado'] = false;
            }
        }
        $this->retornarJSON($respuesta);
    }



    /**
     * setea un hallazgo como corregido y le ponen la fecha actual
     */
    public function finalizarhallazgoinspeccionAction(){ // finalizar o correrir hallazgo/disconformidad
        $hallazgoid = $this->request->getParam('id_hallazgo');

        $camposaguardar= array();
        $camposaguardar['hallazgo_corregido']=1;
        $camposaguardar['fecha_correccion'] = date('Y-m-d H:i:s');
        $camposaguardar['fecha_ultima_modificacion'] = date('Y-m-d H:i:s');
        $camposaguardar['usuario_ultima_modificacion'] =  pnUserGetVar('uid');
        try{
            $hallazgo = new HallazgosInspeccion($hallazgoid,null,null);// obtener id ,si es nuevo crear, sino modificar
            $result = $hallazgo->modificar($camposaguardar);
            //$hallazgo_fields = $hallazgo->toArray();
           // $hallazgo_id = $hallazgo_fields['id'];//12;//
        }
        catch(Exception $e){
            $result = false;
            $str_error = $e->getMessage();
        }
        $respuesta = array();
        $respuesta['resultado'] = $result;
      //  $respuesta['id'] = $hallazgo_id;
     //$respuesta['hallazgo_fields']=$hallazgo_fields;
        $this->retornarJSON($respuesta);
    }


    /**
     * Devuelve la informacion de un formulario de inspeccion , los intems que estan en check , y la info basica
     *
     * no devuelve la info de los hallazgos en si por que esos se cargar a raiz de los que se checkeen
     */
    public function datosformulariodeinspeccionAction (){

        $respuesta = array();
        $numero_seguiento = $this->request->getParam('id');
        $items_con_hallazgos= HallazgosInspeccion::cargartodosloshallazgosdeunainspeccion($numero_seguiento);
        $eventoinspeccion = new EventoDeInspeccionesyMuestreos(null,$numero_seguiento);
        $eventoinspeccion_fields = $eventoinspeccion->toArray();
        $respuesta['formulario']=$eventoinspeccion_fields;
        $respuesta['eventoinspeccion_checks'] = $items_con_hallazgos;
        $respuesta['resultado'] = true;

        $this->retornarJSON($respuesta);
    }


    /** y muestreos !!
     * Se encarga de guardar los datosd e un formulario de inspeccion , en la tabala de evento de inspeccion
     * los hallazgos no se guardan , ya que estos se guardan cada uno con su respectivo boton de guardar
     */
    public function guardarformulariodeinspeccionAction(){
        $numero_de_seguimiento = $this->request->getParam('numero_de_seguimiento');
        //$camposaguardar = array(); // no se si hace falta revisar qu este vacios
        $camposaguardar= $this->request->getParams();
        $establecimientos = array();
        foreach($this->request->getParam('formulario_acompannantes') as $establecimientoItem){
            if($establecimientoItem != ''){
                array_push($establecimientos, $establecimientoItem);
            }
        }
        $camposaguardar['formulario_acompannantes'] = json_encode($establecimientos);
        try{
            $eventoinspeccion = new EventoDeInspeccionesyMuestreos(null,$numero_de_seguimiento);
            $result = $eventoinspeccion->modificar($camposaguardar);
            $eventoinspeccion_fields = $eventoinspeccion->toArray();
        }
        catch(Exception $e){
            $result = false;
            $respuesta['errormensaje']= $e->getMessage();
        }
        $respuesta = array();
        $respuesta['resultado'] = $result;
        $respuesta['camposaguardar']=$camposaguardar;
        $respuesta['eventoinspeccion_fields']=$eventoinspeccion_fields;
        $this->retornarJSON($respuesta);

    }


    /**
     * Se encarga de cargar el formulario de informes anteeriores(los hallazgos pendientes o no), del establecimento enviado
     * con forme a los paremetros enviados
     * en caso de recibir el id de un evento busca el id del establecimento ligado a ese establecimento para ganerar el formulario
     */
    public function formulariodeinspeccionesanterioresAction(){
        $anno=date('Y');
      //  $Numero_de_seguimiento= $this->request->getParam('numero_seguimiento_inspeccion');
        $Numero_establecimento= $this->request->getParam('establecimiento_id');
       // $tipodeestablecimiento= $this->request->getParam('tipo_de_establecimiento');

        $id_evento= $this->request->getParam('id_evento');
        if($id_evento!=''&& $id_evento!=null ){
            $evento= new EventoDeInspeccionesyMuestreos($id_evento,null);
            $evento= $evento->toArray();
        //    $Numero_de_seguimiento= $evento['numero_de_seguimiento'];
            $Numero_establecimento= $evento['establecimiento_id'];
        }
        $vars = array();

        $vars['titulo'] = "Inspecciones/Auditorias anteriores ";
        $vars['anno']= $anno;
        $vars['tiempo']= date('Y-m-d H:i');

        $establecimiento_sirea= new EstablecimientosSIREA();
        $infoestablecimiento=$establecimiento_sirea->getinfoestablecimiento($Numero_establecimento) ;
        $vars['E_identificador']=$infoestablecimiento['identificador'];
        $vars['E_nombre']=$infoestablecimiento['nombre'];
        $vars['E_responsable']=$infoestablecimiento['tramitante_nombre'];
        $vars['E_region_nombre']=Region::nombreregion($infoestablecimiento['region']);
        $vars['E_estado']=$infoestablecimiento['estado'];
        $vars['E_direccion']= Region::nombredistrito($infoestablecimiento['distrito'],$infoestablecimiento['canton'],$infoestablecimiento['provincia']) .', '.$infoestablecimiento['caserio'].', '.$infoestablecimiento['direccion'];
        $vars['E_numero_telefono']=$infoestablecimiento['numero_telefono'].'  '.$infoestablecimiento['numero_fax'];
        $vars['E_correo']=$infoestablecimiento['correo'];



        $inspecciones= EventoDeInspeccionesyMuestreos::cargartodoslasinspeccionesdeunestablecimiento($Numero_establecimento);
        $vars['Total_inspecciones_calendaridas']= count($inspecciones);

        $inspeccionefinalizada= EventoDeInspeccionesyMuestreos::ultimainspeccionesdeunestablecimiento($Numero_establecimento,0);
        $vars['Ultima_inspeccion_finalizada']= $inspeccionefinalizada['start_date'];
        $inspeccionefinalizada= EventoDeInspeccionesyMuestreos::ultimainspeccionesdeunestablecimiento($Numero_establecimento,1);
        $vars['Ultima_inspeccion_activa']= $inspeccionefinalizada['start_date'];
//
        $vars['tabla_de_hallazgos_pendientes'] =$this->generadordehallazgospendientes($Numero_establecimento);

       /* $generadoritems = new GeneradorDeHTMLDeinspecionesAnteriores();
        $preguntas = $generadoritems->getItmesPreguntas("DAOIaCamposformularioinspeccion","aquitabladerespuestas",$Numero_de_seguimiento,$tipodeestablecimiento);
        $vars['tabla_de_hallazgos_pendientes'] = $generadoritems->generarHTMLAcordionPreguntas($preguntas);*/

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD2($tabla = "DAOIaColaboradores", $select = "habilitado =1 ", $ordebBy = "nombre", $value = "id", $text = "identificacion", $text2 = "nombre");
        $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "formulario_acompannantes[]", $id = "formulario_acompannantes", $items, $opcionSeleccione = false, $extra = "multiple class='inputmantenimiento2' style='width: 450px;'");
        // $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "formulario_acompannantes[]", $id = "formulario_acompannantes", $items, $opcionSeleccione = false, $extra = "multiple class='inputmantenimiento2'", false, json_decode($vars['establecimientos']));
        $vars['combo_acompannantes'] =$combo_tipo_objetivo_html;

        //$vars['tabla_de_items'] = "Tabla de items aca ";
        $this->view->assignOld($vars);
        $temp_file = 'Formulario_de_inspecciones_anteriores.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


    /**genera el htlm de los cuadros de hallazgos , para el formulario de informes anteriores
     * recive el establecimento
     * @param $id_establamcimento
     * @return string
     */
    public function generadordehallazgospendientes($id_establamcimento){
        date_default_timezone_set ( 'America/Costa_Rica' );
        $fecha=date('Y-m-d');

        $HTML='<div >';
        $Hallazgos=HallazgosInspeccion::cargartodosloshallazgospendientesdeunestablecimiento($id_establamcimento);
        if(count($Hallazgos)<1 || $Hallazgos==false){

            $HTML.='<h4 class="texto_enfasis">El establecimiento no posee ninguna No conformidad o Hallazgo</h4><br><br></div>';
            return $HTML;
        }

        foreach ($Hallazgos as $Hallazgo){
            $OHallazgo = new HallazgosInspeccion($Hallazgo['id']);
            $OHallazgoInfo= $OHallazgo->toArray();
            $infoitem=HallazgosInspeccion::cargarinfodeitem($Hallazgo['id_item']);
            $HTML.= '<div  class="borde1" style=" margin-bottom: 3px;padding: 10px;"  id ="hallazgo_'.$Hallazgo['id'].'">';
            $HTML.= '<label> <span class="texto_enfasis_az">Item:</span> <strong>'.$infoitem['item'].'</strong><span>, '.substr($infoitem['label_de_item'], 0,200).'... </span> <a href="#" onclick="ver('.$infoitem['pdf_de_ayuda_id'].');">Art.</a></label><br>';
            $HTML.= '<label> <span class="texto_enfasis_az">Fecha de Hallazgo:</span> '.$OHallazgoInfo['fecha_creacion'].'</label>';
             $HTML.='<label class="margen1"> <span class="texto_enfasis_az">Inspeccion: </span>'.$OHallazgoInfo['numero_de_seguimiento'].'</label>';
            $HTML.='<label class="margen1"> <span class="texto_enfasis_az">N.Riesdo de Inspeccion: </span>'.$OHallazgoInfo['formulario_nivelderiesgo'].'</label><br>';
            $HTML.= '<label><span class="texto_enfasis_az"> Observaciones: </span>'.$OHallazgoInfo['detalles'].'</label><br>';

            if($OHallazgoInfo['adjunto1']!= '' && $OHallazgoInfo['adjunto1']!= '0' && $OHallazgoInfo['adjunto1']!= null  ){
                $HTML.= '<label> <span class="texto_enfasis_az">Adjuntos:</span> ';
                $HTML.=  ' <a href="#" onclick="ver('.$OHallazgoInfo['adjunto1'].');">Adjunto1</a> ';
                if($OHallazgoInfo['adjunto2']!= '' && $OHallazgoInfo['adjunto2']!= null){
                    $HTML.=  ' <a href="#" onclick="ver('.$OHallazgoInfo['adjunto2'].');">Adjunto2</a> ';
                }
                if($OHallazgoInfo['adjunto3']!= '' && $OHallazgoInfo['adjunto3']!= null){
                    $HTML.=  ' <a href="#" onclick="ver('.$OHallazgoInfo['adjunto3'].');">Adjunto3</a> ';
                }
                $HTML.= '</label><br>';
            }

            $HTML.= '<label><span class="texto_enfasis_az"> Nivel de disconformidad:</span> '.$OHallazgoInfo['nivel_disconformidad'].'</label>';
            $HTML.= '<label class="margen1"> <span class="texto_enfasis_az">Arreglo Inmediato:</span> '.$OHallazgoInfo['arreglo_inmediato'].'</label>';
            $HTML.= '<label class="margen1"> <span class="texto_enfasis_az">Fecha limite inicial:</span>'. substr($OHallazgoInfo['fecha_limite'], 0,10) .'</label><br>';
            if($OHallazgoInfo['fecha_prorroga_1']!= '' && $OHallazgoInfo['fecha_prorroga_1']!= null  ){
                $HTML.= '<label><span class="texto_enfasis_az"> Prorrogas: </span></label><br>';
                $HTML.= '<label class="margen3">'.  substr($OHallazgoInfo['fecha_prorroga_1'], 0,10).' , <a href="#" onclick="ver('.$OHallazgoInfo['carta_prorroga_1'].');">Carta de solicitud</a></label><br>';
                if($OHallazgoInfo['fecha_prorroga_2']!= '' && $OHallazgoInfo['fecha_prorroga_2']!= null  ){
                    $HTML.= '<label class="margen3">'.substr($OHallazgoInfo['fecha_prorroga_2'], 0,10).' , <a href="#" onclick="ver('.$OHallazgoInfo['carta_prorroga_2'].');">Carta de solicitud</a></label><br>';
                }
                if($OHallazgoInfo['fecha_prorroga_3']!= '' && $OHallazgoInfo['fecha_prorroga_3']!= null  ){
                    $HTML.= '<label class="margen3">'.substr($OHallazgoInfo['fecha_prorroga_3'], 0,10).' , <a href="#" onclick="ver('.$OHallazgoInfo['carta_prorroga_3'].');">Carta de solicitud</a></label><br>';
                }
            }


            $HTML.= '<div style="height: 30px;" id="estado_hallazgo_'.$Hallazgo['id'].'"><div style="width: 70%;float: left ">';
            if($OHallazgoInfo['hallazgo_corregido']=='1'){
                $HTML.='<h3 class="texto_enfasis_ve">Corregido el '.substr($OHallazgoInfo['fecha_correccion'], 0,10).'</h3></div>';
            }else{
                $vencida=false;
                $fechavencida='';
                if (!$vencida){$vencida= $this->vencida($OHallazgoInfo['fecha_prorroga_3']); $fechavencida= substr($OHallazgoInfo['fecha_prorroga_3'], 0,10);}
                if (!$vencida){$vencida= $this->vencida($OHallazgoInfo['fecha_prorroga_2']); $fechavencida= substr($OHallazgoInfo['fecha_prorroga_2'], 0,10);}
                if (!$vencida){$vencida= $this->vencida($OHallazgoInfo['fecha_prorroga_1']); $fechavencida= substr($OHallazgoInfo['fecha_prorroga_1'], 0,10);}
                if (!$vencida){$vencida= $this->vencida($OHallazgoInfo['fecha_limite']); $fechavencida= substr($OHallazgoInfo['fecha_limite'], 0,10);}

                if ($vencida){// falta tomar en cuenta prorrogas
                    $HTML.='<h3 class="texto_enfasis">Vencida desde el '.$fechavencida.'</h3></div>';
                }else{
                    $HTML.='<h3 class="texto_enfasis_am" >Pendiente pero al día</h3></div>';
                }
                //$HTML.= '<button style="float: right" type="button" onclick="corregirhallazgo(65)">Hallazgo Corregido</button>';
                $HTML.= '<button style="float: right" type="button" onclick="corregirhallazgo('.$Hallazgo['id'].');">El hallazgo ha sido corregido</button>';
            }
            $HTML.='</div></div>';


        }

        $HTML.='</div>';
        //$HTML.=var_export($Hallazgos,true);
        return $HTML;
    }

/**
 * retorna si ya paso o no la fecha que ha sido enviada por parametro, con respecto a la fecha de hoy
 */
    public function vencida($time){
        if ($time==null || $time==""){
            return false;
        }
        return (strtotime($time) < strtotime('today'));

       /* $time= $this->request->getParam('fecha');// para probar
        if ($time==null || $time==""){echo false;}
        if (strtotime($time) < strtotime('today')){echo 'si';}else{echo 'no';}
       */

    }



/***************************************************************************************************************************************/
/***************************************************************************************************************************************/
/***************************************************************************************************************************************/
/*ESTA PARTE TIENE QUE VER CON LAS TOMAS DE MUESTRA */



    /**Carga Pantalla del formulario i acta de muestro de una visita de tomas de muestras
     * @MODULO: DEBERIA ser muestreo
     * */
    public function formulariodemuestranuevoAction(){
        $anno=date('Y');
        $Numero_de_seguimiento= $this->request->getParam('numero_seguimiento_inspeccion');
        $Numero_establecimento= $this->request->getParam('establecimiento_id');

        $id_evento= $this->request->getParam('id_evento');
        if($id_evento!=''&& $id_evento!=null ){
            $evento= new EventoDeInspeccionesyMuestreos($id_evento,null);
            $evento= $evento->toArray();
            $Numero_de_seguimiento= $evento['numero_de_seguimiento'];
            $Numero_establecimento= $evento['establecimiento_id'];
        }

        $vars = array();
        $vars['titulo'] = "Formulario de Toma de muestra";
        $vars['Numero_de_seguimiento']=$Numero_de_seguimiento;
        $vars['anno']= $anno;

        $establecimiento_sirea= new EstablecimientosSIREA();
        $infoestablecimiento=$establecimiento_sirea->getinfoestablecimiento($Numero_establecimento) ;
        $vars['E_identificador']=$infoestablecimiento['identificador'];
        $vars['E_nombre']=$infoestablecimiento['nombre'];
        $vars['E_responsable']=$infoestablecimiento['tramitante_nombre'];
        $vars['E_region_nombre']=Region::nombreregion($infoestablecimiento['region']);
        $vars['E_estado']=$infoestablecimiento['estado'];
        $vars['E_direccion']= Region::nombredistrito($infoestablecimiento['distrito'],$infoestablecimiento['canton'],$infoestablecimiento['provincia']) .', '.$infoestablecimiento['caserio'].', '.$infoestablecimiento['direccion'];
        $vars['E_numero_telefono']=$infoestablecimiento['numero_telefono'].'  '.$infoestablecimiento['numero_fax'];
        $vars['E_correo']=$infoestablecimiento['correo'];

        $evento = new EventoDeInspeccionesyMuestreos(null,$Numero_de_seguimiento);
        $evento_fields = $evento->toArray();
        if($evento_fields){
            $vars = array_merge($vars, $evento_fields);
        }
        $vars['tabla_de_tomas_realizadas']= $this->generarfilasdetomasrealizadas($Numero_de_seguimiento);

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrostabladeanalisisdemuestreo();// funcion hecha para esto que devuelve todos los analisis haciendo el join con su tipo para obtener su nombre
        $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "combo_analisis", $id = "combo_analisis", $items, $opcionSeleccione = ' -- Seleccione Analisis/Muestreo -- ', $extra = " class='inputmantenimiento2' style='width: 551px;' placeholder='Muestreo/analisis'");
        // $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "formulario_acompannantes[]", $id = "formulario_acompannantes", $items, $opcionSeleccione = false, $extra = "multiple class='inputmantenimiento2'", false, json_decode($vars['establecimientos']));
        $vars['combo_tomas']= $combo_tipo_objetivo_html;

        $itmes = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaLaboratorios", "habilitado=1 ", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $itmes[]= array('value'=>'Otro','text'=>'Otro(s)');// le agregamos la opcion de otros
        $combolabs = $generadorHTMLCombos->generarHTMLCombo($name = "muestreo_laboratorioutilizados_c[]", $id = "muestreo_laboratorioutilizados_c", $itmes, $opcionSeleccione = false,$extra = " multiple style='width:450px;'",false,explode(",",$vars['muestreo_laboratoriosusados_c']));//,false,$tipo_establecimiento_id);

        $vars['combo_labs'] =$combolabs;


        $this->view->assignOld($vars);
        $temp_file = 'Formulario_de_toma_de_muestra.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**genera el html de de las filas de la tabla de tomas de muestras del acta de muestreo
     * @param $Numero_de_seguimiento
     * @return string
     */
    public function generarfilasdetomasrealizadas($Numero_de_seguimiento){
        $tomas = TomaDeMuestra::cargartodoslastomademuestrasdeunavisita($Numero_de_seguimiento);
        $html ='';
        foreach($tomas as $toma){
            $html .='<tr><td><div class="btn_borrar" id="'.$toma['id'].'"></div></td> <td>'.$toma['descripccion'].'</td><td> '.$toma['lote'].'</td><td>'.$toma['tamanno'].'<td>'.$toma['analisis'].'</td></tr>';
        }
        return $html;
    }

    /**
     *Se encarga de moficicar o crear una toma de muestra con los datos que han sido enviados como parametro
     */
    public function guardartomademuestraAction(){
        $respuesta['resultado'] = false;
        $id_toma = $this->request->getParam('id_toma');
        $camposaguardar= $this->request->getParams();
            try{
                $Obje= new TomaDeMuestra($id_toma);
                $Obje->modificar($camposaguardar);
                $Objef=$Obje->toArray();
                $respuesta['id_nuevo'] = $Objef['id'];
                $respuesta['resultado'] = true;

            }catch(Exception $e){
                $respuesta['resultado'] = false;
            }
        $this->retornarJSON($respuesta);
    }


    /**
     *Se encarga de moficicar el estado de una toma de muestra para asi hacerlos parecer borrardos
     */
    public function borrartomademuestraAction(){
        $respuesta['resultado'] = false;
        $id_toma = $this->request->getParam('id_toma');
        if ($id_toma){
            try{
                $Obje= new TomaDeMuestra($id_toma);
                $Obje->modificar( array("habilitada" => 0));
                $respuesta['resultado'] = true;
            }catch(Exception $e){
                $respuesta['resultado'] = false;
            }
        }
        $this->retornarJSON($respuesta);
    }


    /**Carga Pantalla de formulario de confirmacion de toma de muestra vacio
     *
     * @MODULO: DEBERIA ser muestreo
     *
     * */
    public function vercomprobantemuestreoAction(){
        $anno=date('Y');
        $numseguimiento = $this->request->getParam('numseguimiento');
        $Numero_de_ACTA="XXXXXX-".$anno;// deberia ser dinamico
        $vars = array();
        $vars['titulo'] = "Confirmación de toma de muestra/acta entrega <br> ".$numseguimiento;
        $generadorHTMLCombos= new GeneradorHTMLCombos();
        $itmes = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaLaboratorios", "habilitado=1 ", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $combolabs = $generadorHTMLCombos->generarHTMLCombo($name = "laboratorio", $id = "laboratorio", $itmes, $opcionSeleccione = true,$extra = " style='width:300px;'");//,false,$tipo_establecimiento_id);

        $vars['combolabs'] =$combolabs;
        $vars['Numero_de_acta']="<h3 style='color:red;'>Número de acta: ".$Numero_de_ACTA."</h3>";
        $vars['anno']= $anno;
        //$vars['tabla_de_items'] = "Tabla de items aca ";
        $this->view->assignOld($vars);
        $temp_file = 'Formulario_de_acta_muestra.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


    /**
     * muestra la pagina donde
     */
    public function verpaginadeseguimientodeeventoAction(){
        $vars = array();
        $anio=date('Y');
        $vars['anio']= $anio;
        $this->view->assignOld($vars);
        $temp_file = 'Solicitud_de_numero_de_seguimiento.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }


    /**
     * muestra un crud donde estan listados todos
     */

    public function listadeeventosAction(){

        $anio_actual = date('Y');
        $vars = array();
        $user_id = pnUserGetVar('uid');
        $colaboradorobj = new Colaborador(NULL, $user_id);// id colaborador , id zkuser
        $vars2= $colaboradorobj->toArray();

        if($vars2['administrador_central']=='1'){
            $extraregion='';
            $regiondefault='';
            $colaboradordefault='';
            $extracolaborador='';
            $wherecolaborador='habilitado=1 ';
        }elseif ($vars2['administrador_regional']=='1'){
            $vars['region_encargado'] = 'Región: '.Region::nombreregion($vars2['id_region']);
            $extraregion='  onfocus="this.defaultIndex=this.selectedIndex;" onchange="this.selectedIndex=this.defaultIndex;" ' ;
            $regiondefault= $vars2['id_region'];
            $extracolaborador='';
            $colaboradordefault='';
            $wherecolaborador="habilitado=1 AND (id_region=$regiondefault OR id_region_secundaria=$regiondefault)";
        }else{
            $vars['region_encargado'] = 'Colaborador: '. $vars2['nombre'];
            $extraregion=' readonly ';
            $regiondefault= '';
            $extracolaborador='  onfocus="this.defaultIndex=this.selectedIndex;" onchange="this.selectedIndex=this.defaultIndex;" ' ;
            $colaboradordefault= $vars2['id'];
            $wherecolaborador=" usuario_id=$user_id ";
        }

/*
        $vars['nombre_establecimiento'] =$nombre_establecimiento =$this->request->getParam('nombre_establecimiento');
        $vars['codigo_establecimiento'] =$codigo_establecimiento = $this->request->getParam('codigo_establecimiento');
        $vars['estado'] = $estado =$this->request->getParam('estado_objetivo');
        $vars['tipo'] = $tipo=$this->request->getParam('tipo_objetivo');
        $vars['periodo'] = $periodo = $this->request->getParam('periodo_objetivo');
        // $vars['region'] = $region= $this->request->getParam('region_objetivo');
*/
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        //para inspecciones
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = "habilitado = 1", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $vars['cbTipoObjetivo']= $generadorHTMLCombos->generarHTMLCombo($name = "cbTipoObjetivo", $id = "cbTipoObjetivo", $items, $opcionSeleccione = true,$extra = "style='width: 100%'",false);
        // para muestreos
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", $select = "habilitado = 1", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $vars['cbTipoAnalisis']  = $generadorHTMLCombos->generarHTMLCombo($name = "cbTipoAnalisis", $id = "cbTipoAnalisis", $items, $opcionSeleccione = true,$extra = "style='width: 100%;'", $opcionTodas = false);
        $vars['cbPeriodo']= $this->getopcionesdeperiodos($anio_actual,2,$anio_actual);


        $items2 = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAORegion","id != 0", $ordebBy = "nombre", $value = "id", $text = "nombre");
        $vars['cbRegion']= $generadorHTMLCombos->generarHTMLCombo($name = "cbRegion", $id = "cbRegion", $items2, $opcionSeleccione = true, $extraregion, $opcionTodas = false,$regiondefault);

        $items3 = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaColaboradores", $wherecolaborador , $ordebBy = "nombre", $value = "id", $text = "nombre");
        $vars['cbColaborador'] = $generadorHTMLCombos->generarHTMLCombo($name = "cbColaboadores", $id = "cbColaboadores", $items3, $opcionSeleccione = true,$extracolaborador,false,$colaboradordefault);



        $vars['anio'] = $anio_actual;
        $vars['titulo'] = "Gestor de Visitas de Inspecciones y Tomas de Muestra";
        $vars['tabla'] = $this->generarlistaeventos($anio_actual,'','','','',$regiondefault,'',$colaboradordefault,'');
        $this->view->assignOld($vars);
        $temp_file = 'Lista_de_eventos.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    public function generarlistaeventosAction(){

            $tipodeevento = $this->request->getParam('tipodeevento');
            $colaborador = $this->request->getParam('colaborador');
            $nombre_establecimiento =$this->request->getParam('nombre_establecimiento');
            $codigo_establecimiento = $this->request->getParam('codigo_establecimiento');
            $estado =$this->request->getParam('estado');
            $periodo = $this->request->getParam('periodo');
            $tipo_objetivo=$this->request->getParam('tipo_objetivo');
            $region = $this->request->getParam('region');
        $numero_de_seguimiento = $this->request->getParam('numero_de_seguimiento');
            $tipo_analisis = $this->request->getParam('tipo_analisis');
            $analisis = $this->request->getParam('analisis');

            $html_tabla = $this->generarListaEventos($periodo,$tipodeevento,$nombre_establecimiento,$codigo_establecimiento,$estado,$region,$tipo_objetivo,$colaborador,$numero_de_seguimiento, $tipo_analisis,$analisis);
            $vars = array();
            $vars['valor'] = $html_tabla;
            $this->view->assignOld($vars);
            $temp_file = 'Inspeccion_user_popup.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);
    }

    public function formatAsCurrency($data){
        return number_format($data, 2, '.', ','); //displays 10 as 10.00
    }

    public function generarListaEventos($periodo='',$tipo='',$nombreEstablecimiento='',$codigoEstablecimiento='',$estado='',$region='',$tipo_inspeccion='',$colaborador='',$numero_de_seguimiento='',$tipo_analisis='', $analisis=''){
            try{
                $tbl= $this->_helper->AddaxCRUD("DAOIaEventosInspeccionesMuestreos","Eventos inspeccion/muestreo","Objetivos Específicos");
                $tbl->disallowAdd();
                $tbl->disallowDelete();
                $tbl->omitFieldCompletely("event_id");
                $tbl->omitFieldCompletely("event_name");
                $tbl->omitFieldCompletely("end_date");
                $tbl->omitFieldCompletely("analisis_de_muestreo");
                $tbl->omitFieldCompletely("details");
                $tbl->omitFieldCompletely("laboratorio");
                $tbl->omitFieldCompletely("establecimiento_id");// con solo el establecimiento
                /*esta es la parte del formulario de inspeccion*/
                $tbl->omitFieldCompletely("formulario_fechaderealizacion");
                $tbl->omitFieldCompletely("formulario_numerodehojadevisita");
                $tbl->omitFieldCompletely("formulario_testigos");
                $tbl->omitFieldCompletely("formulario_observaciones");
                $tbl->omitFieldCompletely("formulario_acompannantes");
                $tbl->omitFieldCompletely("formulario_nivelderiesgo");
                /*esta es la parte del formulario de muestreo*/
                $tbl->omitFieldCompletely("muestreo_codigo");
                $tbl->omitFieldCompletely("muestreo_proposito");
                $tbl->omitFieldCompletely("muestreo_solicitadopor");
                $tbl->omitFieldCompletely("muestreo_origendemuestra_c");
                $tbl->omitFieldCompletely("muestreo_origendemuestra_i");
                $tbl->omitFieldCompletely("muestreo_laboratoriosusados_c");
                $tbl->omitFieldCompletely("muestreo_laboratoriosusados_i");
                $tbl->omitFieldCompletely("muestreo_temperatura");
                $tbl->omitFieldCompletely("muestreo_contramuestra");
                $tbl->omitFieldCompletely("muestreo_colilla");
                $tbl->omitFieldCompletely("fecha_creacion");
                $tbl->omitFieldCompletely("fecha_ultima_modificacion");


                $tbl->displayAs("estado_evento","Estado"); $tbl->disallowEdit("estado_evento");
                $tbl->displayAs("start_date","Fecha"); $tbl->disallowEdit("start_date");
                $tbl->displayAs("tipo","Tipo"); $tbl->disallowEdit("tipo");
                $tbl->displayAs("tipo_inspeccion","Tipo Inspec."); $tbl->disallowEdit("tipo_inspeccion");
                $tbl->displayAs("establecimiento","Nom. Establ."); $tbl->disallowEdit("establecimiento");
                $tbl->displayAs("encargado","Encargado"); $tbl->disallowEdit("encargado");
                $tbl->displayAs("objetivo_especifico","Obj. Especifico"); $tbl->disallowEdit("objetivo_especifico");
                $tbl->displayAs("numero_de_seguimiento","Num. Seguimiento"); $tbl->disallowEdit("numero_de_seguimiento");
                $tbl->displayAs("id_region","Región"); $tbl->disallowEdit("id_region");

                $tbl->enableRelationship("id_region", "nombre"); // para que esto funcione tiene que estar el fk realcionado desde la db , y los doctrine actualizados
               // $tbl->formatFieldWithFunction('id_region', array($this, 'formatAsCurrency'));

//start_date	tipo	tipo_inspeccion	establecimiento_id	establecimiento	encargado	inspeccion_especifica	numero_de_seguimiento	id_region	Estado	Acción
                $tbl->addButtonToRow("", "", "", "", "verObjetivo", array(
                    'estado_evento' => array(
                        'Finalizado','Activo'
                    )),'button_de_icono boton_verObjetivo');
                $tbl->addButtonToRow("", "", "", "", "verFormulariodetomas", array(
                    'tipo' => array(
                        'Muestreo'
                    )),'button_de_icono boton_verFormulariodetomas');
                $tbl->addButtonToRow("", "", "", "", "verFormulariodeinspeccion", array(
                    'tipo' => array(
                        'Auditoria-Inspeccion'
                    )),'button_de_icono boton_verFormulariodeinspeccion');

                $tbl->addButtonToRow("", "", "", "", "verEnCalendario", array(
                    'estado_evento' => array(
                        'Finalizado','Activo'
                    )),'button_de_icono boton_verEnCalendario');

                $tbl->addButtonToRow("", "", "", "", "verFormulariodeinspeccionesanteriores", array(
                    'tipo' => array(
                        'Auditoria-Inspeccion'
                )),'button_de_icono boton_verFormulariodeinspeccionesanteriores');

                if($tipo == "Muestreo"){

                }
                else{
                     $tbl->disallowEdit("tipoobjetivo");
                     $tbl->omitFieldCompletely("tipoanalisis");
                }

                //Paginación
                $page = $this->request->getParam('page');
                $tbl->turnOnPaging($page, $rowsxpage = 25);

                //Ordenamiento
                $sort_field = $this->request->getParam('sort-field');
                if (empty($sort_field)){$sort_field ="start_date";}
                $sort_dir = $this->request->getParam('sort-dir');
                if (empty($sort_dir)){ $sort_dir ="ASC";}
                $tbl->turnOnSorting($sort_field, $sort_dir);

                //Filtrado
                $where = " estado_evento != 'Borrado' ";

                if($tipo!=""){
                    $where.=" AND tipo='".$tipo."'";
                }
                if($nombreEstablecimiento != ""){
                    $where.= " AND establecimiento like '%$nombreEstablecimiento%'";
                }
                if($codigoEstablecimiento != ""){
                    $where.= " AND establecimiento like '%$codigoEstablecimiento%'";
                }
                if($numero_de_seguimiento != ""){
                    $where.= " AND numero_de_seguimiento like '%$numero_de_seguimiento%'";
                }
                if($estado!=""){
                    $where.=" AND estado_evento like '$estado' ";
                }
                if($periodo != ""){
                    $where .= " AND YEAR(start_date) ='$periodo' ";
                }
                if($region !=""){
                    $where.=" AND id_region='$region' ";
                }
                if($tipo_inspeccion !=""){
                    $where.= " AND tipo_inspeccion='$tipo_inspeccion'";
                }
                if($colaborador !=""){
                    $where.=" AND encargado='$colaborador' ";
                }


                if($tipo_analisis != "" && $analisis ==''){
                    $analsis_por_tipo = Analisis::obtenerRegistrosPorTipo($tipo_analisis);// ****
                    if (count($analsis_por_tipo)  > 0 !== false && !empty($analsis_por_tipo)){
                        //ECHO print_r($analsis_por_tipo).'/////';
                            $ids = EventoDeInspeccionesyMuestreos::obtenerIdsPorAnalisis($analsis_por_tipo); //***
                       // ECHO print_r($ids).'/////';
                            if (count($ids)  > 0 && !empty($ids)){
                                $where.= " AND (";
                                foreach ($ids as $id) {
                                    $where.= " event_id = ".$id;
                                    $where.= " OR";
                                }
                                $posicion = strrpos($where, " OR");
                                $where = substr_replace($where, ")", $posicion);
                            } else {
                                $where.= " AND event_id = 0";
                                ECHO '***';
                            }

                    }
                }
                if($analisis != ""){
                    $ids = EventoDeInspeccionesyMuestreos::obtenerIdsPorAnalisis($analisis);
                    if (count($ids)  > 0  && !empty($ids)){
                        $where.= " AND (";
                        foreach ($ids as $id) {
                            $where.= " event_id = ".$id;
                            $where.= " OR";
                        }
                        $posicion = strrpos($where, " OR");
                        $where = substr_replace($where, ")", $posicion);
                    } else {
                        $where.= " AND event_id = 0"; ECHO 2;
                    }
                }

              //  ECHO $where;

               $tbl->addWhereClause("$where");
                ob_start();
                $tbl->showTable();
                $htmlTbl = ob_get_contents();
                ob_end_clean();
                return $htmlTbl;
            }
            catch(Exception $e){
                error_log("No se ha podido cargar el crud $e");
                return false;
            }
        }


    /**retorna una string con las opciones del select html para
     * @param $anio_actual
     * @param $cantidaddeaniosanteriores
     * @return string
     */
    public function  getopcionesdeperiodos($anio_actual,$cantidaddeaniosanteriores,$seleccion=null){
        if($seleccion==null){$seleccion=$anio_actual;}
        $opciones_cbPeriodoNuevo = "<option value=''>-- Seleccione --</option>'";
        for($i=($anio_actual+1);$i>=($anio_actual-$cantidaddeaniosanteriores);$i--){
            $opciones_cbPeriodoNuevo .= "<option value='".$i."'";
            if($i==$seleccion){  $opciones_cbPeriodoNuevo .= "selected='selected'";}
            $opciones_cbPeriodoNuevo .= ">".$i."</option>";
        }
        return $opciones_cbPeriodoNuevo;
    }


    public function resumendeeventoAction(){
        $idevento = $this->request->getParam('id_evento');
        $numdeseguiminetoevento = $this->request->getParam('seguimiento_evento');

      /*  $user_id = pnUserGetVar('uid');
        $colaborador = new Colaborador(NULL, $user_id);// id colaborador , id zkuser
        $colaborador = $colaborador->toArray();*/

        $evento= NEW EventoDeInspeccionesyMuestreos($idevento,$numdeseguiminetoevento);
        $infoevento=$evento->toArray();

        $infoevento["nombre_region"] = Region::nombreregion($infoevento["id_region"]);
        $infoevento["encargado"] = Colaborador::getNombre($infoevento["encargado"]);

        if( $infoevento['tipo']=='Muestreo'){
            $infoevento["analisis"] = $this->obtenerAnalisisParaResumen($infoevento["analisis_de_muestreo"]);
        }else{
            $infoevento['tipo_inspeccion_nombre']=TipoEstablecimiento::getNombreTipoEstablecimiento($infoevento['tipo_inspeccion']);
            $aconpannates= json_decode($infoevento['formulario_acompannantes']);
            $aconpannatesnombres='';
            if(count($aconpannates)>0){
                foreach($aconpannates as $aconpannate){
                    $aconpannatesnombres.= Colaborador::getNombre($aconpannate).'<br>';
                }
            }
            $infoevento['formulario_acompannantes']=$aconpannatesnombres;
            $infoevento['cantidad_de_hallazgos']=  count(HallazgosInspeccion::cargartodosloshallazgosdeunainspeccion($infoevento["numero_de_seguimiento"]));
        }
        $this->view->assignOld($infoevento);
        $temp_file = 'Resumen_evento.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**devulve un arrary con la informacion de los analisis de laboratorio
     * @param $str_analisislaboratorio
     * @return array
     */
    private function obtenerAnalisisParaResumen($str_analisislaboratorio){
        $analisis = array();
        $analisis_laboratorio = explode(",", $str_analisislaboratorio);
        $analisis_laboratorio = array_unique($analisis_laboratorio);
        $count = 0;
        foreach ($analisis_laboratorio as $a_l) {
            $analisis_especifico = explode(".", $a_l);
            $id_analisislaboratorio = $analisis_especifico[0];
            $cantidad_analisislaboratorio = $analisis_especifico[1];
            $obj_analisislaboratorio = new Analisis($id_analisislaboratorio);
            $datos_analisislaboratorio = $obj_analisislaboratorio->toArray();
            $obj_tipoanalisis = new TipoAnalisis($datos_analisislaboratorio["tipoanalisis_id"]);
            $datos_tipoanalisis = $obj_tipoanalisis->toArray();
            $analisis[$count]["tipoanalisis"] = $datos_tipoanalisis["nombre"];
            $analisis[$count]["analisislaboratorio"] = $datos_analisislaboratorio["nombre"];
            $analisis[$count]["id_analisislaboratorio"] = $datos_analisislaboratorio["id"];
            $analisis[$count]["cantidad"] = $cantidad_analisislaboratorio;
            $count++;
        }
        return $analisis;
    }

}






