<?php

if(!defined('OPCION_SELECCIONE')) define('OPCION_SELECCIONE', "-- Seleccione --");
if(!defined('OPCION_TODAS')) define('OPCION_TODAS', "Todas");

/**
 * Class GeneradorHTMLCombos
 *
 * Se encarga de generar htmls con combos de lainfo solicitada
 */
class GeneradorHTMLCombos extends DAOInit
{
	public function __construct(){
		parent::__construct();
		Zend_Loader::loadClass('TableUtil');		
	}
	
	public function getRegistrosTablaBD($tabla, $select, $ordebBy, $value, $text){
		$tableUtil = new TableUtil($tabla);
		$registros = $tableUtil->getRows($select, $ordebBy);
		$items = array();
		foreach($registros as $registro){
			$item = array();
			$item['value'] = $registro[$value];
			$item['text'] = $registro[$text];
			$items[] = $item;
		}
		return $items;
	}
    public function getRegistrosTablaBD2($tabla, $select, $ordebBy, $value, $text,$text2){
		$tableUtil = new TableUtil($tabla);
		$registros = $tableUtil->getRows($select, $ordebBy);
		$items = array();
		foreach($registros as $registro){
			$item = array();
			$item['value'] = $registro[$value];
			$item['text'] = $registro[$text]."::".$registro[$text2];
			$items[] = $item;
		}
		return $items;
	}

    public function getRegistrosTablaBDDosTexts($tabla, $select, $ordebBy, $value, $text, $text2){
        $tableUtil = new TableUtil($tabla);
        $registros = $tableUtil->getRows($select, $ordebBy);
        $items = array();
        foreach($registros as $registro){
            $item = array();
            $item['value'] = $registro[$value];
            $item['text'] = $registro[$text]." :: ".$registro[$text2];
            $items[] = $item;
        }
        return $items;
    }
	
		public function getRegistrosTablaBDNoDeshabilitados($tabla, $select,$select2,$select3 = null, $ordebBy, $value, $text){
		$tableUtil = new TableUtil($tabla);
		$registros = $tableUtil->getRowsConWheres($select,$select2,$select3 = null, $ordebBy);
		$items = array();
		foreach($registros as $registro){
			$item = array();
			$item['value'] = $registro[$value];
			$item['text'] = $registro[$text];
			$items[] = $item;
		}
		return $items;
	}
	
	public function generarHTMLCombo($name, $id, $items, $opcionSeleccione = false, $extra = "", $opcionTodas = false, $defaultValue=null)
	{
		$html = "";
		$html .= "<select name=\"".$name."\" id=\"".$id."\" ".$extra.">";
		if($opcionSeleccione != false){
            if(is_string($opcionSeleccione)){
                $html .= $this->generarHTMLOptionSelect("", $opcionSeleccione);
            }else{
                $html .= $this->generarHTMLOptionSelect("", OPCION_SELECCIONE);
            }
		}
		if($opcionTodas == true){
			$html .= $this->generarHTMLOptionSelect(OPCION_TODAS, OPCION_TODAS);
		}
		foreach($items as $item){
			$html .= $this->generarHTMLOptionSelect($item['value'],$item['text'], $defaultValue);
		}
		$html .= "</select>";
		return $html;
	}

    public function generarHTMLComboArray($name, $id, $arregloOpciones, $opcionSeleccione = false, $extra = "", $opcionTodas = false ,$opcionvacia = false)
	{
		$html = "";
		$html .= "<select name=\"".$name."\" id=\"".$id."\" ".$extra.">";
		if($opcionSeleccione == true){
			$html .= $this->generarHTMLOptionSelect("", OPCION_SELECCIONE);
		}
        if($opcionvacia == true){
			$html .= $this->generarHTMLOptionSelect("", "",null);
		}
		if($opcionTodas == true){
			$html .= $this->generarHTMLOptionSelect(OPCION_TODAS, OPCION_TODAS);
		}
		foreach($arregloOpciones as $opcion){
			$html .= $this->generarHTMLOptionSelect($opcion,$opcion);
		}
		$html .= "</select>";
		return $html;
	}
	
	public function generarHTMLOptionSelect($value, $text, $default){
		$selected = "";
		if(is_array($default))
		{
			foreach($default as $val)
			{
				if($value == $val)
				{
					$selected = "selected='selected'";
				}
			}
		}
		else if($value == $default)
		{
			$selected = "selected='selected'";
		}
		$html = "<option value=\"".$value."\" $selected test='$default'>".$text."</option>";
		return $html;
	}


    /**
     * Creado para debolver tosos los items del combo que contenga todoas los analisis que se pueden realizar
     * @param $tabla
     * @param $select
     * @param $ordebBy
     * @param $value
     * @param $text
     * @return array
     */
    public function getRegistrostabladeanalisisdemuestreo(){
        $consultaClases = "SELECT a.id, a.nombre as anombre, t.nombre as tnombre
FROM ia_analisislaboratorio  a
inner join ia_tipoanalisis t on t.id =a.tipoanalisis_id
WHERE a.habilitado = 1";
        //echo $consultaClases;
        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        if (empty($resultados)){
            return false;
        }
        $items = array();
        foreach($resultados as $registro){
            $item = array();
            $item['value'] = $registro['id'];
            $item['text'] = $registro['tnombre']." :: ".$registro['anombre'];
            $items[] = $item;
        }
        return $items;
    }
	
}
