<?php
/**
 * Created by PhpStorm.
 * User: jrojas
 * Date: 2/14/14
 * Time: 1:52 PM
 */

class TipoAnalisis  extends DAOInit{
    private $tipoAnalisis;
    public function __construct($TipoAnalisisID)
    {
        parent::__construct();
        $this->tipoAnalisis_record = NULL;
        $this->tipoAnalisis = array();
        if(isset($TipoAnalisisID) && $TipoAnalisisID != null && $TipoAnalisisID >= 0)
        {
            try{

                $q = Doctrine_Query::create()
                    ->from('DAOIaTipoanalisis o')
                    ->where("o.id = $TipoAnalisisID");
                $tipoAnalisis_record = $q->fetchOne();

                $tipoAnalisisCargado = false;
                if($tipoAnalisis_record != null && isset($tipoAnalisis_record))
                {
                    if($tipoAnalisis_record->exists())
                    {
                        $tipoAnalisisCargado = true;
                    }
                }
                if (!$tipoAnalisisCargado)
                {
                    error_log("NO TipoAnalisis Cargado");
                    $tipoAnalisis_record = new DAOIaTipoanalisis();
                    $this->setRecord($tipoAnalisis_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("TipoAnalisis Cargado");
                    $this->setRecord($tipoAnalisis_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $tipoAnalisis_record = new DAOIaTipoanalisis();
                $this->setRecord($tipoAnalisis_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }

    }


    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->tipoAnalisis_record->toArray();
        return $fields;
    }


    public function existe()
    {
        return $this->tipoAnalisis_record->exists();
    }


    public function setRecord(&$Record)
    {
        error_log("TipoAnalisis::setRecord");
        if(!is_null($this->tipoAnalisis_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->tipoAnalisis_record))
            {
                error_log("setRecord:: Record is not the same type as tipoAnalisis_record");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->tipoAnalisis_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }


    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("TipoAnalisis::salvar");
        try
        {
            $nuevo_registro = false;
            if(! $this->existe() )
            {
                $nuevo_registro = true;
            }

            $tipoAnalisis_record = &$this->tipoAnalisis_record;

            $arreglo_datos = $tipoAnalisis_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                switch($key)
                {
                    default:
                        $tipoAnalisis_record->{$key} = $this->{$key};
                        break;
                }
            }
            $tipoAnalisis_record->save();
            $new_tipoAnalisis_id = $tipoAnalisis_record['id'];
            if($nuevo_registro)
            {
                error_log('NEW SOLICITUD ID = ' . $new_tipoAnalisis_id);
            }
            $this->setRecord($tipoAnalisis_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }








    //Modifica el objetivo con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("TipoAnalisis::modificar");
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $tipoAnalisis_record= &$this->tipoAnalisis_record;
            $arreglo_datos = $tipoAnalisis_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }
        $conn->commit();

        return true;
    }

} 