<?php

/**
 * Class HallazgoInspeccion
 *
 * Clase objeto que se encarga de de la interaccion con la tabla de tomademuestra
 * @category     Model
 * @author       Addax Software SA
 */
class TomaDeMuestra extends DAOInit
{
	private $tomademuestra;

    /**
     * Constructor del objeto
     * @param null $TomasdemuestraID
     */
    public function __construct($TomasdemuestraID= NULL)
	{
		parent::__construct();
		$this->tomademuestra_record = NULL;
		$this->tomademuestra = array();
		error_log("HallazgoInspeccionID=$TomasdemuestraID");
         if(isset($TomasdemuestraID) && $TomasdemuestraID != null && $TomasdemuestraID >= 0){
			try
			{
				//Cargar HallazgoInspeccion.
				$q = Doctrine_Query::create()
					->from('DAOIaTomasdemuestra s')
					->where("s.id = $TomasdemuestraID");
				$tomademuestra_record = $q->fetchOne();
				$tomademuestraCargado = false;
				if($tomademuestra_record != null && isset($tomademuestra_record))
				{
					if($tomademuestra_record->exists())
					{
						$tomademuestraCargado = true;
					}
				}
				if ( !$tomademuestraCargado)
				{
					error_log("NO HallazgoInspeccion Cargado");
                    $tomademuestra_record = new DAOIaTomasdemuestra();
					$this->setRecord($tomademuestra_record);
				}
				else //Cargar la aplicación si es necesario
				{
					error_log("HallazgoInspeccion Cargado");
					$this->setRecord($tomademuestra_record);
				}
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
		else
		{
			try
			{
				$tomademuestra_record = new DAOIaTomasdemuestra();
				$this->setRecord($tomademuestra_record);
			}
			catch(Exception $e)
			{
				error_log(__METHOD__ . " : [$e]");
				throw $e;
			}
		}
	}

    /**Retorna los datos del objeto tomademuestra en forma de arreglo
     *
     * @return array
     */
	public function toArray()
	{
		$fields = $this->tomademuestra_record->toArray();

		$tomademuestra_fields = $this->tomademuestra_record->toArray();

		//Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
		$fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
		//$fields['fecha_ultima_modificacion'] = $this->MySQLDate2SpanishDate($fields['fecha_ultima_modificacion']);

		$tomademuestra_fields['tomademuestra_id'] = $tomademuestra_fields['id'];
		unset($tomademuestra_fields['id']);

		return array_merge($fields, $tomademuestra_fields);
	}
    /**
     * Retorna si el objeto existe
     * @return mixed
     */
	public function existe()
	{
		return $this->tomademuestra_record->exists();
	}
    private function MySQLDate2SpanishDate($StrMySQLDate)
    {
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }
    /**
     * Transforma a time un date
     *
     * @param $date
     * @param $format
     * @return int
     */
    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }
    /**
     * Cambia el formato de fecha de español al de  sql
     *
     * @param $StrSpanishDate
     * @return string
     */
    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }
    /**
     * Guarda lo cambios que se hayan hecho en las variables del objeto en la base de datos .
     *
     * @return bool
     * @throws Exception
     */
	public function salvar()
	{
		error_log("HallazgoInspeccion::salvar");
		try
		{
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
            }

			$tomademuestra_record = &$this->tomademuestra_record;
			$arreglo_datos = $tomademuestra_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				switch($key)
				{
					case 'fecha_creacion':
						$tomademuestra_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
						break;

					default:
						$tomademuestra_record->{$key} = $this->{$key};
					break;
				}
			}
			$tomademuestra_record->save();
			$new_tomademuestra_id = $tomademuestra_record['id'];
			error_log('NEW PDF ID = ' . $new_tomademuestra_id);
			$this->setRecord($tomademuestra_record);
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");

			throw $e;
			//return false;
		}

		return true;
	}

    /**
     * Modifica el objeto con el arreglo de mapeo que recibe por parametro.
     * @param $Parametros
     * @return bool
     * @throws Exception
     */
	public function modificar($Parametros)
	{
		error_log("Tomasdemuestra::modificar");
		try
		{
			//protege de que vengan parametros fuera de los campos del Aplicante.
            $tomademuestra_record= &$this->tomademuestra_record;
			$arreglo_datos = $tomademuestra_record->toArray();
			foreach($arreglo_datos as $key=>$value)
			{
				if(array_key_exists($key, $Parametros))
				{
					switch($key)
					{
						case 'fecha_creacion':
							$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
							break;

						default:
							error_log("modificando $key con valor " . $Parametros[$key]);
							$this->{$key} = $Parametros[$key];
							break;
					}
				}
			}
			if(! $this->salvar())
			{
				return false;
			}
		}
		catch(Exception $e)
		{
			error_log(__METHOD__ . " : [$e]");
			//return false;
			throw $e;
		}

		return true;
	}

    /**
     * Setea los valores del objeto que recibe por parámetro
     * @param $Record
     * @return bool
     */
	public function setRecord(&$Record)
	{
		error_log("HallazgoInspeccion::setRecord");
		if(!is_null($this->tomademuestra_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
		{
			if(get_class($Record) != get_class($this->tomademuestra_record))
			{
				error_log("setRecord:: Record is not the same type as tomademuestra_record");
				return false;
			}
		}
		$arreglo_datos = $Record->toArray();
		$this->tomademuestra_record = &$Record;
		foreach($arreglo_datos as $key=>$value)
		{
			switch($key)
			{
				case 'fecha_creacion':
					$this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
					break;

				default:
					$this->{$key} = $Record->{$key};
					break;
			}
		}

		return true;
	}

    /**
     * Modifica el registro de la base para cambiarlo a estado eliminidado (no elimina nada).
     *
     * @param $TomasdemuestraID
     * @return bool
     */
	public function eliminar($TomasdemuestraID)
	{
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		try
		{
			$conn->beginTransaction();
			$tomademuestra_fields = $this->tomademuestra_record->toArray();
			if($TomasdemuestraID != $tomademuestra_fields['id'])
			{
				return false;
			}

			/*  @MISSING@ Falta decidir qué revisiones realizar antes de permitir eliminar al tomademuestra, si tiene marcas, certificados, solicitudes en proceso, etc
			$campos = "ea.aplicacion_id as aplicacion_id";
			$select = "SELECT $campos FROM ra_Examen_Aplicacion as ea";
			$where = " WHERE ea.aplicacion_id=$AplicacionID AND ( ea.estado is not null AND ea.estado != 'Invitado' AND ea.estado != 'ErrorVerificacion' AND ea.estado != '')"; //Solo se eliminan aplicaciones invitadas , o que no tienen invitacion
			$orderby = '';
			$select .= " $where $orderby";
			error_log("SQL=$select");
			$results = Doctrine_Manager::connection()->fetchAll($select);

			$tiene_solicitudes_pendientes = false;
			foreach($results as $result)
			{
				$tiene_invitaciones_ejecutadas = true;
			}
			if(!$tiene_invitaciones_ejecutadas)
			{
				//protege de que vengan parametros fuera de los campos de la Temática.
				//$examen_record = &$this->examen_record;
				$this->aplicacion_record->{'eliminado'} = 'Sí';
				$this->aplicacion_record->save();
				$conn->commit();
			}
			*/
		}
		catch(Exception $e)
		{
			$conn->rollback();
			error_log(__METHOD__ . " : [$e]");

			return false;
		}

		return true;
	}

    /**CArga todos los tomademuestras de unaa inspeccion
     * @param $seguimiento
     * @return array|bool
     */
    public static  function cargartodoslastomademuestrasdeunavisita($seguimiento){
        $consultaClases = "SELECT *
            FROM ia_tomasdemuestra
            where habilitada = '1'
           AND numero_de_seguimiento LIKE '%$seguimiento%'";
        //echo $consultaClases;
        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
      if (empty($resultados)){
          return false;
      }

        return $resultados;
    }


}