﻿<?php

error_reporting(E_ALL);
ini_set('display_errors', '1');
if(!defined('RUTASERVIDOR')) define('RUTASERVIDOR', "http://test_sirea.addax.cc:80/");
if(!defined('MDKEY')) define('MDKEY', 'ed923d6d3f9d47e8abdb3e16aac166a1');


/**
 * Class IndexController
 *
 * Se encarga de todas las tablas de mantenimiento del sistema
 */
class IndexController extends Zend_Controller_Action
{


	private $_configparams;
	
    public function init()
    {
		error_reporting(E_ALL);
        ini_set('display_errors', '1');
        /* Initialize action controller here */
		try
		{
            require_once(APPLICATION_PATH . "/models/DAOInit.php");
            Zend_Loader::loadClass('DAOInit');
            require_once(APPLICATION_PATH . "/models/GeneradorHTMLCombos.php");
            Zend_Loader::loadClass('GeneradorHTMLCombos');
            require_once(APPLICATION_PATH . "/models/User.php");
            Zend_Loader::loadClass('User');
            require_once(APPLICATION_PATH . "/models/GroupMembership.php");
            Zend_Loader::loadClass('GroupMembership');
            require_once(APPLICATION_PATH . "/models/Colaborador.php");
            Zend_Loader::loadClass('Colaborador');
            require_once(APPLICATION_PATH . "/models/FiltradoCombo.php");
            require_once(APPLICATION_PATH . "/models/TipoAnalisis.php");
            require_once(APPLICATION_PATH . "/models/Analisis.php");
            require_once(APPLICATION_PATH . "/models/ItemDeInspeccion.php");
            require_once(APPLICATION_PATH . "/models/UserUtil.php");
            require_once(APPLICATION_PATH . "/models/Region.php");

            $controller = Zend_Controller_Front::getInstance();
			$this->request = $controller->getRequest();




            Zend_Loader::loadClass('DAOBaseIaTipoanalisis');
            Zend_Loader::loadClass('DAOIaTipoanalisis');

            Zend_Loader::loadClass('DAOBaseIaAnalisislaboratorio');
            Zend_Loader::loadClass('DAOIaAnalisislaboratorio');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosmuestras');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosmuestras');

            Zend_Loader::loadClass('DAOBaseIaTipoestablecimiento');
            Zend_Loader::loadClass('DAOIaTipoestablecimiento');

            Zend_Loader::loadClass('DAOBaseIaPeriodoobjetivosauditoriainspeccion');
            Zend_Loader::loadClass('DAOIaPeriodoobjetivosauditoriainspeccion');

            Zend_Loader::loadClass('DAOBaseIaObjetivosespecificos');
            Zend_Loader::loadClass('DAOIaObjetivosespecificos');

            Zend_Loader::loadClass('DAOBaseIaCalendarizador');
            Zend_Loader::loadClass('DAOIaCalendarizador');

            Zend_Loader::loadClass('DAOBaseIaCamposformularioinspeccion');
            Zend_Loader::loadClass('DAOIaCamposformularioinspeccion');

            Zend_Loader::loadClass('DAOBaseIaColaboradores');
            Zend_Loader::loadClass('DAOIaColaboradores');

            Zend_Loader::loadClass('DAOBaseIaLaboratorios');
            Zend_Loader::loadClass('DAOIaLaboratorios');

            Zend_Loader::loadClass('DAOBaseZkUsers');
            Zend_Loader::loadClass('DAOZkUsers');

            Zend_Loader::loadClass('DAOBaseZkGroupMembership');
            Zend_Loader::loadClass('DAOZkGroupMembership');

            Zend_Loader::loadClass('DAOBaseRegion');
            Zend_Loader::loadClass('DAORegion');

            Zend_Loader::loadClass('DAOBaseIaHallazgosinspeccion');
            Zend_Loader::loadClass('DAOIaHallazgosinspeccion');





			//Zend_Loader::loadClass('DAOBASECxPermisoConexion');
			//Zend_Loader::loadClass('DAOCxPermisoConexion');
            $this->_configparams = Zend_Registry::get('options');
            $this->config = Zend_Registry::get('config');
            $this->estadoObjetivoEspecifico = $this->config->estadoObjetivoEspecifico->toArray();

		}
		catch(Exception $e)
		{
			error_log("Excepcion iniciando index: [$e]");
		}
		
		$this->_configparams = Zend_Registry::get('options');
    }


    /**
     * INDEX ACTION DE MANTENIMIENTO ,
     * MODULO: MANTENIMIENTO*/
    public function indexAction()
    {

        $user_id = pnUserGetVar('uid');
        $colaborador = new Colaborador(NULL, $user_id);// id colaborador , id zkuser
        $colaborador = $colaborador->toArray();


        echo "<h1>Mantenimiento Básico de Datos de Datos de Inspección y Muestreo</h1>";
        echo "<center><br /><br />";
        if($colaborador['administrador_central']==1){// estos parametros solo se le muestran al central
            echo "<h2>Analisis/Muestreos </h2>
            <a style='text-decoration: none' href=\"/zf_Mantenimiento/index/tiposanalisis\"><div class='botonverde'>Tipos de Análisis</div></a><br/>
            <a style='text-decoration: none' href=\"/zf_Mantenimiento/index/analisilaboratorio\"><div class='botonverde'>Análisis Laboratorio</div></a><br/>
            <a style='text-decoration: none' href=\"/zf_Mantenimiento/index/laboratoriosexternos\"><div class='botonverde'>Laboratorios externos</div></a><br/>
            <br>
            <h2>Inspecciones </h2>
            <a style='text-decoration: none' href=\"/zf_Mantenimiento/index/tiposestablecimientos\"><div class='botonverde'>Tipos de Establecimientos para inspecciones </div></a><br/>
            <a style='text-decoration: none' href=\"/zf_Mantenimiento/index/indexitemdeinspecciones\"><div class='botonverde'>Items Formulario de Inspección</div></a><br/>";
        }



         echo "<br><h2>Colaboradores </h2>
                <a style='text-decoration: none' href=\"/zf_Mantenimiento/index/indexcolaboradores\"><div class='botonverde'>Colaboradores </div></a><br/>
                </center>";


    }


    /**
     * Retorna el JSON del arreglo que se recibe como parametro
     * @param arregloRespuesta Arreglo que se va a convertir en JSON
     * @return JSON del arreglo que se recibe como parametro
     */
    public  function retornarJSON($arregloRespuesta)
    {
        $retorno = json_encode($arregloRespuesta);
        $vars = array();
        $vars['valor'] = $retorno ;
        $this->view->assignOld($vars);
        $temp_file = 'Mantenimiento_user_popup.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }






    /*Tablas de CRUD para ingreso de datos*/
    /* CRUD DE MANTENIMIENTO DE TABLA TIPO DE ANALISIS , MODULO: MANTENIMIENTO  */
    public function tiposestablecimientosAction(){
        $tbl= $this->_helper->AddaxCRUD("DAOIaTipoestablecimiento","Tipo de Establecimiento","Tipos de Establecimientos");

        $tbl->omitFieldCompletely("id");
        $tbl->displayAs("nombre", "Nombre");
        $tbl->displayAs("habilitado", "Habilitado");
       // $tbl->disallowDelete();
        $tbl->defineCheckbox("habilitado", true);

        /*$tbl->enableRelationship("user_id","pn_uname");*/

        //Paginación
        $page = $this->request->getParam('page');
        /* Si el parametro de pagina debe llamarse diferente a 'page', antes hay que configurarlo con
           $tbl->setPageParameterName('pid'); */
        $rowsxpage = 20;
        $tbl->turnOnPaging($page, $rowsxpage);

        //Ordenamiento

        $sort_field = $this->request->getParam('sort-field');
        if (empty($sort_field))
        {
            $sort_field ="nombre";
        }
        $sort_dir = $this->request->getParam('sort-dir');
        if (empty($sort_dir))
        {
            $sort_dir ="ASC";
        }
        $tbl->turnOnSorting($sort_field, $sort_dir);

        ob_start();
        $tbl->showTable();
        $htmlTbl = ob_get_contents();
        ob_end_clean();
        echo "
            <h2>Tipos de Establecimiento/Inspeción</h2>
            <p style='text-align: center'>Esta sección permite el mantenimiento y la modificación de los tipos de Establecimiento para las inspecciones</p><br/>
            <div style='width: 100%; margin-left: auto; margin-right: auto'  class='divparatabla'  >$htmlTbl</div>";

    }

    /*Tablas de CRUD para ingreso de datos*/
    /* CRUD DE MANTENIMIENTO DE TABLA TIPO DE ANALISIS , MODULO: MANTENIMIENTO  */
    public function tiposanalisisAction(){
        $tbl= $this->_helper->AddaxCRUD("DAOIaTipoanalisis","Tipos de Analisis","Tipos de Analisis");

        $tbl->omitFieldCompletely("id");

        $tbl->displayAs("nombre", "Nombre");
        $tbl->displayAs("descripcion", "Descripción");
        $tbl->displayAs("habilitado", "Habilitado");
        //$tbl->disallowDelete();
        /*$tbl->enableRelationship("user_id","pn_uname");*/

        $tbl->defineCheckbox("habilitado", true);

        //Paginación
        $page = $this->request->getParam('page');
        /* Si el parametro de pagina debe llamarse diferente a 'page', antes hay que configurarlo con
           $tbl->setPageParameterName('pid'); */
        $rowsxpage = 20;
        $tbl->turnOnPaging($page, $rowsxpage);

        //Ordenamiento

        $sort_field = $this->request->getParam('sort-field');
        if (empty($sort_field))
        {
            $sort_field ="nombre";
        }
        $sort_dir = $this->request->getParam('sort-dir');
        if (empty($sort_dir))
        {
            $sort_dir ="ASC";
        }
        $tbl->turnOnSorting($sort_field, $sort_dir);

        //actually show the table
        //actually show the table
        //$tbl->showTable();

        ob_start();
        $tbl->showTable();
        $htmlTbl = ob_get_contents();
        ob_end_clean();
        echo "
            <h2>Tipos de Analisis de Laboratorio</h2>
            <p style='text-align: center'>Esta sección permite el mantenimiento y la modificación de los tipos de analisis en los cuales están divididas las pruebas <br>**No se recomienda borrar los tipos, es mejor solo deshabilitarlos. </p><br/>
            <div style='width: 100%; margin-left: auto; margin-right: auto'  class='divparatabla'  >$htmlTbl</div>";

    }
    /* CRUD DE MANTENIMIENTO DE TABLA ANALISIS DE LABORATORIO, MODULO: MANTENIMIENTO  */
    //antiguo ya se cambio por uno con mas funcionalidades
    public function colaboradoresAction(){
        $tbl= $this->_helper->AddaxCRUD("DAOIaColaboradores","Colaboradores","Colaboradores");

        $tbl->omitFieldCompletely("usuario_id");
        $tbl->omitFieldCompletely("id");

        $tbl->omitFieldCompletely("fecha_creacion");
        $tbl->omitFieldCompletely("usuario_creacion");
        $tbl->omitFieldCompletely("usuario_creacion_id");
        $tbl->omitFieldCompletely("usuario_modificacion");
        $tbl->omitFieldCompletely("ultima_modificacion_usuario_id");
        $tbl->omitFieldCompletely("fecha_actualizacion");
        $tbl->displayAs("nombre", "Nombre");
        $tbl->displayAs("inspector", "Inspector");
        $tbl->displayAs("tomadormuestra", "Tomador de Muestra");
        $tbl->displayAs("puesto", "Puesto");
        $tbl->displayAs("id_region", "ID Region");

        $tbl->enableRelationship("usuario_id","nombre");

        $tbl->defineCheckbox("inspector", true);
        $tbl->defineCheckbox("tomadormuestra", true);

        //Paginación
        $page = $this->request->getParam('page');
        /* Si el parametro de pagina debe llamarse diferente a 'page', antes hay que configurarlo con
           $tbl->setPageParameterName('pid'); */
        $rowsxpage = 20;
        $tbl->turnOnPaging($page, $rowsxpage);

        //Ordenamient

        $sort_field = $this->request->getParam('sort-field');
        if (empty($sort_field))
        {
            $sort_field ="nombre";
        }
        $sort_dir = $this->request->getParam('sort-dir');
        if (empty($sort_dir))
        {
            $sort_dir ="ASC";
        }
        $tbl->turnOnSorting($sort_field, $sort_dir);

        //actually show the table
        $tbl->showTable();
    }

    /* CRUD DE MANTENIMIENTO DE TABLA ANALISIS DE LABORATORIO, MODULO: MANTENIMIENTO  */

    public function analisilaboratorioAction(){
        $filtro_texto=$this->request->getParam('filtro_texto');
        $filtro_subclase=$this->request->getParam('filtro_subclase');

        $tbl= $this->_helper->AddaxCRUD("DAOIaAnalisislaboratorio","Análisis","Análisis");

        $tbl->omitFieldCompletely("id");
        $tbl->displayAs("nombre", "Nombre");
        $tbl->displayAs("tipoanalisis_id", "Tipo de Análisis");
        $tbl->displayAs("descripcion", "Descripción");
        $tbl->displayAs("habilitado", "Habilitado");
        //$tbl->disallowDelete();
        $tbl->enableRelationship("tipoanalisis_id","nombre");
        $tbl->defineCheckbox("habilitado", true);

        //Paginación
        $page = $this->request->getParam('page');
        $rowsxpage = 25;
        $tbl->turnOnPaging($page, $rowsxpage);

        //Ordenamient
        $sort_field = $this->request->getParam('sort-field');
        if (empty($sort_field)){ $sort_field ="nombre";}
        $sort_dir = $this->request->getParam('sort-dir');
        if (empty($sort_dir)){$sort_dir ="ASC";}
        $tbl->turnOnSorting($sort_field, $sort_dir);

        $where = " 1 = 1 ";
        if($filtro_texto != ""){
            $where .= " AND (nombre like '%$filtro_texto%')";
        }
        if($filtro_subclase != ""){
            $where .= " AND tipoanalisis_id = '$filtro_subclase'";
        }

        $tbl->addWhereClause("$where");

        ob_start();
        $tbl->showTable();
        $htmlTbl = ob_get_contents();
        ob_end_clean();
        $vars['htmlTbl'] = $htmlTbl;
        $vars['filtro_texto'] = $filtro_texto;
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoanalisis", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $vars['filtro_subclase'] = $generadorHTMLCombos->generarHTMLCombo($name = "filtro_subclase", $id = "filtro_subclase", $items, TRUE, "style='width: 280px;'", false, $filtro_subclase);

       // $vars['filtro_subclase'] = $filtro_subclase;// no sirve por que es el id
        $this->view->assignOld($vars);
        $temp_file = 'Mantenimiento_index_de_analisisdelaboratorio.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);

    }

    /* CRUD DE MANTENIMIENTO DE TABLA ANALISIS DE LABORATORIO, MODULO: MANTENIMIENTO  */
    public function camposformularioinspeccionAction(){
        $tbl= $this->_helper->AddaxCRUD("DAOIaCamposformularioinspeccion","Items","Item");

        $tbl->omitFieldCompletely("id");


        $tbl->displayAs("label_de_item", "Pregunta del item");
        $tbl->displayAs("articulo_asociado", "Articulo Asociado");
        $tbl->displayAs("subcalse_de_item", "Subclase del item");
        $tbl->displayAs("subcalse_orden", "Orden de aparicion de Subclase");
        $tbl->displayAs("habilitado", "Habilitado");
        $tbl->disallowDelete();
       // $tbl->enableRelationship("subcalse_orden","subcalse_de_item");

        $tbl->defineCheckbox("habilitado", true);

        //Paginación
        $page = $this->request->getParam('page');
        /* Si el parametro de pagina debe llamarse diferente a 'page', antes hay que configurarlo con
           $tbl->setPageParameterName('pid'); */
        $rowsxpage = 20;
        $tbl->turnOnPaging($page, $rowsxpage);

        //Ordenamient

        $sort_field = $this->request->getParam('sort-field');
        if (empty($sort_field))
        {
            $sort_field ="subcalse_de_item";
        }
        $sort_dir = $this->request->getParam('sort-dir');
        if (empty($sort_dir))
        {
            $sort_dir ="ASC";
        }
        $tbl->turnOnSorting($sort_field, $sort_dir);

        //actually show the table
        $tbl->showTable();


    }
    /* CRUD DE MANTENIMIENTO DE TABLA PERIODOS OBJETIVOS DE MUESTRAS , MODULO: MANTENIMIENTO  */
    public function periodoobjetivosAction(){
        $tbl= $this->_helper->AddaxCRUD("DAOIaPeriodoobjetivosmuestras","Período Objetivos","Período OBjetivo");

        $tbl->omitFieldCompletely("id");
        $tbl->displayAs("anio", "Año");
        $tbl->displayAs("tipoanalisis_id", "Tipo de Análisis");
        $tbl->displayAs("analisislaboratorio_id", "Análisis");
        $tbl->displayAs("meta_actual", "Meta Actual");
        $tbl->displayAs("meta_especificos", "Meta Específicos");
        $tbl->displayAs("ejecucion", "Ejecución");
        $tbl->displayAs("porcentaje_ejecucion", " % Ejecución");
        $tbl->disallowDelete();
        $tbl->enableRelationship("tipoanalisis_id","nombre");
        $tbl->enableRelationship("analisislaboratorio_id","nombre");

        //Paginación
        $page = $this->request->getParam('page');
        /* Si el parametro de pagina debe llamarse diferente a 'page', antes hay que configurarlo con
           $tbl->setPageParameterName('pid'); */
        $rowsxpage = 20;
        $tbl->turnOnPaging($page, $rowsxpage);

        //Ordenamiento

        $sort_field = $this->request->getParam('sort-field');
        if (empty($sort_field))
        {
            $sort_field ="anio";
        }
        $sort_dir = $this->request->getParam('sort-dir');
        if (empty($sort_dir))
        {
            $sort_dir ="ASC";
        }
        $tbl->turnOnSorting($sort_field, $sort_dir);

        //actually show the table
        $tbl->showTable();

    }
    /*FIN Tablas de CRUD para ingreso de datos*/

    public function laboratoriosexternosAction(){
        $tbl= $this->_helper->AddaxCRUD("DAOIaLaboratorios","Laboratorios Externos","Laboratorios Externos");

        $tbl->omitFieldCompletely("id");
        $tbl->displayAs("nombre", "Nombre");
        $tbl->displayAs("cedula_juridica", "Cedula");
        $tbl->displayAs("telefono", "Teléfonos");
        $tbl->displayAs("direccion", "Dirección");
        $tbl->displayAs("contacto", "Contacto");

        $tbl->displayAs("habilitado", "Habilitado");
        $tbl->defineCheckbox("habilitado", true);
       // $tbl->disallowDelete();

        //Paginación
        $page = $this->request->getParam('page');
        /* Si el parametro de pagina debe llamarse diferente a 'page', antes hay que configurarlo con
           $tbl->setPageParameterName('pid'); */
        $rowsxpage = 30;
        $tbl->turnOnPaging($page, $rowsxpage);

        //Ordenamiento

        $sort_field = $this->request->getParam('sort-field');
        if (empty($sort_field))
        {
            $sort_field ="nombre";
        }
        $sort_dir = $this->request->getParam('sort-dir');
        if (empty($sort_dir))
        {
            $sort_dir ="ASC";
        }
        $tbl->turnOnSorting($sort_field, $sort_dir);


        //actually show the table
        //actually show the table
        //$tbl->showTable();

        ob_start();
        $tbl->showTable();
        $htmlTbl = ob_get_contents();
        ob_end_clean();
        echo "
            <h2>Laboratorios Externos</h2>
            <p style='text-align: center;'>Esta sección permite el mantenimiento y la modificación, de los nombres e información de los laboratorios externos usados para el analisis de las muestras tomadas en los diferentes establecimientos<br> **No se recomienda borrar los laboratorios, solo deshabilitarlos. </p><br/>
            <div style='width: 100%; margin-left: auto; margin-right: auto'  class='divparatabla'  >$htmlTbl</div>";

    }


    /*********************************************************************************************************************************************************/
    /*********************************************************************************************************************************************************/
    /*********************************************************************************************************************************************************/
    //esta parte es para gestion de colaboradores

    /**
     * Se encarga de carga la pagina de gestor de colaboradores  donde esta la tabla de colaboradores
     */
    public function indexcolaboradoresAction()
    {
       /* if (!pnSecAuthAction(0, 'zf_Mantenimiento::', '::', ACCESS_ADMIN)) {
            //return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            return permisosinvalidos($this->view);
        }*/

        $vars = array();
        $userUtil = new UserUtil();
        if($userUtil->administradorcentral()){ // si es centrl
            $vars['htmlTbl'] = $this->loadtablacolaboradores(null);
            $vars['region']= null;
        }else{// si es regional
            $user_id = pnUserGetVar('uid');
            $colaborador = new Colaborador(NULL, $user_id);// id colaborador , id zkuser
            $colaborador = $colaborador->toArray();
            $vars['region']= Region::nombreregion($colaborador['id_region']);
            $vars['htmlTbl'] = $this->loadtablacolaboradores($colaborador['id_region']);
        }


        $this->view->assignOld($vars);
        $temp_file = 'Mantenimiento_index_de_colaborador.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * Se encarga de crear el curd html para el gestro de colaboradores
     * */
    public function loadtablacolaboradores($id_region=null) {
        try{
            $tbl= $this->_helper->AddaxCRUD("DAOIaColaboradores","Colaborador","Colaboradores");
            $tbl->disallowAdd();
            $tbl->disallowDelete();

            //Paginación
            $page = $this->request->getParam('page');
            $rowsxpage = 50;
            $tbl->turnOnPaging($page, $rowsxpage);

            //Ordenamiento

            $sort_field = $this->request->getParam('sort-field');
            if (empty($sort_field)){
                $sort_field ="email";
            }
            $sort_dir = $this->request->getParam('sort-dir');
            if (empty($sort_dir)) {
                $sort_dir ="ASC";
            }
            $tbl->turnOnSorting($sort_field, $sort_dir);


            $tbl->displayAs("inspector", "Inspector");
            $tbl->defineCheckbox("inspector", true);
            $tbl->disallowEdit("inspector");
            $tbl->displayAs("tomadormuestra", "Tomador Muestral");
            $tbl->defineCheckbox("tomadormuestra", true);
            $tbl->disallowEdit("tomadormuestra");
            $tbl->displayAs("habilitado", "Habilitado");
            $tbl->disallowEdit("habilitado");
            $tbl->defineCheckbox("habilitado", true);
            $tbl->displayAs("administrador_regional", "Admin regional");
            $tbl->disallowEdit("administrador_regional");
            $tbl->defineCheckbox("administrador_regional", true);
            $tbl->displayAs("administrador_central", "Admin Central");
            $tbl->disallowEdit("administrador_central");
            $tbl->defineCheckbox("administrador_central", true);

            $tbl->displayAs("nombre", "Nombre");
            $tbl->disallowEdit("nombre");
           //$tbl->addAjaxFilterBox("nombre"); //no sirve a la hora de cargar la tambal

            $tbl->disallowEdit("email");
            $tbl->displayAs("email", "Email");

            $tbl->displayAs("identificacion", "Id");
            $tbl->disallowEdit("identificacion");
            $tbl->displayAs("telefono", "Teléfono");
            $tbl->disallowEdit("telefono");
            $tbl->omitFieldCompletely("telefono");

            $tbl->displayAs("puesto", "Puesto");
            $tbl->disallowEdit("puesto");
            $tbl->displayAs("id_region", "Region");
            $tbl->disallowEdit("id_region");
            //$tbl->defineRelationship("id_region", "DAORegion", "id", "nombre",$category_sort_field = "", $category_required = "1", $category_where = "");
            $tbl->enableRelationship("id_region", "nombre"); // para que esto funcione tiene que estar el fk realcionado desde la db , y los doctrine actualizados


            $tbl->displayAs("id_region_secundaria", "Region2");
            $tbl->disallowEdit("id_region_secundaria");
            $tbl->omitFieldCompletely("id_region_secundaria");

            $tbl->omitFieldCompletely("usuario_id");
            $tbl->omitFieldCompletely("id");
            $tbl->omitFieldCompletely("fecha_creacion");
            $tbl->omitFieldCompletely("usuario_creacion");
            $tbl->omitFieldCompletely("usuario_creacion_id");
            $tbl->omitFieldCompletely("usuario_modificacion");
            $tbl->omitFieldCompletely("ultima_modificacion_usuario_id");
            $tbl->omitFieldCompletely("fecha_actualizacion");

           // $tbl->orderFields("nombre,email,puesto,id_region,inspector,tomadormuestra,administrador_regional,habilitado");

            $urlEditar = pnZendPopupURL("zf_Mantenimiento", "Index", "modificarcolaborador");//$urlEditar = pnZendPopupURL("zf_Mantenimiento", "Index", "modificarcolaborador");
            $tbl->addButtonToRow("Editar", $urlEditar, "id",'','');

            $where = " 1 = 1 ";
            if($id_region != ""){
                $where .= " AND id_region = '$id_region'";
            }

            $tbl->addWhereClause("$where");

            ob_start();
            $tbl->showTable();
            $htmlTbl = ob_get_contents();
            ob_end_clean();
            return $htmlTbl;
        }
        catch(Exception $e) {
            error_log("No se ha podido cargar el crud-colaboradores [$e]");
            return false;
        }
    }



    /**funcion se encarga de crear y cargar  el formulario para crear o modificar un colaborador de homologacion
     *
     */
    public function modificarcolaboradorAction(){

        if (!pnSecAuthAction(0, 'zf_Mantenimiento::', '::', ACCESS_ADMIN)) {
            //return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            return permisosinvalidos($this->view);
        }
        $vars = array();
        $userUtil = new UserUtil();


        $Colaborador_id = $this->request->getParam('Colaborador_id');
        if(is_array($Colaborador_id)){ // por el problemema de de me lo manda dos veces
            $Colaborador_id=$Colaborador_id[0];
        }
        if (is_null($Colaborador_id)){// es nuevo
            $vars['titulo']='Nuevo Colaborador';
            $vars['placeholder']='Password requerido';
        }else{ // es otro ya creado ocupa modificacion

            $Encargado = new Colaborador($Colaborador_id,null,null);
            $vars=$Encargado->toArray();
            $vars['titulo']='Edición de Colaborador';
            $vars['placeholder']='Digite solo si desea replazar el actual';
        }
        if($userUtil->administradorcentral()){ // si es administrador en central
            $vars['usuariocentral']=1;
        }
        // $vars['htmlTbl'] = $this->loadtablaencargados();
        $this->view->assignOld($vars);
        $temp_file = 'Mantenimiento_formulario_datos_colaborador.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);

    }

    /**
     * si el solicitante no existe lo crea y le crea el usaurio en de sikula
     * con los datos recibidos, si exite solo  le actualiza los datos con lo datos recibidos
     *
     * @return string
     */
    public function guardarcolaboradorAction()
    {
        if (!pnSecAuthAction(0, 'zf_Mantenimiento::', '::', ACCESS_ADMIN)){
            return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
        }

        $colaborador_id = $this->request->getParam('colaborador_id');
        $nombre = $this->request->getParam('nombre');
        $email = $this->request->getParam('email');
        $clave = $this->request->getParam('password');
        $puesto = $this->request->getParam('puesto');
        $identificacion = $this->request->getParam('identificacion');
        $telefonos = $this->request->getParam('telefono');
        $region= $this->request->getParam('id_region');
        $region2= $this->request->getParam('id_region_secundaria');
        $inspector= $this->request->getParam('inspector');
        $habilitado= $this->request->getParam('habilitado');
        $tomadormuestra= $this->request->getParam('tomadormuestra');
        $administrador_regional= $this->request->getParam('administrador_regional');

        $administrador_central= $this->request->getParam('administrador_central');// solo en caso de que



        $respuesta = array();
        $result = true;
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        $conn->beginTransaction();
        $esnuevousuario = 0;

        if(!isset($colaborador_id) || is_null($colaborador_id) || $colaborador_id <= 0)// si es no tiene id es user es nuevo y hay que crearle el zkuser
        {
            $esnuevousuario =1;
            $colaborador_id = null;
            $cms_user_email = new User(NULL, NULL, $email);
            if($cms_user_email->existe()){ // verificamos si el correo existe
                $respuesta['resultado'] = false;
                $respuesta['mensaje'] = 'Correo electrónico ya registrado, creación de usuario fallida';
                $this->retornarJSON($respuesta);
                return;
            }else{ // si el correo no exite
                $uname = $nombre;
                $uname = strtolower($uname);
                $uname = str_replace(' ', '_', $uname);
                $uname = str_replace('ñ', 'nn', $uname);
                $uname = str_replace('á', 'a', $uname);
                $uname = str_replace('é', 'e', $uname);
                $uname = str_replace('í', 'i', $uname);
                $uname = str_replace('ó', 'o', $uname);
                $uname = str_replace('í', 'i', $uname);
               // echo'1';
                $contador = 0;

                $cms_user_uname = new User(NULL, $uname, NULL);

                while($cms_user_uname->existe()){// nose para que es esto
                    $contador++;
                    $uname .= $contador;
                    $cms_user_uname = new User(NULL, $uname, NULL);
                }
             //   echo'1';
                $cms_user = new User();// crea el zk_user nuevo
                try{
                    $result = $cms_user->modificar(array(// lo modifica los datos como los valores nuevos
                        'pn_uname' => $uname,
                        'pn_email' => $email,
                        'pn_user_regdate' => date('Y-m-d h:i:s'),
                        'pn_user_viewemail' => 0,
                        'pn_user_theme' => '',
                        'pn_pass' => hash('sha256', $clave),
                        'pn_storynum' => 5,
                        'pn_ublockon' => '',
                        'pn_ublock' => '',
                        'pn_theme' => '',
                        'pn_counter' => 0,
                        'pn_activated' => 1,
                        'pn_lastlogin' => date('Y-m-d h:i:s'),
                        'pn_validfrom' => 0,
                        'pn_validuntil' => 0,
                        'pn_hash_method' => 8
                    ));
                    GroupMembership::insertarunregistrodelmembership($cms_user->pn_uid, 1);// para membresia en usuarios
                    GroupMembership::insertarunregistrodelmembership($cms_user->pn_uid, 3);//3colaborador
                    if($inspector=='1'){
                        GroupMembership::insertarunregistrodelmembership($cms_user->pn_uid, 4);//   4	Inspector_Senasa
                    }
                    if($tomadormuestra=='1'){
                        GroupMembership::insertarunregistrodelmembership($cms_user->pn_uid, 5);///  5	TomadorMuestra_Senasa
                    }
                    if($administrador_regional=='1'){
                        GroupMembership::insertarunregistrodelmembership($cms_user->pn_uid, 6);//   6	AdministradorRegional_Senasa
                    }
                    if($administrador_central=='1'){
                        GroupMembership::insertarunregistrodelmembership($cms_user->pn_uid, 7);//      // 7	AdministradorCentral_Senasa
                    }



                }catch (Exception $e){
                    $conn->rollback();
                    $result = false;
                    $str_error = $e->getMessage();
                    error_log(__METHOD__ . ' EXCEPTION ' . $e->getTraceAsString());
                }
            }
        }
        error_log('usuario zk creado');

        $colaborador = new Colaborador($colaborador_id, NULL);// si es nuevo el colaborador_id es null , lo que va crear uno nuevo ,si  colaborador_id ya existe, lo abre

        if($result != false){
            try
            {
                if($esnuevousuario== 1){// como es nuevo solo se le modican los datos con los recividos
                    $result = $colaborador->modificar(array(
                            'nombre' => $nombre,
                            'email' => $email,
                            'identificacion' => $identificacion,
                            'telefono' => $telefonos,
                            'id_region' => $region,
                            'id_region_secundaria' => $region2,
                            'puesto' => $puesto,
                            'habilitado' => $habilitado,
                            'inspector' => $inspector,
                            'tomadormuestra' => $tomadormuestra,
                            'administrador_regional' => $administrador_regional,
                            'administrador_central' => $administrador_central,
                            'usuario_id' => $cms_user->pn_uid

                        )
                    );

                }else{//si es viejo  hay que modificar los datos
                    $datosS= $colaborador->toArray();
                    $usuario_id = $datosS['usuario_id'];
                    $email_viejo = $datosS['email'];
                    if ($usuario_id != null && $usuario_id!=''){
                        $zkuser_de_colaborador= new User($usuario_id, null,null);// cresmos el zkuser con eluser_id del colaborador
                        $datosZK= $zkuser_de_colaborador->toArray();
                        if ($datosZK['pn_email']== $email){ // si es el mismo email modificamos
                            if ($clave!= null && $clave !=''){
                                $result = $zkuser_de_colaborador->modificar(array(
                                    'pn_email' => $email,
                                    'pn_pass' => hash('sha256', $clave),
                                    'pn_activated' => $habilitado

                                ));
                            }else{
                                $result = $zkuser_de_colaborador->modificar(array(
                                    'pn_email' => $email,
                                    'pn_activated' => $habilitado
                                ));
                            }
                        }else{// si es difenrente hay que revisar que no exita el correo ya
                            $cms_user_email2 = new User(NULL, NULL, $email);
                            if($cms_user_email2->existe()){
                                $respuesta['resultado'] = false;
                                $respuesta['mensaje'] = 'Correo electrónico ya registrado, modificación de usuario fallida';
                                $this->retornarJSON($respuesta);
                                return;
                            }else { // si no hay, lo modificamos
                                if ($clave!= null && $clave !=''){
                                    $result = $zkuser_de_colaborador->modificar(array(
                                        'pn_email' => $email,
                                        'pn_pass' => hash('sha256', $clave),
                                        'pn_activated' => $habilitado

                                    ));
                                }else{
                                    $result = $zkuser_de_colaborador->modificar(array(
                                        'pn_email' => $email,
                                        'pn_activated' => $habilitado
                                    ));
                                }

                            }
                        }

                        //ahora modificacmos los groupmemberships dependiendo de los que entro
                        //la membresia al grupo de los $inspector
                        if($datosS['inspector'] != $inspector && !is_null($inspector)) { // si el campo supervisor cambio
                            if($inspector=='1'){ // si es 1 , hay que agregarlo
                                GroupMembership::insertarunregistrodelmembership($usuario_id, 4);//   4	Inspector_Senasa
                            }else{// si es 0 o null hay que quitarlo
                                GroupMembership::borrarunregistrodelmembership($usuario_id,'4');// quita el registro que loga el zkuser con el grupo
                            }

                        }
                        //la membresia al grupo de los tomadores de muestras
                        if($datosS['tomadormuestra'] != $tomadormuestra && !is_null($tomadormuestra)) { // si el campo cambio
                            if($tomadormuestra=='1'){ // si es 1 , hay que agregarlo
                                GroupMembership::insertarunregistrodelmembership($usuario_id, 5);//   4	Inspector_Senasa
                            }else{// si es 0 o null hay que quitarlo
                                GroupMembership::borrarunregistrodelmembership($usuario_id,'5');// quita el registro que loga el zkuser con el grupo
                            }

                        }
                        //la membresia al grupo de los $administrador_regional
                        if($datosS['administrador_regional'] != $administrador_regional && !is_null($administrador_regional)) { // si el campo cambio
                            if($administrador_regional=='1'){ // si es 1 , hay que agregarlo
                                GroupMembership::insertarunregistrodelmembership($usuario_id, 6);//   4	Inspector_Senasa
                            }else{// si es 0 o null hay que quitarlo
                                GroupMembership::borrarunregistrodelmembership($usuario_id,'6');// quita el registro que loga el zkuser con el grupo
                            }

                        } //la membresia al grupo de los $administrador_regional
                        if($datosS['administrador_central'] != $administrador_central && !is_null($administrador_central)) { // si el campo cambio
                            if($administrador_central=='1'){ // si es 1 , hay que agregarlo
                                GroupMembership::insertarunregistrodelmembership($usuario_id, 7);//   7	administrador_central_Senasa
                            }else{// si es 0 o null hay que quitarlo
                                GroupMembership::borrarunregistrodelmembership($usuario_id,'7');// quita el registro que loga el zkuser con el grupo
                            }

                        }

                    }

                    if ( $result != false){// si ninguna de las cosas anteriores dio error procedemos a modificar la info del colaborador
                        $result = $colaborador->modificar(array(
                                'nombre' => $nombre,
                                'email' => $email,
                                'identificacion' => $identificacion,
                                'telefono' => $telefonos,
                                'id_region' => $region,
                                'id_region_secundaria' => $region2,
                                'puesto' => $puesto,
                                'habilitado' => $habilitado,
                                'inspector' => $inspector,
                                'tomadormuestra' => $tomadormuestra,
                                'administrador_regional' => $administrador_regional,
                                'administrador_central' => $administrador_central
                                //'usuario_id' => $cms_user->pn_uid
                            )
                        );


                    }


                }
            }
            catch(Exception $e)
            {
                $conn->rollback();
                $result = false;
                $str_error = $e->getMessage();
                //echo $e->getTraceAsString();
            }
        }

        $respuesta['resultado'] = $result;
        if($result)
        {
            $conn->commit();
            $respuesta['mensaje'] = '';
            $respuesta['colaborador_id'] = $colaborador->id;
        }
        else
        {
            $respuesta['mensaje'] = $str_error;
        }

        $datosrecibidos = $this->request->getParams();
        $respuesta['datosrecibidos']=$datosrecibidos;
        $this->retornarJSON($respuesta);

        /*  $respuesta = array();

          $datosrecibidos = $this->request->getParams();
           $respuesta['datosrecibidos']=$datosrecibidos;
          sleep(2);
          $respuesta['resultado']=false;
          $respuesta['datosrecibidos']=$datosrecibidos;
          $this->retornarJSON($respuesta);*/

    }


    /*********************************************************************************************************************************************************/
    /*********************************************************************************************************************************************************/
    /*********************************************************************************************************************************************************/
    //esta parte es para gestion de itemdeinspecciones

    /**
     * Se encarga de carga la pagina de gestor de itemdeinspecciones  donde esta la tabla de itemdeinspecciones
     */
    public function indexitemdeinspeccionesAction()
    {
        /* if (!pnSecAuthAction(0, 'zf_Mantenimiento::', '::', ACCESS_ADMIN)) {
             //return pnVarPrepHTMLDisplay(_MODULENOAUTH);
             return permisosinvalidos($this->view);
         }*/
        $vars = array();
        $vars['texto'] =$texto=$this->request->getParam('filtro_texto');
        $vars['subclase']=$subclase=$this->request->getParam('filtro_subclase');
        $vars['actividad']= $actividad=$this->request->getParam('filtro_actividad');
        $vars['articulo']= $articulo=$this->request->getParam('filtro_articulo');

        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        $vars['comboestablecimientos'] = $generadorHTMLCombos->generarHTMLCombo($name = "filtro_actividad", $id = "filtro_actividad", $items, $opcionSeleccione = TRUE, $extra = " style='width: 280px;'", false, $actividad);


        $vars['htmlTbl'] = $this->loadtablaitemdeinspecciones($texto,$subclase,$actividad,$articulo);
        $this->view->assignOld($vars);
        $temp_file = 'Mantenimiento_index_de_itemdeinspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);
    }

    /**
     * Se encarga de crear el curd html para el gestro de itemdeinspecciones
     * */
    public function loadtablaitemdeinspecciones($texto="",$subclase="",$actividad="",$articulo="") {
        try{

            $tbl= $this->_helper->AddaxCRUD("DAOIaCamposformularioinspeccion","Items","Item");
            $tbl->disallowDelete();
            $tbl->disallowAdd();

            $tbl->omitFieldCompletely("id");
            $tbl->displayAs("label_de_item", "Pregunta del item");
            $tbl->disallowEdit("label_de_item");
            $tbl->disallowEdit("item");

            $tbl->omitFieldCompletely("articulo_asociado");
            $tbl->displayAs("articulo_asociado", "Articulo Asociado");
            $tbl->disallowEdit("articulo_asociado");
            $tbl->displayAs("subcalse_de_item", "Subclase del item");
            $tbl->displayAs("item", "Item");
            $tbl->disallowEdit("subcalse_de_item");
            $tbl->omitFieldCompletely("subcalse_orden");
            $tbl->displayAs("subcalse_orden", "Orden de aparicion de Subclase");
            $tbl->disallowEdit("subcalse_orden");
            $tbl->displayAs("habilitado", "Habilitado");
            $tbl->defineCheckbox("habilitado", true);
            $tbl->disallowEdit("habilitado");

            $tbl->omitFieldCompletely("pdf_de_ayuda_id");
            $tbl->omitFieldCompletely("establecimientos");
            //Paginación
            $page = $this->request->getParam('page');
            $rowsxpage = 30;
            $tbl->turnOnPaging($page, $rowsxpage);


            //Ordenamiento
             $sort_field = $this->request->getParam('sort-field');
             if (empty($sort_field)){
                 $sort_field ="item , label_de_item";
             }
             $sort_dir = $this->request->getParam('sort-dir');
             if (empty($sort_dir)) {
                 $sort_dir ="ASC";
             }
             $tbl->turnOnSorting($sort_field, $sort_dir);


            // $tbl->orderFields("nombre,email,puesto,id_region,inspector,tomadormuestra,administrador_regional,habilitado");

            $urlEditar = pnZendPopupURL("zf_Mantenimiento", "Index", "modificaritemdeinspeccion");//$urlEditar = pnZendPopupURL("zf_Mantenimiento", "Index", "modificaritemdeinspeccion");
            $tbl->addButtonToRow("Editar", $urlEditar, "id",'','');

            $where = " 1 = 1 ";
            if($texto != ""){
                $where .= " AND (label_de_item like '%$texto%' OR item like '%$texto%'   )";
            }
            if($subclase != ""){
                $where .= " AND subcalse_de_item like '%$subclase%'";
            }
            if($actividad != ""){
                $where .= " AND establecimientos like '%\"$actividad\"%'";
            }
            if($articulo != ""){
                $where .= " AND articulo_asociado like '%$articulo%'";
            }

            $tbl->addWhereClause("$where");
            //$where=$filtroRegion;
            ob_start();
            $tbl->showTable();
            $htmlTbl = ob_get_contents();
            ob_end_clean();
            return $htmlTbl;
        }
        catch(Exception $e) {
            error_log("No se ha podido cargar el crud-itemdeinspecciones [$e]");
            return false;
        }
    }


    /**funcion se encarga de crear y cargar  el formulario para crear o modificar un itemdeinspeccion
     *
     */
    public function modificaritemdeinspeccionAction(){

      /*  if (!pnSecAuthAction(0, 'zf_Mantenimiento::', '::', ACCESS_ADMIN)) {
            //return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            return permisosinvalidos($this->view);
        }*/
        $vars = array();
        $itemdeinspeccion_id = $this->request->getParam('Items_id');
        if(is_array($itemdeinspeccion_id)){ // por el problemema de de me lo manda dos veces
            $itemdeinspeccion_id=$itemdeinspeccion_id[0];
        }
        if (is_null($itemdeinspeccion_id)){// es nuevo
            $vars['titulo']='Nuevo item de formulario de inspección';
        }else{ // es otro ya creado ocupa modificacion
            $Item = new ItemDeInspeccion ($itemdeinspeccion_id);
            $vars=$Item->toArray();
            $vars['titulo']='Edición de item de formulario de inspección';

        }
        $generadorHTMLCombos = new GeneradorHTMLCombos();
        $items = $generadorHTMLCombos->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = null, $ordebBy = "nombre", $value = "id", $text = "nombre");
        //$combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "establecimientos", $id = "establecimientos", $items, $opcionSeleccione = false ,$extra = "multiple class='inputmantenimiento2'");
         $combo_tipo_objetivo_html = $generadorHTMLCombos->generarHTMLCombo($name = "establecimientos[]", $id = "establecimientos", $items, $opcionSeleccione = false, $extra = "multiple class='inputmantenimiento2'", false, json_decode($vars['establecimientos']));
        $vars['comboestablecimientos'] =$combo_tipo_objetivo_html;

        // $vars['htmlTbl'] = $this->loadtablaencargados();
        $this->view->assignOld($vars);
        $temp_file = 'Mantenimiento_formulario_datos_itemdeinspeccion.htm';
        $smarty = $this->view->getEngine();
        $smarty->force_compile = true;
        $m_html = $this->view->render($temp_file);
        Zend_Registry::set('response', $m_html);

    }


    /**
     * Se encarga de gaurda todos los datos de un item de formulario de inspeccion
     */
    public function guardaritemdeinspeccionAction(){
        $respuesta = array();

        $id = $this->request->getParam('item_id');
        $camposaguardar= $this->request->getParams();

        $establecimientos = array();
        foreach($this->request->getParam('establecimientos') as $establecimientoItem){
            if($establecimientoItem != ''){
                array_push($establecimientos, $establecimientoItem);
            }
        }
        $camposaguardar['establecimientos'] = json_encode($establecimientos);

        //echo $id;
        try{
            $Item = new ItemDeInspeccion ($id);
            $result = $Item->modificar($camposaguardar);
           // $result = $Item->modificar( array("estado_evento" => $camposaguardar));
            $Item_fields = $Item->toArray();
            $respuesta['Item_fields']=$Item_fields;
        }
        catch(Exception $e){
            $result = false;
            $respuesta['mensaje'] = $e->getMessage();
        }

        $respuesta['camposaguardar']=$camposaguardar;
        $respuesta['resultado'] = $result;
        $this->retornarJSON($respuesta);

    }


}






