<?php
/**
 * Created by PhpStorm.
 * User: jrojas
 * Date: 2/14/14
 * Time: 10:00 AM
 */
class ActualizacionesAPI extends DAOInit {
    public function __construct($id){
        parent::__construct();
        $this->objetivo_record = NULL;
        $this->objetivo = array();
        if(isset($id) && $id != null && $id >= 0){
            try{
                //cargar objetivo
                $q = Doctrine_Query::create()
                    ->from('DAOIaActualizacionesApi a')
                    ->where("a.id = $id");
                $objetivo_record = $q->fetchOne();
                $objetivoCargado = false;
                if($objetivo_record != null && isset($objetivo_record))
                {
                    if($objetivo_record->exists())
                    {
                        $objetivoCargado = true;
                    }
                }//asdasd
                if (!$objetivoCargado)
                {
                    error_log("NO Actualizacion_Api Cargado");
                    $objetivo_record = new DAOIaSubclase();
                    $this->setRecord($objetivo_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Actualizacion_Api Cargado");
                    $this->setRecord($objetivo_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $objetivo_record = new DAOIaActualizacionesApi();
                $this->setRecord($objetivo_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }

    }

    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->objetivo_record->toArray();
        return $fields;
    }


    public function existe()
    {
        return $this->objetivo_record->exists();
    }


    public function setRecord(&$Record)
    {
        error_log("Actualizacion_Api::setRecord");
        if(!is_null($this->objetivo_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->objetivo_record))
            {
                error_log("setRecord:: Record is not the same type as Actualizacion_Api_record");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->objetivo_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }


    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("Actualizacion_Api::salvar");
        try
        {
            $nuevo_registro = false;
            if(! $this->existe() )
            {
                $nuevo_registro = true;
            }

            $objetivo_record = &$this->objetivo_record;

            $arreglo_datos = $objetivo_record->toArray();
            foreach($arreglo_datos as $key=>$value) //todo no parece necesario
            {
                switch($key)
                {
                    default:
                        $objetivo_record->{$key} = $this->{$key};
                        break;
                }
            }
            $objetivo_record->save();
            $new_objetivo_id = $objetivo_record['id'];
            if($nuevo_registro)
            {
                error_log('NEW Actualizacion_Api ID = ' . $new_objetivo_id);
            }
            $this->setRecord($objetivo_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }

    //Modifica el objetivo con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("Actualizacion_Api::modificar");
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $objetivo_record= &$this->objetivo_record;
            $arreglo_datos = $objetivo_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }
        $conn->commit();

        return true;
    }

    public static function revisarTimestamp($id_tabla, $diferencia_permitida){
        $query = "SELECT TIME_TO_SEC( TIMEDIFF( CURRENT_TIMESTAMP, fecha_actualizacion ) ) diff
                  FROM ia_actualizaciones_api
                  WHERE id = $id_tabla";
        try{
            $conn = Doctrine_Manager::connection();
            $vals = $conn->fetchAll($query);
            $diferencia_en_segundos = $vals[0]["diff"];
            if ($diferencia_en_segundos < $diferencia_permitida) {
                $return = true;
            }else{
                $return = false;
            }
        }
        catch(Exception $e){
            $return = false;
        }
        return $return;
    }
} 