<?php


/**
 * Class GeneradorHTMLTablaAsignacionColaboradoresAObjetivosDeInspeccion
 *
 * Modelo que se encarga de generar la tabla de dsitribucion de objetivos por colaboradores de una region
 */
class GeneradorHTMLTablaAsignacionColaboradoresAObjetivosDeInspeccion extends DAOInit
{
    public function __construct(){
        parent::__construct();
        Zend_Loader::loadClass('TableUtil');
    }

    /**
     *
     * @param $tablaTipoEstablecimiento
     * @param $tablaperiodoObjetivos
     * @param $orderBy
     * @param $periodo
     * @return array
     */
    public function getRegistrosTabla($tablaTipoEstablecimiento,$tablaperiodoObjetivos,$colaboradores, $orderBy,$region,$periodo){
        $tableUtil = new TableUtil($tablaTipoEstablecimiento);
        $tableUtil2 = new TableUtil($tablaperiodoObjetivos);
        $tableUtil3 = new TableUtil($colaboradores);
        $colaboradoresarray= $tableUtil3->getRows(" inspector=1 AND  (id_region='".$region."'  OR administrador_central=1 )"); // solo los inspectores de esa region
        $registros = $tableUtil->getRows("habilitado=1",$orderBy);
        $items = array();
        foreach($registros as $establecimiento){
            $item =  array();
            $item["id"] = $establecimiento['id'];
            $item["nombre"] = $establecimiento['nombre'];
            $tupla_periodo_Actual = $tableUtil2->getRows("anio='".$periodo." ' AND tipoestablecimiento_id=".$establecimiento['id']." AND region_id=".$region." AND parent_id is not null" );
            $item["id_padre"] = $tupla_periodo_Actual[0]['id'];
            $item["sin_distribuir"] = (int)$tupla_periodo_Actual[0]["meta_actual"]- (int)$tupla_periodo_Actual[0]["meta_especificos"];
            foreach($colaboradoresarray as $colaborador){
                $tupla_Actual = $tableUtil2->getRows("anio='".$periodo." ' AND tipoestablecimiento_id=".$establecimiento['id']." AND region_id=".$region." AND parent_id=". $item["id_padre"]." AND colaborador_id=".$colaborador['id']);
                $item[$colaborador['nombre']."_id"]=$tupla_Actual[0]["id"];
                $item[$colaborador['nombre']]=0;
                If($tupla_Actual[0]["meta_actual"]!="") {
                    $item["sin_distribuir"]-=(int)$tupla_Actual[0]["meta_actual"];
                    $item[$colaborador['nombre']]=$tupla_Actual[0]["meta_actual"];
                }
            }

            $items[] = $item;
        }
        return $items;
    }

    public function generarHTMLPrimerafilaFila($region){
        $tableUtil3 = new TableUtil("DAOIaColaboradores");
        $colaboradoresarray=  $tableUtil3->getRows(" inspector=1 AND  (id_region='".$region."'  OR administrador_central=1 )");
        $fila="<thead><tr><th></th>";
        foreach($colaboradoresarray as $item){
            if($item["administrador_central"]){
                $fila.="<th style ='height: 75px;'><div class='rotar_letra' style='width: 63px;'>* ". $item["nombre"]."</div></th>";
            }else{
                $fila.="<th style ='height: 75px;'><div class='rotar_letra' style='width: 63px;'>". $item["nombre"]."</div></th>";

            }

        }
        $fila.=  "<th>Sin asignar</th> </tr></thead>";
        return $fila;

    }

    public function generarHTMLFilasObjetivos($items,$region){
        $arreglo_filas = array();
        foreach($items as $item){
            $arreglo_filas [] = $this->generarHTMLFilaObjetivo($item,$region);
        }
        return $arreglo_filas;

    }

    private function generarHTMLFilaObjetivo($infoFila,$region){
        $sufijo ="fila_". $infoFila["id"];
        $nombreObjetivo = $infoFila["nombre"];
        $filaobjetivo= "<tr id='".$sufijo."'><td class=''>".$nombreObjetivo."</td>";
        $tableUtil3 = new TableUtil("DAOIaColaboradores");
        $colaboradoresarray=  $tableUtil3->getRows(" inspector=1 AND  (id_region='".$region."'  OR administrador_central=1 )");
        foreach($colaboradoresarray as $item){
            $idcampo=$infoFila[$item["nombre"]."_id"]."_".$infoFila["id"]."_".$item["id"]."_".$infoFila["id_padre"] ;// [odjectivo_id]_[tipo_establecimiento_id]_[colaborador_id ]_[parentid]
            $filaobjetivo.= "<td> <input type='number' min='0' class='entrada' style='width: 40px; height: 18px;' id='".$idcampo."' name='".$idcampo."' title='".$infoFila[$item["nombre"]]."' value='".$infoFila[$item["nombre"]]."' ></td>";// hay que ver como se ve el number en IE // le guarde el valor tambeine en tible para ayudarme a la hora de hacer usar js
        }
        $filaobjetivo.= "<td style='width:64px' class='letraresultado'><label id='".$infoFila["id"]."'>".$infoFila["sin_distribuir"]."</label></td></tr>";
        return $filaobjetivo;
       // return "<tr id='".$sufijo."'><td class='alineado-derecha'>".$nombreObjetivo."</td><td>".$asignadosPeriodoAnterior."</td><td>".$porcentajeCumplimientoAnterior."</td><td>".$ejecutadosPeriodoActual."</td><td><input class='asignados' type='text' value='".$asignados."'></td><td><input class='meta-especificos' type='text' value='".$objetivosEspecificos."'></td><td style='width:64px'><div><div title='Guardar' class='div-guardarObj'></div><div title='Específicos' class='div-Objespecificos'></div></div></td></tr>";
    }


public function transponer($items){
    $nuevos_items= array();
    foreach($items as $item){
        foreach($item as $item2){
            $nuevos_items[$item2][$item]=$item2;
        }
    }
 return$nuevos_items;
}


} 