<?php
/**
 * Created by PhpStorm.
 * User: jrojas
 * Date: 2/7/14
 * Time: 10:46 AM
 */

class ObjetivosAuditoriaInspeccion extends DAOInit {

    private $objetivo;
    public function __construct($ObjetivoID){
         parent::__construct();
        $this->objetivo_record = NULL;
        $this->objetivo = array();
        if(isset($ObjetivoID) && $ObjetivoID != null && $ObjetivoID >= 0){
            try{
                //cargar objetivo
                $q = Doctrine_Query::create()
                    ->from('DAOIaPeriodoobjetivosauditoriainspeccion o')
                    ->where("o.id = $ObjetivoID");
                $objetivo_record = $q->fetchOne();
                $objetivoCargado = false;
                if($objetivo_record != null && isset($objetivo_record))
                {
                    if($objetivo_record->exists())
                    {
                        $objetivoCargado = true;
                    }
                }
                if (!$objetivoCargado)
                {
                    error_log("NO Objetivo Cargado");
                    $objetivo_record = new DAOIaPeriodoobjetivosauditoriainspeccion();
                    $this->setRecord($objetivo_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Objetivo Cargado");
                    $this->setRecord($objetivo_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $objetivo_record = new DAOIaPeriodoobjetivosauditoriainspeccion();
                $this->setRecord($objetivo_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }

    }


    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->objetivo_record->toArray();
        return $fields;
    }


    public function existe()
    {
        return $this->objetivo_record->exists();
    }


    public function setRecord(&$Record)
    {
        error_log("Objetivo::setRecord");
        if(!is_null($this->objetivo_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->objetivo_record))
            {
                error_log("setRecord:: Record is not the same type as objetivo_record");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->objetivo_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }


    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("Objetivo::salvar");
        try
        {
            $nuevo_registro = false;
            if(! $this->existe() )
            {
                $nuevo_registro = true;
            }

            $objetivo_record = &$this->objetivo_record;

            $arreglo_datos = $objetivo_record->toArray();
            foreach($arreglo_datos as $key=>$value) //todo no parece necesario
            {
                switch($key)
                {
                    default:
                        $objetivo_record->{$key} = $this->{$key};
                        break;
                }
            }
            $objetivo_record->save();
            $new_objetivo_id = $objetivo_record['id'];
            if($nuevo_registro)
            {
                error_log('NEW SOLICITUD ID = ' . $new_objetivo_id);
            }
            $this->setRecord($objetivo_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }

    //Modifica el objetivo con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("Objetivo::modificar");
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $objetivo_record= &$this->objetivo_record;
            $arreglo_datos = $objetivo_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }
        $conn->commit();

        return true;
    }
} 