<?php
/*
*/
class GroupMembership extends DAOInit
{
    private $membership;

    public function __construct($UserID= NULL)
    {
        parent::__construct();
        $this->membership_record = NULL;
        $this->membership = array();
        error_log("UserID=$UserID");
        if(isset($UserID) && $UserID != null && $UserID >= 0)
        {
            try
            {
                //Cargar Solicitante.
                $q = Doctrine_Query::create()
                    ->from('DAOZkGroupMembership s')
                    ->where("s.pn_uid = $UserID");
                $membership_record = $q->fetchOne();
                $membershipCargado = false;
                if($membership_record != null && isset($membership_record))
                {
                    if($membership_record->exists())
                    {
                        $membershipCargado = true;
                    }
                }
                if ( !$membershipCargado)
                {
                    error_log("NO Membership Cargado");
                    $membership_record = new DAOZkGroupMembership();
                    $this->setRecord($membership_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Membership Cargado");
                    $this->setRecord($membership_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $membership_record = new DAOZkGroupMembership();
                $this->setRecord($membership_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
    }

    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->membership_record->toArray();

        $membership_fields = $this->membership_record->toArray();

        //Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
        $fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
        $fields['fecha_actualizacion'] = $this->MySQLDate2SpanishDate($fields['fecha_actualizacion']);

        $membership_fields['pn_uid'] = $membership_fields['pn_uid'];
        unset($membership_fields['pn_uid']);

        return array_merge($fields, $membership_fields);
    }

    public function existe()
    {
        return $this->membership_record->exists();
    }

    private function MySQLDate2SpanishDate($StrMySQLDate)
    {
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }

    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }

    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }

    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("Membership::salvar");
        try
        {
            $this->fecha_actualizacion= date('Y-m-d H:i:s');
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
                $this->usuarios_creacion_id = pnUserGetVar('uid');
                $this->usuario_creacion = pnUserGetVar('uname',$this->usuarios_creacion_id);
            }
            $this->ultima_modificacion_usuario_id = pnUserGetVar('uid');
            $this->usuario_modificacion = pnUserGetVar('uname',$this->ultima_modificacion_usuario_id);

            $membership_record = &$this->membership_record;
            $arreglo_datos = $membership_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                switch($key)
                {
                    case 'fecha_actualizacion':
                        $membership_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                        break;
                    case 'fecha_creacion':
                        $membership_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                        break;
                    default:
                        $membership_record->{$key} = $this->{$key};
                        break;
                }
            }
            $membership_record->save();
            $new_membership_id = $membership_record['pn_uid'];
            error_log('NEW MEMBERSHIP ID = ' . $new_membership_id);
            $this->setRecord($membership_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }

    //Modifica el solicitante con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("Membership::modificar");
        try
        {
            //protege de que vengan parametros fuera de los campos del Aplicante.

            $membership_record= &$this->membership_record;
            $arreglo_datos = $membership_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        case 'fecha_actualizacion':
                            $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                            break;
                        case 'fecha_creacion':
                            $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                            break;
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }

        return true;
    }

    //Establece un aplicante que recibe por parámetro.
    public function setRecord(&$Record)
    {
        error_log("Membership::setRecord");
        if(!is_null($this->membership_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->membership_record))
            {
                error_log("setRecord:: Record is not the same type as user");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->membership_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                case 'fecha_actualizacion':
                    $this->{$key} = $this->SpanishDate2MySQLDate($Record->{$key});
                    break;
                case 'fecha_creacion':
                    $this->{$key} = $this->SpanishDate2MySQLDate($Record->{$key});
                    break;
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }

    //Modifica el Anotacion con el arreglo de mapeo que recibe por parametro.
    public function eliminar($UserID)
    {
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $user_fields = $this->membership_record->toArray();
            if($UserID != $user_fields['pn_uid'])
            {
                return false;
            }

            /*  @MISSING@ Falta decidir qué revisiones realizar antes de permitir eliminar al solicitante, si tiene marcas, certificados, solicitudes en proceso, etc
            $campos = "ea.aplicacion_id as aplicacion_id";
            $select = "SELECT $campos FROM ra_Examen_Aplicacion as ea";
            $where = " WHERE ea.aplicacion_id=$AplicacionID AND ( ea.estado is not null AND ea.estado != 'Invitado' AND ea.estado != 'ErrorVerificacion' AND ea.estado != '')"; //Solo se eliminan aplicaciones invitadas , o que no tienen invitacion
            $orderby = '';
            $select .= " $where $orderby";
            error_log("SQL=$select");
            $results = Doctrine_Manager::connection()->fetchAll($select);

            $tiene_solicitudes_pendientes = false;
            foreach($results as $result)
            {
            $tiene_invitaciones_ejecutadas = true;
            }
            if(!$tiene_invitaciones_ejecutadas)
            {
            //protege de que vengan parametros fuera de los campos de la Temática.
            //$examen_record = &$this->examen_record;
            $this->aplicacion_record->{'eliminado'} = 'Sí';
            $this->aplicacion_record->save();
            $conn->commit();
            }
             */
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");

            return false;
        }

        return true;
    }
}