<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

class IndexController extends Zend_Controller_Action
{

    protected $version_actual;

	protected $_configparams;

	function __destruct() {
		$manager = Doctrine_Manager::getInstance();
		if($manager && !empty($manager)){
			$conns = $manager->getConnections();
			foreach ($conns as $conn) {
				$conn->close();
				//echo $conn->getName() . "";
			}
		}
	}

    /**
     * Inicializa el controlador, carga clases y modelos
     */
    public function init()
    {
		try
		{
			$controller = Zend_Controller_Front::getInstance();		
			$this->request = $controller->getRequest();

        /*    Zend_Loader::loadClass('DAOBaseAsset');
            Zend_Loader::loadClass('DAOAsset');
*/
            Zend_Loader::loadClass('DAOBaseIaTipoestablecimiento');
            Zend_Loader::loadClass('DAOIaTipoestablecimiento');

            Zend_Loader::loadClass('DAOBaseIaTipoanalisis');
            Zend_Loader::loadClass('DAOIaTipoanalisis');

            Zend_Loader::loadClass('DAOBaseIaAnalisislaboratorio');
            Zend_Loader::loadClass('DAOIaAnalisislaboratorio');

            Zend_Loader::loadClass('DAOBaseIaColaboradores');
            Zend_Loader::loadClass('DAOIaColaboradores');

            Zend_Loader::loadClass('DAOBaseRegion');
            Zend_Loader::loadClass('DAORegion');


            require_once(APPLICATION_PATH . "/models/DAOInit.php");
            Zend_Loader::loadClass('DAOInit');

            require_once(APPLICATION_PATH . "/models/PHPExcelHandler.php");
            Zend_Loader::loadClass('PHPExcelHandler');

            require_once(APPLICATION_PATH . "/models/GeneradorHTMLCombos.php");
            Zend_Loader::loadClass('GeneradorHTMLCombos');

            require_once(APPLICATION_PATH . "/models/Reportes.php");
            Zend_Loader::loadClass('Reportes');


            //$this->_configparams2 = Zend_Registry::get('options');

            $this->_archivostemporales = ZIKULA_PATH. $this->_configparams["reporter"]["temporaryfiles"];
            $this->_archivosplantillas = ZIKULA_PATH. $this->_configparams["reporter"]["plantillas"];//realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."modules". DIRECTORY_SEPARATOR . "zf_Reporte" . DIRECTORY_SEPARATOR  . "Plantillas_de_reportes");

        }
		catch(Exception $e)
		{
			error_log("Excepcion iniciando index: [$e]");
			echo("Excepcion iniciando index: [$e]");
		}
		
		$this->_configparams = Zend_Registry::get('options');
    }


    /**
     * Carga la página base inicial del módulo
     */
    public function indexAction(){

        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_IndexdeReportes.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }

    }


    /**
     * funcionde prueba para ver como llenar palntillas
     */
    public function pruebaAction(){
        try{
            $phpexcel = new PHPExcelHandler();
            $res = $phpexcel->prueba('prueba');
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }

    /**********************************************************************************************************************/
    /**********************************************************************************************************************/
    /*REPORTES*/
    /**********************************************************************************************************************/
    /**********************************************************************************************************************/



    /**
     * Muestra la pantalla del reporte PRUEBA
     *
     */
    function reportepruebaAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();
            $items = $combo->getRegistrosTablaBD($tabla = "DAORegion", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_region", $id = "filtro_region", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['combo_regiones'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_actividad", $id = "filtro_actividad", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['combo_actividad'] =$combo_html;


            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reportedeprueba.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }

    }

    /**
     * Se encarga de ejecutar el reporte prueba , con los filtros seleccionados
     *
     * lo que devuelve son todos los
     */
    public function execreportepruebaAction(){
        try{
            $filtro_filtro_fechainicio= $this->request->getParam('filtro_fechainicio');
            $filtro_fechafinal = $this->request->getParam('filtro_fechafinal');
            $filtro_region = $this->request->getParam('filtro_region');
            $filtro_actividad = $this->request->getParam('filtro_actividad');
            $consulta =Reportes::ConsultaReporteprueba($filtro_region,$filtro_actividad);// print_r($consulta, true);

            $keys = array_keys($consulta[0]); // echo $keys[0];// le sacamos los keys a la primera fila
            $columnas = array();
            foreach ($keys as $key){ $columnas[] = array('internal' => "$key", "display" => "$key");}

            $phpexcel = new PHPExcelHandler();
           // $res = $phpexcel->generarExcel('Reporte1',$columnas,$consulta, "TodasInspecciones_".date("Y-m-d") );
            $res = $phpexcel->GenerarExcelConPlantilla('Reporteprueba_'.date("Y-m-d"),'acuicola_reporte1.xlsx','A 13',$columnas, $consulta);
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }

    /**********************************************************************************************************************/
    /*REPORTE1*/

    /**
     * Muestra la pantalla del reporte 1
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reporteunoAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();
            $items = $combo->getRegistrosTablaBD($tabla = "DAORegion", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_region", $id = "filtro_region", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_region'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_actividad", $id = "filtro_actividad", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_actividad'] =$combo_html;

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;


            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte1.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }

    }

    /**
     * Se encarga de ejecutar el reporte 1 , con los filtros seleccionados
     */
    public function execreporteunoAction(){
        try{
            $filtro_filtro_fechainicio= $this->request->getParam('filtro_fechainicio');
            $filtro_fechafinal = $this->request->getParam('filtro_fechafinal');
            $filtro_region = $this->request->getParam('filtro_region');
            $filtro_actividad = $this->request->getParam('filtro_actividad');
            $filtro_periodo = $this->request->getParam('filtro_periodo');

            $consulta =Reportes::ConsultaReporte1($filtro_region,$filtro_actividad,$filtro_periodo);// print_r($consulta, true);

            $keys = array_keys($consulta[0]); // echo $keys[0];// le sacamos los keys a la primera fila
            $columnas = array();
            foreach ($keys as $key){ $columnas[] = array('internal' => "$key", "display" => "$key");}

            $datosencabezado=array();
            $datosencabezado[]=array('posicion' => "A6", "valor" => "Fecha de consulta: ".Date('Y-m-d H:i:s') );
            $datosencabezado[]=array('posicion' => "A7", "valor" => "Región: $filtro_region" );
            $datosencabezado[]=array('posicion' => "A8", "valor" => "Cantón: " );
            $datosencabezado[]=array('posicion' => "A9", "valor" => "Cuadricula: " );
            $datosencabezado[]=array('posicion' => "E7", "valor" => "Provincia: " );
            $datosencabezado[]=array('posicion' => "E8", "valor" => "Distrito: " );
            $datosencabezado[]=array('posicion' => "A10", "valor" => "Periodo: $filtro_periodo" );
            $datosencabezado[]=array('posicion' => "A11", "valor" => "Actividad: $filtro_actividad" );

            $phpexcel = new PHPExcelHandler();
            $res = $phpexcel->GenerarExcelReporte('Reporte1_'.date("Y-m-d"),'acuicola_reporte1.xlsx',$datosencabezado,'A 13',$columnas, $consulta);
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }

    /**********************************************************************************************************************/
    /*REPORTE2*/

    /**
     * Muestra la pantalla del reporte 2
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reportedosAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte2.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }
    /**
     * Se encarga de ejecutar la consulta para el reporte 2 , ademas de llenar y guardar el excel con la informacion, con los filtros seleccionados
     */
    public function execreportedosAction(){
        try{
            $filtro_establecimiento = $this->request->getParam('filtro_establecimiento');
            $filtro_establecimiento_a = explode("::",$filtro_establecimiento);
            $filtro_periodo = $this->request->getParam('filtro_periodo');
            $consulta=array();
            $consulta =Reportes::ConsultaReporte2($filtro_periodo,$filtro_establecimiento_a[0]);// print_r($consulta, true);

            $keys = array_keys($consulta[0]); // echo $keys[0];// le sacamos los keys a la primera fila
            $columnas = array();
            foreach ($keys as $key){ $columnas[] = array('internal' => "$key", "display" => "$key");}

            $datosencabezado=array();
            $datosencabezado[]=array('posicion' => "A6", "valor" => "Fecha de consulta: ".Date('Y-m-d H:i:s') );
            $datosencabezado[]=array('posicion' => "A7", "valor" => "Región: " );
            $datosencabezado[]=array('posicion' => "A8", "valor" => "Cantón: " );
            $datosencabezado[]=array('posicion' => "A9", "valor" => "Cuadricula: " );
            $datosencabezado[]=array('posicion' => "E7", "valor" => "Provincia: " );
            $datosencabezado[]=array('posicion' => "E8", "valor" => "Distrito: " );
            $datosencabezado[]=array('posicion' => "A10", "valor" => "Periodo: $filtro_periodo" );
            $datosencabezado[]=array('posicion' => "A11", "valor" => "Establecimiento: $filtro_establecimiento" );

            $phpexcel = new PHPExcelHandler();
            $res = $phpexcel->GenerarExcelReporte('Reporte2_'.date("Y-m-d"),'acuicola_reporte2.xlsx',$datosencabezado,'A 13',$columnas, $consulta,false);
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }






    /**********************************************************************************************************************/
    /*REPORTE3*/

    /**
     * Muestra la pantalla del reporte 3
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reportetresAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte3.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }



    /**********************************************************************************************************************/
    /*REPORTE4*/

    /**
     * Muestra la pantalla del reporte 4
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reportecuatroAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAORegion", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_region", $id = "filtro_region", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_region'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_actividad", $id = "filtro_actividad", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_actividad'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte4.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }

    /**
     * Se encarga de ejecutar el reporte 9 , con los filtros seleccionados
     */
    public function execreportecuatroAction(){
        try{
            $filtro_establecimiento = $this->request->getParam('filtro_establecimiento');
            $filtro_establecimiento_a = explode("::",$filtro_establecimiento);
            $filtro_region = $this->request->getParam('filtro_region');
            $filtro_actividad = $this->request->getParam('filtro_actividad');
            $filtro_periodo = $this->request->getParam('filtro_periodo');

            $consulta =Reportes::ConsultaReporte4($filtro_region,$filtro_actividad,$filtro_periodo,$filtro_establecimiento_a[0]);// print_r($consulta, true);

            $keys = array_keys($consulta[0]); // echo $keys[0];// le sacamos los keys a la primera fila
            $columnas = array();
            foreach ($keys as $key){ $columnas[] = array('internal' => "$key", "display" => "$key");}

            $datosencabezado=array();
            $datosencabezado[]=array('posicion' => "A6", "valor" => "Fecha de consulta: ".Date('Y-m-d H:i:s') );
            $datosencabezado[]=array('posicion' => "A7", "valor" => "Región: $filtro_region" );
            $datosencabezado[]=array('posicion' => "A8", "valor" => "Cantón: " );
            $datosencabezado[]=array('posicion' => "A9", "valor" => "Cuadricula: " );
            $datosencabezado[]=array('posicion' => "E7", "valor" => "Provincia: " );
            $datosencabezado[]=array('posicion' => "E8", "valor" => "Distrito: " );
            $datosencabezado[]=array('posicion' => "A10", "valor" => "Periodo: $filtro_periodo" );
            $datosencabezado[]=array('posicion' => "A11", "valor" => "Actividad: $filtro_actividad" );
            $datosencabezado[]=array('posicion' => "A12", "valor" => "Establecimiento: $filtro_establecimiento" );

            $phpexcel = new PHPExcelHandler();
            $res = $phpexcel->GenerarExcelReporte('Reporte4_'.date("Y-m-d"),'acuicola_reporte1.xlsx',$datosencabezado,'A 13',$columnas, $consulta,'Reporte de no conformidades por item ');
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }


    /**********************************************************************************************************************/
    /*REPORTE5*/

    /**
     * Muestra la pantalla del reporte 5
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reportecincoAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAORegion", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_region", $id = "filtro_region", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_region'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_actividad", $id = "filtro_actividad", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_actividad'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte5.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }



    /**
     * Se encarga de ejecutar el reporte 5 , con los filtros seleccionados
     */
    public function execreportecincoAction(){
        try{
            $filtro_establecimiento = $this->request->getParam('filtro_establecimiento');
            $filtro_establecimiento_a = explode("::",$filtro_establecimiento);
            $filtro_region = $this->request->getParam('filtro_region');
            $filtro_actividad = $this->request->getParam('filtro_actividad');
            $filtro_periodo = $this->request->getParam('filtro_periodo');

            $consulta =Reportes::ConsultaReporte5($filtro_region,$filtro_actividad,$filtro_periodo);// print_r($consulta, true);

            $keys = array_keys($consulta[0]); // echo $keys[0];// le sacamos los keys a la primera fila
            $columnas = array();
            foreach ($keys as $key){ $columnas[] = array('internal' => "$key", "display" => "$key");}

            $datosencabezado=array();
            $datosencabezado[]=array('posicion' => "A6", "valor" => "Fecha de consulta: ".Date('Y-m-d H:i:s') );
            $datosencabezado[]=array('posicion' => "A7", "valor" => "Región: $filtro_region" );
            $datosencabezado[]=array('posicion' => "A8", "valor" => "Cantón: " );
            $datosencabezado[]=array('posicion' => "A9", "valor" => "Cuadricula: " );
            $datosencabezado[]=array('posicion' => "E7", "valor" => "Provincia: " );
            $datosencabezado[]=array('posicion' => "E8", "valor" => "Distrito: " );
            $datosencabezado[]=array('posicion' => "A10", "valor" => "Periodo: $filtro_periodo" );
            $datosencabezado[]=array('posicion' => "A11", "valor" => "Actividad: $filtro_actividad" );
            $datosencabezado[]=array('posicion' => "A12", "valor" => "Establecimiento: $filtro_establecimiento" );

            $phpexcel = new PHPExcelHandler();
            $res = $phpexcel->GenerarExcelReporte('Reporte5_'.date("Y-m-d"),'acuicola_reporte1.xlsx',$datosencabezado,'A 13',$columnas, $consulta,'Ultimo informe realizado por actividad y por establecimientos ');
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }

    /**********************************************************************************************************************/
    /*REPORTE6*/

    /**
     * Muestra la pantalla del reporte 6
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reporteseisAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte6.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }




    /**********************************************************************************************************************/
    /*REPORTE7*/

    /**
     * Muestra la pantalla del reporte 7
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reportesieteAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte7.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }
    /**********************************************************************************************************************/
    /*REPORTE8*/

    /**
     * Muestra la pantalla del reporte 8
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reporteochoAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte8.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }


    /**********************************************************************************************************************/
    /*REPORTE9*/

    /**
     * Muestra la pantalla del reporte 9
     * esta presenta una pequeña explicacion acerca de el reporte y tambien permite la escogencia de los filtros para la consulta
     */
    function reportenueveAction(){
        try{
            /*if (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) {
                return permisosinvalidos($this->view);//return pnVarPrepHTMLDisplay(_MODULENOAUTH);
            }*/
            $vars = array();
            $combo=new GeneradorHTMLCombos();

            $items = $combo->getRegistrosperiodos(2013);
            $combo_html = $combo->generarHTMLCombo($name = "filtro_periodo", $id = "filtro_periodo", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_periodo'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAORegion", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_region", $id = "filtro_region", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_region'] =$combo_html;

            $items = $combo->getRegistrosTablaBD($tabla = "DAOIaTipoestablecimiento", $select = "", $ordebBy = "nombre", $value = "id", $text = "nombre");
            $combo_html = $combo->generarHTMLCombo($name = "filtro_actividad", $id = "filtro_actividad", $items, $opcionSeleccione = true, $extra = " class='inputmantenimiento2' style='width: 200px;'", false);
            $vars['filtro_actividad'] =$combo_html;

            $this->view->assignOld($vars);
            $temp_file = 'Reporte_user_Reporte9.htm';
            $smarty = $this->view->getEngine();
            $smarty->force_compile = true;
            $m_html = $this->view->render($temp_file);
            Zend_Registry::set('response', $m_html);

        }catch(Exception $ee){
            echo "$ee"; die;
        }
    }


    /**
     * Se encarga de ejecutar el reporte 9 , con los filtros seleccionados
     */
    public function execreportenueveAction(){
        try{
            $filtro_establecimiento = $this->request->getParam('filtro_establecimiento');
            $filtro_establecimiento_a = explode("::",$filtro_establecimiento);
            $filtro_region = $this->request->getParam('filtro_region');
            $filtro_actividad = $this->request->getParam('filtro_actividad');
            $filtro_periodo = $this->request->getParam('filtro_periodo');

            $consulta =Reportes::ConsultaReporte9($filtro_region,$filtro_actividad,$filtro_periodo,$filtro_establecimiento_a[0]);// print_r($consulta, true);

            $keys = array_keys($consulta[0]); // echo $keys[0];// le sacamos los keys a la primera fila
            $columnas = array();
            foreach ($keys as $key){ $columnas[] = array('internal' => "$key", "display" => "$key");}

            $datosencabezado=array();
            $datosencabezado[]=array('posicion' => "A6", "valor" => "Fecha de consulta: ".Date('Y-m-d H:i:s') );
            $datosencabezado[]=array('posicion' => "A7", "valor" => "Región: $filtro_region" );
            $datosencabezado[]=array('posicion' => "A8", "valor" => "Cantón: " );
            $datosencabezado[]=array('posicion' => "A9", "valor" => "Cuadricula: " );
            $datosencabezado[]=array('posicion' => "E7", "valor" => "Provincia: " );
            $datosencabezado[]=array('posicion' => "E8", "valor" => "Distrito: " );
            $datosencabezado[]=array('posicion' => "A10", "valor" => "Periodo: $filtro_periodo" );
            $datosencabezado[]=array('posicion' => "A11", "valor" => "Actividad: $filtro_actividad" );
            $datosencabezado[]=array('posicion' => "A12", "valor" => "Establecimiento: $filtro_establecimiento" );

            $phpexcel = new PHPExcelHandler();
            $res = $phpexcel->GenerarExcelReporte('Reporte9_'.date("Y-m-d"),'acuicola_reporte1.xlsx',$datosencabezado,'A 13',$columnas, $consulta,'Resumen de observaciones por informe de inspección / Auditoría');
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }




















    /**
     * Permite al usuario descargar un archivo de reporte XLSX previamente generado recibido como parámetro
     * @param fid Ruta del archivo que se desea descargar
     */
    public function imprimirexcelAction(){
        /* if ( !(pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_READ)  ) &&
             (!pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_ADMIN)) &&
             !(pnSecAuthAction(0, 'zf_Reports::', '::', ACCESS_EDIT)  )
         ) {
             return pnVarPrepHTMLDisplay(_MODULENOAUTH);
         }*/

        $fid = FormUtil::getPassedValue('fid');//$_REQUEST['hijo'];
        if(empty($fid))
            $fid = $this->request->getParam('fid');
        if(empty($fid))
            $fid = $$_REQUEST['fid'];

        $filename = $this->_archivostemporales .'/'. $fid . ".xlsx";
        $file = $filename;
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename='.basename($file));
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file));

        ob_clean();
        flush();
        readfile($file);
        die;

    }
}

