<?php
require_once("IndexController.php");
class PopupController extends IndexController
{


    function __destruct() {
        $manager = Doctrine_Manager::getInstance();
        if($manager && !empty($manager)){
            $conns = $manager->getConnections();
            foreach ($conns as $conn) {
                $conn->close();
                //echo $conn->getName() . "";
            }
        }
    }
    public function init()
    {
        /*require_once('Addax/View/Adapter/Smarty.php');
        $this->view = new Addax_View_Adapter_Smarty();
		$this->view->setTemplatePath(APPLICATION_PATH . '/templates/smarty/prueba');
		$this->view->setCompilePath(ZIKULA_PATH . '/pnTemp/zfSmarty_compiled');
		$this->view->setCachePath(ZIKULA_PATH . '/pnTemp/zfSmarty_cache');
        $this->_helper->viewRenderer->setNoRender();
		*/
        parent::init();

        Zend_Loader::loadClass('PHPExcelHandler');

        $this->_archivostemporales = ZIKULA_PATH. $this->_configparams["reporter"]["temporaryfiles"];
        $this->_archivosplantillas = ZIKULA_PATH. $this->_configparams["reporter"]["plantillas"];//realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."modules". DIRECTORY_SEPARATOR . "zf_Reporte" . DIRECTORY_SEPARATOR  . "Plantillas_de_reportes");

    }


    /**
     * Genera un reporte en XLSX de los datos faltantes en el sistema para la versión que se recibe como parametro
     * @param version Versión de datos para la cual se desea generar el reporte de Datos Faltantes
     * @return JSON indicando resultado de la operación y en caso de ser exitosa, la ruta del archivo generado, en caso de error, el mensaje de error respectivo
     */
    public function generarxlsreporteAction(){
        try{
            $phpexcel = new PHPExcelHandler();
            $version = FormUtil::getPassedValue('version');
            $resultados = GeneradorHTMLCombos::getDatosFaltantes($version);

            $columnas = array();
            $columnas[] = array('internal' => "Servicio", "display" => "Servicio");
            $columnas[] = array('internal' => "Operador", "display" => "Operador");
            $columnas[] = array('internal' => "Clasificacion", "display" => "Clasificación");
            $columnas[] = array('internal' => "Cumplimiento", "display" => "Cumplimiento");
            $columnas[] = array('internal' => "Periodo", "display" => "Período Faltante");

            $res = $phpexcel->generarExcel('Titulo',$columnas,$resultados,$version);
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }

    /**
     * Genera un array multidimensional con la información de datos de cumplimiento para los operadores del servicio que se recibe como parámetro
     * @param servicio Identificador del servicio para el cual se desean obtener los datos de cumplimientos en el sistema
     * @return array multidimensional con la informacion de datos de cumplimiento para los operadores del servicio solicitado o false en caso de error
     */
    public function getDatosServicioArray($servicio)
    {
        $datos = array();
        try
        {
            $consulta = "SELECT c.id cumplimiento, o.nombre operador, d.periodo, d.valor from Dato d, Servicio s, Operador o, Cumplimiento c ";
            $consulta = $consulta . "where s.id=" . $servicio . " and c.servicio_id=s.id and c.id=d.cumplimiento_id and o.servicio_id=s.id and o.id=d.operador_id ";
            $consulta = $consulta . " order by c.nombre, o.nombre, periodo DESC";

            $dcon = Doctrine_Manager::connection();
            $datos = $dcon->fetchAll( $consulta );
            $resultado = array();

            $i = 0;
            $cumplimiento_actual = $datos[$i]["cumplimiento"];
            while($i<count($datos)){
                $cumplimiento_id = $datos[$i]["cumplimiento"];
                $cumplimiento = new Cumplimiento($cumplimiento_id);
                $cumplimiento = $cumplimiento->toArray();
                $resultado[$cumplimiento_id] = array();
                $resultado[$cumplimiento_id]['nombre'] = $cumplimiento['nombre'];
                $resultado[$cumplimiento_id]['tipo_periodo'] = $cumplimiento['tipo_periodo'];
                $resultado[$cumplimiento_id]['umbral'] = $cumplimiento['umbral'];
                $resultado[$cumplimiento_id]['cantidad_periodos_comparativo'] = $cumplimiento['cantidad_periodos_comparativo'];
                $resultado[$cumplimiento_id]['texto_ayuda'] = $cumplimiento['texto_ayuda'];
                $periodos = array();
                $resultado[$cumplimiento_id]["datos"] = array();
                $operador_actual = "";
                while($cumplimiento_id==$datos[$i]["cumplimiento"]){
                    $operador = $datos[$i]["operador"];
                    if($operador!=$operador_actual){
                        $operador_actual = $operador;
                        $resultado[$cumplimiento_id]["datos"][$operador_actual] = array();
                    }
                    $resultado[$cumplimiento_id]["datos"][$operador_actual][$datos[$i]["periodo"]] = $datos[$i]["valor"];
                    $periodos[$datos[$i]["periodo"]] = $datos[$i]["periodo"];
                    $i++;
                }
                rsort($periodos);
                $resultado[$cumplimiento_id]['periodos'] = $periodos;
            }
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            return false;
        }
        return $resultado;
    }

    /**
     * Genera un reporte en XLSX con la lista de operadores y servicios en el sistema para la versión que se recibe como parametro
     * @param version Versión de datos para la cual se desea generar el reporte de Operadores y Servicios
     * @return JSON indicando resultado de la operación y en caso de ser exitosa, la ruta del archivo generado, en caso de error, el mensaje de error respectivo
     */
    public function generarxlslistadoAction(){
        try{
            $phpexcel = new PHPExcelHandler();
            $version = 200;
            $servicios = array();
            $servicios[] = 'servisio1';
            $servicios[] = 'servisio2';

            $operadores = array();
            $operadores[] = 'operador1';

            $columnasOperador = array();
            $columnasOperador[] = array('internal' => "Servicio", "display" => "Servicio");
            $columnasOperador[] = array('internal' => "Operador", "display" => "Operador");

            $res = $phpexcel->generarExcel4('Servicios-Operadores (' . $version . ')',$servicios,$columnasOperador,$operadores);
            $filenoext = basename($res,".xlsx");
            $retorno = array("result" => true, "fid" => $filenoext);
            echo json_encode($retorno);
            die;
        }
        catch (Exception $ee){
            $retorno = array("result" => false, "error" => $ee->getMessage());
            echo json_encode($retorno);die;
        }
    }



}
?>
