<?php
/*
*/
//set_include_path(realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."includes". DIRECTORY_SEPARATOR . "classes" . DIRECTORY_SEPARATOR . "PHPExcel") . PATH_SEPARATOR . get_include_path());
$directorioPHPExcel = realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."includes". DIRECTORY_SEPARATOR . "classes" . DIRECTORY_SEPARATOR . "PHPExcel");


require_once($directorioPHPExcel . DIRECTORY_SEPARATOR . "PHPExcel.php");
require_once($directorioPHPExcel .  DIRECTORY_SEPARATOR . "PHPExcel" .DIRECTORY_SEPARATOR . "Writer".DIRECTORY_SEPARATOR."Excel2007.php");


class PHPExcelHandler
{
    private $marca_solicitante;
    private $_archivostemporales;
    private $directorioplantillasExcel;


    public function __construct()
    {

        //Incluir el PHPEXCEL
        $this->_configparams = Zend_Registry::get('options');

        $this->_archivostemporales = ZIKULA_PATH. $this->_configparams["reporter"]["temporaryfiles"];
        $this->_archivosplantillas = ZIKULA_PATH. $this->_configparams["reporter"]["plantillas"];//realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."modules". DIRECTORY_SEPARATOR . "zf_Reporte" . DIRECTORY_SEPARATOR  . "Plantillas_de_reportes");

    }


    /**prueba de modificacion de plantilla de excel
     * @param $filename
     * @return mixed
     */
    public function  prueba($filename){
        $inputFileName =  $this->_archivosplantillas. DIRECTORY_SEPARATOR.'acuicola_reporte_prueba.xlsx';// nombre y ubicacion de la plantillas
        $objReader = PHPExcel_IOFactory::createReader('Excel2007');
        $objPHPExcel = $objReader->load($inputFileName);

        $objPHPExcel->getActiveSheet()->SetCellValue('A25', 'HHHHola esta es una prueba de modificacion ');

        $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'Fecha de consulta: '. Date('Y-m-d H:i:s'));
        $outputFileType = 'Excel2007';
        $outputFileName = $this->_archivostemporales . DIRECTORY_SEPARATOR.$filename.'.xlsx';
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, $outputFileType);

        $objWriter->save($outputFileName);
        return $filename;

}

    /**
     * feuncion que sirve para generar el docuemnto usando la plantilla especificada con los datos enviados
     * @param string $nombre_archivo_final
     * @param string $nombre_de_plantilla
     * @param string $celda_de_inicio_de_tabla , el nombre de la celda tiene que esta separado por un espacio
     * @param $ColumnasNombres
     * @param $Arraydatosasociativo
     * @return string
     */
    public function  GenerarExcelConPlantilla($nombre_archivo_final='Reporte',$nombre_de_plantilla='acuicola_reporte_prueba.xlsx',$celda_de_inicio_de_tabla='A 13',$ColumnasNombres, $Arraydatosasociativo){
        $inputFileName =  $this->_archivosplantillas. DIRECTORY_SEPARATOR.$nombre_de_plantilla;// nombre y ubicacion de la plantillas
        $objReader = PHPExcel_IOFactory::createReader('Excel2007');
        $objPHPExcel = $objReader->load($inputFileName);

        $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'Fecha de consulta: '. Date('Y-m-d H:i:s'));

        $celdainicio=explode(" ",$celda_de_inicio_de_tabla); // el nombre de la celda tiene que esta separado por un espacio
        $letra = $celdainicio[0];
        $fila = $celdainicio[1];

        $styleArray1 = array(
            'borders' => array(
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THICK ),
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THICK )
            )
        );
        $styleArray2 = array(
            'borders' => array(
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOTTED)
            )
        );
        $styleArray3 = array(
            'borders' => array(
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THICK )
            )
        );

        foreach($ColumnasNombres as $key =>$columna){// pone los nombres de las columans
            $displayname = $columna["display"];
            $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $displayname);
            $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->applyFromArray($styleArray1);
            $letra++;
        }
        $fila++;
        $letra = $celdainicio[0];
        $filainit = $fila;
        foreach($ColumnasNombres as $key =>$columna){// llena la tabla con la info de los array
            $internalname = $columna["internal"];
            $fila = $filainit;
            foreach ($Arraydatosasociativo as $datoactual) {
                $value = $datoactual[$internalname];
                if(array_key_exists("decode", $columna) ){
                    switch($columna["decode"]){
                        case "json":
                            $value = json_decode($value);
                            break;
                    }
                }
                $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $value . "");
                $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->applyFromArray($styleArray2);// borde punteado
                if (($fila % 2) == 0){// colorear filas pares
                    $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FBFFEF');
                }
                if ($datoactual === end($Arraydatosasociativo)){// pomer una linea guresa  en la ultima linea  para indicar final
                    $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->applyFromArray($styleArray3);
                }
                $fila++;
            }
            $letra++;
        }

        $outputFileType = 'Excel2007';
        $outputFileName = $this->_archivostemporales . DIRECTORY_SEPARATOR.$nombre_archivo_final.'.xlsx';
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, $outputFileType);
        $objWriter->save($outputFileName);
        return $nombre_archivo_final;
    }

/*****************************************************************************************************************************************/
//REPORTE ; como todas los formatos de las plantillas son similares con excepcion a 3 casos , este funcion se encarga de llenarlos de manera sencilla


    /**
     * @param $nombre_archivo_final
     * @param $nombre_de_plantilla
     * @param $Datos
     * @param $celda_de_inicio_de_tabla // tiene que venir con un espacio entre la letra y el numero
     * @param $ColumnasNombres
     * @param $Arraydatosasociativo
     * @param bool $tituloreporte
     * @return mixed
     */
    public function  GenerarExcelReporte($nombre_archivo_final,$nombre_de_plantilla,$Datos,$celda_de_inicio_de_tabla,$ColumnasNombres, $Arraydatosasociativo ,$tituloreporte=false){
        $inputFileName =  $this->_archivosplantillas. DIRECTORY_SEPARATOR.$nombre_de_plantilla;// nombre y ubicacion de la plantillas
        $objReader = PHPExcel_IOFactory::createReader('Excel2007');
        $objPHPExcel = $objReader->load($inputFileName);

        if($tituloreporte){// si trate el titulo se lo pone
            $objPHPExcel->getActiveSheet()->SetCellValue('B3', $tituloreporte);
            //$objPHPExcel->getActiveSheet()->mergeCells("B3:B7");
        }
        $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'Fecha de consulta: '. Date('Y-m-d H:i:s'));

        foreach($Datos as $dato){// llena los datos del array de datosextra o filtros, en cada una de los pociciones especificadas
            $objPHPExcel->getActiveSheet()->SetCellValue($dato['posicion'], $dato['valor']);
        }

        $celdainicio=explode(" ",$celda_de_inicio_de_tabla); // el nombre de la celda tiene que esta separado por un espacio
        $letra = $celdainicio[0];
        $fila = $celdainicio[1];

        $styleArray1 = array(
            'borders' => array(
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THICK ),
                'top' => array('style' => PHPExcel_Style_Border::BORDER_THICK )
            )
        );
        $styleArray2 = array(
            'borders' => array(
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_DOTTED)
            )
        );
        $styleArray3 = array(
            'borders' => array(
                'bottom' => array('style' => PHPExcel_Style_Border::BORDER_THICK )
            )
        );

        foreach($ColumnasNombres as $key =>$columna){// pone los nombres de las columans
            $displayname = $columna["display"];
            $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $displayname);
            $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->applyFromArray($styleArray1);
            $letra++;
        }
        $fila++;
        $letra = $celdainicio[0];
        $filainit = $fila;
        foreach($ColumnasNombres as $key =>$columna){// llena la tabla con la info de los array
            $internalname = $columna["internal"];
            $fila = $filainit;
            foreach ($Arraydatosasociativo as $datoactual) {
                $value = $datoactual[$internalname];
                if(array_key_exists("decode", $columna) ){
                    switch($columna["decode"]){
                        case "json":
                            $value = json_decode($value);
                            break;
                    }
                }
                if($value == null){$value = '-';}

                $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $value . "");
                $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->applyFromArray($styleArray2);// borde punteado
                if (($fila % 2) == 0){// colorear filas pares
                    $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('F1F1F1');
                }
                if ($datoactual === end($Arraydatosasociativo)){// pomer una linea guresa  en la ultima linea  para indicar final
                    $objPHPExcel->getActiveSheet()->getStyle($letra.''.$fila)->applyFromArray($styleArray3);
                }
                $fila++;
            }
            $letra++;
        }


        /*$S->setCellValue("I$row", "Total"); $S->setCellValue("J$row", "=SUM(J5:J".($row-1).")");*/

        $outputFileType = 'Excel2007';
        $outputFileName = $this->_archivostemporales . DIRECTORY_SEPARATOR.$nombre_archivo_final.'.xlsx';
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, $outputFileType);
        $objWriter->setPreCalculateFormulas(true);
        $objWriter->save($outputFileName);
        return $nombre_archivo_final;
    }




    /*
     * Genera un archivo XLSX con los datos de cumplimiento de operadores de u tipo de servicio
     * @param Servicio el nombre del tipo de servicio para el cual se están exportando los datos
     * @param Datos arreglo con los datos de operadores para diferentes períodos de cada cumplimiento del tipo de servicio
     * @return La ruta y nombre del archivo XLSX generado
     */
    public function generarExcel3($Servicio, $Datos){
        $filename = false;
        $nombresPeriodos = array("Mensual", "Bimestral", "Trimestral", "Cuatrimestral", "", "Semestral", "", "", "", "", "", "Anual");
        try{
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Addax Software");
            $objPHPExcel->getProperties()->setLastModifiedBy("Addax Software");
            $objPHPExcel->getProperties()->setTitle($Servicio);
            $objPHPExcel->getProperties()->setSubject($Servicio);
            $objPHPExcel->getProperties()->setDescription($Servicio);

            $hojaActual = 0;
            foreach ($Datos as $cumplimiento => $datosCumplimiento){
                if($hojaActual > 0){
                    $objPHPExcel->createSheet();
                }
                $objPHPExcel->setActiveSheetIndex($hojaActual);
                $nombreHoja = $datosCumplimiento['nombre'];
                //Hay un límite de 31 caracteres para los nombres de las hojas
                if(strlen($nombreHoja)>31){
                    $nombreHoja = substr($nombreHoja,0,31);
                }
                $objPHPExcel->getActiveSheet()->setTitle($nombreHoja);

                $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Servicio');
                $objPHPExcel->getActiveSheet()->SetCellValue('B1', $datosCumplimiento['servicio']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Cumplimiento');
                $objPHPExcel->getActiveSheet()->SetCellValue('B2', $datosCumplimiento['nombre']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A3', 'Clasificación');
                $objPHPExcel->getActiveSheet()->SetCellValue('B3', $datosCumplimiento['clasificacion']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A4', 'Periodicidad');
                $objPHPExcel->getActiveSheet()->SetCellValue('B4', $nombresPeriodos[$datosCumplimiento['tipoperiodo']-1]);
                $objPHPExcel->getActiveSheet()->SetCellValue('A5', 'Umbral Vigente');
                if(isset($datosCumplimiento['umbral'])){
                    $objPHPExcel->getActiveSheet()->SetCellValue('B5', $datosCumplimiento['umbral'] . '%');
                }
                $objPHPExcel->getActiveSheet()->SetCellValue('A6', 'Períodos Gráfico');
                $objPHPExcel->getActiveSheet()->SetCellValue('B6', $datosCumplimiento['cantidadperiodoscomparativo']);
                $objPHPExcel->getActiveSheet()->getStyle('B6')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                $objPHPExcel->getActiveSheet()->getStyle('B6')->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()->setARGB('FFFDEADA');
                $objPHPExcel->getActiveSheet()->SetCellValue('A7', 'Texto Ayuda');
                $objPHPExcel->getActiveSheet()->SetCellValue('B7', $datosCumplimiento['textoayuda']);
                $objPHPExcel->getActiveSheet()->SetCellValue('A8', 'Nota (opcional)');
                $objPHPExcel->getActiveSheet()->SetCellValue('B8', $datosCumplimiento['nota']);

                $objPHPExcel->getActiveSheet()->SetCellValue('A9', 'Operadores');
                $objPHPExcel->getActiveSheet()->getColumnDimension()->setAutoSize(true);
                //$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);

                $objPHPExcel->getActiveSheet()->getStyle('A:A')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->getStyle('9:9')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->getStyle('A:B')->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()->setARGB('FFFDEADA');
                $objPHPExcel->getActiveSheet()->getStyle('9:9')->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()->setARGB('FFFDEADA');


                //Periodos en orden descendente a partir de celda C9
                $precol = "";
                $col = "C";
                $fila = 9;
                $posPeriodos = array();
                for($i=0;$i<count($datosCumplimiento['periodos']);$i++){
                    $objPHPExcel->getActiveSheet()->SetCellValue($precol.$col.$fila, $datosCumplimiento['periodos'][$i]);
                    $posPeriodos[$datosCumplimiento['periodos'][$i]] = $precol.$col;
                    if($col=="Z"){
                        $col = "A";
                        if($precol == ""){
                            $precol = "A";
                        }
                        else{
                            $precol++;
                        }
                    }
                    else{
                        $col++;
                    }
                }

                //Operadores y sus datos
                foreach($datosCumplimiento['datos'] as $operador => $datosOperador){
                    $fila++;
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$fila, $operador);
                    $objPHPExcel->getActiveSheet()->mergeCells('A'.$fila.':B'.$fila);
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$fila)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                    foreach($datosOperador as $periodo =>$valor){
                        $objPHPExcel->getActiveSheet()->SetCellValue($posPeriodos[$periodo].$fila, $valor);
                    }
                }

                $hojaActual++;
            }
            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
            $filename = $this->_archivostemporales . $Servicio . time() . session_id() . ".xlsx";
            $objWriter->save($filename);

        }catch (Exception $ee){
            echo ("ERROR $ee");
        }


        return $filename;
    }


    /*
     * Genera un archivo XLSX con la información de entrada.  Se utiliza para el reporte de datos faltantes
     * @param Titulo es el nombre del documento, se asigna al titulo, tema y descripción del documento generado
     * @param Columnas arreglo con los nombres de la información de las columnas de datos
     * @param Arraydatosasociativo arreglo con los datos a insertar en las columnas respectivas
     * @param TituloSum especifica el nombre de la hoja de datos
     * @return La ruta y nombre del archivo XLSX generado
     */
    public function generarExcel($Titulo, $Columnas, $Arraydatosasociativo, $TituloSum = ""){
        $filename = false;
        try{
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getProperties()->setCreator("Addax Software");
            $objPHPExcel->getProperties()->setLastModifiedBy("Addax Software");
            $objPHPExcel->getProperties()->setTitle($Titulo);
            $objPHPExcel->getProperties()->setSubject($Titulo);
            $objPHPExcel->getProperties()->setDescription($Titulo);

            $objPHPExcel->setActiveSheetIndex(0);

            $letra = "A";
            $fila = 1;
            foreach($Columnas as $key =>$columna){
                $displayname = $columna["display"];
                $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $displayname);
                $letra++;
            }

            $fila++;$letra = "A";
            $filainit = $fila;
            foreach($Columnas as $key =>$columna){
                $internalname = $columna["internal"];

                $fila = $filainit;
                foreach ($Arraydatosasociativo as $datoactual) {
                    $value = $datoactual[$internalname];
                    if(array_key_exists("decode", $columna) ){
                        switch($columna["decode"]){
                            case "json":
                                $value = json_decode($value);
                                break;
                        }
                    }
                    $objPHPExcel->getActiveSheet()->SetCellValue($letra.''.$fila, $value . "");
                    $fila++;
                }
                $letra++;
            }
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);

            if(empty($TituloSum)){$TituloSum = "Resultado";}
            $objPHPExcel->getActiveSheet()->setTitle($TituloSum);

            $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);

            //$filename =  $TituloSum . ".xlsx";
            $filename = $this->_archivostemporales . "/" . $TituloSum . ".xlsx";

            $objWriter->save($filename);
        }catch (Exception $ee){
            echo ("ERROR $ee");
        }

        return $TituloSum;
    }

}