<?php

/**
 * Class Reportes
 * Esta clase se encarga de realizar todas las consultas de los reportes de la aplicacion 
 * 
 */
class Reportes{

    public function __construct(){

    }

    /**
     * ejecuata el repote de prueba devuelve todas los eventos , muestreos e inspecciones
     * @param $para1
     * @return mixed
     */
   static  public function ConsultaReporteprueba($region=false, $actividad=false){
        $where='';
        if( !empty($region)){
            $where.=" AND  id_region = '$region' ";
        }
        if( !empty($actividad)){
            $where.=" AND  tipo_inspeccion = '$actividad' ";
        }
        $consultaClases = "
            SELECT event_id as Id,
            start_date AS Inicio,
            end_date AS Fin,
            tipo,
            tipo_inspeccion as Establecimiento,
            details as detalles,
            establecimiento,
            encargado
            FROM ia_eventos_inspecciones_muestreos
            $where
            ";

        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
      //  echo $consultaClases;
        //print_r($resultados); die;
        return $resultados;
    }


    /**
     * Ejecuta el repote 1
     *
     *
     * @param $para1
     * @return mixed
     */
    static  public function ConsultaReporte1($region=false, $actividad=false,$periodo=false){
        //falta ver a que se refiere con nivel de riesgo , si es el ultimo que sea != a null
        // despues falta aplicarle el where a las consultas que vienen anidadas
        // falta ver si faltan mas parametros/filtros
        $where='';
        if( !empty($region)){
            $where.=" AND  e.id_region = '$region' ";
        }
        if( !empty($region)){
            $where.=" AND EXTRACT(YEAR FROM e.start_date) ='$periodo' ";
        }
        if( !empty($actividad)){
            $where.=" AND  e.tipo_inspeccion = '$actividad' ";
        }
        $consultaClases = "
		SELECT COUNT( DISTINCT e.event_id ) AS  'Total de Inspecciones' ,
		COUNT( h.id ) AS 'Total de Disconformudades',
		menores.cuantos_menores as 'Disconformudades menores',
		mayores.cuantos_mayores as 'Disconformudades Mayores',
		e.formulario_nivelderiesgo AS 'Nivel de riesgo',
		e.establecimiento_id AS 'Código',
		 SUBSTRING_INDEX(e.establecimiento, '::', 1)  as 'Establecimiento'
		FROM ia_eventos_inspecciones_muestreos e
		LEFT JOIN ia_hallazgosinspeccion h ON UPPER( TRIM( e.numero_de_seguimiento ) ) = UPPER( TRIM( h.numero_de_seguimiento ) )
		LEFT JOIN (
				 SELECT COUNT(hm.id) AS cuantos_menores,
				  em.establecimiento_id
				 FROM ia_hallazgosinspeccion hm
				inner JOIN  ia_eventos_inspecciones_muestreos em  ON UPPER( TRIM( em.numero_de_seguimiento ) ) = UPPER( TRIM( hm.numero_de_seguimiento ) )
				WHERE hm.nivel_disconformidad='Menor'
				AND hm.habilitado =1
				GROUP BY em.establecimiento
		) as menores on menores.establecimiento_id = e.establecimiento_id
		LEFT JOIN (
				 SELECT COUNT(hM.id) AS cuantos_mayores,
				  eM.establecimiento_id
				 FROM ia_hallazgosinspeccion hM
				inner JOIN  ia_eventos_inspecciones_muestreos eM  ON UPPER( TRIM( eM.numero_de_seguimiento ) ) = UPPER( TRIM( hM.numero_de_seguimiento ) )
				WHERE hM.nivel_disconformidad='Mayor'
				AND hM.habilitado =1
				GROUP BY eM.establecimiento
		) as mayores on mayores.establecimiento_id = e.establecimiento_id
		WHERE e.tipo =  'Auditoria-Inspeccion'
		AND (
			e.estado_evento =  'Finalizado'
			OR e.estado_evento =  'Activo'
		)
		AND h.habilitado =1
		$where
		GROUP BY e.establecimiento
";

        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        //  echo $consultaClases;
        //print_r($resultados); die;
        return $resultados;
    }

    /**
     * Ejecuta el repote 2
     *
     * @param $para1
     * @return mixed
     */
    static  public function ConsultaReporte2($periodo=false,$establecimiento=false){
        //falta ver a que se refiere con nivel de riesgo , si es el ultimo que sea != a null
        // despues falta aplicarle el where a las consultas que vienen anidadas
        // falta ver si faltan mas parametros/filtros
        $where='';

        if( !empty($region)){
            $where.=" AND EXTRACT(YEAR FROM e.start_date) ='$periodo' ";
        }
        if( !empty($establecimiento)){
            $where.=" AND  e.establecimiento_id like '$establecimiento' ";
        }
        $consultaClases =
            "
 SELECT
 t.analisis as Analisis,
 '' as Programadas,
'' AS  'Realizadas' ,
 e.muestreo_codigo as 'Cod. muestreo',
 e.numero_de_seguimiento as 'Protocolos',
 t.fecha_creacion as 'Fecha de toma de muestra',
 ((  1 *100 / (1 ) ) + '%' ) AS 'Porcentaje cumplimiento'
 FROM ia_tomasdemuestra t
 inner JOIN  ia_eventos_inspecciones_muestreos e  ON UPPER( TRIM( e.numero_de_seguimiento ) ) = UPPER( TRIM( t.numero_de_seguimiento ) )
 WHERE t.habilitada= 1
 and e.tipo =  'Muestreo'
 $where
order by t.analisis_id
        ";

        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        //  echo $consultaClases;
        //print_r($resultados); die;
        return $resultados;
    }



   /**
     * Ejecuta el repote 4
     *
     * @param $para1
     * @return mixed
     */
    static  public function ConsultaReporte4($region=false, $actividad=false,$periodo=false,$establecimiento=false){
        //falta ver a que se refiere con nivel de riesgo , si es el ultimo que sea != a null
        // despues falta aplicarle el where a las consultas que vienen anidadas
        // falta ver si faltan mas parametros/filtros
        $where='';
        if( !empty($region)){
            $where.=" AND  e.id_region = '$region' ";
        }
        if( !empty($region)){
            $where.=" AND EXTRACT(YEAR FROM e.start_date) ='$periodo' ";
        }
        if( !empty($actividad)){
            $where.=" AND  e.tipo_inspeccion = '$actividad' ";
        }
        if( !empty($establecimiento)){
            $where.=" AND  e.establecimiento_id like '$establecimiento' ";
        }
        $consultaClases =
            "

		SELECT c.item as 'Item de formulario',
		COUNT(h.id) AS 'Cantidad de Hallazgos',
		GROUP_CONCAT(h.numero_de_seguimiento) as 'Inspecciones'
		FROM ia_hallazgosinspeccion h
		inner JOIN  ia_eventos_inspecciones_muestreos e  ON UPPER( TRIM( e.numero_de_seguimiento ) ) = UPPER( TRIM( h.numero_de_seguimiento ) )
		inner JOIN  ia_camposformularioinspeccion  c  ON c.id= h.id_item
		WHERE  h.habilitado =1
		 $where
		GROUP BY h.id_item
		Order by c.item



        ";

        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        //  echo $consultaClases;
        //print_r($resultados); die;
        return $resultados;
    }








    /**
     * Ejecuta el repote 5
     *
     * @param $para1
     * @return mixed
     */
    static  public function ConsultaReporte5($region=false, $actividad=false,$periodo=false){
        //falta ver a que se refiere con nivel de riesgo , si es el ultimo que sea != a null
        // despues falta aplicarle el where a las consultas que vienen anidadas
        // falta ver si faltan mas parametros/filtros
        $where='';
        if( !empty($region)){
            $where.=" AND  e.id_region = '$region' ";
        }
        if( !empty($region)){
            $where.=" AND EXTRACT(YEAR FROM e.start_date) ='$periodo' ";
        }
        if( !empty($actividad)){
            $where.=" AND  e.tipo_inspeccion = '$actividad' ";
        }
        $consultaClases = "
		SELECT e.event_id,
		e.numero_de_seguimiento as 'Num. seguimiento',
		MAX(e.formulario_fechaderealizacion) as 'Fec. Informe',
		COUNT( h.id ) AS  'Cant. Disconformudades',
		menores.cuantos as 'Dis. Menores',
		mayores.cuantos as 'Dis. Mayores',
		e.formulario_nivelderiesgo as 'Niv. Riesgo',
		e.establecimiento_id AS 'Cód. Establecimiento',
		 SUBSTRING_INDEX(e.establecimiento, '::', 1)  as 'Nom. Establecimiento'
		FROM ia_eventos_inspecciones_muestreos e
		LEFT JOIN ia_hallazgosinspeccion h ON UPPER( TRIM( e.numero_de_seguimiento ) ) = UPPER( TRIM( h.numero_de_seguimiento ) )
		LEFT JOIN (
				 SELECT COUNT(hm.id) AS cuantos,
				 hm.numero_de_seguimiento
				 FROM ia_hallazgosinspeccion hm
				WHERE hm.nivel_disconformidad='Menor'
				AND hm.habilitado =1
				GROUP BY  hm.numero_de_seguimiento
		) as menores ON UPPER( TRIM( e.numero_de_seguimiento ) ) = UPPER( TRIM( menores.numero_de_seguimiento ) )
		LEFT JOIN (
				 SELECT COUNT(hM.id) AS cuantos,
				 hM.numero_de_seguimiento
				 FROM ia_hallazgosinspeccion hM
				WHERE hM.nivel_disconformidad='Mayor'
				AND hM.habilitado =1
				GROUP BY  hM.numero_de_seguimiento
		) as mayores ON UPPER( TRIM( e.numero_de_seguimiento ) ) = UPPER( TRIM( mayores.numero_de_seguimiento ) )
		WHERE e.tipo =  'Auditoria-Inspeccion'
		AND (e.estado_evento =  'Finalizado' OR e.estado_evento =  'Activo')
		AND h.habilitado =1
		$where
		GROUP BY e.establecimiento
        ";

        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        //  echo $consultaClases;
        //print_r($resultados); die;
        return $resultados;
    }




    /**
     * Ejecuta el repote 9
     *
     * @param $para1
     * @return mixed
     */
    static  public function ConsultaReporte9($region=false, $actividad=false,$periodo=false,$establecimiento=false){
        //falta ver a que se refiere con nivel de riesgo , si es el ultimo que sea != a null
        // despues falta aplicarle el where a las consultas que vienen anidadas
        // falta ver si faltan mas parametros/filtros
        $where='';
        if( !empty($region)){
            $where.=" AND  e.id_region = '$region' ";
        }
        if( !empty($region)){
            $where.=" AND EXTRACT(YEAR FROM e.start_date) ='$periodo' ";
        }
        if( !empty($actividad)){
            $where.=" AND  e.tipo_inspeccion = '$actividad' ";
        }
        if( !empty($establecimiento)){
            $where.=" AND  e.establecimiento_id like '$establecimiento' ";
        }
        $consultaClases =
            "
		SELECT e.event_id,
		e.numero_de_seguimiento as 'Num. seguimiento',
		e.establecimiento_id AS 'Cód. Establecimiento',
		SUBSTRING_INDEX(e.establecimiento, '::', 1)  as 'Nom. Establecimiento',
		t.nombre as 'Tipo de Actividad ',
		e.formulario_fechaderealizacion as 'Fec. Informe',
		COUNT(h.id) AS  'Cant. Disconformidades',
		e.formulario_nivelderiesgo as 'Niv. Riesgo',
		e.formulario_observaciones as 'Observaciones',
		c.nombre as 'Colaborador Encargado'
		FROM ia_eventos_inspecciones_muestreos e
		LEFT JOIN ia_hallazgosinspeccion h ON UPPER( TRIM( e.numero_de_seguimiento ) ) = UPPER( TRIM( h.numero_de_seguimiento ) )
		LEFT JOIN ia_tipoestablecimiento t ON t.id = e.tipo_inspeccion
		LEFT JOIN ia_colaboradores c ON c.id = e.encargado
		WHERE e.tipo =  'Auditoria-Inspeccion'
		AND (e.estado_evento =  'Finalizado' OR e.estado_evento =  'Activo')
		AND h.habilitado =1
		$where
		Group by h.numero_de_seguimiento
        ";

        $dcon = Doctrine_Manager::connection();
        $resultados = $dcon->fetchAll( $consultaClases );
        //  echo $consultaClases;
        //print_r($resultados); die;
        return $resultados;
    }

}