<?php
/*
*/
class User extends DAOInit
{
    private $user;

    public function __construct($UserID= NULL, $Username = NULL, $Email = NULL)
    {
        parent::__construct();
        $this->user_record = NULL;
        $this->user = array();
        error_log("UserID=$UserID");
        if(isset($UserID) && $UserID != null && $UserID >= 0)
        {
            try
            {
                //Cargar Solicitante.
                $q = Doctrine_Query::create()
                    ->from('DAOZkUsers s')
                    ->where("s.pn_uid = $UserID");
                $user_record = $q->fetchOne();
                $userCargado = false;
                if($user_record != null && isset($user_record))
                {
                    if($user_record->exists())
                    {
                        $userCargado = true;
                    }
                }
                if ( !$userCargado)
                {
                    error_log("NO User Cargado");
                    $user_record = new DAOZkUsers();
                    $this->setRecord($user_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("User Cargado");
                    $this->setRecord($user_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else if(isset($Username) && $Username != null && $Username != '')
        {
            try
            {
                //Cargar Solicitante.
                $q = Doctrine_Query::create()
                    ->from('DAOZkUsers s')
                    ->where("s.pn_uname = '$Username'");
                $user_record = $q->fetchOne();
                $userCargado = false;
                if($user_record != null && isset($user_record))
                {
                    if($user_record->exists())
                    {
                        $userCargado = true;
                    }
                }
                if ( !$userCargado)
                {
                    error_log("NO User Cargado");
                    $user_record = new DAOZkUsers();
                    $this->setRecord($user_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("User Cargado");
                    $this->setRecord($user_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else if(isset($Email) && $Email != null && $Email != '')
        {
            try
            {
                //Cargar Solicitante.
                $q = Doctrine_Query::create()
                    ->from('DAOZkUsers s')
                    ->where("s.pn_email = '$Email'");
                $user_record = $q->fetchOne();
                $userCargado = false;
                if($user_record != null && isset($user_record))
                {
                    if($user_record->exists())
                    {
                        $userCargado = true;
                    }
                }
                if ( !$userCargado)
                {
                    error_log("NO User Cargado");
                    $user_record = new DAOZkUsers();
                    $this->setRecord($user_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("User Cargado");
                    $this->setRecord($user_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $user_record = new DAOZkUsers();
                $this->setRecord($user_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
    }

    //Retorna los datos en aplicante de arreglo en lugar de ->
    /**
     * @return array
     */
    public function toArray()
    {
        $fields = $this->user_record->toArray();

        $user_fields = $this->user_record->toArray();

        //Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
        $fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
        $fields['fecha_actualizacion'] = $this->MySQLDate2SpanishDate($fields['fecha_actualizacion']);

        $user_fields['pn_uid'] = $user_fields['pn_uid'];
        unset($user_fields['pn_uid']);

        return array_merge($fields, $user_fields);
    }

    public function existe()
    {
        return $this->user_record->exists();
    }

    private function MySQLDate2SpanishDate($StrMySQLDate)
    {
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }

    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }

    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }

    //Guarda cambios que se hayan hecho en las variables.
    /**
     * @return bool
     * @throws Exception
     */
    public function salvar()
    {
        error_log("User::salvar");
        try
        {
            $this->fecha_actualizacion= date('Y-m-d H:i:s');
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
                $this->usuarios_creacion_id = pnUserGetVar('uid');
                $this->usuario_creacion = pnUserGetVar('uname',$this->usuarios_creacion_id);
            }
            $this->ultima_modificacion_usuario_id = pnUserGetVar('uid');
            $this->usuario_modificacion = pnUserGetVar('uname',$this->ultima_modificacion_usuario_id);

            $user_record = &$this->user_record;
            $arreglo_datos = $user_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                switch($key)
                {
                    case 'fecha_actualizacion':
                        $user_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                        break;
                    case 'fecha_creacion':
                        $user_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                        break;
                    default:
                        $user_record->{$key} = $this->{$key};
                        break;
                }
            }
			error_log("User::salvar, justo antes de salvar");
            $user_record->save();
			error_log("User::salvar, despues de salvar");
            $new_user_id = $user_record['pn_uid'];
            error_log('NEW USER ID = ' . $new_user_id);
            $this->setRecord($user_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }

    //Modifica el solicitante con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("User::modificar");
        try
        {
            //protege de que vengan parametros fuera de los campos del Aplicante.

            $user_record= &$this->user_record;
            $arreglo_datos = $user_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        case 'fecha_actualizacion':
                            $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                            break;
                        case 'fecha_creacion':
                            $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                            break;
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }

        return true;
    }

    //Establece un aplicante que recibe por parámetro.
    public function setRecord(&$Record)
    {
        error_log("User::setRecord");
        if(!is_null($this->user_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->user_record))
            {
                error_log("setRecord:: Record is not the same type as user");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->user_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                case 'fecha_actualizacion':
                    $this->{$key} = $this->SpanishDate2MySQLDate($Record->{$key});
                    break;
                case 'fecha_creacion':
                    $this->{$key} = $this->SpanishDate2MySQLDate($Record->{$key});
                    break;
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }

    //Modifica el Anotacion con el arreglo de mapeo que recibe por parametro.
    public function eliminar($UserID)
    {
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $user_fields = $this->user_record->toArray();
            if($UserID != $user_fields['id'])
            {
                return false;
            }

            /*  @MISSING@ Falta decidir qué revisiones realizar antes de permitir eliminar al solicitante, si tiene marcas, certificados, solicitudes en proceso, etc
            $campos = "ea.aplicacion_id as aplicacion_id";
            $select = "SELECT $campos FROM ra_Examen_Aplicacion as ea";
            $where = " WHERE ea.aplicacion_id=$AplicacionID AND ( ea.estado is not null AND ea.estado != 'Invitado' AND ea.estado != 'ErrorVerificacion' AND ea.estado != '')"; //Solo se eliminan aplicaciones invitadas , o que no tienen invitacion
            $orderby = '';
            $select .= " $where $orderby";
            error_log("SQL=$select");
            $results = Doctrine_Manager::connection()->fetchAll($select);

            $tiene_solicitudes_pendientes = false;
            foreach($results as $result)
            {
            $tiene_invitaciones_ejecutadas = true;
            }
            if(!$tiene_invitaciones_ejecutadas)
            {
            //protege de que vengan parametros fuera de los campos de la Temática.
            //$examen_record = &$this->examen_record;
            $this->aplicacion_record->{'eliminado'} = 'Sí';
            $this->aplicacion_record->save();
            $conn->commit();
            }
             */
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");

            return false;
        }

        return true;
    }
}