<?php
/**
 * Created by PhpStorm.
 * User: jrojas
 * Date: 2/14/14
 * Time: 2:12 PM
 */

class Analisis extends DAOInit{
    private $analisis;
    public function __construct($AnalisisID)
    {
        parent::__construct();
        $this->analisis_record = NULL;
        $this->analisis = array();
        if(isset($AnalisisID) && $AnalisisID != null && $AnalisisID >= 0)
        {
            try{

                $q = Doctrine_Query::create()
                    ->from('DAOIaAnalisislaboratorio a')
                    ->where("a.id = $AnalisisID");
                $analisis_record = $q->fetchOne();

                $analisisCargado = false;
                if($analisis_record != null && isset($analisis_record))
                {
                    if($analisis_record->exists())
                    {
                        $analisisCargado = true;
                    }
                }
                if (!$analisisCargado)
                {
                    error_log("NO Analisis Cargado");
                    $analisis_record = new DAOIaAnalisislaboratorio();
                    $this->setRecord($analisis_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Analisis Cargado");
                    $this->setRecord($analisis_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $analisis_record = new DAOIaAnalisislaboratorio();
                $this->setRecord($analisis_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }

    }


    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->analisis_record->toArray();
        return $fields;
    }


    public function existe()
    {
        return $this->analisis_record->exists();
    }


    public function setRecord(&$Record)
    {
        error_log("Analisis::setRecord");
        if(!is_null($this->analisis_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->analisis_record))
            {
                error_log("setRecord:: Record is not the same type as analisis_record");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->analisis_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }


    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("Analisis::salvar");
        try
        {
            $nuevo_registro = false;
            if(! $this->existe() )
            {
                $nuevo_registro = true;
            }

            $analisis_record = &$this->analisis_record;

            $arreglo_datos = $analisis_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                switch($key)
                {
                    default:
                        $analisis_record->{$key} = $this->{$key};
                        break;
                }
            }
            $analisis_record->save();
            $new_analisis_id = $analisis_record['id'];
            if($nuevo_registro)
            {
                error_log('NEW SOLICITUD ID = ' . $new_analisis_id);
            }
            $this->setRecord($analisis_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }








    //Modifica el objetivo con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("Analisis::modificar");
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $analisis_record= &$this->analisis_record;
            $arreglo_datos = $analisis_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }
        $conn->commit();

        return true;
    }

} 