<?php
/*
*/
class Colaborador extends DAOInit
{
    private $colaborador;

    public function __construct($colaboradorID= NULL, $User_id = NULL)
    {
        parent::__construct();
        $this->colaborador_record = NULL;
        $this->colaborador = array();
        error_log("ColaboradorID=$colaboradorID");
        if(isset($colaboradorID) && $colaboradorID != null && $colaboradorID >= 0)
        {
            try
            {
                //Cargar Colaborador.
                $q = Doctrine_Query::create()
                    ->from('DAOIaColaboradores ms')
                    ->where("ms.id = $colaboradorID");
                $colaborador_record = $q->fetchOne();
                $colaboradorCargado = false;
                if($colaborador_record != null && isset($colaborador_record))
                {
                    if($colaborador_record->exists())
                    {
                        $colaboradorCargado = true;
                    }
                }
                if ( !$colaboradorCargado)
                {
                    error_log("NO Colaborador Cargado");
                    $colaborador_record = new DAOIaColaboradores();
                    $this->setRecord($colaborador_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Colaborador Cargado");
                    $this->setRecord($colaborador_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else if(isset($User_id) && $User_id != null && $User_id >= 0)
        {
            try
            {
                //Cargar Colaborador.
                $q = Doctrine_Query::create()
                    ->from('DAOIaColaboradores ms')
                    ->where("ms.usuario_id = $User_id");
                $colaborador_record = $q->fetchOne();
                $colaboradorCargado = false;
                if($colaborador_record != null && isset($colaborador_record))
                {
                    if($colaborador_record->exists())
                    {
                        $colaboradorCargado = true;
                    }
                }
                if ( !$colaboradorCargado)
                {
                    error_log("NO Colaborador Cargado");
                    $colaborador_record = new DAOIaColaboradores();
                    $this->setRecord($colaborador_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("Colaborador Cargado");
                    $this->setRecord($colaborador_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $colaborador_record = new DAOIaColaboradores();
                $this->setRecord($colaborador_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
    }

    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->colaborador_record->toArray();

        $colaborador_fields = $this->colaborador_record->toArray();

        //Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
        $fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
        $fields['fecha_actualizacion'] = $this->MySQLDate2SpanishDate($fields['fecha_actualizacion']);

        $colaborador_fields['colaborador_id'] = $colaborador_fields['id'];
        unset($colaborador_fields['id']);

        return array_merge($fields, $colaborador_fields);
    }

    public function existe()
    {
        return $this->colaborador_record->exists();
    }

    private function MySQLDate2SpanishDate($StrMySQLDate)
    {
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }

    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }

    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }

    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("Colaborador::salvar");
        try
        {
            $this->fecha_actualizacion= date('Y-m-d H:i:s');
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
                $this->usuario_creacion_id = pnUserGetVar('uid');
                $this->usuario_creacion = pnUserGetVar('uname',$this->usuario_creacion_id);
            }
            $this->ultima_modificacion_usuario_id = pnUserGetVar('uid');
            $this->usuario_modificacion = pnUserGetVar('uname',$this->usuario_creacion_id);

            $colaborador_record = &$this->colaborador_record;
            $arreglo_datos = $colaborador_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                switch($key)
                {

                    default:
                        $colaborador_record->{$key} = $this->{$key};
                        break;
                }
            }
            $colaborador_record->save();
            $new_colaborador_id = $colaborador_record['id'];
            error_log('NEW PERITO ID = ' . $new_colaborador_id);
            $this->setRecord($colaborador_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }

    //Modifica el encargado con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("Colaborador::modificar");
        try
        {
            //protege de que vengan parametros fuera de los campos del Aplicante.
            $colaborador_record= &$this->colaborador_record;
            $arreglo_datos = $colaborador_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {

                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }

        return true;
    }

    //Establece un aplicante que recibe por parámetro.
    public function setRecord(&$Record)
    {
        error_log("Colaborador::setRecord");
        if(!is_null($this->colaborador_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->colaborador_record))
            {
                error_log("setRecord:: Record is not the same type as encargado_record");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->colaborador_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {

                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }

    //Modifica el Anotacion con el arreglo de mapeo que recibe por parametro.
    public function eliminar($colaboradorID)
    {
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $colaborador_fields = $this->colaborador_record->toArray();
            if($colaboradorID != $colaborador_fields['id'])
            {
                return false;
            }

            /*  @MISSING@ Falta decidir qué revisiones realizar antes de permitir eliminar al encargado, si tiene encargados, certificados, solicitudes en proceso, etc
            $campos = "ea.aplicacion_id as aplicacion_id";
            $select = "SELECT $campos FROM ra_Examen_Aplicacion as ea";
            $where = " WHERE ea.aplicacion_id=$AplicacionID AND ( ea.estado is not null AND ea.estado != 'Invitado' AND ea.estado != 'ErrorVerificacion' AND ea.estado != '')"; //Solo se eliminan aplicaciones invitadas , o que no tienen invitacion
            $orderby = '';
            $select .= " $where $orderby";
            error_log("SQL=$select");
            $results = Doctrine_Manager::connection()->fetchAll($select);

            $tiene_solicitudes_pendientes = false;
            foreach($results as $result)
            {
            $tiene_invitaciones_ejecutadas = true;
            }
            if(!$tiene_invitaciones_ejecutadas)
            {
            //protege de que vengan parametros fuera de los campos de la Temática.
            //$examen_record = &$this->examen_record;
            $this->aplicacion_record->{'eliminado'} = 'Sí';
            $this->aplicacion_record->save();
            $conn->commit();
            }
             */
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");

            return false;
        }

        return true;
    }
}