<?php
/*
*/
class ItemDeInspeccion extends DAOInit
{
    private $itemdeinspeccion;

    public function __construct($itemdeinspeccionID= NULL)
    {
        parent::__construct();
        $this->itemdeinspeccion_record = NULL;
        $this->itemdeinspeccion = array();
        error_log("ItemDeInspeccionID=$itemdeinspeccionID");
        if(isset($itemdeinspeccionID) && $itemdeinspeccionID != null && $itemdeinspeccionID >= 0)
        {
            try
            {
                //Cargar ItemDeInspeccion.
                $q = Doctrine_Query::create()
                    ->from('DAOIaCamposformularioinspeccion ms')
                    ->where("ms.id = $itemdeinspeccionID");
                $itemdeinspeccion_record = $q->fetchOne();
                $itemdeinspeccionCargado = false;
                if($itemdeinspeccion_record != null && isset($itemdeinspeccion_record))
                {
                    if($itemdeinspeccion_record->exists())
                    {
                        $itemdeinspeccionCargado = true;
                    }
                }
                if ( !$itemdeinspeccionCargado)
                {
                    error_log("NO ItemDeInspeccion Cargado");
                    $itemdeinspeccion_record = new DAOIaCamposformularioinspeccion();
                    $this->setRecord($itemdeinspeccion_record);
                }
                else //Cargar la aplicación si es necesario
                {
                    error_log("ItemDeInspeccion Cargado");
                    $this->setRecord($itemdeinspeccion_record);
                }
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
        else
        {
            try
            {
                $itemdeinspeccion_record = new DAOIaCamposformularioinspeccion();
                $this->setRecord($itemdeinspeccion_record);
            }
            catch(Exception $e)
            {
                error_log(__METHOD__ . " : [$e]");
                throw $e;
            }
        }
    }

    //Retorna los datos en aplicante de arreglo en lugar de ->
    public function toArray()
    {
        $fields = $this->itemdeinspeccion_record->toArray();

        $itemdeinspeccion_fields = $this->itemdeinspeccion_record->toArray();

        //Le cambia el orden a la fecha, en MySQL es YYYY-MM-DD, y lo cambia por DD/MM/YYYY
        $fields['fecha_creacion'] = $this->MySQLDate2SpanishDate($fields['fecha_creacion']);
        $fields['fecha_actualizacion'] = $this->MySQLDate2SpanishDate($fields['fecha_actualizacion']);

        $itemdeinspeccion_fields['itemdeinspeccion_id'] = $itemdeinspeccion_fields['id'];
        unset($itemdeinspeccion_fields['id']);

        return array_merge($fields, $itemdeinspeccion_fields);
    }

    public function existe()
    {
        return $this->itemdeinspeccion_record->exists();
    }

    private function MySQLDate2SpanishDate($StrMySQLDate)
    {
        $dobcheck = date("Y/m/d",strtotime($StrMySQLDate));

        //NOTE: echo $dobcheck on your system to see if you get negative values for date below 1970

        if ($dobcheck <= 0)
        {
            $date = $StrMySQLDate;
            $date = explode('-', $date);
            $Y = $date[0];

            $M = $date[1];
            $D = $date[2];
            $dobshow = $D."/".$M."/".$Y;        //echos dd/mm/YYYY format for dates below 1970.
        }
        else
        {
            $dobshow = date("d/m/Y",strtotime($StrMySQLDate));
        }

        error_log("MODIFYING $StrMySQLDate  to  $dobshow");

        return $dobshow;
    }

    private function strotimeformat($date, $format)
    {
        $d = strptime($date, $format);
        return mktime(0, 0, 0, $d['tm_mon'], $d['tm_mday'], $d['tm_year']);
    }

    private function SpanishDate2MySQLDate($StrSpanishDate)
    {
        //$time = $this->strotimeformat($StrSpanishDate, "d/m/Y");

        //$result = date("Y-m-d", $time);
        $parts = explode("/", $StrSpanishDate);
        $result = implode("-", array_reverse($parts));

        error_log("SpanishDate2MySQLDate $StrSpanishDate => $result");

        return $result;
    }

    //Guarda cambios que se hayan hecho en las variables.
    public function salvar()
    {
        error_log("ItemDeInspeccion::salvar");
        try
        {
            $this->fecha_actualizacion= date('Y-m-d H:i:s');
            if(! $this->existe() )
            {
                $this->fecha_creacion= date('Y-m-d H:i:s');
                $this->usuario_creacion_id = pnUserGetVar('uid');
                $this->usuario_creacion = pnUserGetVar('uname',$this->usuario_creacion_id);
            }
            $this->ultima_modificacion_usuario_id = pnUserGetVar('uid');
            $this->usuario_modificacion = pnUserGetVar('uname',$this->usuario_creacion_id);

            $itemdeinspeccion_record = &$this->itemdeinspeccion_record;
            $arreglo_datos = $itemdeinspeccion_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                switch($key)
                {
                    case 'fecha_actualizacion':
                        $itemdeinspeccion_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                        break;
                    case 'fecha_creacion':
                        $itemdeinspeccion_record->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                        break;
                    default:
                        $itemdeinspeccion_record->{$key} = $this->{$key};
                        break;
                }
            }
            $itemdeinspeccion_record->save();
            $new_itemdeinspeccion_id = $itemdeinspeccion_record['id'];
            error_log('NEW PERITO ID = ' . $new_itemdeinspeccion_id);
            $this->setRecord($itemdeinspeccion_record);
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");

            throw $e;
            //return false;
        }

        return true;
    }

    //Modifica el encargado con el arreglo de mapeo que recibe por parametro.
    public function modificar($Parametros)
    {
        error_log("ItemDeInspeccion::modificar");
        try
        {
            //protege de que vengan parametros fuera de los campos del Aplicante.
            $itemdeinspeccion_record= &$this->itemdeinspeccion_record;
            $arreglo_datos = $itemdeinspeccion_record->toArray();
            foreach($arreglo_datos as $key=>$value)
            {
                if(array_key_exists($key, $Parametros))
                {
                    switch($key)
                    {
                        case 'fecha_actualizacion':
                            $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                            break;
                        case 'fecha_creacion':
                            $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                            break;
                        default:
                            error_log("modificando $key con valor " . $Parametros[$key]);
                            $this->{$key} = $Parametros[$key];
                            break;
                    }
                }
            }
            if(! $this->salvar())
            {
                return false;
            }
        }
        catch(Exception $e)
        {
            error_log(__METHOD__ . " : [$e]");
            //return false;
            throw $e;
        }

        return true;
    }

    //Establece un aplicante que recibe por parámetro.
    public function setRecord(&$Record)
    {
        error_log("ItemDeInspeccion::setRecord");
        if(!is_null($this->itemdeinspeccion_record)) //@todo esto permite que la primera asignación de un Record sea de cualquier tipo
        {
            if(get_class($Record) != get_class($this->itemdeinspeccion_record))
            {
                error_log("setRecord:: Record is not the same type as encargado_record");
                return false;
            }
        }
        $arreglo_datos = $Record->toArray();
        $this->itemdeinspeccion_record = &$Record;
        foreach($arreglo_datos as $key=>$value)
        {
            switch($key)
            {
                case 'fecha_actualizacion':
                    $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                    break;
                case 'fecha_creacion':
                    $this->{$key} = $this->SpanishDate2MySQLDate($this->{$key});
                    break;
                default:
                    $this->{$key} = $Record->{$key};
                    break;
            }
        }

        return true;
    }

    //Modifica el Anotacion con el arreglo de mapeo que recibe por parametro.
    public function eliminar($itemdeinspeccionID)
    {
        $conn = Doctrine_Manager::getInstance()->getCurrentConnection();
        try
        {
            $conn->beginTransaction();
            $itemdeinspeccion_fields = $this->itemdeinspeccion_record->toArray();
            if($itemdeinspeccionID != $itemdeinspeccion_fields['id'])
            {
                return false;
            }

            /*  @MISSING@ Falta decidir qué revisiones realizar antes de permitir eliminar al encargado, si tiene encargados, certificados, solicitudes en proceso, etc
            $campos = "ea.aplicacion_id as aplicacion_id";
            $select = "SELECT $campos FROM ra_Examen_Aplicacion as ea";
            $where = " WHERE ea.aplicacion_id=$AplicacionID AND ( ea.estado is not null AND ea.estado != 'Invitado' AND ea.estado != 'ErrorVerificacion' AND ea.estado != '')"; //Solo se eliminan aplicaciones invitadas , o que no tienen invitacion
            $orderby = '';
            $select .= " $where $orderby";
            error_log("SQL=$select");
            $results = Doctrine_Manager::connection()->fetchAll($select);

            $tiene_solicitudes_pendientes = false;
            foreach($results as $result)
            {
            $tiene_invitaciones_ejecutadas = true;
            }
            if(!$tiene_invitaciones_ejecutadas)
            {
            //protege de que vengan parametros fuera de los campos de la Temática.
            //$examen_record = &$this->examen_record;
            $this->aplicacion_record->{'eliminado'} = 'Sí';
            $this->aplicacion_record->save();
            $conn->commit();
            }
             */
        }
        catch(Exception $e)
        {
            $conn->rollback();
            error_log(__METHOD__ . " : [$e]");

            return false;
        }

        return true;
    }
}