<?php
/**
 * Zikula Application Framework
 *
 * @copyright (c) 2001, Zikula Development Team
 * @link http://www.zikula.org
 * @version $Id: pnajax.php 24342 2008-06-06 12:03:14Z markwest $
 * @license GNU/GPL - http://www.gnu.org/copyleft/gpl.html
 * @package Zikula_System_Modules
 * @subpackage Blocks
*/

/**
 * changeblockorder
 *
 * @author Frank Schummertz
 * @param blockorder array of sorted blocks (value = block id)
 * @param position int zone id
 * @return mixed true or Ajax error
 */
function Blocks_ajax_changeblockorder()
{
    if (!SecurityUtil::checkPermission('Blocks::', '::', ACCESS_ADMIN)) {
        AjaxUtil::error(DataUtil::formatForDisplayHTML(_MODULENOAUTH));
    }

    if (!SecurityUtil::confirmAuthKey()) {
        AjaxUtil::error(_BADAUTHKEY);
    }

    $blockorder = FormUtil::getPassedValue('blockorder');
    $position = FormUtil::getPassedValue('position');

    // empty block positions for this block zone
    $res = DBUtil::deleteObjectByID('block_placements', $position, 'pid');
    if (!$res) {
        AjaxUtil::error(_UPDATEFAILED);
    }

    // add new block positions
    $blockplacements = array();
    foreach ($blockorder as $order => $bid) {
        $blockplacements[] = array('bid' => $bid, 'pid' => $position, 'order' => $order);
    }
    $res = DBUtil::insertObjectArray($blockplacements, 'block_placements');
    if (!$res) {
        AjaxUtil::error(_UPDATEFAILED);
    }

    return array('result' => true);
}

/**
 * toggleblock
 * This function toggles active/inactive
 *
 * @author Frank Schummertz
 * @param bid int  id of block to toggle
 * @return mixed true or Ajax error
 */
function Blocks_ajax_toggleblock()
{
    if (!SecurityUtil::checkPermission('Blocks::', '::', ACCESS_ADMIN)) {
        AjaxUtil::error(DataUtil::formatForDisplayHTML(_MODULENOAUTH));
    }

    $bid = FormUtil::getPassedValue('bid', -1, 'GET');
    if ($bid==-1) {
        LogUtil::registerError('no block id');
        AjaxUtil::output();
    }
    
    // read the block information
    $blockinfo = pnBlockGetInfo($bid);
    if ($blockinfo == false) {
        LogUtil::registerError('unable to get block info for bid=' . DataUtil::formatForDisplay($bid));
        AjaxUtil::output();
    }
    
    if ($blockinfo['active'] == 1) {
        pnModAPIFunc('Blocks', 'admin', 'deactivate', array('bid' => $bid));
    } else {
        pnModAPIFunc('Blocks', 'admin', 'activate', array('bid' => $bid));
    }
    
    AjaxUtil::output(array('bid' => $bid));
}
