<?php
/**
 * Zikula Application Framework
 * @copyright (c) 2001, Zikula Development Team
 * @link http://www.zikula.org
 * @version $Id: thelang.php 25069 2008-12-15 09:12:56Z rgasch $
 * @license GNU/GPL - http://www.gnu.org/copyleft/gpl.html
 * @package Zikula_System_Modules
 * @subpackage Blocks
 */

/**
 * initialise block
 *
 * @author       The Zikula Development Team
 */
function Blocks_thelangblock_init()
{
    // Security
    pnSecAddSchema('Languageblock::', 'Block title::');
}

/**
 * get information on block
 *
 * @author       The Zikula Development Team
 * @return       array       The block information
 */
function Blocks_thelangblock_info()
{
    return array('text_type'       => 'Language',
                 'module'          => 'Blocks',
                 'text_type_long'  => 'Languages',
                 'allow_multiple'  => false,
                 'form_content'    => false,
                 'form_refresh'    => false,
                 'show_preview'    => true,
                 'admin_tableless' => true);
}

/**
 * Display the block
 *
 * @param        row           blockinfo array
 */
function Blocks_thelangblock_display($blockinfo)
{
    // security check
    if (!SecurityUtil::checkPermission('Languageblock::', "$blockinfo[title]::", ACCESS_OVERVIEW)) {
        return;
    }

    // if the site's not an ML site don't display the block
    if (!pnConfigGetVar('multilingual')) {
        return;
    }

    // Get current content
    $vars = pnBlockVarsFromContent($blockinfo['content']);

    // Defaults
    if (empty($vars['format'])) {
        $vars['format'] = 2;
    }

    // quick fix for [#5166] Languages block displays an empty list
    // this needs some rework for .9
    if (!isset($vars['languages']) || empty($vars['languages']) || !is_array($vars['languages'])) {
        $vars['languages'] = Blocks_thelangblock_getAvailableLanguages();
    }

    // Create output object - this object will store all of our output so that
    // we can return it easily when required
    $pnRender = pnRender::getInstance('Blocks');

    // assign the block vars
    $pnRender->assign($vars);

    // what's the current language
    $pnRender->assign('currentlanguage', pnUserGetLang());

    // set a block title
    if (empty($blockinfo['title'])) {
        $blockinfo['title'] = DataUtil::formatForDisplay(_SELECTLANGUAGE);
    }

    // get the block content from the template then end the templating
    $blockinfo['content'] = $pnRender->fetch('blocks_block_thelang.htm');

    // return the block to the theme
    return pnBlockThemeBlock($blockinfo);
}


/**
 * modify block settings
 *
 * @author       The Zikula Development Team
 * @param        array       $blockinfo     a blockinfo structure
 * @return       output      the bock form
 */
function blocks_thelangblock_modify($blockinfo)
{
    // Get current content
    $vars = pnBlockVarsFromContent($blockinfo['content']);

    // Defaults
    if (empty($vars['format'])) {
        $vars['format'] = 2;
    }

    // Create output object
    // As Admin output changes often, we do not want caching.
    $pnRender = pnRender::getInstance('Blocks', false);

    // assign the approriate values
    $pnRender->assign($vars);

    // clear the block cache
    $pnRender = pnRender::getInstance('Blocks');
    $pnRender->clear_cache('blocks_block_thelang.htm');

    // Return the output that has been generated by this function
    return $pnRender->fetch('blocks_block_thelang_modify.htm');
}


/**
 * update block settings
 *
 * @author       The Zikula Development Team
 * @param        array       $blockinfo     a blockinfo structure
 * @return       $blockinfo  the modified blockinfo structure
 */
function Blocks_thelangblock_update($blockinfo)
{
    // Get current content
    $vars = pnBlockVarsFromContent($blockinfo['content']);

    // Read inputs
    $vars['format'] = FormUtil::getPassedValue('format');

    // Scan for languages and save cached version
    $vars['languages'] = Blocks_thelangblock_getAvailableLanguages();

    // write back the new contents
    $blockinfo['content'] = pnBlockVarsToContent($vars);

    // clear the block cache
    $pnRender = pnRender::getInstance('Blocks');
    $pnRender->clear_cache('blocks_block_thelang.htm');

    return $blockinfo;
}


function Blocks_thelangblock_getAvailableLanguages()
{
    $langlist = LanguageUtil::getInstalledLanguages();
    $flags = array();
    $lang = array();

    foreach ($langlist as $k => $v) {
        // if we don't have an image or the language directory doesn't exist
        // then don't pass this language to the template
        if (is_dir("language/$k")) {
            $imgsize = @getimagesize("images/flags/flag-$k.png");
            $lang[] = array('code' => $k,
                            'name' => $v);
            if ($imgsize) {
                $flags[] = array('code' => $k,
                                 'title' => $v,
                                 'image' => "images/flags/flag-$k.png");
            }
        }
    }

    usort ($lang, '_blocks_thelangblock_sort');
    usort ($flags, '_blocks_thelangblock_sort');

    return array('lang' => $lang, 'flags' => $flags);
}


function _blocks_thelangblock_sort ($a, $b)
{
    return strcmp ($a['code'], $b['code']);
}

