/**
 * Zikula Application Framework
 *
 * @copyright (c) 2001, Zikula Development Team
 * @link http://www.zikula.com
 * @version $Id: blocks.js 25487 2009-03-27 21:49:05Z Guite $
 * @license GNU/GPL - http://www.gnu.org/copyleft/gpl.html
 * @package Zikula_System_Modules
 * @subpackage Blocks
 */


/**
 * Inits block sorting
 *
 *@params none;
 *@return none;
 *@author Frank Schummertz
 */
function blocksmodifyinit()
{
    Sortable.create("assignedblocklist",
                    {
                      dropOnEmpty: true,
                      only: 'pn-sortable',
                      constraint: false,
                      containment:["assignedblocklist","unassignedblocklist"],
                      onUpdate: blockorderchanged
                    });

    Sortable.create("unassignedblocklist",
                    {
                      dropOnEmpty: true,
                      only: 'pn-sortable',
                      constraint: false,
                      containment:["assignedblocklist","unassignedblocklist"]
                    });

    initactivationbuttons();
    $A(document.getElementsByClassName('pn-sortable', 'assignedblocklist')).each(
        function(node) 
        {
            node.setStyle({'cursor': 'move'});
            var thisblockid = node.id.split('_')[1];
            Element.update('blockdrag_' + thisblockid, '<img style="margin-top: 3px; margin-left: 3px;" src="images/icons/extrasmall/move.gif" width="16" height="16" alt="move.gif" />&nbsp;' + $('blockdrag_' + thisblockid).innerHTML);
        }
    )
    $A(document.getElementsByClassName('pn-sortable', 'unassignedblocklist')).each(
        function(node)
        {
            node.setStyle({'cursor': 'move'});
            var thisblockid = node.id.split('_')[1];
            Element.update('blockdrag_' + thisblockid, '<img style="margin-top: 3px; margin-left: 3px;" src="images/icons/extrasmall/move.gif" width="16" height="16" alt="move.gif" />&nbsp;' + $('blockdrag_' + thisblockid).innerHTML);
        }
    )
}

/**
 * activate all buttons to (de-)activate blocks
 *
 */
function initactivationbuttons()
{
    $$('a.activationbutton').each(function(item) {
        item.removeClassName('activationbutton');
    });
}

/**
 * Stores the new sort order. This function gets called automatically
 * from the Sortable when a 'drop' action has been detected
 *
 *@params none;
 *@return none;
 *@author Frank Schummertz
 */
function blockorderchanged()
{
    var pars = "module=Blocks&func=changeblockorder&authid=" + $F('authid')
               + "&position=" + $F('position')
               + "&" + Sortable.serialize('assignedblocklist', { 'name': 'blockorder' });
    var myAjax = new Ajax.Request(
        "ajax.php",
        {
            method: 'get',
            parameters: pars,
            onComplete: blockorderchanged_response
        });
}

/**
 * Ajax response function for updating new sort order: cleanup
 *
 *@params none;
 *@return none;
 *@author Frank Schummertz
 */
function blockorderchanged_response(req)
{
    if (req.status != 200 ) {
        pnshowajaxerror(req.responseText);
        return;
    }

    var json = pndejsonize(req.responseText);
    pnupdateauthids(json.authid);

    pnrecolor('assignedblocklist', 'assignedblocklistheader');
    pnrecolor('unassignedblocklist', 'unassignedblocklistheader');
}

/**
 * Toggle a blocks active/inactive status
 *
 *@params bid;
 *@return none;
 *@author Frank Schummertz
 */
function toggleblock(bid)
{
    var pars = "module=Blocks&func=toggleblock&bid=" + bid;
    var myAjax = new Ajax.Request(
        "ajax.php",
        {
            method: 'get',
            parameters: pars,
            onComplete: toggleblock_response
        });
}

/**
 * Ajax response function for updating block status: cleanup
 *
 *@params none;
 *@return none;
 *@author Frank Schummertz
 */
function toggleblock_response(req)
{
    if (req.status != 200 ) {
        pnshowajaxerror(req.responseText);
        return;
    }

    var json = pndejsonize(req.responseText);

    $('active_' + json.bid).toggle();
    $('inactive_' + json.bid).toggle();
    $('activity_' + json.bid).update((($('activity_' + json.bid).innerHTML == msgBlockStatusInactive) ? msgBlockStatusActive : msgBlockStatusInactive));
}

/**
 * Inits menu item sorting
 *
 *@params none;
 *@return none;
 *@author Frank Schummertz
 */
function menublockinit()
{
    if ($('menuitemlist').length == 1) {
        appendmenuitem();
    }

    // define a rule to delete a menuitem when the trashcan icon is clicked
    var ruleset = {
        '#menuitemlist .deletebutton' : function(delbutton){
            Event.observe(delbutton,
                          'click',
                          function()
                          {
                              var thisid = this.id.split('_')[1];
                              if ($('menuitem_' + thisid)) {
                                  $('menuitem_' + thisid).remove();
                              }
                          },
                          false);
        }
    };

    // register the ruleset
    Behaviour.register(ruleset);

    // apply the ruleset to all existing delete buttons
    Behaviour.apply();

    Sortable.create("menuitemlist",
                    {
                      only: 'pn-sortable',
                      constraint: false
                    });
    $A(document.getElementsByClassName('pn-sortable')).each(
    function(node)
    {
        node.setStyle({'cursor': 'move'});
    });
}

/**
 * Appends a new menuitem by cloning a previous one
 *
 *@params none;
 *@return none;
 *@author Frank Schummertz
 */
function appendmenuitem()
{
    // copy new permission li
    var newmenu = $('menuitem_X').cloneNode(true);

    lastmenuid++;
    var newmenuid = lastmenuid;

    newmenu.id   = 'menuitem_' + newmenuid;

    if ( $(newmenu).hasClassName('pn-odd')) {
        $(newmenu).removeClassName('pn-odd');
        $(newmenu).addClassName('pn-even');
    } else {
        $(newmenu).removeClassName('pn-even');
        $(newmenu).addClassName('pn-odd');
    }

    $A(newmenu.getElementsByTagName('input')).each(
    function(node)
    {
        if ($(node).hasClassName('linkid')) {
            node.value = newmenuid;
            node.name = 'linkids[]';
        } else {
            node.id   = node.id.split('_')[0] + '_' + node.id.split('_')[1] + '_' + newmenuid;
            node.name = node.id.split('_')[0] +  '[' + newmenuid + '][' + node.id.split('_')[1] + ']';
        }
    });
    $A(newmenu.getElementsByTagName('button')).each(function(node){ node.id = node.id.split('_')[0] + '_' + newmenuid; });

    $('menuitemlist').appendChild(newmenu);

    // re-apply the ruleset to all existing delete buttons
    Behaviour.apply();
    Sortable.create("menuitemlist",
                    { 
                      only: 'pn-sortable',
                      constraint: false
                    });
    $A(document.getElementsByClassName('pn-sortable')).each(
    function(node)
    {
        node.setStyle({'cursor': 'move'});
    });
}
