<?php
/**
 * Zikula Application Framework
 * @copyright (c) 2001, Zikula Development Team
 * @link http://www.zikula.org
 * @version $Id: pnuser.php 24342 2008-06-06 12:03:14Z markwest $
 * @license GNU/GPL - http://www.gnu.org/copyleft/gpl.html
 * @package Zikula_System_Modules
 * @subpackage Blocks
 */

/**
 * The main blocks user function
 * @author Mark West
 * @return HTML String
 */
function blocks_user_main()
{
    return LogUtil::registerError(_MODULENODIRECTACCESS, 403);
}


/**
 * Change the status of a block
 * Invert the status of a given block id (collapsed/uncollapsed)
 *
 * @author Michael (acm3)
 * @author lophas
 * @return void
 */
function blocks_user_changestatus()
{
    /* Throwing an error under come conditions - commented out temporarily.
    if (!SecurityUtil::confirmAuthKey()) {
        include 'header.php';
        echo _BADAUTHKEY;
        include 'footer.php';
        pnShutDown();
    }
    */
    $bid = FormUtil::getPassedValue('bid');
    $uid = pnUserGetVar('uid');

    $pntable = pnDBGetTables();
    $column  = $pntable['userblocks_column'];

    $where  = "WHERE $column[bid]='".DataUtil::formatForStore($bid)."' AND $column[uid]='".DataUtil::formatForStore($uid)."'";
    $active = DBUtil::selectField ('userblocks', 'active', $where);

    $obj = array();
    $obj['active'] = ($active ? 0 : 1);
    $where = "WHERE $column[uid]='".DataUtil::formatForStore($uid)."' AND $column[bid]='".DataUtil::formatForStore($bid)."'";
    $res = DBUtil::updateObject ($obj, 'userblocks', $where);

    if (!$res) {
        return LogUtil::registerError('Sql error');
    }

    // now lets get back to where we came from
    return pnRedirect(pnServerGetVar('HTTP_REFERER'));
}
